/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.xslui.tools;

import com.iplanet.xslui.tools.ServletRequestDataSource;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.activation.DataSource;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.ParseException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

public class MultipartHttpServletRequest
extends HttpServletRequestWrapper {
    private static final String CONTENT_DISPOSITION = "Content-Disposition";
    private static final String CONTENT_DISPOSITION_NAME = "name=\"";
    private static final String CONTENT_DISPOSITION_FILENAME = "filename=\"";
    private static final String CONTENT_TYPE = "Content-Type";
    private static final String CONTENT_TYPE_MULTI = "multipart/form-data";
    private Hashtable _paramTable = null;
    private Hashtable _fileTable = null;

    public MultipartHttpServletRequest(HttpServletRequest httpServletRequest) throws IOException, IllegalArgumentException {
        super(httpServletRequest);
        if (httpServletRequest == null) {
            throw new IllegalArgumentException("null servletRequest");
        }
        this._paramTable = new Hashtable();
        this._fileTable = new Hashtable();
        ServletRequestDataSource servletRequestDataSource = new ServletRequestDataSource((ServletRequest)httpServletRequest);
        MimeMultipart mimeMultipart = null;
        try {
            mimeMultipart = new MimeMultipart((DataSource)servletRequestDataSource);
        }
        catch (MessagingException messagingException) {
            throw new IOException("MimeMultipart failed: " + messagingException.getMessage());
        }
        catch (ClassCastException classCastException) {
            throw new IOException("MimeMultipart failed: not Mime content-type " + classCastException.getMessage());
        }
        try {
            MultipartHttpServletRequest.parseMultiPart(mimeMultipart, this._paramTable, this._fileTable);
        }
        catch (IOException iOException) {
            throw new IOException("parseMultiPart has thrown IOException: " + iOException.getMessage());
        }
        catch (MessagingException messagingException) {
            throw new IOException("parseMultiPart has thrown MessagingException: " + messagingException.getMessage());
        }
    }

    public String getParameter(String string) {
        if (string == null) {
            return null;
        }
        String[] stringArray = (String[])this._paramTable.get(string);
        if (stringArray != null) {
            return stringArray[0];
        }
        return null;
    }

    public String[] getParameterValues(String string) {
        if (string == null) {
            return null;
        }
        return (String[])this._paramTable.get(string);
    }

    public Enumeration getParameterNames() {
        return this._paramTable.keys();
    }

    public Enumeration getFileParameterNames() {
        return this._fileTable.keys();
    }

    public InputStream getFileParameter(String string) {
        if (string == null) {
            return null;
        }
        return (InputStream)this._fileTable.get(string);
    }

    protected static String inputStreamToString(InputStream inputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n = 0;
        while (n != -1) {
            byte[] byArray = new byte[1];
            n = inputStream.read(byArray);
            if (n == -1) continue;
            byteArrayOutputStream.write(byArray);
        }
        byteArrayOutputStream.flush();
        byteArrayOutputStream.close();
        return byteArrayOutputStream.toString();
    }

    protected static void parseMultiPart(MimeMultipart mimeMultipart, Hashtable hashtable, Hashtable hashtable2) throws IOException, MessagingException {
        int n = mimeMultipart.getCount();
        for (int i = 0; i < n; ++i) {
            BodyPart bodyPart = mimeMultipart.getBodyPart(i);
            if (!(bodyPart instanceof MimeBodyPart)) {
                throw new IOException("Content is not Mime");
            }
            MimeBodyPart mimeBodyPart = (MimeBodyPart)bodyPart;
            MultipartHttpServletRequest.parseBody(mimeBodyPart, hashtable, hashtable2);
        }
    }

    private static void parseBody(MimeBodyPart mimeBodyPart, Hashtable hashtable, Hashtable hashtable2) throws IOException, MessagingException, ParseException {
        String[] stringArray = MultipartHttpServletRequest.getNames(mimeBodyPart);
        String string = stringArray[0];
        if (string == null) {
            return;
        }
        String string2 = stringArray[1];
        InputStream inputStream = mimeBodyPart.getInputStream();
        String string3 = null;
        String[] stringArray2 = mimeBodyPart.getHeader(CONTENT_TYPE);
        if (stringArray2 != null || string2 != null) {
            if (stringArray2 != null && (string3 = stringArray2[0]).startsWith("multipart")) {
                throw new IOException("nested multipart not allowed");
            }
            hashtable2.put(string, inputStream);
        } else {
            String string4 = MultipartHttpServletRequest.inputStreamToString(inputStream);
            inputStream.close();
            MultipartHttpServletRequest.putParameter(hashtable, string, string4);
        }
    }

    private static String[] getNames(MimeBodyPart mimeBodyPart) throws MessagingException, ParseException {
        String[] stringArray = new String[2];
        String[] stringArray2 = mimeBodyPart.getHeader(CONTENT_DISPOSITION);
        if (stringArray2 != null) {
            int n;
            int n2 = stringArray2[0].indexOf(CONTENT_DISPOSITION_NAME);
            if (n2 != -1) {
                n = stringArray2[0].indexOf("\";", n2 + CONTENT_DISPOSITION_NAME.length());
                stringArray[0] = n == -1 ? stringArray2[0].substring(n2 + CONTENT_DISPOSITION_NAME.length(), stringArray2[0].length() - 1) : stringArray2[0].substring(n2 + CONTENT_DISPOSITION_NAME.length(), n);
            }
            if ((n2 = stringArray2[0].indexOf(CONTENT_DISPOSITION_FILENAME)) != -1) {
                n = stringArray2[0].indexOf("\";", n2 + CONTENT_DISPOSITION_FILENAME.length());
                stringArray[1] = n == -1 ? stringArray2[0].substring(n2 + CONTENT_DISPOSITION_FILENAME.length(), stringArray2[0].length() - 1) : stringArray2[0].substring(n2 + CONTENT_DISPOSITION_FILENAME.length(), n);
            }
        }
        return stringArray;
    }

    private static void putParameter(Hashtable hashtable, String string, String string2) {
        String[] stringArray;
        if (hashtable.containsKey(string)) {
            String[] stringArray2 = (String[])hashtable.get(string);
            stringArray = new String[stringArray2.length + 1];
            for (int i = 0; i < stringArray2.length; ++i) {
                stringArray[i] = stringArray2[i];
            }
            stringArray[stringArray2.length] = string2;
        } else {
            stringArray = new String[]{string2};
        }
        hashtable.put(string, stringArray);
    }
}

