/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.xslui.tools;

import java.util.Vector;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPException;

public class LDAPPool {
    private int _poolMin;
    private int _poolMax;
    private long _timeout;
    private String _host;
    private int _port;
    private String _authdn;
    private String _authpw;
    private Vector _pool;
    private boolean _poolIsFull;
    private boolean _noPool;
    private int _ldapVersion;

    public LDAPPool(int n, int n2, int n3, String string, int n4, String string2, String string3, int n5) throws LDAPException {
        if (n < 0) {
            throw new LDAPException("ConnectionPoolSize invalid:" + n);
        }
        if (n2 < n) {
            throw new LDAPException("ConnectionPoolSize invalid: max = " + n2 + " < min = " + n);
        }
        this._poolMin = n;
        this._poolMax = n2;
        if (this._poolMax == 0) {
            this._noPool = true;
        }
        this._timeout = n3 < 0 ? (long)(-n3) : (long)(n3 * 1000);
        this._host = string;
        this._port = n4;
        this._authdn = string2;
        this._authpw = string3;
        this._ldapVersion = n5;
        this._pool = new Vector();
        this._poolIsFull = false;
        this.setUpPool(this._poolMin);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LDAPConnection getConnection() throws LDAPException {
        LDAPConnection lDAPConnection = null;
        if (!this._noPool) {
            boolean bl = false;
            while (!bl) {
                Vector vector = this._pool;
                synchronized (vector) {
                    if (this._poolIsFull) {
                        try {
                            this._pool.wait(this._timeout);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        if (this._poolIsFull) {
                            bl = true;
                        }
                    }
                    if ((lDAPConnection = this.getConnFromPool()) != null) {
                        break;
                    }
                    this._poolIsFull = true;
                }
            }
        } else {
            lDAPConnection = new LDAPConnection();
            Long l = new Long(this._timeout);
            Integer n = new Integer(l.intValue());
            lDAPConnection.setOption(4, (Object)n);
            lDAPConnection.connect(this._ldapVersion, this._host, this._port, this._authdn, this._authpw);
        }
        return lDAPConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LDAPConnection getConnectionNoWait() throws LDAPException {
        LDAPConnection lDAPConnection = null;
        if (!this._noPool) {
            Vector vector = this._pool;
            synchronized (vector) {
                if (!this._poolIsFull) {
                    lDAPConnection = this.getConnFromPool();
                }
            }
        } else {
            lDAPConnection = new LDAPConnection();
            Long l = new Long(this._timeout);
            Integer n = new Integer(l.intValue());
            lDAPConnection.connect(this._ldapVersion, this._host, this._port, this._authdn, this._authpw);
        }
        return lDAPConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(LDAPConnection lDAPConnection) {
        if (lDAPConnection == null) {
            return;
        }
        if (!this._noPool) {
            Object object;
            int n = -1;
            for (int i = 0; i < this._pool.size(); ++i) {
                object = (LDAPConnectionObject)this._pool.elementAt(i);
                if (((LDAPConnectionObject)object).getLDAPConn() != lDAPConnection) continue;
                n = i;
                break;
            }
            if (n != -1) {
                LDAPConnectionObject lDAPConnectionObject = (LDAPConnectionObject)this._pool.elementAt(n);
                object = this._pool;
                synchronized (object) {
                    lDAPConnectionObject.setInUse(false);
                    this._poolIsFull = false;
                    this._pool.notify();
                }
            }
        } else {
            try {
                lDAPConnection.disconnect();
            }
            catch (LDAPException lDAPException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Vector vector = this._pool;
        synchronized (vector) {
            for (int i = 0; i < this._pool.size(); ++i) {
                this.disconnect((LDAPConnectionObject)this._pool.elementAt(i));
            }
            this._pool.removeAllElements();
        }
    }

    private LDAPConnection getConnFromPool() throws LDAPException {
        int n;
        LDAPConnection lDAPConnection = null;
        LDAPConnectionObject lDAPConnectionObject = null;
        int n2 = this._pool.size();
        for (n = 0; n < n2; ++n) {
            LDAPConnectionObject lDAPConnectionObject2 = (LDAPConnectionObject)this._pool.elementAt(n);
            if (!lDAPConnectionObject2.isAvailable()) continue;
            lDAPConnectionObject = lDAPConnectionObject2;
            break;
        }
        if (lDAPConnectionObject == null && n2 < this._poolMax && (n = this.addConnection()) >= 0) {
            lDAPConnectionObject = (LDAPConnectionObject)this._pool.elementAt(n);
        }
        if (lDAPConnectionObject != null) {
            lDAPConnectionObject.setInUse(true);
            lDAPConnection = lDAPConnectionObject.getLDAPConn();
        }
        if (lDAPConnection != null && !lDAPConnection.isConnected()) {
            lDAPConnection.connect(this._ldapVersion, this._host, this._port, this._authdn, this._authpw);
        }
        return lDAPConnection;
    }

    private void disconnect(LDAPConnectionObject lDAPConnectionObject) {
        if (lDAPConnectionObject != null && lDAPConnectionObject.isAvailable()) {
            LDAPConnection lDAPConnection = lDAPConnectionObject.getLDAPConn();
            if (lDAPConnection != null && lDAPConnection.isConnected()) {
                try {
                    lDAPConnection.disconnect();
                }
                catch (LDAPException lDAPException) {
                    // empty catch block
                }
            }
            lDAPConnectionObject.setLDAPConn(null);
        }
    }

    private int addConnection() throws LDAPException {
        int n = -1;
        int n2 = this._pool.size() + 1;
        this.setUpPool(n2);
        if (n2 == this._pool.size()) {
            n = n2 - 1;
        }
        return n;
    }

    private void setUpPool(int n) throws LDAPException {
        while (this._pool.size() < n) {
            LDAPConnectionObject lDAPConnectionObject = new LDAPConnectionObject();
            LDAPConnection lDAPConnection = new LDAPConnection();
            Long l = new Long(this._timeout);
            Integer n2 = new Integer(l.intValue());
            lDAPConnection.setOption(4, (Object)n2);
            lDAPConnection.connect(this._ldapVersion, this._host, this._port, this._authdn, this._authpw);
            lDAPConnectionObject.setLDAPConn(lDAPConnection);
            lDAPConnectionObject.setInUse(false);
            this._pool.addElement(lDAPConnectionObject);
        }
    }

    class LDAPConnectionObject {
        private LDAPConnection ld;
        private boolean inUse;

        LDAPConnectionObject() {
        }

        LDAPConnection getLDAPConn() {
            return this.ld;
        }

        void setLDAPConn(LDAPConnection lDAPConnection) {
            this.ld = lDAPConnection;
        }

        void setInUse(boolean bl) {
            this.inUse = bl;
        }

        boolean isAvailable() {
            return !this.inUse;
        }
    }
}

