/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.xslui.tools;

import com.iplanet.xslui.tools.LDAPPool;
import com.iplanet.xslui.tools.PropertyReader;
import com.iplanet.xslui.ui.Logging;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import netscape.ldap.LDAPException;

public class LDAPConfigReader {
    public static final String LDAPHOST = "ldaphost";
    public static final String LDAPPORT = "ldapport";
    public static final String LDAPBINDDN = "ldapbinddn";
    public static final String LDAPBINDCRED = "ldapbindcred";
    public static final String LDAPVERSION = "ldapversion";
    public static final String LDAPPOOLMIN = "ldappoolmin";
    public static final String LDAPPOOLMAX = "ldappoolmax";
    public static final String LDAPPOOLTIMEOUT = "ldappooltimeout";
    private static int _port = 389;
    private static Hashtable _poolTable;

    public static LDAPPool getLDAPPool(PropertyReader propertyReader, String string) throws LDAPException {
        int n = propertyReader.getIntProperty(string + LDAPPOOLMIN, 1);
        int n2 = propertyReader.getIntProperty(string + LDAPPOOLMAX, 4);
        int n3 = propertyReader.getIntProperty(string + LDAPPOOLTIMEOUT, 10);
        String string2 = propertyReader.getStringProperty(string + LDAPHOST, "localhost");
        int n4 = propertyReader.getIntProperty(string + LDAPPORT, _port);
        int n5 = propertyReader.getIntProperty(string + LDAPVERSION, 3);
        String string3 = propertyReader.getStringProperty(string + LDAPBINDDN, "anonymous");
        String string4 = propertyReader.getStringProperty(string + LDAPBINDCRED, "");
        String string5 = string2 + ":" + n4 + ":" + string3;
        if (_poolTable != null && _poolTable.containsKey(string5)) {
            Logging.trace((int)1, (String)("Pool exists for -> " + string5));
            return (LDAPPool)_poolTable.get(string5);
        }
        Logging.trace((int)1, (String)("Pool doesn't exists for -> " + string5 + " so creating a new one"));
        LDAPPool lDAPPool = new LDAPPool(n, n2, n3, string2, n4, string3, string4, n5);
        if (_poolTable == null) {
            _poolTable = new Hashtable();
        }
        _poolTable.put(string5, lDAPPool);
        return lDAPPool;
    }

    public static void setDefaultPort(int n) {
        _port = n;
    }

    public static void destroyPool() {
        Set set = _poolTable.keySet();
        Iterator iterator = set.iterator();
        for (int i = 0; i < set.size(); ++i) {
            String string = (String)iterator.next();
            LDAPPool lDAPPool = (LDAPPool)_poolTable.get(string);
            if (lDAPPool != null) {
                lDAPPool.destroy();
            }
            _poolTable.remove(string);
        }
    }
}

