/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.xslui.dbtrans;

import com.iplanet.xslui.dbtrans.DbTransException;
import com.iplanet.xslui.dbtrans.DbTranslation;
import com.iplanet.xslui.dbtrans.XML2DbTranslatable;
import com.iplanet.xslui.xslutil.XMLDOMBuilder;
import com.iplanet.xslui.xslutil.XMLProcessingException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class TwoWayDbTranslation
extends DbTranslation {
    public TwoWayDbTranslation(File file) throws DbTransException {
        super(file);
    }

    public void reverseTranslate(Element element, XML2DbTranslatable xML2DbTranslatable) throws DbTransException {
        if (element == null) {
            throw new DbTransException(10, "null entryElement");
        }
        if (xML2DbTranslatable == null) {
            throw new DbTransException(10, "null dbEntry");
        }
        String string = element.getTagName();
        Document document = super.getXlateTreeForXMLType(string);
        Element element2 = document.getDocumentElement();
        String string2 = super.getDbTypeForXMLType(string);
        if (string2 == null) {
            throw new DbTransException(7, "getDbTypeForXMLType: can't find xlate template for " + string);
        }
        xML2DbTranslatable.setDbType(string2);
        this.convertWriteTree(element2, element, xML2DbTranslatable, false);
    }

    private void convertWriteTree(Element element, Element element2, XML2DbTranslatable xML2DbTranslatable, boolean bl) throws DbTransException {
        Element element3 = element;
        Element element4 = element2;
        String string = null;
        ArrayList<String> arrayList = null;
        do {
            int n;
            Object object;
            Object object2;
            if (element3 == null) {
                if (string == null) break;
                xML2DbTranslatable.setDbValues(string, arrayList.toArray(new String[1]));
                string = null;
                break;
            }
            String string2 = null;
            if (!element3.getNodeName().equals(element4.getNodeName())) {
                if (string != null) {
                    xML2DbTranslatable.setDbValues(string, arrayList.toArray(new String[1]));
                    string = null;
                }
                if ((element3 = this.getNextElementSibling(element3)) != null) continue;
                break;
            }
            Element element5 = element3;
            boolean bl2 = false;
            HashMap<String, String> hashMap = new HashMap<String, String>(3);
            HashMap<String, String> hashMap2 = new HashMap<String, String>(3);
            boolean bl3 = false;
            while (!bl2 && element5 != null && element5.getNodeName().equals(element4.getNodeName())) {
                Attr attr;
                bl3 = false;
                hashMap.clear();
                hashMap2.clear();
                int n2 = 0;
                object2 = element5.getAttributes();
                boolean bl4 = true;
                while (bl4 && object2 != null && (attr = (Attr)object2.item(n2++)) != null) {
                    String string3;
                    object = attr.getName();
                    String string4 = attr.getValue();
                    n = 0;
                    boolean bl5 = false;
                    if (string4.startsWith("db:")) {
                        n = 1;
                    } else if (string4.startsWith("oc:")) {
                        bl5 = true;
                    }
                    String string5 = null;
                    Attr attr2 = element4.getAttributeNode((String)object);
                    if (attr2 != null) {
                        string5 = attr2.getValue();
                    }
                    if (n == 0) {
                        bl3 = true;
                        if (string5 != null && !string4.equals(string5)) {
                            bl4 = false;
                            break;
                        }
                    } else {
                        if (string4.startsWith("db:xml:") || string4.startsWith("db:expr:") || string4.startsWith("db:count:")) continue;
                        string3 = string4.substring("db:".length());
                        hashMap2.put(string3, "");
                        if (string5 != null) {
                            hashMap.put(string3, string5);
                        }
                    }
                    if (!bl5 || (string3 = string4.substring("oc:".length())).length() <= 0) continue;
                    hashMap.put("objectclass", string3);
                }
                if (bl4) {
                    bl2 = true;
                    continue;
                }
                element5 = this.getNextElementSibling(element5);
            }
            if (!bl2) {
                if ((element4 = this.getNextElementSibling(element4)) != null) continue;
                break;
            }
            boolean bl6 = true;
            String string6 = DbTranslation.getElementContent(element5);
            if (string6 == null) {
                bl6 = false;
                if (hashMap.size() > 0) {
                    this.writeAttrFromMap(xML2DbTranslatable, hashMap, true);
                }
            } else if (string6.startsWith("db:") && !string6.startsWith("db:expr:")) {
                string2 = DbTranslation.getElementContent(element4);
                Node node = element4.getPreviousSibling();
                if (node != null && string2 != null && !bl3 && element4.getNodeName().equals(node.getNodeName())) {
                    arrayList.add(string2);
                    if (hashMap.size() > 0) {
                        this.writeAttrFromMap(xML2DbTranslatable, hashMap, true);
                    }
                } else {
                    object2 = null;
                    String string7 = string6.substring(string6.lastIndexOf(":") + 1);
                    if (string6.startsWith("db:xml:")) {
                        object = new ByteArrayOutputStream(64);
                        try {
                            XMLDOMBuilder.dumpNode((Node)element4, (OutputStream)object);
                        }
                        catch (XMLProcessingException xMLProcessingException) {
                            throw new DbTransException(3, "Couldn't dump Elt " + element4.getTagName() + ":" + xMLProcessingException.getMessage());
                        }
                        string2 = ((ByteArrayOutputStream)object).toString();
                        int n3 = string2.indexOf(10, 2);
                        n = string2.lastIndexOf(10, string2.length() - 2);
                        if (n3 < 0 || n < 0) {
                            throw new DbTransException(3, "Couldn't dump/analyze Elt " + element4.getTagName());
                        }
                        string2 = string2.substring(n3 + 1, n);
                    }
                    if (string != null) {
                        xML2DbTranslatable.setDbValues(string, arrayList.toArray(new String[1]));
                        string = null;
                    }
                    if (string2 == null || string2.equals("")) {
                        xML2DbTranslatable.removeDbValues(string7);
                        if (hashMap2.size() > 0) {
                            this.writeAttrFromMap(xML2DbTranslatable, hashMap2, false);
                        }
                    } else {
                        if (hashMap.size() > 0) {
                            this.writeAttrFromMap(xML2DbTranslatable, hashMap, true);
                        }
                        string = string7;
                        arrayList = new ArrayList<String>();
                        arrayList.add(string2);
                    }
                }
            }
            if (!bl6 && element5.hasChildNodes() && element4.hasChildNodes()) {
                Node node = element5.getFirstChild();
                if (!(node instanceof Element)) {
                    throw new DbTransException(2, "converWriteTree: Non Element child found in " + element5.getTagName());
                }
                object2 = element4.getFirstChild();
                if (!(object2 instanceof Element)) {
                    throw new DbTransException(4, "converWriteTree: Non Element child found in " + element4.getTagName());
                }
                this.convertWriteTree((Element)node, (Element)object2, xML2DbTranslatable, true);
            }
            if (!bl) break;
            element4 = this.getNextElementSibling(element4);
        } while (element4 != null);
        if (string != null) {
            xML2DbTranslatable.setDbValues(string, arrayList.toArray(new String[1]));
        }
    }

    private void writeAttrFromMap(XML2DbTranslatable xML2DbTranslatable, HashMap hashMap, boolean bl) {
        Iterator iterator = hashMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String string = (String)entry.getKey();
            String[] stringArray = new String[]{(String)entry.getValue()};
            if (bl) {
                xML2DbTranslatable.setDbValues(string, stringArray);
                continue;
            }
            xML2DbTranslatable.removeDbValues(string);
        }
    }

    private Element getNextElementSibling(Node node) {
        Node node2 = node.getNextSibling();
        while (node2 != null && !(node2 instanceof Element)) {
        }
        return (Element)node2;
    }
}

