/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.xslui.dbtrans;

import com.iplanet.xslui.dbtrans.DbTransException;
import com.iplanet.xslui.dbtrans.DbTranslatable;
import com.iplanet.xslui.dbtrans.XlateFilenameFilter;
import com.iplanet.xslui.xslutil.XMLDOMBuilder;
import com.iplanet.xslui.xslutil.XMLProcessingException;
import com.iplanet.xslui.xslutil.XPathTools;
import com.iplanet.xslui.xslutil.XSLProcessingException;
import java.io.File;
import java.util.ArrayList;
import java.util.Hashtable;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class DbTranslation {
    protected XMLDOMBuilder _domBuilder = null;
    private Document[] _dom_tables = null;
    private Hashtable _return_attributes = null;
    private ArrayList _xlate_entry_types = null;
    private ArrayList _xlate_names = null;

    public DbTranslation(File file) throws DbTransException {
        if (file == null) {
            throw new DbTransException(10, "null configPath");
        }
        this._xlate_entry_types = new ArrayList();
        this._xlate_names = new ArrayList();
        this._dom_tables = this.loadXlateDocs(this._xlate_entry_types, this._xlate_names, file);
        this._return_attributes = DbTranslation.loadRetAttribs(this._xlate_entry_types, this._dom_tables);
        try {
            this._domBuilder = new XMLDOMBuilder();
        }
        catch (XMLProcessingException xMLProcessingException) {
            throw new DbTransException(3, "Can not create XMLDOMBuilder : " + xMLProcessingException.getMessage());
        }
    }

    public Element translate(DbTranslatable dbTranslatable, Element element) throws DbTransException {
        if (dbTranslatable == null) {
            throw new DbTransException(10, "null dbEntry");
        }
        if (element == null) {
            throw new DbTransException(10, "null docHanger");
        }
        Document document = element.getOwnerDocument();
        if (document == null) {
            throw new DbTransException(10, "null resultTree");
        }
        String[] stringArray = dbTranslatable.getDbTypes();
        if (stringArray == null) {
            throw new DbTransException(7, "translate: getDbTypes returned null");
        }
        int n = -1;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null) {
                throw new DbTransException(7, "translate: null dbType");
            }
            n = this._xlate_names.indexOf(stringArray[i].toUpperCase());
            if (n != -1) break;
        }
        if (n == -1) {
            throw new DbTransException(7, "translate: can't find xlate template for " + stringArray[0]);
        }
        Document document2 = this._dom_tables[n];
        if (document2 == null) {
            throw new DbTransException(7, "translate: wrong xlate template: " + n + " for " + stringArray.toString());
        }
        DocumentFragment documentFragment = document.createDocumentFragment();
        DbTranslation.processXlateTree(document2.getDocumentElement(), dbTranslatable, false, documentFragment, document, null);
        if (!documentFragment.hasChildNodes()) {
            throw new DbTransException(8, "translate: doc fragment has no child");
        }
        Element element2 = (Element)documentFragment.getFirstChild();
        if (element2 == null) {
            throw new DbTransException(7, "translate: doc fragment has null child");
        }
        element.appendChild(documentFragment);
        return element2;
    }

    public Element translate(DbTranslatable dbTranslatable) throws DbTransException {
        if (dbTranslatable == null) {
            throw new DbTransException(10, "null dbEntry");
        }
        Document document = null;
        Element element = null;
        try {
            document = this._domBuilder.newDocument();
            element = document.createElement("dummyElement");
            document.appendChild(element);
        }
        catch (DOMException dOMException) {
            throw new DbTransException(3, "DbTranslation.translate: Creation of dummyDoc failed : " + dOMException.getMessage());
        }
        return this.translate(dbTranslatable, element);
    }

    public String getDbTypeForXMLType(String string) {
        int n = this._xlate_entry_types.indexOf(string);
        if (n == -1) {
            return null;
        }
        return (String)this._xlate_names.get(n);
    }

    public String[] getXMLTypes() {
        return this._xlate_entry_types.toArray(new String[this._xlate_entry_types.size()]);
    }

    public String[] getDbAttributeList(ArrayList arrayList) {
        if (arrayList == null) {
            return null;
        }
        ArrayList<String> arrayList2 = new ArrayList<String>();
        String[] stringArray = null;
        for (int i = 0; i < arrayList.size(); ++i) {
            if (arrayList.get(i) == null || (stringArray = (String[])this._return_attributes.get(arrayList.get(i))) == null || stringArray.length <= 0) continue;
            for (int j = 0; j < stringArray.length; ++j) {
                if (DbTranslation.containsCaseInsensitive(arrayList2, stringArray[j]) || stringArray[j] == null || stringArray[j].length() <= 0) continue;
                arrayList2.add(stringArray[j].toLowerCase());
            }
        }
        String[] stringArray2 = null;
        if (arrayList2.size() != 0) {
            stringArray2 = arrayList2.toArray(new String[0]);
            return stringArray2;
        }
        return null;
    }

    public String[] getAllDbAttributeList() {
        String[] stringArray = (String[])this._return_attributes.get("All");
        return stringArray;
    }

    public ArrayList xlateXPathField(String string, boolean bl, ArrayList arrayList) throws DbTransException {
        ArrayList arrayList2 = new ArrayList();
        this.xlateXPathField(string, bl, arrayList, arrayList2);
        if (arrayList2.isEmpty()) {
            return null;
        }
        return arrayList2;
    }

    public void xlateXPathField(String string, boolean bl, ArrayList arrayList, ArrayList arrayList2) throws DbTransException {
        int n;
        if (string == null) {
            throw new DbTransException(10, "null xpathField");
        }
        if (arrayList2 == null) {
            throw new DbTransException(10, "null dbAttrs");
        }
        Document[] documentArray = null;
        if (arrayList != null && !arrayList.isEmpty()) {
            documentArray = new Document[arrayList.size()];
            for (n = arrayList.size() - 1; n >= 0; --n) {
                documentArray[n] = this.getXlateTreeForXMLType((String)arrayList.get(n));
            }
        } else {
            documentArray = this._dom_tables;
        }
        n = 0;
        Object var7_7 = null;
        for (int i = 0; i < documentArray.length; ++i) {
            Document document = documentArray[i];
            ArrayList arrayList3 = new ArrayList(6);
            Element element = document.getDocumentElement();
            try {
                XPathTools.getNodesByXPath(element, string, arrayList3);
            }
            catch (XSLProcessingException xSLProcessingException) {
                throw new DbTransException(3, "XSL Exception is: " + xSLProcessingException.toString());
            }
            for (int j = 0; j < arrayList3.size(); ++j) {
                Node node = (Node)arrayList3.get(j);
                if (node instanceof Element && bl) {
                    DbTranslation.addChildren(node, arrayList2);
                    continue;
                }
                n = DbTranslation.getNodeContent(node, arrayList2) ? 1 : 0;
            }
        }
    }

    private Document[] loadXlateDocs(ArrayList arrayList, ArrayList arrayList2, File file) throws DbTransException {
        XlateFilenameFilter xlateFilenameFilter = new XlateFilenameFilter();
        String[] stringArray = file.list(xlateFilenameFilter);
        if (stringArray == null) {
            throw new DbTransException(1, "loadXlateDocs: directory doesn't exist " + file.toString());
        }
        if (stringArray.length <= 0) {
            throw new DbTransException(1, "loadXlateDocs: no xlate-*.xml file found under " + file.toString());
        }
        Document[] documentArray = new Document[stringArray.length];
        Object var8_7 = null;
        for (int i = 0; i < stringArray.length; ++i) {
            String string;
            Document document;
            String string2 = stringArray[i];
            File file2 = new File(file, string2);
            if (!file2.canRead()) {
                throw new DbTransException(1, file + string2);
            }
            try {
                XMLDOMBuilder xMLDOMBuilder = new XMLDOMBuilder();
                document = xMLDOMBuilder.parse(file2);
                string = document.getDocumentElement().getNodeName();
            }
            catch (XMLProcessingException xMLProcessingException) {
                throw new DbTransException(2, file + string2);
            }
            arrayList.add(string);
            arrayList2.add(string2.toUpperCase().substring(6, string2.length() - 4));
            documentArray[i] = document;
        }
        return documentArray;
    }

    private static boolean processDBexpr(String string, ArrayList arrayList) {
        boolean bl = false;
        if (string.indexOf(58, 3) == -1) {
            arrayList.add(string.substring(3));
            bl = true;
        } else {
            block0 : switch (string.charAt(4)) {
                case 'x': {
                    arrayList.add(string.substring(7));
                    bl = true;
                    break;
                }
                case 'c': 
                case 'v': {
                    break;
                }
                case 'e': {
                    int n = 0;
                    while ((n = string.indexOf("db:", n)) != -1) {
                        bl = true;
                        int n2 = string.indexOf(43, n);
                        if (n2 != -1) {
                            while (string.charAt(n2 - 1) == ' ') {
                                --n2;
                            }
                        }
                        if (n2 == -1) {
                            arrayList.add(string.substring(n));
                            break block0;
                        }
                        arrayList.add(string.substring(n++, n2 - 1));
                    }
                    break;
                }
            }
        }
        return bl;
    }

    private static void addChildren(Node node, ArrayList arrayList) {
        if (node.getNodeType() == 3) {
            String string = node.getNodeValue();
            if (string.startsWith("db:")) {
                DbTranslation.processDBexpr(string, arrayList);
            }
        } else if (node instanceof Element) {
            Node node2;
            int n;
            int n2;
            Object object;
            if (node.hasAttributes()) {
                object = node.getAttributes();
                n2 = object.getLength();
                for (n = 0; n < n2; ++n) {
                    node2 = (Attr)object.item(n);
                    String string = node2.getValue();
                    if (string == null || !string.startsWith("db:")) continue;
                    DbTranslation.processDBexpr(string, arrayList);
                }
            }
            if (node.hasChildNodes()) {
                object = node.getChildNodes();
                n2 = object.getLength();
                for (n = 0; n < n2; ++n) {
                    node2 = object.item(n);
                    DbTranslation.addChildren(node2, arrayList);
                }
            }
        }
    }

    private static boolean getNodeContent(Node node, ArrayList arrayList) {
        String string = null;
        boolean bl = false;
        if (node instanceof Attr) {
            string = node.getNodeValue();
        } else if (node instanceof Element) {
            string = DbTranslation.getElementContent(node);
        }
        if (string != null && string.startsWith("db:")) {
            bl = DbTranslation.processDBexpr(string, arrayList);
        } else if (string != null && string.length() > 0) {
            arrayList.add(string);
        }
        return bl;
    }

    protected static String getElementContent(Node node) {
        Node node2;
        for (node2 = node.getFirstChild(); node2 != null && node2.getNodeType() != 3; node2 = node2.getNextSibling()) {
        }
        if (node2 != null) {
            return node2.getNodeValue();
        }
        return null;
    }

    private static String parseSubExpr(String string, DbTranslatable dbTranslatable) throws DbTransException {
        int n = 0;
        String[] stringArray = null;
        String string2 = null;
        String[] stringArray2 = null;
        stringArray = new String[]{""};
        while (n < string.length() && n >= 0) {
            char c = string.charAt(n);
            switch (c) {
                case '+': {
                    ++n;
                    break;
                }
                case ' ': {
                    ++n;
                    break;
                }
                case '\'': {
                    int n2 = string.indexOf(39, n + 1);
                    stringArray[0] = stringArray[0] + string.substring(n + 1, n2);
                    n = n2 + 1;
                    break;
                }
                case 'd': {
                    int n3 = string.indexOf(43, n);
                    if (n3 != -1) {
                        while (string.charAt(n3 - 1) == ' ') {
                            --n3;
                        }
                    }
                    string2 = n3 == -1 ? string.substring(string.indexOf("db:", n) + "db:".length()) : string.substring(string.indexOf("db:", n) + "db:".length(), n3);
                    n = n3;
                    stringArray2 = null;
                    stringArray2 = new String[1];
                    try {
                        stringArray2 = dbTranslatable.getDbValue(string2);
                    }
                    catch (Exception exception) {
                        throw new DbTransException(7, "dbReadinst db: " + exception.getMessage());
                    }
                    if (stringArray2 != null) {
                        stringArray[0] = stringArray[0] + stringArray2[0];
                        break;
                    }
                    return null;
                }
            }
        }
        if (stringArray != null) {
            return stringArray[0];
        }
        return null;
    }

    private static String[] parseDbExpr(String string, DbTranslatable dbTranslatable, int n) throws DbTransException {
        String[] stringArray = null;
        String[] stringArray2 = null;
        String string2 = null;
        stringArray2 = new String[1];
        int n2 = 0;
        if (string.startsWith("db:param:")) {
            string2 = string.substring("db:param:".length());
            stringArray = new String[1];
            try {
                stringArray2 = dbTranslatable.getDbValue(string2);
                if (stringArray2 != null) {
                    stringArray[0] = stringArray2[0];
                }
                stringArray = null;
            }
            catch (Exception exception) {
                throw new DbTransException(7, "dbReadinst db:param:" + exception.getMessage());
            }
        } else if (string.startsWith("db:count:")) {
            stringArray = new String[]{Integer.toString(n + 1)};
        } else if (string.startsWith("db:expr:")) {
            int n3 = 0;
            int n4 = 0;
            String string3 = null;
            String string4 = null;
            int n5 = 0;
            boolean bl = false;
            string2 = string.substring("db:expr:".length());
            stringArray = new String[1];
            while (n5 < string.length() && n5 >= 0 && !bl) {
                ++n3;
                n2 = string2.indexOf("||", n5);
                if (n2 == -1) {
                    bl = true;
                    string4 = DbTranslation.parseSubExpr(string2 = string2.substring(n5), dbTranslatable);
                    if (string4 != null) {
                        stringArray[0] = string4;
                        continue;
                    }
                    stringArray = null;
                    continue;
                }
                string3 = string2.substring(n5, n2);
                try {
                    string4 = DbTranslation.parseSubExpr(string3, dbTranslatable);
                }
                catch (DbTransException dbTransException) {
                    throw new DbTransException(7, "dbReadinst db:param:" + dbTransException.getMessage());
                }
                n5 = n2 + 2;
                if (string4 == null) {
                    ++n4;
                    continue;
                }
                bl = true;
                stringArray[0] = string4;
            }
            if (n4 == n3) {
                stringArray = null;
            }
        } else {
            string2 = string.substring(string.lastIndexOf(58) + 1);
            try {
                stringArray = dbTranslatable.getDbValue(string2);
            }
            catch (Exception exception) {
                throw new DbTransException(7, "dbReadinst db: " + exception.getMessage());
            }
        }
        return stringArray;
    }

    private static boolean processXlateTree(Node node, DbTranslatable dbTranslatable, boolean bl, DocumentFragment documentFragment, Document document, String string) throws DbTransException {
        DocumentFragment documentFragment2 = documentFragment;
        boolean bl2 = false;
        boolean bl3 = true;
        String string2 = null;
        int n = 0;
        while (node != null) {
            bl3 = true;
            if (node instanceof Element) {
                Object object;
                int n2;
                boolean bl4 = bl;
                Element element = null;
                boolean bl5 = false;
                String[] stringArray = null;
                String string3 = DbTranslation.getElementContent(node);
                String string4 = null;
                string4 = node.getNodeName();
                if (string3 != null) {
                    if (string3.startsWith("db:")) {
                        stringArray = DbTranslation.parseDbExpr(string3, dbTranslatable, n);
                    } else if (bl4) {
                        stringArray = new String[]{string3};
                    }
                    if (stringArray != null) {
                        for (n2 = 0; n2 < stringArray.length; ++n2) {
                            element = document.createElement(node.getNodeName());
                            documentFragment2.appendChild(element);
                            if (string3.startsWith("db:xml:")) {
                                try {
                                    object = new XMLDOMBuilder();
                                    ((XMLDOMBuilder)object).insertNodeFromString(document, element, stringArray[n2]);
                                    continue;
                                }
                                catch (XMLProcessingException xMLProcessingException) {
                                    throw new DbTransException(4, "field = " + string3 + ", value = " + stringArray[n2]);
                                }
                            }
                            if (stringArray[n2] != null) {
                                object = document.createTextNode(stringArray[n2]);
                                element.appendChild((Node)object);
                            }
                            bl5 = true;
                            bl4 = true;
                        }
                        bl3 = false;
                    } else {
                        bl3 = true;
                    }
                }
                n2 = 0;
                object = null;
                if (node.hasChildNodes()) {
                    object = document.createDocumentFragment();
                    n2 = DbTranslation.processXlateTree(node.getFirstChild(), dbTranslatable, bl4, (DocumentFragment)object, document, string) ? 1 : 0;
                }
                ArrayList<Attr> arrayList = new ArrayList<Attr>(8);
                boolean bl6 = false;
                boolean bl7 = false;
                stringArray = null;
                if (node.hasAttributes()) {
                    NamedNodeMap namedNodeMap = node.getAttributes();
                    int n3 = namedNodeMap.getLength();
                    for (int i = 0; i < n3; ++i) {
                        Attr attr = (Attr)namedNodeMap.item(i);
                        string3 = attr.getValue();
                        if (string3 != null) {
                            bl7 = string3.startsWith("db:count:");
                            if (bl7 && !bl3) {
                                n = !string4.equals(string2) ? 0 : ++n;
                                string2 = string4;
                            }
                            if (string3.startsWith("db:")) {
                                stringArray = DbTranslation.parseDbExpr(string3, dbTranslatable, n);
                                if (stringArray != null && !bl7) {
                                    bl6 = true;
                                }
                            } else if (bl4 || n2 != 0) {
                                stringArray = new String[]{string3};
                            }
                        }
                        if (stringArray == null) continue;
                        Attr attr2 = document.createAttribute(attr.getName());
                        attr2.setValue(stringArray[0]);
                        arrayList.add(attr2);
                    }
                }
                if ((n2 != 0 || bl6) && !bl5) {
                    element = document.createElement(node.getNodeName());
                    documentFragment2.appendChild(element);
                    bl5 = true;
                }
                if (bl5 && arrayList.size() > 0) {
                    for (int i = 0; i < arrayList.size(); ++i) {
                        element.setAttributeNode((Attr)arrayList.get(i));
                    }
                }
                if (n2 != 0) {
                    element.appendChild((Node)object);
                }
                if (bl5) {
                    bl2 = true;
                }
            }
            node = node.getNextSibling();
        }
        return bl2;
    }

    protected Document getXlateTreeForXMLType(String string) throws DbTransException {
        int n = this._xlate_entry_types.indexOf(string);
        if (n == -1) {
            throw new DbTransException(7, "getXlateTreeForXMLType: can't find xlate template for " + string);
        }
        Document document = this._dom_tables[n];
        if (document == null) {
            throw new DbTransException(7, "getXlateTreeForXMLType: null xlate template for " + string);
        }
        return document;
    }

    private static ArrayList getAttribContent(Node node) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = null;
        int n = 32;
        if (node == null) {
            return null;
        }
        string = node.getNodeValue();
        if (string != null && string.startsWith("db:xml:")) {
            arrayList.add(string.substring("db:xml:".length()));
            return arrayList;
        }
        if (string != null && string.startsWith("db:expr:")) {
            int n2 = 0 + "db:expr:".length();
            int n3 = 0;
            n2 = string.indexOf("db:", n2);
            while (n2 != -1 && n2 < string.length()) {
                for (n3 = n2 + "db:".length(); n != 43 && n != 124 && n3 < string.length(); ++n3) {
                    n = string.charAt(n3);
                }
                arrayList.add(string.substring(n2 + "db:".length(), n3));
                n2 = n3;
                n2 = string.indexOf("db:", n2);
            }
            return arrayList;
        }
        if (string != null && string.startsWith("db:")) {
            arrayList.add(string.substring("db:".length()));
            return arrayList;
        }
        return null;
    }

    private static Hashtable loadRetAttribs(ArrayList arrayList, Document[] documentArray) {
        int n;
        if (arrayList == null || documentArray == null) {
            return null;
        }
        Hashtable<String, String[]> hashtable = new Hashtable<String, String[]>();
        ArrayList arrayList2 = new ArrayList();
        ArrayList arrayList3 = null;
        for (n = 0; n < arrayList.size(); ++n) {
            Document document = null;
            document = DbTranslation.getXlateDoc(documentArray, (String)arrayList.get(n));
            Element element = document.getDocumentElement();
            if (document == null) {
                return null;
            }
            arrayList3 = DbTranslation.getNodeAttributes(document, arrayList3);
            String[] stringArray = null;
            stringArray = arrayList3.toArray(new String[0]);
            arrayList3 = null;
            hashtable.put((String)arrayList.get(n), stringArray);
        }
        arrayList3 = null;
        for (n = 0; n < documentArray.length; ++n) {
            arrayList3 = DbTranslation.getNodeAttributes(documentArray[n], arrayList3);
        }
        String[] stringArray = arrayList3.toArray(new String[0]);
        hashtable.put("All", stringArray);
        return hashtable;
    }

    private static boolean containsCaseInsensitive(ArrayList arrayList, String string) {
        if (arrayList == null || string == null) {
            return false;
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            if (!string.equalsIgnoreCase((String)arrayList.get(i))) continue;
            return true;
        }
        return false;
    }

    private static ArrayList getNodeAttributes(Node node, ArrayList arrayList) {
        if (node == null) {
            return null;
        }
        if (arrayList == null) {
            arrayList = new ArrayList();
        }
        ArrayList arrayList2 = null;
        String string = null;
        while (node != null) {
            NamedNodeMap namedNodeMap;
            arrayList2 = DbTranslation.getAttribContent(node);
            if (arrayList2 != null) {
                for (int i = 0; i < arrayList2.size(); ++i) {
                    string = (String)arrayList2.get(i);
                    if (DbTranslation.containsCaseInsensitive(arrayList, string)) continue;
                    arrayList.add(string.toLowerCase());
                }
            }
            if ((namedNodeMap = node.getAttributes()) != null) {
                for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                    arrayList = DbTranslation.getNodeAttributes(namedNodeMap.item(i), arrayList);
                }
            }
            if (node.hasChildNodes()) {
                arrayList = DbTranslation.getNodeAttributes(node.getFirstChild(), arrayList);
            }
            node = node.getNextSibling();
        }
        return arrayList;
    }

    private static Document getXlateDoc(Document[] documentArray, String string) {
        for (int i = 0; i < documentArray.length; ++i) {
            Element element = documentArray[i].getDocumentElement();
            if (!element.getNodeName().equals(string)) continue;
            return documentArray[i];
        }
        return null;
    }
}

