/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.xslui.ui;

import com.iplanet.xslui.ui.CacheableProcessor;
import com.iplanet.xslui.ui.CacheableTranslator;
import com.iplanet.xslui.ui.CacheableXML;
import com.iplanet.xslui.xslutil.XMLProcessingException;
import com.iplanet.xslui.xslutil.XMLTranslator;
import com.iplanet.xslui.xslutil.XSLProcessorPool;
import com.iplanet.xslui.xslutil.XSLXMLLogHandler;
import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import org.w3c.dom.Document;

public class XSLXMLCache {
    private boolean _reloadOnChange = false;
    private Hashtable _xmlHashtable = null;
    private Hashtable _transHashtable = null;
    private Hashtable _xslHashtable = null;
    private XSLXMLLogHandler _logHandler = null;
    private String _uiRootPath = null;

    public XSLXMLCache(boolean bl, XSLXMLLogHandler xSLXMLLogHandler, String string) {
        this._reloadOnChange = bl;
        this._xmlHashtable = new Hashtable();
        this._transHashtable = new Hashtable();
        this._xslHashtable = new Hashtable();
        this._logHandler = xSLXMLLogHandler;
        this._uiRootPath = string;
    }

    public XSLXMLCache(boolean bl, XSLXMLLogHandler xSLXMLLogHandler) {
        this._reloadOnChange = bl;
        this._xmlHashtable = new Hashtable();
        this._transHashtable = new Hashtable();
        this._xslHashtable = new Hashtable();
        this._logHandler = xSLXMLLogHandler;
    }

    public Document getXMLTemplateDocument(String string, String[] stringArray) throws XMLProcessingException {
        return this.getXMLTemplateDocument(string, null, stringArray);
    }

    public CacheableXML getXMLTemplateCacheable(String string, String[] stringArray) throws XMLProcessingException {
        return this.getXMLTemplateCacheable(string, null, stringArray);
    }

    public Document getXMLTemplateDocument(String string, String string2, String[] stringArray) throws XMLProcessingException {
        CacheableXML cacheableXML = this.getXMLTemplateCacheable(string, string2, stringArray);
        return (Document)cacheableXML.getObject();
    }

    public CacheableXML getXMLTemplateCacheable(String string, String string2, String[] stringArray) throws XMLProcessingException {
        CacheableXML cacheableXML = null;
        String string3 = string2 != null ? stringArray[0] + string + "." + string2 : stringArray[0] + string;
        cacheableXML = (CacheableXML)this._xmlHashtable.get(string3);
        if (cacheableXML != null) {
            boolean bl = false;
            if (this._reloadOnChange) {
                bl = cacheableXML.isOutdated();
            }
            if (!bl) {
                return cacheableXML;
            }
            this._xmlHashtable.remove(string3);
        }
        if ((cacheableXML = this.findCacheableXML(string, string2, stringArray, true)) == null) {
            return null;
        }
        return cacheableXML;
    }

    protected synchronized CacheableXML findCacheableXML(String string, String string2, String[] stringArray, boolean bl) throws XMLProcessingException {
        CacheableXML cacheableXML = null;
        CacheableXML cacheableXML2 = null;
        String string3 = stringArray[0] + string;
        String string4 = string2 != null ? string3 + "." + string2 : string3;
        cacheableXML = (CacheableXML)this._xmlHashtable.get(string4);
        if (cacheableXML != null) {
            boolean bl2 = false;
            if (this._reloadOnChange) {
                bl2 = cacheableXML.isOutdated();
            }
            if (!bl2) {
                return cacheableXML;
            }
            this._xmlHashtable.remove(string4);
        }
        if (string2 == null) {
            File file = new File(string3);
            if (file.isFile()) {
                cacheableXML = new CacheableXML(file, this._logHandler);
                this._xmlHashtable.put(string4, cacheableXML);
                return cacheableXML;
            }
        } else {
            cacheableXML2 = this.findCacheableXML(string, null, stringArray, false);
            if (cacheableXML2 != null && cacheableXML2.getType() == 1) {
                CacheableTranslator cacheableTranslator = this.findCacheableTranslator(string2, stringArray, false);
                if (cacheableTranslator != null) {
                    XMLTranslator xMLTranslator = (XMLTranslator)cacheableTranslator.getObject();
                    Document document = (Document)cacheableXML2.getObject();
                    Document document2 = null;
                    document2 = xMLTranslator.translate(document);
                    cacheableXML = new CacheableXML(this._logHandler);
                    cacheableXML.setObject(document2);
                    cacheableXML.dependsOn(cacheableXML2);
                    cacheableXML.dependsOn(cacheableTranslator);
                    this._xmlHashtable.put(string4, cacheableXML);
                    return cacheableXML;
                }
                cacheableXML = new CacheableXML(this._logHandler);
                cacheableXML.setParent(cacheableXML2);
                this._xmlHashtable.put(string4, cacheableXML);
                return cacheableXML;
            }
        }
        if (!bl) {
            return null;
        }
        if (stringArray.length <= 1) {
            return null;
        }
        String[] stringArray2 = new String[stringArray.length - 1];
        System.arraycopy(stringArray, 1, stringArray2, 0, stringArray.length - 1);
        cacheableXML2 = this.findCacheableXML(string, string2, stringArray2, true);
        if (cacheableXML2 != null) {
            cacheableXML = new CacheableXML(this._logHandler);
            cacheableXML.setParent(cacheableXML2);
            this._xmlHashtable.put(string4, cacheableXML);
            return cacheableXML;
        }
        return null;
    }

    public XMLTranslator getXMLTranslator(String string, String[] stringArray) throws XMLProcessingException {
        CacheableTranslator cacheableTranslator = null;
        String string2 = stringArray[0] + string;
        cacheableTranslator = (CacheableTranslator)this._transHashtable.get(string2);
        if (cacheableTranslator != null) {
            boolean bl = false;
            if (this._reloadOnChange) {
                bl = cacheableTranslator.isOutdated();
            }
            if (!bl) {
                return (XMLTranslator)cacheableTranslator.getObject();
            }
            this._transHashtable.remove(string2);
        }
        if ((cacheableTranslator = this.findCacheableTranslator(string, stringArray, false)) == null) {
            return null;
        }
        return (XMLTranslator)cacheableTranslator.getObject();
    }

    public XSLProcessorPool getXSLProcessorPool(String string, String string2, String[] stringArray) throws XMLProcessingException {
        CacheableProcessor cacheableProcessor = null;
        String string3 = string2 != null ? stringArray[0] + string + "." + string2 : stringArray[0] + string;
        cacheableProcessor = (CacheableProcessor)this._xslHashtable.get(string3);
        if (cacheableProcessor != null) {
            boolean bl = false;
            if (this._reloadOnChange) {
                bl = cacheableProcessor.isOutdated();
            }
            if (!bl) {
                return (XSLProcessorPool)cacheableProcessor.getObject();
            }
            this._xslHashtable.remove(string3);
        }
        if ((cacheableProcessor = this.findCacheableProcessor(string, string2, stringArray, true)) == null) {
            return null;
        }
        return (XSLProcessorPool)cacheableProcessor.getObject();
    }

    public void clear() {
        this._xmlHashtable.clear();
        this._transHashtable.clear();
        this._xslHashtable.clear();
    }

    private synchronized CacheableTranslator findCacheableTranslator(String string, String[] stringArray, boolean bl) {
        CacheableTranslator cacheableTranslator = null;
        CacheableTranslator cacheableTranslator2 = null;
        String string2 = stringArray[0] + string;
        int n = 1;
        if (bl) {
            n = stringArray.length;
        }
        for (int i = 0; i < n; ++i) {
            File file;
            String string3 = stringArray[i] + string;
            cacheableTranslator2 = (CacheableTranslator)this._transHashtable.get(string3);
            if (cacheableTranslator2 != null) {
                boolean bl2 = false;
                if (this._reloadOnChange) {
                    try {
                        bl2 = cacheableTranslator2.isOutdated();
                    }
                    catch (XMLProcessingException xMLProcessingException) {
                        this._logHandler.error("XSLXMLCache.findCacheableTranslator: got " + xMLProcessingException.getMessage() + " while processing " + string3);
                    }
                }
                if (!bl2) {
                    if (i != 0) {
                        cacheableTranslator = new CacheableTranslator(this._logHandler);
                        cacheableTranslator.setParent(cacheableTranslator2);
                        this._transHashtable.put(string2, cacheableTranslator);
                        return cacheableTranslator;
                    }
                    return cacheableTranslator2;
                }
                this._transHashtable.remove(string3);
            }
            if (!(file = new File(string3)).isFile()) continue;
            try {
                cacheableTranslator2 = new CacheableTranslator(file, this._logHandler);
            }
            catch (XMLProcessingException xMLProcessingException) {
                this._logHandler.error("XSLXMLCache.findCacheableTranslator: Couldn't parse " + string3 + " : " + xMLProcessingException.getMessage());
                return null;
            }
            this._transHashtable.put(string3, cacheableTranslator2);
            if (i != 0) {
                cacheableTranslator = new CacheableTranslator(this._logHandler);
                cacheableTranslator.setParent(cacheableTranslator2);
                this._transHashtable.put(string2, cacheableTranslator);
                return cacheableTranslator;
            }
            return cacheableTranslator2;
        }
        return null;
    }

    private synchronized CacheableProcessor findCacheableProcessor(String string, String string2, String[] stringArray, boolean bl) throws XMLProcessingException {
        CacheableProcessor cacheableProcessor = null;
        CacheableProcessor cacheableProcessor2 = null;
        String string3 = stringArray[0] + string;
        String string4 = string2 != null ? string3 + "." + string2 : string3;
        if (this._uiRootPath != null) {
            try {
                File file = new File(string4);
                string4 = file.getCanonicalPath();
                file = new File(this._uiRootPath);
                this._uiRootPath = file.getAbsoluteFile().getCanonicalPath();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                throw new XMLProcessingException("findCacheableProcessor: Trouble getting the canonical path of either: " + string4 + " or " + this._uiRootPath);
            }
            string4 = string4.substring(this._uiRootPath.length());
            string4 = string4.replace('.', '_');
            string4 = string4.replace('-', '_');
            string4 = string4.replace('/', '_');
        }
        if ((cacheableProcessor = (CacheableProcessor)this._xslHashtable.get(string4)) != null) {
            boolean bl2 = false;
            if (this._reloadOnChange) {
                bl2 = cacheableProcessor.isOutdated();
            }
            if (!bl2) {
                return cacheableProcessor;
            }
            this._xslHashtable.remove(string4);
        }
        if (new File(stringArray[0]).isDirectory()) {
            cacheableProcessor = new CacheableProcessor(string, string2, stringArray, this, this._logHandler, string4);
            this._xslHashtable.put(string4, cacheableProcessor);
            return cacheableProcessor;
        }
        String[] stringArray2 = new String[stringArray.length - 1];
        System.arraycopy(stringArray, 1, stringArray2, 0, stringArray.length - 1);
        cacheableProcessor2 = this.findCacheableProcessor(string, string2, stringArray2, true);
        if (cacheableProcessor2 != null) {
            cacheableProcessor = new CacheableProcessor(this._logHandler);
            cacheableProcessor.setParent(cacheableProcessor2);
            this._xslHashtable.put(string4, cacheableProcessor);
            return cacheableProcessor;
        }
        return null;
    }
}

