/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.xslui.ui;

import com.iplanet.xslui.auth.UserSession;
import com.iplanet.xslui.tools.LDAPConfigReader;
import com.iplanet.xslui.tools.PropertyReader;
import com.iplanet.xslui.ui.Logging;
import com.iplanet.xslui.ui.SessionObjectFactory;
import com.iplanet.xslui.ui.XSLServlet;
import com.iplanet.xslui.ui.XSLUIEngine;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class XSLUIEngineServlet
extends XSLServlet {
    public static final String CONFIG_FILENAME = "uwcconfig.properties";
    public static final String CONFIG_LOGINPAGETEMPLATE = "loginpagetemplate";
    public static final String CONFIG_UWCLOGINPATH = "uwcloginpath";
    public static final String CONFIG_MAIL_HOST = "webmail.host";
    public static final String CONFIG_MAIL_PORT = "webmail.port";
    public static final String CONFIG_SSL_ENABLED = "uwcauth.ssl.enabled";
    public static final String CONFIG_SESSIONOBJ_PREFIX = "sessionobjfactory.";
    public static final String CONFIG_SESSIONID_SUFFIX = ".sessionid";
    private static final String ERROR_TEMPLATE = "error.xml";
    private XSLUIEngine _xslUIHandler = null;
    private static Hashtable _sessionObjTable = null;
    private String _loginPage;
    private String _uwcloginPath;
    private static String _mailURL;

    public void init(ServletConfig servletConfig) throws ServletException {
        Object object;
        String string;
        String string2;
        this._config_filename = CONFIG_FILENAME;
        super.init(servletConfig);
        PropertyReader propertyReader = super.getPropertyReader();
        if (propertyReader == null) {
            throw new ServletException("Couldn't get config from uwcconfig.properties");
        }
        try {
            this._xslUIHandler = new XSLUIEngine(propertyReader.getConfigPath(), Logging.getLogHandler());
        }
        catch (Exception exception) {
            Logging.error(2, "Couldn't create XSLUIEngine: " + exception + exception.getMessage());
            throw new ServletException("Couldn't create XSLUIEngine: " + exception + exception.getMessage());
        }
        _sessionObjTable = new Hashtable();
        Enumeration enumeration = propertyReader.getKeyProperty(CONFIG_SESSIONOBJ_PREFIX, ".class");
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                string2 = CONFIG_SESSIONOBJ_PREFIX + (String)enumeration.nextElement();
                string = propertyReader.getStringProperty(string2 + CONFIG_SESSIONID_SUFFIX, null);
                object = null;
                try {
                    object = propertyReader.getObjectProperty(string2, true);
                }
                catch (Exception exception) {
                    Logging.error(2, "Exception thrown while creating Factory for: " + string2);
                    Logging.errorPrintStackTrace(exception);
                    throw new ServletException("Exception thrown while creating Factory for: " + string2);
                }
                if (string != null && string.length() > 0) {
                    if (object != null) {
                        _sessionObjTable.put(string, object);
                        continue;
                    }
                    Logging.error(2, "Couldn't create Factory for: " + string2);
                    throw new ServletException("error while creating Factory for: " + string2);
                }
                Logging.error(2, "No sessionid for: " + string2);
            }
        } else {
            Logging.error(2, "No sessionObject defined");
        }
        this._loginPage = propertyReader.getStringProperty(CONFIG_LOGINPAGETEMPLATE, "login.xml");
        this._uwcloginPath = propertyReader.getStringProperty(CONFIG_UWCLOGINPATH, "/base/UWCMain");
        string2 = propertyReader.getStringProperty(CONFIG_MAIL_HOST, null);
        string = propertyReader.getStringProperty(CONFIG_MAIL_PORT, null);
        object = (String)servletConfig.getServletContext().getAttribute(CONFIG_SSL_ENABLED);
        Logging.trace(2, "SSL -> " + (String)object);
        String string3 = "http";
        if (object != null && ((String)object).equalsIgnoreCase("true")) {
            string3 = "https";
        }
        if (string2 != null) {
            _mailURL = string3 + "://" + string2;
        }
        if (string != null) {
            _mailURL = _mailURL + ":" + string;
        }
    }

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        Object object;
        String string;
        HttpSession httpSession = null;
        String string2 = null;
        boolean bl = false;
        boolean bl2 = false;
        httpSession = httpServletRequest.getSession(false);
        UserSession userSession = null;
        String string3 = null;
        boolean bl3 = false;
        if (httpSession != null) {
            userSession = (UserSession)httpSession.getAttribute("com.iplanet.xslui.ui.usersession");
            string3 = (String)httpSession.getAttribute("integration");
        }
        String string4 = (String)httpServletRequest.getAttribute("validClientIP");
        String string5 = httpServletRequest.getRequestURI();
        if (httpSession == null || userSession == null) {
            bl2 = true;
            Logging.trace(2, "<--- Usersession not created yet ---->");
        } else if (string4 != null && string4.equals("false")) {
            bl2 = true;
            Logging.error(2, "<--- Client IP conflict --->");
        }
        if (bl2) {
            if (string3 == null) {
                string3 = (String)httpServletRequest.getAttribute("integration");
            }
            if (string3 != null) {
                StringBuffer stringBuffer = new StringBuffer(this._uwcloginPath);
                stringBuffer.append("?");
                stringBuffer.append("gotoUri");
                stringBuffer.append("=");
                stringBuffer.append(string5);
                Logging.trace(2, "Forwarding to -> " + new String(stringBuffer));
                RequestDispatcher requestDispatcher = this.getServletContext().getRequestDispatcher(new String(stringBuffer));
                requestDispatcher.forward((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
                return;
            }
            if (!string5.endsWith("xsl")) {
                string2 = this._loginPage;
            }
        } else {
            Enumeration enumeration = _sessionObjTable.keys();
            while (enumeration.hasMoreElements()) {
                String string6;
                string = (String)enumeration.nextElement();
                object = httpSession.getAttribute(string);
                if (object != null) continue;
                SessionObjectFactory sessionObjectFactory = (SessionObjectFactory)_sessionObjTable.get(string);
                object = sessionObjectFactory.newSessionObject(userSession, string6 = (String)httpSession.getAttribute("domainname"));
                if (object != null) {
                    httpSession.setAttribute(string, object);
                } else {
                    Logging.error(2, "Can't create SessionObject: " + string + " for user " + userSession.getUserId());
                    string2 = ERROR_TEMPLATE;
                }
                bl = true;
            }
        }
        if (!bl3) {
            if (bl) {
                httpSession.setAttribute("com.iplanet.xslui.ui.freshlogin", (Object)"true");
            } else {
                httpSession.setAttribute("com.iplanet.xslui.ui.freshlogin", (Object)"false");
            }
            if (string5.endsWith("jsp")) {
                int n = string5.indexOf("/", 1);
                string = string5.substring(0, n);
                string = string.concat("jsp");
                string = string.concat(string5.substring(n));
                object = this.getServletContext().getRequestDispatcher(string);
                object.forward((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
            } else {
                this._xslUIHandler.process(httpServletRequest, httpServletResponse, string2);
            }
        }
    }

    public void destroy() {
        Logging.trace(2, "Destroying LDAPPool for Address Book");
        LDAPConfigReader.destroyPool();
    }

    public static String getMailURL() {
        return _mailURL;
    }

    public static Hashtable getSessionObjectTable() {
        return _sessionObjTable;
    }
}

