/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.xslui.ui;

import com.iplanet.xslui.dbtrans.DbTransException;
import com.iplanet.xslui.dbtrans.DbTranslation;
import com.iplanet.xslui.tools.PropertyReader;
import com.iplanet.xslui.ui.CacheableXML;
import com.iplanet.xslui.ui.ElementHandler;
import com.iplanet.xslui.ui.FormHandler;
import com.iplanet.xslui.ui.ProcessingHandler;
import com.iplanet.xslui.ui.XSLUILocator;
import com.iplanet.xslui.ui.XSLUILocatorHandler;
import com.iplanet.xslui.ui.XSLXMLCache;
import com.iplanet.xslui.xslutil.XMLDOMBuilder;
import com.iplanet.xslui.xslutil.XMLDOMContentHandler;
import com.iplanet.xslui.xslutil.XMLProcessingException;
import com.iplanet.xslui.xslutil.XSLProcessingException;
import com.iplanet.xslui.xslutil.XSLXMLLogHandler;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;

public class XSLUIEngine {
    public static final String CONFIG_FILENAME = "xsluiengine.properties";
    public static final String CONFIG_RELOADONCHANGE = "reloadonchange";
    public static final String CONFIG_USETRANSLETS = "useTranslets";
    public static final String CONFIG_XMLHANDLER_PREFIX = "xmlhandler.";
    public static final String CONFIG_HANDLER_XLATEPATH = ".xlatepath";
    public static final String CONFIG_XSLUILOCATORHANDLER = "xsluilocatorhandler";
    public static final String CONFIG_FORMHANDLER_PREFIX = "formhandler.";
    public static final String CONFIG_FORMHANDLER_ACTION = "actionattributename";
    public static final String CONFIG_FORMHANDLER_NEXTVIEW = ".nextview";
    public static final String CONFIG_FORMHANDLER_ERRORVIEW = ".errorview";
    public static final String CONFIG_PROCHANDLER_PREFIX = "prochandler.";
    public static final String CONFIG_ROOTPATH = "defaultxsluilocatorhandler.rootpath";
    private HashMap _elementHandlerTable = null;
    private HashMap _formHandlerTable = null;
    private HashMap _procHandlerTable = null;
    private XSLXMLCache _xslxmlCache = null;
    private XSLUILocatorHandler _locatorHandler = null;
    private XSLXMLLogHandler _logHandler = null;
    private XMLDOMBuilder _xmlBuilder = null;
    private boolean _useGzip = false;
    private boolean _useTranslets = false;
    private String _formActionAttribute = null;
    private String[] _weekday = new String[]{"Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"};
    private String _uiRootPath = null;

    public XSLUIEngine(File file, XSLXMLLogHandler xSLXMLLogHandler) throws IOException {
        String string;
        String string2 = null;
        this._logHandler = xSLXMLLogHandler;
        PropertyReader propertyReader = null;
        try {
            propertyReader = new PropertyReader(file, CONFIG_FILENAME);
        }
        catch (Exception exception) {
            throw new IOException("XSLUIEngine: can't open configuration file at " + file.toString() + " : " + exception.getMessage());
        }
        boolean bl = propertyReader.getBooleanProperty(CONFIG_RELOADONCHANGE, "false");
        string2 = propertyReader.getStringProperty(CONFIG_ROOTPATH, "../ui");
        this._uiRootPath = new File(file, string2).getAbsolutePath();
        this._xslxmlCache = new XSLXMLCache(bl, this._logHandler, this._uiRootPath);
        this._useTranslets = propertyReader.getBooleanProperty(CONFIG_USETRANSLETS, "false");
        this._formActionAttribute = propertyReader.getStringProperty("formhandler.actionattributename", "myaction");
        this._elementHandlerTable = new HashMap();
        Enumeration enumeration = propertyReader.getKeyProperty(CONFIG_XMLHANDLER_PREFIX, ".class");
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            this.loadXMLHandler(propertyReader, string);
        }
        this._formHandlerTable = new HashMap();
        enumeration = propertyReader.getKeyProperty(CONFIG_FORMHANDLER_PREFIX, ".class");
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            this.loadFormHandler(propertyReader, string);
        }
        this._procHandlerTable = new HashMap();
        enumeration = propertyReader.getKeyProperty(CONFIG_PROCHANDLER_PREFIX, ".class");
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            this.loadProcHandler(propertyReader, string);
        }
        try {
            this._locatorHandler = (XSLUILocatorHandler)propertyReader.getObjectProperty(CONFIG_XSLUILOCATORHANDLER, false);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new IOException("XSLUIEngine: couldn't load locator: " + exception.getMessage());
        }
        if (this._locatorHandler == null) {
            throw new IOException("XSLUIEngine: couldn't load locator: xsluilocatorhandler");
        }
        boolean bl2 = this._locatorHandler.init(file, propertyReader.getProperties(), this._logHandler);
        if (!bl2) {
            throw new IOException("XSLUIEngine: couldn't initialize locator");
        }
        try {
            this._xmlBuilder = new XMLDOMBuilder(this._logHandler);
        }
        catch (XMLProcessingException xMLProcessingException) {
            throw new IOException("XSLUIEngine.process: Couldn't create XMLDOMBuilder: " + xMLProcessingException.getMessage());
        }
    }

    public void process(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string) throws IOException {
        ProcessingHandler processingHandler;
        String string2;
        Object object;
        Element element;
        Document document;
        XSLUILocator xSLUILocator;
        Date date;
        ServletOutputStream servletOutputStream;
        block54: {
            servletOutputStream = null;
            date = new Date();
            xSLUILocator = this._locatorHandler.getLocator(httpServletRequest);
            if (xSLUILocator == null) {
                httpServletResponse.sendError(404, "XSLUIEngine.process: couldn't find locator");
                return;
            }
            document = null;
            element = null;
            document = this._xmlBuilder.newDocument();
            try {
                element = document.createElement("errormessages");
            }
            catch (DOMException dOMException) {
                if (!this._logHandler.isLogEnabled()) break block54;
                this._logHandler.error("XSLUIEngine.process: Could not create errorRootElt: " + dOMException.getMessage());
            }
        }
        String string3 = null;
        String string4 = null;
        string4 = httpServletRequest.getParameter("nextview");
        String[] stringArray = httpServletRequest.getParameterValues(this._formActionAttribute);
        if (stringArray != null) {
            if (stringArray.length == 1) {
                if (stringArray[0].length() > 0) {
                    string3 = stringArray[0];
                    object = (FormHandler)this._formHandlerTable.get(string3);
                    if (object != null) {
                        boolean bl = ((FormHandler)object).process(httpServletRequest, element);
                        string = bl ? (string4 != null && string4.length() > 0 ? string4 : ((FormHandler)object).getNextView()) : ((FormHandler)object).getErrorView();
                    } else if (this._logHandler.isLogEnabled()) {
                        this._logHandler.error("XSLUIEngine.process: unrecognized action: " + string3);
                    }
                }
            } else if (this._logHandler.isLogEnabled()) {
                this._logHandler.error("XSLUIEngine.process: more than one action: " + stringArray.length);
            }
        }
        if (string == null && (string = xSLUILocator.getXMLTemplate()) == null) {
            httpServletResponse.sendError(404, "XSLUIEngine.process: Couldn't find template name");
            return;
        }
        if (!string.endsWith(".xml") && !string.endsWith(".xsl")) {
            int n = string.lastIndexOf(".");
            string = n > 0 ? string.substring(0, n) + ".xml" : string + ".xml";
        }
        if ((object = xSLUILocator.getPathList()) == null) {
            httpServletResponse.sendError(404, "XSLUIEngine.process: Couldn't find path list");
            return;
        }
        String string5 = xSLUILocator.getDictionaryName();
        servletOutputStream = httpServletResponse.getOutputStream();
        CacheableXML cacheableXML = null;
        Document document2 = null;
        try {
            cacheableXML = this._xslxmlCache.getXMLTemplateCacheable(string, (String[])object);
        }
        catch (XMLProcessingException xMLProcessingException) {
            xMLProcessingException.printStackTrace(new PrintStream((OutputStream)servletOutputStream));
            return;
        }
        if (cacheableXML == null) {
            servletOutputStream.close();
            httpServletResponse.sendError(404, "XSLUIEngine.process: couldn't find template Document " + string);
            return;
        }
        document2 = (Document)cacheableXML.getObject();
        if (document2 == null) {
            servletOutputStream.close();
            httpServletResponse.sendError(404, "XSLUIEngine.process: couldn't find XML Document " + string);
            return;
        }
        ProcInstruction procInstruction = new ProcInstruction(document2);
        String string6 = procInstruction.getHRef();
        if (string6 == null) {
            if (string5 != null) {
                try {
                    cacheableXML = this._xslxmlCache.getXMLTemplateCacheable(string, string5, (String[])object);
                }
                catch (XMLProcessingException xMLProcessingException) {
                    xMLProcessingException.printStackTrace(new PrintStream((OutputStream)servletOutputStream));
                    return;
                }
                if (cacheableXML == null) {
                    throw new IOException("XSLUIEngine.process: Couldn't find translated template Document");
                }
                document2 = (Document)cacheableXML.getObject();
                if (document2 == null) {
                    throw new IOException("XSLUIEngine.process: Couldn't find XML translated Document " + string);
                }
            }
            long l = cacheableXML.getLastLoaded();
            Date date2 = new Date(l);
            long l2 = httpServletRequest.getDateHeader("If-Modified-Since");
            if (l2 < 0L || l - l2 >= 1000L) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(date2);
                String string7 = this._weekday[calendar.get(7) - 1];
                byte[] byArray = cacheableXML.getXMLContent();
                httpServletResponse.setContentType("text/xml");
                httpServletResponse.setHeader("Last-Modified", string7 + ", " + date2.toGMTString());
                httpServletResponse.setHeader("Content-Length", String.valueOf(byArray.length));
                servletOutputStream.write(byArray);
            } else {
                if (this._logHandler.isLogEnabled()) {
                    this._logHandler.debug("XSLUIEngine.process GET request for file : " + string + ". Client cached file up to date. Returning status " + 304 + ".");
                }
                httpServletResponse.setStatus(304);
            }
            servletOutputStream.close();
            return;
        }
        Date date3 = new Date();
        XMLExpandHandler xMLExpandHandler = new XMLExpandHandler(httpServletRequest, this._elementHandlerTable, document, element);
        Document document3 = null;
        try {
            document3 = this._xmlBuilder.newDocument(document2);
            document3.removeChild(document3.getDocumentElement());
            document3.appendChild(this._xmlBuilder.copyNode((Node)document2.getDocumentElement(), document3, (XMLDOMContentHandler)xMLExpandHandler));
            if (element.hasChildNodes()) {
                document3.getDocumentElement().appendChild(this._xmlBuilder.copyNode((Node)element, document3));
            }
        }
        catch (XMLProcessingException xMLProcessingException) {
            throw new IOException("XSLUIEngine.process: Error while expanding tree: " + xMLProcessingException.getMessage());
        }
        Date date4 = new Date();
        String string8 = httpServletResponse.encodeURL("/").substring(1);
        Element element2 = document3.getDocumentElement();
        element2.setAttribute("sessionstring", string8);
        String string9 = httpServletRequest.getContextPath();
        if (string9 == null || string9 != null && string9.trim().length() == 0) {
            string9 = "";
        }
        element2.setAttribute("contexturi", string9);
        if (string3 != null) {
            element2.setAttribute("uiaction", string3);
        }
        if (!string.equalsIgnoreCase(string4) && string4 != null) {
            element2.setAttribute("nextview", string4);
        } else {
            element2.setAttribute("nextview", "");
        }
        String string10 = httpServletRequest.getParameter("dumpXML");
        if (string10 == null) {
            string10 = element2.getAttribute("dumpXML");
        }
        if (string10 != null && string10.equals("1")) {
            Object object2;
            Date date5 = new Date();
            httpServletResponse.setContentType("text/xml");
            try {
                for (object2 = document3.getFirstChild(); object2 != null; object2 = object2.getNextSibling()) {
                    if (object2.getNodeType() != 7) continue;
                    document3.removeChild((Node)object2);
                }
                XMLDOMBuilder.dumpNode((Node)document3, (OutputStream)servletOutputStream);
            }
            catch (XMLProcessingException xMLProcessingException) {
                throw new IOException("XSLUIEngine.process: Couldn't dump expanded XML" + string + " : " + xMLProcessingException.getMessage());
            }
            servletOutputStream.close();
            if (this._logHandler.isLogEnabled()) {
                object2 = new Date();
                Date date6 = new Date();
                long l = date6.getTime() - date.getTime();
                long l3 = date3.getTime() - date.getTime();
                long l4 = date4.getTime() - date3.getTime();
                long l5 = date5.getTime() - date4.getTime();
                long l6 = ((Date)object2).getTime() - date5.getTime();
                long l7 = date6.getTime() - ((Date)object2).getTime();
                this._logHandler.debug("Total       time: " + l);
                this._logHandler.debug("Preprocess  time: " + l3 + " (" + l3 * 100L / l + "%)");
                this._logHandler.debug("Expand      time: " + l4 + " (" + l4 * 100L / l + "%)");
                this._logHandler.debug("Inter proc  time: " + l5 + " (" + l5 * 100L / l + "%)");
                this._logHandler.debug("Dumping     time: " + l6 + " (" + l6 * 100L / l + "%)");
            }
            return;
        }
        boolean bl = procInstruction.isTypeXSL();
        if (bl && xSLUILocator.supportClientXSLProcessing()) {
            Date date7 = new Date();
            httpServletResponse.setContentType("text/xml");
            try {
                XMLDOMBuilder.dumpNode((Node)document3, (OutputStream)servletOutputStream);
            }
            catch (XMLProcessingException xMLProcessingException) {
                throw new IOException("XSLUIEngine.process: Couldn't dump expanded XML" + string + " : " + xMLProcessingException.getMessage());
            }
            Date date8 = new Date();
            servletOutputStream.close();
            Date date9 = new Date();
            long l = date9.getTime() - date.getTime();
            long l8 = date3.getTime() - date.getTime();
            long l9 = date4.getTime() - date3.getTime();
            long l10 = date7.getTime() - date4.getTime();
            long l11 = date8.getTime() - date7.getTime();
            long l12 = date9.getTime() - date8.getTime();
            this._logHandler.debug("Total       time: " + l);
            this._logHandler.debug("Preprocess  time: " + l8 + " (" + l8 * 100L / l + "%)");
            this._logHandler.debug("Expand      time: " + l9 + " (" + l9 * 100L / l + "%)");
            this._logHandler.debug("Inter proc  time: " + l10 + " (" + l10 * 100L / l + "%)");
            this._logHandler.debug("Dumping     time: " + l11 + " (" + l11 * 100L / l + "%)");
            return;
        }
        String string11 = null;
        String string12 = element2.getAttribute("content-type");
        if (string12 == null || string12.length() <= 0) {
            string12 = "text/html";
        }
        if ((string2 = element2.getAttribute("charset")) == null || string2.length() > 0) {
            string2 = "UTF-8";
        }
        string11 = string12 + "; " + "charset" + "=" + string2;
        httpServletResponse.setContentType(string11);
        if (!bl) {
            processingHandler = (ProcessingHandler)this._procHandlerTable.get(string6);
            if (processingHandler != null) {
                try {
                    processingHandler.process(httpServletRequest, document3, (OutputStream)servletOutputStream);
                }
                catch (Exception exception) {
                    this._logHandler.error("ProcessingHandler hook: Error while processing: " + exception.getClass() + ": " + exception.getMessage());
                    exception.printStackTrace();
                }
                servletOutputStream.close();
                return;
            }
            this._logHandler.error("ProcessingHandler hook: hook not found: " + string6);
        }
        processingHandler = null;
        try {
            processingHandler = this._xslxmlCache.getXSLProcessorPool(string6, string5, (String[])object);
        }
        catch (XMLProcessingException xMLProcessingException) {
            xMLProcessingException.printStackTrace(new PrintStream((OutputStream)servletOutputStream));
            return;
        }
        if (processingHandler == null) {
            throw new IOException("XSLUIEngine.process: Couldn't find XSLProcessorPool: " + string6);
        }
        Date date10 = new Date();
        try {
            processingHandler.process(document3, (OutputStream)servletOutputStream, this._useTranslets);
        }
        catch (XSLProcessingException xSLProcessingException) {
            PrintStream printStream = new PrintStream((OutputStream)servletOutputStream);
            printStream.println("Error while processing " + string6);
            xSLProcessingException.printStackTrace(printStream);
            return;
        }
        Date date11 = new Date();
        servletOutputStream.close();
        Date date12 = new Date();
        long l = date12.getTime() - date.getTime();
        long l13 = date3.getTime() - date.getTime();
        long l14 = date4.getTime() - date3.getTime();
        long l15 = date10.getTime() - date4.getTime();
        long l16 = date11.getTime() - date10.getTime();
        long l17 = date12.getTime() - date11.getTime();
        this._logHandler.debug("Total       time: " + l);
        this._logHandler.debug("Preprocess  time: " + l13 + " (" + l13 * 100L / l + "%)");
        this._logHandler.debug("Expand      time: " + l14 + " (" + l14 * 100L / l + "%)");
        this._logHandler.debug("Inter proc  time: " + l15 + " (" + l15 * 100L / l + "%)");
        this._logHandler.debug("Process     time: " + l16 + " (" + l16 * 100L / l + "%)");
        this._logHandler.debug("Final       time: " + l17 + " (" + l17 * 100L / l + "%)");
    }

    private void loadXMLHandler(PropertyReader propertyReader, String string) {
        ElementHandler elementHandler = null;
        try {
            elementHandler = (ElementHandler)propertyReader.getObjectProperty(CONFIG_XMLHANDLER_PREFIX + string, false);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this._logHandler.error("XSLUIEngine: couldn't load " + string + " : " + exception.getMessage());
            return;
        }
        boolean bl = elementHandler.init(propertyReader, this._logHandler);
        if (bl) {
            File file = propertyReader.getFileProperty(CONFIG_XMLHANDLER_PREFIX + string + CONFIG_HANDLER_XLATEPATH, "");
            if (file != null) {
                DbTranslation dbTranslation = null;
                try {
                    dbTranslation = new DbTranslation(file);
                }
                catch (Exception exception) {
                    this._logHandler.error("XSLUIEngine: couldn't load xlator for " + string + " : " + exception + " : " + exception.getMessage());
                    return;
                }
                elementHandler.setTranslator(dbTranslation);
            }
            this._elementHandlerTable.put(string, elementHandler);
            this._logHandler.debug("XSLUIEngine.loadElementHandler: adding a handler for element " + string);
        } else {
            this._logHandler.error("XSLUIEngine: couldn't initialize " + string);
        }
    }

    private void loadFormHandler(PropertyReader propertyReader, String string) {
        FormHandler formHandler = null;
        formHandler = (FormHandler)this._formHandlerTable.get(string);
        if (formHandler != null) {
            return;
        }
        try {
            formHandler = (FormHandler)propertyReader.getObjectProperty(CONFIG_FORMHANDLER_PREFIX + string, false);
        }
        catch (Exception exception) {
            this._logHandler.error("XSLUIEngine.loadFormHandler: couldn't load " + string + " : " + exception.getMessage());
            exception.printStackTrace();
            return;
        }
        boolean bl = formHandler.init(string, propertyReader, this._logHandler);
        if (!bl) {
            this._logHandler.error("XSLUIEngine.loadFormHandler: couldn't initialize " + string);
        }
        String string2 = propertyReader.getStringProperty(CONFIG_FORMHANDLER_PREFIX + string + CONFIG_FORMHANDLER_NEXTVIEW, null);
        formHandler.setNextView(string2);
        string2 = propertyReader.getStringProperty(CONFIG_FORMHANDLER_PREFIX + string + CONFIG_FORMHANDLER_ERRORVIEW, null);
        formHandler.setErrorView(string2);
        File file = propertyReader.getFileProperty(CONFIG_FORMHANDLER_PREFIX + string + CONFIG_HANDLER_XLATEPATH, "");
        if (file != null) {
            DbTranslation dbTranslation = null;
            try {
                dbTranslation = new DbTranslation(file);
            }
            catch (DbTransException dbTransException) {
                this._logHandler.error("XSLUIEngine: couldn't load xlator" + string + " : " + dbTransException.getMessage());
                return;
            }
            formHandler.setTranslator(dbTranslation);
        }
        this._formHandlerTable.put(string, formHandler);
        this._logHandler.debug("XSLUIEngine.loadFormHandler: adding a handler for action " + string);
    }

    private void loadProcHandler(PropertyReader propertyReader, String string) {
        ProcessingHandler processingHandler = null;
        try {
            processingHandler = (ProcessingHandler)propertyReader.getObjectProperty(CONFIG_PROCHANDLER_PREFIX + string, false);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this._logHandler.error("XSLUIEngine: couldn't load " + string + " : " + exception.getMessage());
            return;
        }
        boolean bl = processingHandler.init(propertyReader, this._logHandler);
        if (bl) {
            File file = propertyReader.getFileProperty(CONFIG_PROCHANDLER_PREFIX + string + CONFIG_HANDLER_XLATEPATH, "");
            if (file != null) {
                DbTranslation dbTranslation = null;
                try {
                    dbTranslation = new DbTranslation(file);
                }
                catch (Exception exception) {
                    this._logHandler.error("XSLUIEngine: couldn't load xlator for " + string + " : " + exception + " : " + exception.getMessage());
                    return;
                }
                processingHandler.setTranslator(dbTranslation);
            }
            this._procHandlerTable.put(string, processingHandler);
            this._logHandler.debug("XSLUIEngine.loadProcHandler: adding a handler for element " + string);
        } else {
            this._logHandler.error("XSLUIEngine: couldn't initialize " + string);
        }
    }

    private class XMLExpandHandler
    extends XMLDOMContentHandler {
        private HashMap _elementHandlerTable = null;
        private HttpServletRequest _httpRequest = null;
        private Document _errorDoc = null;
        private Element _errorRootElt = null;

        public XMLExpandHandler(HttpServletRequest httpServletRequest, HashMap hashMap, Document document, Element element) {
            this._elementHandlerTable = hashMap;
            this._httpRequest = httpServletRequest;
            this._errorDoc = document;
            this._errorRootElt = element;
        }

        public void preElementHandler(Element element, Document document) {
            ElementHandler elementHandler = (ElementHandler)this._elementHandlerTable.get(element.getTagName());
            if (elementHandler == null) {
                return;
            }
            try {
                elementHandler.preExpand(this._httpRequest, element, this._errorRootElt);
            }
            catch (Exception exception) {
                XSLUIEngine.this._logHandler.error("XMLExpandHandler.preElementHandler: Error while pre-processing <" + element.getTagName() + ">: " + exception.getClass() + ": " + exception.getMessage());
            }
        }

        public void elementHandler(Element element, Document document) {
            ElementHandler elementHandler = (ElementHandler)this._elementHandlerTable.get(element.getTagName());
            if (elementHandler == null) {
                return;
            }
            try {
                elementHandler.expand(this._httpRequest, element, this._errorRootElt);
            }
            catch (Exception exception) {
                XSLUIEngine.this._logHandler.error("XMLExpandHandler.elementHandler: Error while processing <" + element.getTagName() + ">: " + exception.getClass() + ": " + exception.getMessage());
            }
        }
    }

    private class ProcInstruction {
        private String _type = null;
        private String _href = null;

        public ProcInstruction(Document document) {
            for (Node node = document.getFirstChild(); node != null && node.getNodeType() != 1; node = node.getNextSibling()) {
                int n;
                int n2;
                int n3;
                int n4;
                ProcessingInstruction processingInstruction;
                String string;
                if (node.getNodeType() != 7 || (string = (processingInstruction = (ProcessingInstruction)node).getData()) == null || (n4 = string.indexOf("type") + 6) == -1 || (n3 = string.indexOf("\"", n4)) == -1 || (n2 = string.indexOf("href") + 6) == -1 || (n = string.indexOf("\"", n2)) == -1) continue;
                this._type = string.substring(n4, n3);
                this._href = string.substring(n2, n);
            }
        }

        public String getType() {
            return this._type;
        }

        public String getHRef() {
            return this._href;
        }

        public boolean isTypeXSL() {
            return this._type != null && this._type.equals("text/xsl");
        }
    }
}

