/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.xslui.ui;

import com.iplanet.xslui.tools.MultipartHttpServletRequest;
import com.iplanet.xslui.tools.PropertyReader;
import com.iplanet.xslui.ui.Logging;
import java.io.File;
import java.io.IOException;
import java.util.Properties;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class XSLServlet
extends HttpServlet {
    protected String _config_filename = "xsl.properties";
    public static final String CONFIG_LOGFILE = "log.file";
    public static final String CONFIG_LOGLEVEL = "log.level";
    public static final String CONFIG_LOGCOMPONENTS = "log.components";
    public static final String CONFIG_MAXPOSTCONTENTLENGTH = "maxpostcontentlength";
    public static final String CONFIG_CONFIGPATH_SUFFIX = ".configpath";
    private int _maxPostContentLength = -1;
    private PropertyReader _propertyReader;
    private static final String TRANSLETS_LIBPATH_PROPERTY = "com.sun.iabs.translets.libPath";

    public void init(ServletConfig servletConfig) throws ServletException {
        Properties properties;
        String string = null;
        super.init(servletConfig);
        String string2 = servletConfig.getInitParameter("configPath");
        if (string2 == null && (string2 = (properties = servletConfig.getServletContext()).getRealPath("/")) == null) {
            string2 = "./";
        }
        properties = System.getProperties();
        string = string2 + File.separator + "WEB-INF" + File.separator + "lib";
        try {
            string = new File(string).getCanonicalPath();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new ServletException("XSLServlet.init(): Trouble getting the canonical path of : " + string);
        }
        properties.setProperty(TRANSLETS_LIBPATH_PROPERTY, string);
        File file = new File(new File(string2, "local-conf"), "config");
        if (!file.isDirectory() && !(file = new File(string2, "WEB-INF/config")).isDirectory()) {
            throw new ServletException("XSLServlet: can't open configuration dir " + file.toString());
        }
        try {
            this._propertyReader = new PropertyReader(file, this._config_filename);
        }
        catch (Exception exception) {
            throw new ServletException("XSLServlet: can't open configuration file " + this._config_filename + " in " + file.toString() + " : " + exception.getMessage());
        }
        String string3 = this._propertyReader.getStringProperty(CONFIG_LOGFILE, "");
        int n = this._propertyReader.getIntProperty(CONFIG_LOGLEVEL, 2);
        int n2 = this._propertyReader.getIntProperty(CONFIG_LOGCOMPONENTS, 2);
        Logging logging = null;
        if (string3.length() > 0) {
            File file2 = new File(string3);
            logging = new Logging(file2);
        } else {
            logging = new Logging(this.getServletContext());
        }
        Logging.setState(n);
        Logging.setPackage(n2);
        this._maxPostContentLength = this._propertyReader.getIntProperty(CONFIG_MAXPOSTCONTENTLENGTH, -1);
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = httpServletRequest.getContentType();
        if (string != null && string.toLowerCase().startsWith("multipart/form-data")) {
            if (this._maxPostContentLength != -1) {
                int n = httpServletRequest.getContentLength();
                if (n < this._maxPostContentLength && n >= 0) {
                    MultipartHttpServletRequest multipartHttpServletRequest = new MultipartHttpServletRequest(httpServletRequest);
                    this.doGet((HttpServletRequest)multipartHttpServletRequest, httpServletResponse);
                } else {
                    httpServletResponse.sendError(413, "Sorry, the file submitted is too large.");
                }
            }
        } else {
            this.doGet(httpServletRequest, httpServletResponse);
        }
    }

    public String getServletInfo() {
        return "XSL Servlet: " + ((Object)((Object)this)).getClass().getName();
    }

    public PropertyReader getPropertyReader() {
        return this._propertyReader;
    }
}

