/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.xslui.ui;

import com.iplanet.xslui.tools.MultipartRequest;
import com.iplanet.xslui.tools.PropertyReader;
import com.iplanet.xslui.ui.FormHandler;
import com.iplanet.xslui.xslutil.XSLXMLLogHandler;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import org.w3c.dom.Element;

public class FileUploadFormHandler
extends FormHandler {
    public static final String CONFIG_UPLOADPATH = "fileuploadformhandler.uploadpath";
    private File _uploadFile;

    public boolean init(String string, PropertyReader propertyReader, XSLXMLLogHandler xSLXMLLogHandler) {
        Properties properties = propertyReader.getProperties();
        boolean bl = super.init(string, propertyReader, xSLXMLLogHandler);
        if (!bl) {
            return false;
        }
        String string2 = properties.getProperty(CONFIG_UPLOADPATH, "/tmp");
        this._uploadFile = new File(string2);
        if (!this._uploadFile.isDirectory()) {
            this._logHandler.error("FileUploadFormHandler: wrong path: " + string2);
            return false;
        }
        return true;
    }

    public boolean process(HttpServletRequest httpServletRequest, Element element) {
        MultipartRequest multipartRequest = (MultipartRequest)httpServletRequest;
        InputStream inputStream = multipartRequest.getFileParameter("file");
        if (inputStream == null) {
            this._logHandler.error("FileUploadFormHandler: null file");
            return false;
        }
        String string = multipartRequest.getParameter("filename");
        if (string == null || string.length() == 0) {
            this._logHandler.error("FileUploadFormHandler: null filename");
            return false;
        }
        File file = new File(this._uploadFile, string);
        try {
            file.createNewFile();
        }
        catch (IOException iOException) {
            this._logHandler.error("FileUploadFormHandler: failed to create " + file.toString());
            return false;
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            int n = 0;
            while (n != -1) {
                byte[] byArray = new byte[1];
                n = inputStream.read(byArray);
                if (n == -1) continue;
                fileOutputStream.write(byArray);
            }
            fileOutputStream.flush();
            fileOutputStream.close();
        }
        catch (Exception exception) {
            this._logHandler.error("FileUploadFormHandler: failed to write " + file.toString() + " : " + exception.getMessage());
            return false;
        }
        return true;
    }
}

