/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.xslui.ui;

import com.iplanet.xslui.ui.XSLUILocator;
import com.iplanet.xslui.ui.XSLUILocatorHandler;
import com.iplanet.xslui.xslutil.XSLXMLLogHandler;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class DefaultXSLUILocatorHandler
extends XSLUILocatorHandler {
    public static final String CONFIG_PREFIX = "defaultxsluilocatorhandler";
    public static final String CONFIG_ROOTPATH = "defaultxsluilocatorhandler.rootpath";
    public static final String CONFIG_DEFAULTDEVICE = "defaultxsluilocatorhandler.defaultdevice";
    public static final String CONFIG_USERAGENT = "useragent";
    public static final String CONFIG_SUPPORTCLIENTXSL = "supportclientxsl";
    public static final String CONFIG_DEVICE = "device";
    private XSLXMLLogHandler _logHandler = null;
    private String _rootPath = null;
    private String _defaultDevice = null;
    private Hashtable _userAgentTable = null;

    public boolean init(File file, Properties properties, XSLXMLLogHandler xSLXMLLogHandler) {
        this._logHandler = xSLXMLLogHandler;
        this._rootPath = file.getAbsolutePath();
        this._userAgentTable = new Hashtable();
        this._defaultDevice = "html";
        boolean bl = false;
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string;
            Object object;
            Object object2;
            String string2 = (String)enumeration.nextElement();
            if (!string2.startsWith(CONFIG_PREFIX)) continue;
            if (string2.equals(CONFIG_ROOTPATH)) {
                object2 = new File(properties.getProperty(string2));
                if (((File)object2).isAbsolute()) {
                    if (((File)object2).exists()) {
                        this._rootPath = ((File)object2).getAbsolutePath();
                    } else {
                        bl = true;
                    }
                } else {
                    object = new File(file, ((File)object2).getPath());
                    if (((File)object).exists()) {
                        this._rootPath = ((File)object).getAbsolutePath();
                    } else {
                        bl = true;
                    }
                }
                this._logHandler.debug("DefaultXSLUILocatorHandler.init: rootpath for UI=" + this._rootPath);
                continue;
            }
            if (bl) {
                object2 = new File("../../WEB-INF/ui");
                object = new File(file, ((File)object2).getPath());
                this._rootPath = ((File)object).getAbsolutePath();
                this._logHandler.debug("DefaultXSLUILocatorHandler.init: rootpath for UI=" + this._rootPath);
                bl = false;
                continue;
            }
            if (string2.equals(CONFIG_DEFAULTDEVICE)) {
                this._defaultDevice = properties.getProperty(string2);
                continue;
            }
            object2 = string2.substring(string2.indexOf("."), string2.lastIndexOf(".") + 1);
            if (object2 == null || ((String)object2).length() <= 0 || (object = (UserAgent)this._userAgentTable.get(object2)) != null || (string = properties.getProperty(CONFIG_PREFIX + (String)object2 + CONFIG_USERAGENT)) == null) continue;
            object = new UserAgent(string);
            ((UserAgent)object).setDevice(properties.getProperty(CONFIG_PREFIX + (String)object2 + CONFIG_DEVICE, this._defaultDevice));
            boolean bl2 = Boolean.valueOf(properties.getProperty(CONFIG_PREFIX + (String)object2 + CONFIG_SUPPORTCLIENTXSL, "false"));
            ((UserAgent)object).setXSLSupport(bl2);
            this._logHandler.debug("DefaultXSLUILocatorHandler.init: adding " + (String)object2 + "(" + ((UserAgent)object).toString() + ")");
            this._userAgentTable.put(object2, object);
        }
        return true;
    }

    public XSLUILocator getLocator(HttpServletRequest httpServletRequest) throws IOException {
        String[] stringArray;
        String string = this._defaultDevice;
        boolean bl = false;
        String string2 = httpServletRequest.getRequestURI();
        int n = string2.lastIndexOf("/");
        int n2 = string2.substring(0, n).lastIndexOf("/");
        String string3 = string2.substring(n + 1);
        String string4 = "";
        if (n2 > -1) {
            string4 = string2.substring(n2 + 1, n);
        }
        if (string3 == null) {
            this._logHandler.error("DefaultXSLUILocatorHandler.getLocator: Couldn't find XML template in " + string2);
            return null;
        }
        HttpSession httpSession = httpServletRequest.getSession(false);
        if (httpSession == null) {
            this._logHandler.error("DefaultXSLUILocatorHandler.getLocator: no session");
            return null;
        }
        String string5 = (String)httpSession.getAttribute("domainname");
        if (string5 == null) {
            this._logHandler.error("DefaultXSLUILocatorHandler.getLocator: no domain");
            return null;
        }
        String string6 = httpServletRequest.getParameter("lang");
        if (string6 != null) {
            httpSession.setAttribute("userlang", (Object)string6);
        } else {
            string6 = (String)httpSession.getAttribute("userlang");
            if (string6 == null) {
                string6 = httpServletRequest.getHeader("Accept-Language");
            }
        }
        if (string6 == null) {
            string6 = "en";
        }
        Enumeration enumeration = this._userAgentTable.elements();
        while (enumeration.hasMoreElements()) {
            stringArray = (String[])enumeration.nextElement();
            if (!stringArray.match(httpServletRequest)) continue;
            string = stringArray.getDevice();
            bl = stringArray.supportClientXSL();
            break;
        }
        stringArray = new String[]{this._rootPath + "/" + string + "/" + string4 + "/" + string5 + "/" + string6 + "/", this._rootPath + "/" + string + "/" + string4 + "/" + string5 + "/", this._rootPath + "/" + string + "/" + string5 + "/" + string6 + "/", this._rootPath + "/" + string + "/" + string5 + "/", this._rootPath + "/" + string + "/" + string4 + "/" + string6 + "/", this._rootPath + "/" + string + "/" + string4 + "/", this._rootPath + "/" + string + "/" + string6 + "/", this._rootPath + "/" + string + "/", this._rootPath + "/" + string6 + "/", this._rootPath + "/"};
        XSLUILocator xSLUILocator = new XSLUILocator(string3, "dictionary-" + string6 + ".xml", stringArray, bl);
        return xSLUILocator;
    }

    private class UserAgent {
        private String _startWith = null;
        private String _device = "html";
        private boolean _supportClientXSL = false;

        public UserAgent(String string) {
            this._startWith = string;
        }

        public boolean match(HttpServletRequest httpServletRequest) {
            String string = httpServletRequest.getHeader("User-Agent");
            if (string == null) {
                return false;
            }
            return string.startsWith(this._startWith);
        }

        public void setDevice(String string) {
            this._device = string;
        }

        public String getDevice() {
            return this._device;
        }

        public void setXSLSupport(boolean bl) {
            this._supportClientXSL = bl;
        }

        public boolean supportClientXSL() {
            return this._supportClientXSL;
        }

        public String toString() {
            return "Pattern:" + this._startWith + ";Device:" + this._device + ";supportClientXSL:" + this._supportClientXSL;
        }
    }
}

