/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.xslui.ui;

import com.iplanet.xslui.ui.CacheableObject;
import com.iplanet.xslui.xslutil.XMLDOMBuilder;
import com.iplanet.xslui.xslutil.XMLProcessingException;
import com.iplanet.xslui.xslutil.XSLXMLLogHandler;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class CacheableXML
extends CacheableObject {
    private byte[] _xmlContent;
    private File _xmlDocFile = null;
    private long _lastModified = 0L;

    public CacheableXML(XSLXMLLogHandler xSLXMLLogHandler) {
        super(xSLXMLLogHandler);
    }

    public CacheableXML(File file, XSLXMLLogHandler xSLXMLLogHandler) throws XMLProcessingException {
        super(xSLXMLLogHandler);
        this._xmlDocFile = file;
        this.checkReloadLeaf();
        super.setLastLoaded();
    }

    protected synchronized boolean checkReloadLeaf() throws XMLProcessingException {
        if (this._xmlDocFile == null) {
            throw new XMLProcessingException("xmlDocFile is null");
        }
        if (!this._xmlDocFile.exists()) {
            throw new XMLProcessingException("xmlDocFile (" + this._xmlDocFile.toString() + ") doesn't exist");
        }
        long l = this._xmlDocFile.lastModified();
        if (this._lastModified >= l) {
            return false;
        }
        XMLDOMBuilder xMLDOMBuilder = null;
        xMLDOMBuilder = new XMLDOMBuilder(this._errorHandler);
        Document document = xMLDOMBuilder.parse(this._xmlDocFile);
        this.setObject(document);
        super.setLastLoaded();
        this._lastModified = l;
        return true;
    }

    public void setObject(Object object) {
        super.setObject(object);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            XMLDOMBuilder.dumpNode((Node)((Document)object), (OutputStream)byteArrayOutputStream);
            this._xmlContent = byteArrayOutputStream.toByteArray();
        }
        catch (XMLProcessingException xMLProcessingException) {
            this._errorHandler.error("CacheableXML.setObject: Can't dump XML document to ByteArrayOutputStream: " + xMLProcessingException.getMessage());
        }
    }

    public byte[] getXMLContent() {
        if (this.getType() == 1 || this.getType() == 2) {
            return this._xmlContent;
        }
        return ((CacheableXML)this.getParent()).getXMLContent();
    }
}

