/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.xslui.ui;

import com.iplanet.xslui.ui.CacheableObject;
import com.iplanet.xslui.xslutil.XMLProcessingException;
import com.iplanet.xslui.xslutil.XMLTranslator;
import com.iplanet.xslui.xslutil.XSLXMLLogHandler;
import java.io.File;

public class CacheableTranslator
extends CacheableObject {
    private File _xmlFile = null;
    private long _lastModified = 0L;

    public CacheableTranslator(XSLXMLLogHandler xSLXMLLogHandler) {
        super(xSLXMLLogHandler);
    }

    public CacheableTranslator(File file, XSLXMLLogHandler xSLXMLLogHandler) throws XMLProcessingException {
        super(xSLXMLLogHandler);
        this._xmlFile = file;
        this.checkReloadLeaf();
        super.setLastLoaded();
    }

    protected synchronized boolean checkReloadLeaf() throws XMLProcessingException {
        if (this._xmlFile == null) {
            throw new XMLProcessingException("xmlFile is null");
        }
        if (!this._xmlFile.exists()) {
            throw new XMLProcessingException("CacheableTranslator.checkReloadLeaf: xmlFile (" + this._xmlFile.toString() + ") doesn't exist");
        }
        long l = this._xmlFile.lastModified();
        if (this._lastModified >= l) {
            return false;
        }
        XMLTranslator xMLTranslator = new XMLTranslator(this._xmlFile, this._errorHandler);
        super.setObject(xMLTranslator);
        super.setLastLoaded();
        this._lastModified = l;
        return true;
    }
}

