/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.xslui.ui;

import com.iplanet.xslui.ui.CacheableObject;
import com.iplanet.xslui.ui.CacheableXML;
import com.iplanet.xslui.ui.XSLXMLCache;
import com.iplanet.xslui.xslutil.XMLProcessingException;
import com.iplanet.xslui.xslutil.XSLIncludeResolver;
import com.iplanet.xslui.xslutil.XSLProcessingException;
import com.iplanet.xslui.xslutil.XSLProcessorPool;
import com.iplanet.xslui.xslutil.XSLXMLLogHandler;
import org.w3c.dom.Document;

public class CacheableProcessor
extends CacheableObject
implements XSLIncludeResolver {
    private String _fileName = null;
    private String _dictionaryName = null;
    private String[] _pathList = null;
    private XSLXMLCache _cache = null;

    public CacheableProcessor(XSLXMLLogHandler xSLXMLLogHandler) {
        super(xSLXMLLogHandler);
    }

    public CacheableProcessor(String string, String string2, String[] stringArray, XSLXMLCache xSLXMLCache, XSLXMLLogHandler xSLXMLLogHandler, String string3) throws XMLProcessingException {
        super(xSLXMLLogHandler);
        this._fileName = string;
        this._dictionaryName = string2;
        this._pathList = stringArray;
        this._cache = xSLXMLCache;
        CacheableXML cacheableXML = xSLXMLCache.findCacheableXML(this._fileName, this._dictionaryName, this._pathList, true);
        if (cacheableXML == null) {
            throw new XMLProcessingException("CacheableProcessor: Couldn't find " + this._pathList[0] + this._fileName + "." + this._dictionaryName);
        }
        Document document = (Document)cacheableXML.getObject();
        XSLProcessorPool xSLProcessorPool = new XSLProcessorPool();
        xSLProcessorPool.setXSLDoc(document);
        xSLProcessorPool.setCacheHandler((XSLIncludeResolver)this);
        xSLProcessorPool.setErrorHandler(this._errorHandler);
        xSLProcessorPool.setId(string3);
        super.setObject(xSLProcessorPool);
        super.dependsOn(cacheableXML);
    }

    public Document getXSLInclude(String string) throws XSLProcessingException {
        CacheableXML cacheableXML = null;
        try {
            cacheableXML = this._cache.findCacheableXML(string, this._dictionaryName, this._pathList, true);
        }
        catch (XMLProcessingException xMLProcessingException) {
            throw new XSLProcessingException("CacheableProcessor: Can't find cache for " + this._pathList[0] + string + "." + this._dictionaryName + " : " + xMLProcessingException.getMessage());
        }
        if (cacheableXML == null) {
            throw new XSLProcessingException("CacheableProcessor: Couldn't find " + this._pathList[0] + string + "." + this._dictionaryName);
        }
        Document document = (Document)cacheableXML.getObject();
        super.dependsOn(cacheableXML);
        return document;
    }

    public boolean checkReloadLeaf() throws XMLProcessingException {
        throw new XMLProcessingException("CacheableProcessor: checkReloadLeaf() method should never be called from here.");
    }
}

