/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.xslui.ui;

import com.iplanet.xslui.xslutil.XMLProcessingException;
import com.iplanet.xslui.xslutil.XSLXMLLogHandler;
import java.util.Enumeration;
import java.util.Vector;

public abstract class CacheableObject {
    public static final int LEAF = 1;
    public static final int COMPOSITE = 2;
    public static final int LINK = 3;
    private long _lastLoaded = 0L;
    private CacheableObject _parent = null;
    private Object _object = null;
    private Vector _dependenceVector = new Vector();
    protected XSLXMLLogHandler _errorHandler = null;

    public CacheableObject(XSLXMLLogHandler xSLXMLLogHandler) {
        this._errorHandler = xSLXMLLogHandler;
    }

    public void setObject(Object object) {
        this._object = object;
    }

    public Object getObject() {
        if (this._parent != null) {
            return this._parent.getObject();
        }
        return this._object;
    }

    public long getLastLoaded() {
        return this._lastLoaded;
    }

    public void setLastLoaded() {
        this._lastLoaded = System.currentTimeMillis();
    }

    public void setParent(CacheableObject cacheableObject) {
        this._parent = cacheableObject;
        this._lastLoaded = cacheableObject.getLastLoaded();
        this.dependsOn(cacheableObject);
    }

    public void dependsOn(CacheableObject cacheableObject) {
        this._dependenceVector.add(cacheableObject);
        long l = cacheableObject.getLastLoaded();
        if (l > this._lastLoaded) {
            this._lastLoaded = l;
        }
    }

    public boolean isOutdated() throws XMLProcessingException {
        boolean bl = this.modifiedSince(this._lastLoaded);
        if (!bl) {
            return false;
        }
        return !this._dependenceVector.isEmpty();
    }

    public boolean modifiedSince(long l) throws XMLProcessingException {
        boolean bl = false;
        if (this._dependenceVector.isEmpty()) {
            boolean bl2 = this.checkReloadLeaf();
            if (bl2) {
                this.setLastLoaded();
            }
            if (l < this._lastLoaded) {
                bl = true;
            }
        } else {
            Enumeration enumeration = this._dependenceVector.elements();
            while (enumeration.hasMoreElements()) {
                CacheableObject cacheableObject = (CacheableObject)enumeration.nextElement();
                if (!cacheableObject.modifiedSince(l)) continue;
                bl = true;
            }
        }
        return bl;
    }

    public int getType() {
        if (this._parent != null) {
            return 3;
        }
        if (this._dependenceVector.isEmpty()) {
            return 1;
        }
        return 2;
    }

    public CacheableObject getParent() {
        return this._parent;
    }

    protected abstract boolean checkReloadLeaf() throws XMLProcessingException;
}

