/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.xslui.ui;

import com.iplanet.xslui.auth.UserSession;
import com.iplanet.xslui.tools.PropertyReader;
import com.iplanet.xslui.ui.Logging;
import com.iplanet.xslui.ui.SessionObjectFactory;
import com.iplanet.xslui.ui.XSLServlet;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class AuthSDKServlet
extends XSLServlet {
    public static final String CONFIG_FILENAME = "xslui.properties";
    public static final String CONFIG_LOGINPAGETEMPLATE = "loginpagetemplate.";
    public static final String CONFIG_SESSIONOBJ_PREFIX = "sessionobjfactory.";
    public static final String CONFIG_SESSIONID_SUFFIX = ".sessionid";
    public static final String CONFIG_DEPLOYED_PATH = "deployedpath";
    private Hashtable _sessionObjTable = null;
    private String deployedPath = null;

    public void init(ServletConfig servletConfig) throws ServletException {
        this._config_filename = CONFIG_FILENAME;
        super.init(servletConfig);
        PropertyReader propertyReader = super.getPropertyReader();
        if (propertyReader == null) {
            throw new ServletException("Couldn't get config from xslui.properties");
        }
        this.deployedPath = propertyReader.getStringProperty(CONFIG_DEPLOYED_PATH, "/abs");
        this._sessionObjTable = new Hashtable();
        Enumeration enumeration = propertyReader.getKeyProperty(CONFIG_SESSIONOBJ_PREFIX, ".class");
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                String string = CONFIG_SESSIONOBJ_PREFIX + (String)enumeration.nextElement();
                String string2 = propertyReader.getStringProperty(string + CONFIG_SESSIONID_SUFFIX, null);
                Object object = null;
                try {
                    object = propertyReader.getObjectProperty(string, true);
                }
                catch (Exception exception) {
                    Logging.error(64, "Exception thrown while creating Factory for: " + string);
                    Logging.errorPrintStackTrace(exception);
                    throw new ServletException("Exception thrown while creating Factory for: " + string);
                }
                if (string2 != null && string2.length() > 0) {
                    if (object != null) {
                        this._sessionObjTable.put(string2, object);
                        continue;
                    }
                    Logging.error(64, "Couldn't create Factory for: " + string);
                    throw new ServletException("error while creating Factory for: " + string);
                }
                Logging.error(64, "No sessionid for: " + string);
            }
        } else {
            Logging.error(64, "No sessionObject defined");
        }
    }

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        Object object;
        Object object2;
        Object object3;
        HttpSession httpSession = null;
        httpSession = httpServletRequest.getSession(true);
        UserSession userSession = (UserSession)httpSession.getAttribute("com.iplanet.xslui.ui.usersession");
        String string = (String)httpServletRequest.getAttribute("validClientIP");
        if (userSession == null) {
            Logging.error(64, "No usersession");
            return;
        }
        if (string != null && string.equals("false")) {
            Logging.error(64, "Client IP Conflict");
            return;
        }
        Object object4 = this._sessionObjTable.keys();
        while (object4.hasMoreElements()) {
            object3 = (String)object4.nextElement();
            object2 = httpSession.getAttribute((String)object3);
            if (object2 != null) continue;
            object = (SessionObjectFactory)this._sessionObjTable.get(object3);
            object2 = object.newSessionObject(userSession, userSession.getDomain());
            if (object2 != null) {
                httpSession.setAttribute((String)object3, object2);
                continue;
            }
            Logging.error(64, "Can't create SessionObject: " + (String)object3 + " for user " + userSession.getUserId());
        }
        object4 = httpServletRequest.getQueryString();
        if (object4 == null || ((String)object4).indexOf("logout") == -1) {
            object3 = null;
            object2 = null;
            httpServletResponse.setContentType("text/plain");
            object = httpServletResponse.encodeURL("/").substring(1);
            if (object == null || ((String)object).equals("")) {
                object = ";jsessionid=" + httpServletRequest.getSession(false).getId();
            }
            object2 = httpServletRequest.getScheme() + "://" + httpServletRequest.getServerName() + ":";
            object2 = (String)object2 + new Integer(httpServletRequest.getServerPort()).toString() + this.deployedPath + "/search.xml";
            object2 = (String)object2 + (String)object;
            object3 = httpServletResponse.getWriter();
            httpServletResponse.setHeader("Location", (String)object2);
            ((PrintWriter)object3).close();
        } else if (((String)object4).indexOf("logout") != -1) {
            httpServletRequest.getSession(false).invalidate();
        }
    }
}

