/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.xslui.auth;

import com.iplanet.xslui.auth.UserSession;
import com.iplanet.xslui.auth.UserSessionFactory;
import com.iplanet.xslui.tools.PropertyReader;
import com.iplanet.xslui.ui.Logging;
import com.iplanet.xslui.ui.XSLServlet;
import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class XSLAuthServlet
extends XSLServlet {
    public static final String CONFIG_FILENAME = "xslauth.properties";
    public static final String CONFIG_USERSESSION_PREFIX = "usersession";
    public static final String CONFIG_DEFAULTDOMAIN = "defaultdomain";
    private UserSessionFactory _userFactory = null;
    private String _defaultDomain = null;

    public void init(ServletConfig servletConfig) throws ServletException {
        this._config_filename = CONFIG_FILENAME;
        super.init(servletConfig);
        PropertyReader propertyReader = super.getPropertyReader();
        this._defaultDomain = propertyReader.getStringProperty(CONFIG_DEFAULTDOMAIN, "iplanet.com");
        try {
            this._userFactory = (UserSessionFactory)propertyReader.getObjectProperty(CONFIG_USERSESSION_PREFIX, true);
        }
        catch (Exception exception) {
            Logging.error(2, "Exception thrown while creating UserFactory");
            Logging.errorPrintStackTrace(exception);
        }
    }

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string;
        HttpSession httpSession = httpServletRequest.getSession(true);
        UserSession userSession = (UserSession)httpSession.getAttribute("com.iplanet.xslui.ui.usersession");
        if (userSession != null) {
            return;
        }
        httpSession.setAttribute("domainname", (Object)this._defaultDomain);
        this.log("brand new session");
        String string2 = httpServletRequest.getParameter("login");
        if (string2 == null) {
            return;
        }
        Logging.trace(8, "login from " + string2);
        if (!(string2.equals("anonymous") || (string = httpServletRequest.getParameter("password")) != null && string.equals("iplanet"))) {
            return;
        }
        userSession = this._userFactory.newUserSession(string2, this._defaultDomain);
        if (userSession == null) {
            Logging.trace(8, "couldnt create user " + string2 + "(domain " + this._defaultDomain + ")");
            return;
        }
        string = userSession.getPreferredLanguage();
        httpSession.setAttribute("userlang", (Object)string);
        httpSession.setAttribute("com.iplanet.xslui.ui.usersession", (Object)userSession);
    }
}

