/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.xslui.auth;

import com.iplanet.xslui.tools.PropertyReader;
import com.iplanet.xslui.tools.StringUtils;
import com.iplanet.xslui.ui.Logging;
import java.io.File;
import javax.servlet.Filter;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;

public abstract class XSLAuthFilter
implements Filter {
    protected String _config_filename = "xsl.properties";
    public static final String CONFIG_LOGFILE = "log.file";
    public static final String CONFIG_LOGLEVEL = "log.level";
    public static final String CONFIG_LOGCOMPONENTS = "log.components";
    public static final String CONFIG_CONFIGPATH_SUFFIX = ".configpath";
    public static final String USER = "user";
    public static final String PASSWORD = "password";
    public static final String LOGOUT = "logout";
    private PropertyReader _propertyReader;

    public void init(FilterConfig filterConfig) throws ServletException {
        File file;
        String string = filterConfig.getInitParameter("configPath");
        ServletContext servletContext = null;
        if (string == null && (string = (servletContext = filterConfig.getServletContext()).getRealPath("/")) == null) {
            string = "./";
        }
        if (!(file = new File(new File(string, "local-conf"), "config")).isDirectory() && !(file = new File(string, "WEB-INF/config")).isDirectory()) {
            throw new ServletException("XSLAuthFilter: can't open configuration dir " + file.toString());
        }
        try {
            this._propertyReader = new PropertyReader(file, this._config_filename);
        }
        catch (Exception exception) {
            throw new ServletException("XSLAuthFilter: can't open configuration file " + this._config_filename + " in " + file.toString() + " : " + exception.getMessage());
        }
        String string2 = this._propertyReader.getStringProperty(CONFIG_LOGFILE, "");
        int n = this._propertyReader.getIntProperty(CONFIG_LOGLEVEL, 2);
        int n2 = this._propertyReader.getIntProperty(CONFIG_LOGCOMPONENTS, 2);
        Logging logging = null;
        if (string2.length() > 0) {
            File file2 = new File(string2);
            logging = new Logging(file2);
        } else {
            logging = new Logging(servletContext);
        }
        Logging.setState(n);
        Logging.setPackage(n2);
    }

    public PropertyReader getPropertyReader() {
        return this._propertyReader;
    }

    public static String getUserFromRequest(HttpServletRequest httpServletRequest) {
        String string;
        int n;
        String string2 = null;
        String string3 = httpServletRequest.getHeader("Authorization");
        if (string3 != null && (n = (string = StringUtils.b64Decode((String)(string3 = string3.substring(6).trim()))).indexOf(":")) > 0) {
            string2 = string.substring(0, n);
        }
        if (string2 == null) {
            string2 = httpServletRequest.getParameter(USER);
        }
        return string2;
    }

    public static String getPasswordFromRequest(HttpServletRequest httpServletRequest) {
        String string;
        int n;
        String string2 = null;
        String string3 = httpServletRequest.getHeader("Authorization");
        if (string3 != null && (n = (string = StringUtils.b64Decode((String)(string3 = string3.substring(6).trim()))).indexOf(":")) > 0) {
            string2 = string.substring(n + 1);
        }
        if (string2 == null) {
            string2 = httpServletRequest.getParameter(PASSWORD);
        }
        return string2;
    }

    public static boolean invalidateSession(HttpServletRequest httpServletRequest) {
        String string = httpServletRequest.getParameter(LOGOUT);
        return string != null;
    }
}

