/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.xslui.auth;

import com.iplanet.xslui.auth.UserSession;
import com.iplanet.xslui.auth.UserSessionFactory;
import com.iplanet.xslui.auth.XMLUserSession;
import com.iplanet.xslui.ui.Logging;
import com.iplanet.xslui.xslutil.XMLDOMBuilder;
import com.iplanet.xslui.xslutil.XMLProcessingException;
import com.iplanet.xslui.xslutil.XPathTools;
import com.iplanet.xslui.xslutil.XSLProcessingException;
import java.io.File;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class XMLUserSessionFactory
implements UserSessionFactory {
    private Document _dbDoc;

    public boolean init(File file) {
        try {
            XMLDOMBuilder xMLDOMBuilder = new XMLDOMBuilder(Logging.getLogHandler());
            this._dbDoc = xMLDOMBuilder.parse(new File(file, "usersdb.xml"));
        }
        catch (XMLProcessingException xMLProcessingException) {
            Logging.error(1, "init: couldn't load usersdb.xml: " + xMLProcessingException.getMessage());
            return false;
        }
        return true;
    }

    public UserSession newUserSession(String string, String string2) {
        String string3 = string + "@" + string2;
        String string4 = "*/user[@entryID='" + string3 + "']";
        Node node = null;
        Logging.trace(1, "XMLUserSession: opening DB for user: " + string3);
        try {
            node = XPathTools.getFirstNodeByXPath((Node)this._dbDoc, (String)string4);
        }
        catch (XSLProcessingException xSLProcessingException) {
            Logging.error(1, "newUser: couldn't get parameter: " + xSLProcessingException.getMessage());
            return null;
        }
        XMLUserSession xMLUserSession = null;
        try {
            xMLUserSession = new XMLUserSession(node);
        }
        catch (XMLProcessingException xMLProcessingException) {
            Logging.error(1, "newUser: couldn't get create UserSession: " + xMLProcessingException.getMessage());
            return null;
        }
        return xMLUserSession;
    }

    public UserSession newUserSession(String string, String string2, String string3) {
        return this.newUserSession(string, string3);
    }
}

