/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.xslui.auth;

import com.iplanet.xslui.auth.UserSession;
import com.iplanet.xslui.ui.Logging;
import com.iplanet.xslui.xslutil.XMLProcessingException;
import com.iplanet.xslui.xslutil.XPathTools;
import com.iplanet.xslui.xslutil.XSLProcessingException;
import java.util.HashMap;
import org.w3c.dom.Node;

public class XMLUserSession
implements UserSession {
    private String _user = null;
    private String _domain = null;
    private String _lang = null;
    private String _dn = null;
    private HashMap _cachedParams;
    private Node _userNode;

    public XMLUserSession(Node node) throws XMLProcessingException {
        if (node == null) {
            throw new XMLProcessingException("null userNode");
        }
        this._userNode = node;
        this._cachedParams = new HashMap(10);
        try {
            this._user = XPathTools.getValueByXPath((Node)this._userNode, (String)"uid");
            this._domain = XPathTools.getValueByXPath((Node)this._userNode, (String)"domain");
            this._lang = XPathTools.getValueByXPath((Node)this._userNode, (String)"preferredLanguage");
        }
        catch (XSLProcessingException xSLProcessingException) {
            Logging.error(1, "init: couldn't get parameter: " + xSLProcessingException.getMessage());
            throw new XMLProcessingException("couldn't get param: " + xSLProcessingException.getMessage());
        }
        if (this._lang == null || this._lang.length() <= 0) {
            this._lang = "en";
        }
    }

    public String getUserId() {
        return this._user;
    }

    public String getDomain() {
        return this._domain;
    }

    public String getPreferredLanguage() {
        return this._lang;
    }

    public String getDN() {
        return this._dn;
    }

    public String getUserAttrib(String string) {
        if (string == null) {
            return null;
        }
        String string2 = (String)this._cachedParams.get(string);
        if (string2 == null) {
            try {
                string2 = XPathTools.getValueByXPath((Node)this._userNode, (String)string);
            }
            catch (XSLProcessingException xSLProcessingException) {
                Logging.error(1, "getUserAttrib: no such attribute: " + string);
                return null;
            }
            if (string2 == null) {
                return null;
            }
            this._cachedParams.put(string, string2);
        }
        return string2;
    }
}

