/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.xslui.auth;

import com.iplanet.xslui.auth.UserSession;
import com.iplanet.xslui.auth.UserSessionFactory;
import com.iplanet.xslui.auth.XSLAuthFilter;
import com.iplanet.xslui.tools.PropertyReader;
import com.iplanet.xslui.ui.Logging;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class SimpleAuthFilter
extends XSLAuthFilter {
    public static final String CONFIG_FILENAME = "xslauth.properties";
    public static final String CONFIG_USERSESSION_PREFIX = "usersession";
    public static final String CONFIG_DEFAULTDOMAIN = "defaultdomain";
    private UserSessionFactory _userFactory = null;
    private String _defaultDomain = null;

    public void init(FilterConfig filterConfig) throws ServletException {
        this._config_filename = CONFIG_FILENAME;
        super.init(filterConfig);
        PropertyReader propertyReader = super.getPropertyReader();
        this._defaultDomain = propertyReader.getStringProperty(CONFIG_DEFAULTDOMAIN, "iplanet.com");
        try {
            this._userFactory = (UserSessionFactory)propertyReader.getObjectProperty(CONFIG_USERSESSION_PREFIX, true);
        }
        catch (Exception exception) {
            throw new ServletException("Cant initialize UserSessionFactory:" + exception.getMessage());
        }
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws ServletException, IOException {
        String string;
        HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
        HttpSession httpSession = httpServletRequest.getSession(true);
        UserSession userSession = (UserSession)httpSession.getAttribute("com.iplanet.xslui.ui.usersession");
        if (userSession != null) {
            filterChain.doFilter(servletRequest, servletResponse);
            if (XSLAuthFilter.invalidateSession(httpServletRequest)) {
                httpSession.invalidate();
            }
            return;
        }
        String string2 = (String)httpSession.getAttribute("uid");
        String string3 = (String)httpSession.getAttribute("domainname");
        if (string3 == null || string3.length() <= 0) {
            httpSession.setAttribute("domainname", (Object)this._defaultDomain);
        }
        boolean bl = true;
        if (string2 != null && string2.length() > 0 && string3 != null && string3.length() > 0) {
            bl = false;
        } else {
            string = XSLAuthFilter.getUserFromRequest(httpServletRequest);
            if (string == null) {
                filterChain.doFilter(servletRequest, servletResponse);
                return;
            }
            int n = string.lastIndexOf("@");
            if (n != -1) {
                string2 = string.substring(0, n);
                string3 = string.substring(n + 1);
            } else {
                string2 = string;
                string3 = this._defaultDomain;
            }
        }
        userSession = this._userFactory.newUserSession(string2, string3);
        if (userSession == null) {
            Logging.trace(8, "couldnt create user " + string2 + "(domain " + string3 + ")");
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        if (!bl || !string2.equals("anonymous")) {
            string = XSLAuthFilter.getPasswordFromRequest(httpServletRequest);
            String string4 = userSession.getUserAttrib("password");
            if (string4 != null && !string4.equals(string) || string4 == null && string != null) {
                filterChain.doFilter(servletRequest, servletResponse);
                return;
            }
            httpSession.setAttribute("uid", (Object)string2);
            httpSession.setAttribute("domainname", (Object)string3);
            Logging.trace(64, "SimpleAuthFilter: user " + string2 + "@" + string3 + " authenticated");
        }
        httpSession.setAttribute("com.iplanet.xslui.ui.clientIP", (Object)httpServletRequest.getRemoteAddr());
        string = userSession.getPreferredLanguage();
        httpSession.setAttribute("userlang", (Object)string);
        httpSession.setAttribute("com.iplanet.xslui.ui.usersession", (Object)userSession);
        Logging.trace(64, "SimpleAuthFilter: user " + string2 + "@" + string3 + " session created");
        filterChain.doFilter(servletRequest, servletResponse);
        if (XSLAuthFilter.invalidateSession(httpServletRequest)) {
            httpSession.invalidate();
        }
    }

    public void destroy() {
    }
}

