/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.xslui.auth;

import com.iplanet.xslui.auth.MessagingSSO;
import com.iplanet.xslui.auth.UserSession;
import com.iplanet.xslui.tools.PropertyReader;
import com.iplanet.xslui.ui.XSLServlet;
import java.io.IOException;
import java.util.Vector;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class MessagingVerifySSOServlet
extends XSLServlet {
    public static final String CONFIG_FILENAME = "xslauth.properties";
    public static final String CONFIG_DEFAULTDOMAIN = "defaultdomain";
    private boolean _enabled = true;
    private MessagingSSO _messagingSSO = null;

    public void init(ServletConfig servletConfig) throws ServletException {
        this._config_filename = CONFIG_FILENAME;
        super.init(servletConfig);
        PropertyReader propertyReader = super.getPropertyReader();
        this._messagingSSO = new MessagingSSO(propertyReader);
        this._enabled = this._messagingSSO.isEnabled();
    }

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
        if (!this._enabled) {
            this._messagingSSO.sendError(servletOutputStream, "SSO disabled");
            return;
        }
        Cookie[] cookieArray = httpServletRequest.getCookies();
        if (cookieArray == null || cookieArray.length == 0) {
            this._messagingSSO.sendError(servletOutputStream, "No cookie in request");
            return;
        }
        String string = httpServletRequest.getParameter("client");
        if (this._messagingSSO.hasSessionCookie(cookieArray)) {
            HttpSession httpSession = httpServletRequest.getSession(true);
            String string2 = (String)httpSession.getAttribute("com.iplanet.xslui.ui.clientIP");
            if (string == null || string2 == null || !string2.trim().equalsIgnoreCase(string)) {
                this._messagingSSO.sendError(servletOutputStream, "IP addresses dont match");
                return;
            }
            UserSession userSession = (UserSession)httpSession.getAttribute("com.iplanet.xslui.ui.usersession");
            if (userSession == null) {
                this._messagingSSO.sendError(servletOutputStream, "No valid cookie");
                return;
            }
            String string3 = userSession.getUserId() + "@" + userSession.getDomain();
            this._messagingSSO.sendSuccess(servletOutputStream, string3, "plaintext");
            return;
        }
        Vector vector = this._messagingSSO.verifySSO(cookieArray, string, false);
        if (vector == null) {
            this._messagingSSO.sendError(servletOutputStream, "Remote Server sent an error");
            return;
        }
        this._messagingSSO.relaySuccess(servletOutputStream, vector);
    }
}

