/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.xslui.auth;

import com.iplanet.xslui.auth.MessagingSSO;
import com.iplanet.xslui.auth.UserSession;
import com.iplanet.xslui.auth.XSLAuthFilter;
import com.iplanet.xslui.tools.PropertyReader;
import com.iplanet.xslui.ui.Logging;
import java.io.IOException;
import java.util.Vector;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class MessagingSSOAuthFilter
extends XSLAuthFilter {
    public static final String CONFIG_FILENAME = "xslauth.properties";
    public static final String CONFIG_DEFAULTDOMAIN = "defaultdomain";
    private String _defaultDomain = null;
    private boolean _enabled = true;
    private MessagingSSO _messagingSSO = null;

    public void init(FilterConfig filterConfig) throws ServletException {
        this._config_filename = CONFIG_FILENAME;
        super.init(filterConfig);
        PropertyReader propertyReader = super.getPropertyReader();
        this._defaultDomain = propertyReader.getStringProperty(CONFIG_DEFAULTDOMAIN, "iplanet.com");
        this._messagingSSO = new MessagingSSO(propertyReader);
        this._enabled = this._messagingSSO.isEnabled();
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws ServletException, IOException {
        if (!this._enabled) {
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
        HttpSession httpSession = httpServletRequest.getSession(true);
        UserSession userSession = (UserSession)httpSession.getAttribute("com.iplanet.xslui.ui.usersession");
        if (userSession != null) {
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        Cookie cookie = this._messagingSSO.getSSOCookie(httpSession);
        HttpServletResponse httpServletResponse = (HttpServletResponse)servletResponse;
        httpServletResponse.addCookie(cookie);
        String string = servletRequest.getRemoteAddr();
        httpSession.setAttribute("com.iplanet.xslui.ui.clientIP", (Object)string);
        Cookie[] cookieArray = httpServletRequest.getCookies();
        if (cookieArray == null || cookieArray.length == 0) {
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        Vector vector = this._messagingSSO.verifySSO(cookieArray, string, true);
        if (vector == null) {
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        String string2 = (String)vector.elementAt(0);
        String string3 = (String)vector.elementAt(1);
        int n = string2.indexOf("=");
        if (n <= 0 || n == string2.length() - 1) {
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        String string4 = string2.substring(n + 1);
        if ((n = string4.lastIndexOf("@")) <= 0 || n == string4.length() - 1) {
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        String string5 = string4.substring(0, n);
        String string6 = string4.substring(n + 1);
        Logging.trace(64, "MessagingSSOAuth: login from " + string5);
        httpSession.setAttribute("uid", (Object)string5);
        httpSession.setAttribute("domainname", (Object)string6);
        Logging.trace(64, "MessagingSSOAuthFilter: user " + string5 + "@" + string6 + " authenticated");
        filterChain.doFilter(servletRequest, servletResponse);
    }

    public void destroy() {
    }
}

