/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.xslui.auth;

import com.iplanet.xslui.tools.PropertyReader;
import com.iplanet.xslui.ui.Logging;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpSession;

public class MessagingSSO {
    public static final String CONFIG_SSO_PREFIX = "messagingsso.";
    public static final String CONFIG_ENABLE = "enable";
    public static final String CONFIG_SESSIONCOOKIE = "sessioncookie";
    public static final String CONFIG_APPPREFIX = "appprefix";
    public static final String CONFIG_APPID = "appid";
    public static final String CONFIG_COOKIEDOMAIN = "cookiedomain";
    public static final String CONFIG_COOKIEPATH = "cookiepath";
    public static final String CONFIG_URL = ".url";
    public static final String CONFIG_DEFAULTDOMAIN = "defaultdomain";
    public static final String CLIENTIP = "client";
    private String _defaultDomain = null;
    private boolean _enabled = true;
    private String _appPrefix = null;
    private String _appID = null;
    private String _mySSOCookieName = null;
    private Cookie _ssoCookie = null;
    private String _sessionCookieName = null;
    private HashMap _verifySSOMap = null;

    public MessagingSSO(PropertyReader propertyReader) {
        this._enabled = propertyReader.getBooleanProperty("messagingsso.enable", "true");
        this._sessionCookieName = propertyReader.getStringProperty("messagingsso.sessioncookie", "JSESSIONID");
        this._appPrefix = propertyReader.getStringProperty("messagingsso.appprefix", "ssogrp1");
        this._appID = propertyReader.getStringProperty("messagingsso.appid", "iabs");
        this._mySSOCookieName = this._appPrefix + "-" + this._appID;
        String string = propertyReader.getStringProperty("messagingsso.cookiedomain", "iplanet.com");
        String string2 = propertyReader.getStringProperty("messagingsso.cookiepath", "/");
        this._ssoCookie = new Cookie(this._mySSOCookieName, "");
        this._ssoCookie.setDomain(string);
        this._ssoCookie.setPath(string2);
        this._verifySSOMap = new HashMap();
        Enumeration enumeration = propertyReader.getKeyProperty(CONFIG_SSO_PREFIX, CONFIG_URL);
        while (enumeration.hasMoreElements()) {
            String string3 = (String)enumeration.nextElement();
            String string4 = propertyReader.getStringProperty(CONFIG_SSO_PREFIX + string3 + CONFIG_URL, "");
            String string5 = this._appPrefix + "-" + string3;
            if (string4 == null || string4.length() <= 0) continue;
            Logging.trace(64, "Associating cookie " + string5 + " with verify URL " + string4);
            this._verifySSOMap.put(string5, string4);
        }
    }

    public boolean isEnabled() {
        return this._enabled;
    }

    public Vector verifySSO(Cookie[] cookieArray, String string, boolean bl) {
        if (!this._enabled) {
            return null;
        }
        if (cookieArray == null || cookieArray.length == 0) {
            return null;
        }
        int n = cookieArray.length;
        Vector vector = null;
        String string2 = null;
        boolean bl2 = false;
        for (int i = 0; i < n; ++i) {
            String string3;
            string2 = cookieArray[i].getName();
            Logging.trace(64, "Got cookie:" + string2);
            bl2 = this._mySSOCookieName.equals(string2);
            if (bl2 && bl || (string3 = (String)this._verifySSOMap.get(string2)) == null) continue;
            string3 = string3 + CLIENTIP + "=" + string;
            vector = bl2 ? this.verifyOneSSO(string3, this._sessionCookieName, cookieArray[i].getValue()) : this.verifyOneSSO(string3, string2, cookieArray[i].getValue());
            if (vector != null && vector.size() >= 2 && this.isCredValid(vector)) break;
        }
        return vector;
    }

    public Cookie getSSOCookie(HttpSession httpSession) {
        Cookie cookie = (Cookie)this._ssoCookie.clone();
        cookie.setValue(httpSession.getId());
        return cookie;
    }

    public final void sendSuccess(ServletOutputStream servletOutputStream, String string, String string2) throws IOException {
        servletOutputStream.println("fquid=" + string);
        servletOutputStream.println("authtype=" + string2);
    }

    public final void relaySuccess(ServletOutputStream servletOutputStream, Vector vector) throws IOException {
        for (int i = 0; i < vector.size(); ++i) {
            servletOutputStream.println((String)vector.elementAt(i));
        }
    }

    public final void sendError(ServletOutputStream servletOutputStream, String string) throws IOException {
        servletOutputStream.println("Error=" + string);
    }

    public final boolean hasSessionCookie(Cookie[] cookieArray) {
        int n = cookieArray.length;
        for (int i = 0; i < n; ++i) {
            if (!this._sessionCookieName.equals(cookieArray[i].getName())) continue;
            return true;
        }
        return false;
    }

    private Vector verifyOneSSO(String string, String string2, String string3) {
        Vector<String> vector = new Vector<String>();
        Logging.trace(64, "Connecting to: " + string);
        try {
            URL uRL = new URL(string);
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.setDoOutput(true);
            httpURLConnection.setDoInput(true);
            httpURLConnection.setRequestMethod("GET");
            httpURLConnection.setRequestProperty("Accept-Language", "en");
            String string4 = string2 + "=" + string3;
            Logging.trace(64, "Cookie => " + string4);
            httpURLConnection.setRequestProperty("Cookie", string4);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream()));
            String string5 = null;
            Logging.trace(64, "Reading from: " + string);
            while ((string5 = bufferedReader.readLine()) != null) {
                vector.addElement(string5);
                Logging.trace(64, "Recvd: " + string5);
            }
            httpURLConnection.disconnect();
        }
        catch (Exception exception) {
            Logging.trace(64, "VerifySSO Exception: " + exception.getMessage());
            return null;
        }
        if (vector.size() <= 0) {
            vector = null;
        }
        return vector;
    }

    private boolean isCredValid(Vector vector) {
        boolean bl = true;
        if (vector == null || vector.size() < 2) {
            return false;
        }
        for (int i = 0; i < vector.size(); ++i) {
            String string = (String)vector.elementAt(i);
            if (string.toLowerCase().indexOf("error") == -1) continue;
            bl = false;
            break;
        }
        return bl;
    }
}

