/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.xslui.auth;

import com.iplanet.xslui.auth.DefaultDomainMap;
import com.iplanet.xslui.auth.Domain;
import com.iplanet.xslui.auth.DomainMap;
import com.iplanet.xslui.auth.LDAPDomainMap;
import com.iplanet.xslui.auth.LDAPUserSession;
import com.iplanet.xslui.auth.UserSession;
import com.iplanet.xslui.auth.UserSessionFactory;
import com.iplanet.xslui.tools.LDAPConfigReader;
import com.iplanet.xslui.tools.LDAPPool;
import com.iplanet.xslui.tools.PropertyReader;
import com.iplanet.xslui.ui.Logging;
import java.io.File;
import java.io.IOException;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPSearchResults;

public class LDAPUserSessionFactory
implements UserSessionFactory {
    public static final String LDAPUSERSESSIONCONFIGPREFIX = "ldapusersession.";
    public static final String DEFAULTUGFILTER = "ldapusersession.defaultugfilter";
    public static final String UGATTR = "ldapusersession.ugattr";
    private String _defaultUGFilter = null;
    private String[] _ugAttr;
    private LDAPPool _ldapPool = null;
    private DomainMap _domainMap = null;

    public boolean init(File file) {
        PropertyReader propertyReader = null;
        try {
            propertyReader = new PropertyReader(file);
        }
        catch (IOException iOException) {
            Logging.error(64, "LDAPUserSessionFac: Cant read config at: " + file.getAbsolutePath() + ":" + iOException.getMessage());
            return false;
        }
        this._defaultUGFilter = propertyReader.getStringProperty(DEFAULTUGFILTER, "uid=%U");
        this._ugAttr = propertyReader.getStringArrayProperty(UGATTR, null);
        try {
            this._ldapPool = LDAPConfigReader.getLDAPPool((PropertyReader)propertyReader, (String)LDAPUSERSESSIONCONFIGPREFIX);
        }
        catch (LDAPException lDAPException) {
            Logging.error(64, "LDAPUserSessionFac: Cant get LDAP pool: " + file.getAbsolutePath() + ":" + lDAPException.getMessage());
            return false;
        }
        this._domainMap = new LDAPDomainMap();
        boolean bl = this._domainMap.init(file);
        if (!bl) {
            this._domainMap = new DefaultDomainMap();
            this._domainMap.init(file);
        }
        return true;
    }

    public UserSession newUserSession(String string, String string2, String string3) {
        LDAPUserSession lDAPUserSession = null;
        LDAPConnection lDAPConnection = null;
        try {
            lDAPConnection = this._ldapPool.getConnection();
        }
        catch (LDAPException lDAPException) {
            Logging.error(64, "couldnt get a connection from the pool:" + lDAPException.getMessage());
            return null;
        }
        if (lDAPConnection == null) {
            Logging.error(64, "couldnt get a connection from the pool: time out");
            return null;
        }
        try {
            LDAPSearchResults lDAPSearchResults = lDAPConnection.search(string2, 2, null, this._ugAttr, false);
            if (!lDAPSearchResults.hasMoreElements()) {
                this._ldapPool.close(lDAPConnection);
                return null;
            }
            LDAPEntry lDAPEntry = lDAPSearchResults.next();
            lDAPUserSession = new LDAPUserSession(lDAPEntry, string3);
        }
        catch (LDAPException lDAPException) {
            Logging.error(64, "LDAPUserSessionFac: search Returned: " + lDAPException.toString());
            this._ldapPool.close(lDAPConnection);
            return null;
        }
        this._ldapPool.close(lDAPConnection);
        return lDAPUserSession;
    }

    public UserSession newUserSession(String string, String string2) {
        LDAPUserSession lDAPUserSession = null;
        Domain domain = this._domainMap.getDomainObject(string2);
        if (domain == null) {
            return null;
        }
        String string3 = domain.getNamespace();
        String string4 = domain.getAttribute("inetDomainSearchFilter");
        if (string4 == null) {
            string4 = this._defaultUGFilter;
        }
        String string5 = this.buildFilter(string4, string, string2);
        LDAPConnection lDAPConnection = null;
        try {
            lDAPConnection = this._ldapPool.getConnection();
        }
        catch (LDAPException lDAPException) {
            Logging.error(64, "couldnt get a connection from the pool:" + lDAPException.getMessage());
            return null;
        }
        if (lDAPConnection == null) {
            Logging.error(64, "couldnt get a connection from the pool: time out");
            return null;
        }
        try {
            LDAPSearchResults lDAPSearchResults = lDAPConnection.search(string3, 2, string5, this._ugAttr, false);
            if (!lDAPSearchResults.hasMoreElements()) {
                Logging.error(64, "LDAPUserSessionFac: no result for: " + string + " in domain " + string2);
                this._ldapPool.close(lDAPConnection);
                return null;
            }
            LDAPEntry lDAPEntry = lDAPSearchResults.next();
            lDAPUserSession = new LDAPUserSession(lDAPEntry, domain);
        }
        catch (LDAPException lDAPException) {
            Logging.error(64, "LDAPUserSessionFac: search Returned: " + lDAPException.toString() + "for " + string + " in domain " + string2);
            this._ldapPool.close(lDAPConnection);
            return null;
        }
        this._ldapPool.close(lDAPConnection);
        return lDAPUserSession;
    }

    private String buildFilter(String string, String string2, String string3) {
        String string4 = "";
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '%' && i + 1 < string.length()) {
                switch (string.charAt(++i)) {
                    case 'U': {
                        string4 = string4 + this.ldapescape(string2);
                        break;
                    }
                    case 'V': {
                        string4 = string4 + this.ldapescape(string3);
                        break;
                    }
                    case '%': {
                        string4 = string4 + '%';
                        break;
                    }
                }
                continue;
            }
            string4 = string4 + string.charAt(i);
        }
        return string4;
    }

    private String ldapescape(String string) {
        if (string == null) {
            return "";
        }
        String string2 = "";
        block6: for (int i = 0; i < string.length(); ++i) {
            switch (string.charAt(i)) {
                case '*': {
                    string2 = string2 + "\\2a";
                    continue block6;
                }
                case '(': {
                    string2 = string2 + "\\28";
                    continue block6;
                }
                case ')': {
                    string2 = string2 + "\\29";
                    continue block6;
                }
                case '\\': {
                    string2 = string2 + "\\5c";
                    continue block6;
                }
                default: {
                    string2 = string2 + string.charAt(i);
                }
            }
        }
        return string2;
    }
}

