/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.xslui.auth;

import com.iplanet.xslui.auth.Domain;
import com.iplanet.xslui.auth.UserSession;
import java.util.Enumeration;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPEntry;

public class LDAPUserSession
implements UserSession {
    public static final String UID = "uid";
    public static final String PREFERREDLANGUAGE = "preferredLanguage";
    public static final String DEFAULTLANGUAGE = "en";
    private LDAPEntry _ldapEntry = null;
    private Domain _domain = null;
    private String _domainStr = null;
    private String _password = null;

    public LDAPUserSession(LDAPEntry lDAPEntry, Domain domain) {
        this._ldapEntry = lDAPEntry;
        this._domain = domain;
    }

    public LDAPUserSession(LDAPEntry lDAPEntry, String string) {
        this._ldapEntry = lDAPEntry;
        this._domainStr = string;
    }

    public LDAPUserSession(LDAPEntry lDAPEntry) {
        this._ldapEntry = lDAPEntry;
    }

    public String getUserId() {
        return this.getUserAttrib(UID);
    }

    public String getDomain() {
        if (this._domain != null) {
            return this._domain.getDomainName();
        }
        return this._domainStr;
    }

    public String getPreferredLanguage() {
        String string = this.getUserAttrib(PREFERREDLANGUAGE);
        if (string == null && this._domain != null) {
            string = this._domain.getAttribute(PREFERREDLANGUAGE);
        }
        if (string == null) {
            string = DEFAULTLANGUAGE;
        }
        return string;
    }

    public String getDN() {
        return this._ldapEntry.getDN();
    }

    public String getUserAttrib(String string) {
        if (string == null) {
            return null;
        }
        LDAPAttribute lDAPAttribute = this._ldapEntry.getAttribute(string);
        if (lDAPAttribute != null) {
            Enumeration enumeration = lDAPAttribute.getStringValues();
            if (!enumeration.hasMoreElements()) {
                return null;
            }
            return (String)enumeration.nextElement();
        }
        return null;
    }

    public String[] getUserAttribs(String string) {
        if (string == null) {
            return null;
        }
        LDAPAttribute lDAPAttribute = this._ldapEntry.getAttribute(string);
        if (lDAPAttribute != null) {
            return lDAPAttribute.getStringValueArray();
        }
        return null;
    }

    public void setPassword(String string) {
        this._password = string;
    }

    public String getPassword() {
        return this._password;
    }
}

