/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.xslui.auth;

import com.iplanet.xslui.auth.Domain;
import com.iplanet.xslui.auth.DomainMap;
import com.iplanet.xslui.auth.LDAPDomain;
import com.iplanet.xslui.tools.LDAPConfigReader;
import com.iplanet.xslui.tools.LDAPPool;
import com.iplanet.xslui.tools.PropertyReader;
import com.iplanet.xslui.ui.Logging;
import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPSearchResults;

public class LDAPDomainMap
implements DomainMap {
    public static final String DOMAINMAPCONFIGPREFIX = "domainmap.";
    public static final String DCROOT = "domainmap.dcroot";
    public static final String DOMAINATTR = "domainmap.domainattr";
    public static final String DOMAINFILTER = "domainmap.domainfilter";
    public static final String ENABLED = "domainmap.enabled";
    private LDAPPool _ldapPool = null;
    private String _dcroot = null;
    private String[] _domainAttr = null;
    private String _domainFilter = null;
    private Hashtable _domainMap = null;

    public boolean init(File file) {
        PropertyReader propertyReader = null;
        try {
            propertyReader = new PropertyReader(file);
        }
        catch (IOException iOException) {
            Logging.error(64, "LDAPDomainMap: Cant read config at: " + file.getAbsolutePath() + ":" + iOException.getMessage());
            return false;
        }
        if (!propertyReader.getBooleanProperty(ENABLED, "false")) {
            return false;
        }
        try {
            this._ldapPool = LDAPConfigReader.getLDAPPool((PropertyReader)propertyReader, (String)DOMAINMAPCONFIGPREFIX);
        }
        catch (LDAPException lDAPException) {
            Logging.error(64, "LDAPDomainMap: Cant get LDAP pool: " + file.getAbsolutePath() + ":" + lDAPException.getMessage());
            return false;
        }
        this._dcroot = propertyReader.getStringProperty(DCROOT, "o=internet");
        if (this._dcroot.length() > 0) {
            this._dcroot = "," + this._dcroot;
        }
        this._domainAttr = propertyReader.getStringArrayProperty(DOMAINATTR, "inetDomainBaseDN");
        this._domainFilter = propertyReader.getStringProperty(DOMAINFILTER, "objectClass=*");
        this._domainMap = new Hashtable();
        return true;
    }

    public Domain getDomainObject(String string) {
        int n;
        Domain domain = (Domain)this._domainMap.get(string);
        if (domain != null) {
            return domain;
        }
        String string2 = "dc=";
        int n2 = 0;
        while ((n = string.indexOf(46, n2)) != -1) {
            string2 = string2 + string.substring(n2, n) + ",dc=";
            n2 = n + 1;
        }
        string2 = string2 + string.substring(n2) + this._dcroot;
        LDAPConnection lDAPConnection = null;
        try {
            lDAPConnection = this._ldapPool.getConnection();
        }
        catch (LDAPException lDAPException) {
            Logging.error(64, "couldn't get a connection from the pool:" + lDAPException.getMessage());
            return null;
        }
        if (lDAPConnection == null) {
            Logging.error(64, "couldn't get a connection from the pool: timeout");
            return null;
        }
        try {
            LDAPSearchResults lDAPSearchResults = lDAPConnection.search(string2, 0, this._domainFilter, this._domainAttr, false);
            if (!lDAPSearchResults.hasMoreElements()) {
                Logging.error(64, "LDAPDomainMap: no result for: " + string);
                this._ldapPool.close(lDAPConnection);
                return null;
            }
            LDAPEntry lDAPEntry = lDAPSearchResults.next();
            domain = new LDAPDomain(string, lDAPEntry);
        }
        catch (LDAPException lDAPException) {
            Logging.error(64, "LDAPDomainMap: search Returned: " + lDAPException.toString() + "for " + string);
            this._ldapPool.close(lDAPConnection);
            return null;
        }
        this._ldapPool.close(lDAPConnection);
        this._domainMap.put(string, domain);
        return domain;
    }
}

