/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.xslui.auth;

import com.iplanet.xslui.auth.LDAPUserSession;
import com.iplanet.xslui.auth.LDAPUserSessionFactory;
import com.iplanet.xslui.auth.UserSession;
import com.iplanet.xslui.auth.UserSessionFactory;
import com.iplanet.xslui.auth.XSLAuthFilter;
import com.iplanet.xslui.tools.LDAPConfigReader;
import com.iplanet.xslui.tools.LDAPPool;
import com.iplanet.xslui.tools.PropertyReader;
import com.iplanet.xslui.ui.Logging;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPException;

public class LDAPAuthFilter
extends XSLAuthFilter {
    public static final String CONFIG_FILENAME = "xslauth.properties";
    public static final String CONFIG_DEFAULTDOMAIN = "defaultdomain";
    public static final String LDAPAUTHCONFIGPREFIX = "ldapauth.";
    private static final String CONFIG_STOREPASSWORD = "ldapauth.storepasswordinsession";
    public static final String CONFIG_PROXYUSERS = "ldapauth.admins";
    private static final String CONFIG_AUTHSDKPATH = "authsdkpath";
    private static final String CONFIG_IPSECURITY = "ipsecurity";
    public static final int LDAPVERSION = 3;
    private UserSessionFactory _userFactory = null;
    private String _defaultDomain = null;
    private LDAPPool _ldapPool = null;
    private String[] _proxyUsers = null;
    private String _authSDKPath = null;
    private boolean _ipSecurity = false;
    private boolean _storePassword = false;

    public void init(FilterConfig filterConfig) throws ServletException {
        this._config_filename = CONFIG_FILENAME;
        super.init(filterConfig);
        PropertyReader propertyReader = super.getPropertyReader();
        this._defaultDomain = propertyReader.getStringProperty(CONFIG_DEFAULTDOMAIN, "iplanet.com");
        this._proxyUsers = propertyReader.getStringArrayProperty(CONFIG_PROXYUSERS, "");
        this._authSDKPath = propertyReader.getStringProperty(CONFIG_AUTHSDKPATH, "/authSDK");
        this._ipSecurity = propertyReader.getBooleanProperty(CONFIG_IPSECURITY, "false");
        this._storePassword = propertyReader.getBooleanProperty(CONFIG_STOREPASSWORD, "false");
        try {
            this._ldapPool = LDAPConfigReader.getLDAPPool((PropertyReader)propertyReader, (String)LDAPAUTHCONFIGPREFIX);
        }
        catch (LDAPException lDAPException) {
            throw new ServletException("LDAPAuthFilter: Cant get LDAP pool: " + lDAPException.getMessage());
        }
        this._userFactory = new LDAPUserSessionFactory();
        boolean bl = this._userFactory.init(propertyReader.getConfigFile());
        if (!bl) {
            throw new ServletException("LDAPAuthFilter: Cant init LDAPUserSessionFactory");
        }
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws ServletException, IOException {
        String string;
        HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
        HttpSession httpSession = httpServletRequest.getSession(true);
        UserSession userSession = (UserSession)httpSession.getAttribute("com.iplanet.xslui.ui.usersession");
        if (userSession != null) {
            if (this._ipSecurity) {
                String string2 = (String)httpSession.getAttribute("com.iplanet.xslui.ui.clientIP");
                String string3 = httpServletRequest.getRemoteAddr();
                if (httpServletRequest.getRequestURI().equals(this._authSDKPath)) {
                    string3 = httpServletRequest.getParameter("clientIP");
                }
                if (string2.equals(string3)) {
                    servletRequest.setAttribute("validClientIP", (Object)new String("true"));
                } else {
                    servletRequest.setAttribute("validClientIP", (Object)new String("false"));
                }
            }
            filterChain.doFilter(servletRequest, servletResponse);
            if (XSLAuthFilter.invalidateSession(httpServletRequest)) {
                httpSession.invalidate();
            }
            return;
        }
        String string4 = (String)httpSession.getAttribute("uid");
        String string5 = (String)httpSession.getAttribute("domainname");
        if (string5 == null || string5.length() <= 0) {
            httpSession.setAttribute("domainname", (Object)this._defaultDomain);
        }
        boolean bl = true;
        if (string4 != null && string4.length() > 0 && string5 != null && string5.length() > 0) {
            bl = false;
            Logging.trace(64, "LDAPAuthFilter: user already authenticated: " + string4 + "@" + string5);
        } else {
            string = XSLAuthFilter.getUserFromRequest(httpServletRequest);
            if (string == null) {
                filterChain.doFilter(servletRequest, servletResponse);
                return;
            }
            int n = string.lastIndexOf("@");
            if (n != -1) {
                string4 = string.substring(0, n);
                string5 = string.substring(n + 1);
            } else {
                string4 = string;
                string5 = this._defaultDomain;
            }
        }
        Logging.trace(64, "LDAPAuthFilter: login from " + string4);
        userSession = this._userFactory.newUserSession(string4, string5);
        if (userSession == null) {
            Logging.trace(64, "couldnt create user " + string4 + "(domain " + string5 + ")");
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        if (bl) {
            int n;
            string = userSession.getDN();
            Logging.trace(64, "LDAPAuthFilter: Authenticating " + string);
            String string6 = XSLAuthFilter.getPasswordFromRequest(httpServletRequest);
            if (string6 == null || string6.equals("")) {
                Logging.trace(64, "no password provided for " + string);
                filterChain.doFilter(servletRequest, servletResponse);
                return;
            }
            LDAPConnection lDAPConnection = null;
            try {
                lDAPConnection = this._ldapPool.getConnection();
                if (lDAPConnection == null) {
                    Logging.error(64, "couldnt log in DN=" + string + " : couldn't get conn from the pool");
                    filterChain.doFilter(servletRequest, servletResponse);
                    return;
                }
                lDAPConnection.authenticate(3, string, string6);
            }
            catch (LDAPException lDAPException) {
                Logging.trace(64, "couldnt log in DN=" + string + " : " + lDAPException.errorCodeToString() + " : " + lDAPException.getLDAPErrorMessage() + " : " + lDAPException.getLDAPResultCode());
                this._ldapPool.close(lDAPConnection);
                filterChain.doFilter(servletRequest, servletResponse);
                return;
            }
            this._ldapPool.close(lDAPConnection);
            String string7 = httpServletRequest.getParameter("proxyauth");
            String string8 = string4 + "@" + string5;
            boolean bl2 = false;
            String string9 = httpServletRequest.getRemoteAddr();
            if (httpServletRequest.getRequestURI().equals(this._authSDKPath)) {
                string9 = httpServletRequest.getParameter("clientIP");
            }
            if (this._proxyUsers != null && string7 != null) {
                for (n = 0; n < this._proxyUsers.length; ++n) {
                    if (!string8.trim().equalsIgnoreCase(this._proxyUsers[n].trim())) continue;
                    bl2 = true;
                    break;
                }
            }
            if (string7 != null && string7.length() != 0 && bl2) {
                userSession = null;
                n = string7.lastIndexOf("@");
                if (n != -1) {
                    string4 = string7.substring(0, n);
                    string5 = string7.substring(n + 1);
                } else {
                    string4 = string7;
                    string5 = this._defaultDomain;
                }
                userSession = this._userFactory.newUserSession(string4, string5);
                if (userSession == null || string9 == null) {
                    userSession = null;
                    Logging.trace(64, "couldnt create user [ for proxyauth ] " + string4 + "(domain " + string5 + ")");
                    filterChain.doFilter(servletRequest, servletResponse);
                    return;
                }
            }
            if (this._ipSecurity) {
                httpSession.setAttribute("com.iplanet.xslui.ui.clientIP", (Object)string9);
                servletRequest.setAttribute("validClientIP", (Object)new String("true"));
            }
            httpSession.setAttribute("uid", (Object)string4);
            httpSession.setAttribute("domainname", (Object)string5);
            if (!bl2 && this._storePassword && userSession instanceof LDAPUserSession) {
                ((LDAPUserSession)userSession).setPassword(string6);
            }
            Logging.trace(64, "LDAPAuthFilter: user " + string4 + "@" + string5 + " authenticated");
        }
        string = userSession.getPreferredLanguage();
        httpSession.setAttribute("userlang", (Object)string);
        httpSession.setAttribute("com.iplanet.xslui.ui.usersession", (Object)userSession);
        Logging.trace(64, "LDAPAuthFilter: user " + string4 + "@" + string5 + " session created");
        filterChain.doFilter(servletRequest, servletResponse);
        if (XSLAuthFilter.invalidateSession(httpServletRequest)) {
            httpSession.invalidate();
        }
    }

    public void destroy() {
    }
}

