/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.xslui.auth;

import com.iplanet.xslui.auth.DefaultDomain;
import com.iplanet.xslui.auth.Domain;
import com.iplanet.xslui.auth.DomainMap;
import com.iplanet.xslui.tools.PropertyReader;
import com.iplanet.xslui.ui.Logging;
import java.io.File;
import java.io.IOException;

public class DefaultDomainMap
implements DomainMap {
    public static final String DEFAULTDOMAINMAPCONFIGPREFIX = "defaultdomainmap.";
    public static final String DOMAINNAME = "defaultdomainmap.domainname";
    public static final String LDAPBASEDN = "defaultdomainmap.ldapbasedn";
    private Domain _domain = null;
    private String _domainName = null;

    public boolean init(File file) {
        PropertyReader propertyReader = null;
        try {
            propertyReader = new PropertyReader(file);
        }
        catch (IOException iOException) {
            Logging.error(64, "DefaultDomainMap: Cant read config at: " + file.getAbsolutePath() + ":" + iOException.getMessage());
            return false;
        }
        this._domainName = propertyReader.getStringProperty(DOMAINNAME, "iplanet.com");
        String string = propertyReader.getStringProperty(LDAPBASEDN, "o=iplanet.com");
        this._domain = new DefaultDomain(this._domainName, string);
        return true;
    }

    public Domain getDomainObject(String string) {
        if (this._domainName.equals(string)) {
            return this._domain;
        }
        return null;
    }
}

