/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.xslui.auth;

import com.iplanet.xslui.auth.ABUserSessionFactory;
import com.iplanet.xslui.auth.Domain;
import com.iplanet.xslui.auth.UserSession;
import com.iplanet.xslui.ui.Logging;
import com.iplanet.xslui.ui.SessionObjectFactory;
import com.iplanet.xslui.ui.XSLUIEngineServlet;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.servlet.http.HttpSession;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPModification;

public class ABUserSession
implements UserSession {
    public static final String UID = "uid";
    public static final String USERDN = "userdn";
    public static final String USER_LANG = "userlang";
    public static final String DEFAULTLANGUAGE = "en";
    public static final String PSROOT_ATTR_NAME = "psRoot";
    private HttpSession _session = null;
    private Domain _domain = null;
    private String _password = null;
    private static SessionObjectFactory _sessionFactory = null;

    public ABUserSession(HttpSession httpSession) {
        this._session = httpSession;
    }

    public String getUserId() {
        return this.getUserAttrib(UID);
    }

    public String getUserDN() {
        return this.getUserAttrib(USERDN);
    }

    public String getDomain() {
        return (String)this._session.getAttribute("domainname");
    }

    public String getPreferredLanguage() {
        String string = this.getUserAttrib(USER_LANG);
        if (string == null) {
            string = DEFAULTLANGUAGE;
        }
        return string;
    }

    public String getDN() {
        return (String)this._session.getAttribute("domaindn");
    }

    public String getUserAttrib(String string) {
        if (string == null) {
            return null;
        }
        return (String)this._session.getAttribute(string);
    }

    public void setPassword(String string) {
        this._password = string;
    }

    public String getPassword() {
        return this._password;
    }

    public boolean setDefaultPsRoot(LDAPConnection lDAPConnection) {
        Logging.trace(64, "Inside ABUserSession.setDefaultPsRoot() method");
        SessionObjectFactory sessionObjectFactory = this.getSessionObjFactory();
        String string = null;
        if (sessionObjectFactory != null) {
            Logging.trace(64, "Got sessionObjFactory");
            string = sessionObjectFactory.getDefaultPsRoot(this);
            Logging.trace(64, "ABUserSession.setPsRootValue(): Default psRoot obtained " + string);
            if (string != null) {
                try {
                    LDAPAttribute lDAPAttribute = new LDAPAttribute(PSROOT_ATTR_NAME, string);
                    LDAPModification lDAPModification = new LDAPModification(0, lDAPAttribute);
                    Logging.trace(64, "ABUserSession.setPsRootValue(): ABout to do ldap modify DN = " + this.getUserDN());
                    lDAPConnection.modify(this.getUserDN(), lDAPModification);
                    Logging.trace(64, "ABUserSession.setPsRootValue(): ldap modify successfully done");
                    this._session.setAttribute(PSROOT_ATTR_NAME, (Object)string);
                }
                catch (LDAPException lDAPException) {
                    Logging.error(64, "ABUserSession.setPsRootValue(): got exception");
                    Logging.errorPrintStackTrace((Exception)((Object)lDAPException));
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    private SessionObjectFactory getSessionObjFactory() {
        if (_sessionFactory != null) {
            return _sessionFactory;
        }
        Hashtable hashtable = XSLUIEngineServlet.getSessionObjectTable();
        if (hashtable != null) {
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                _sessionFactory = (SessionObjectFactory)hashtable.get(string);
            }
        }
        return _sessionFactory;
    }

    public static ABUserSession createUserSession(HttpSession httpSession) {
        ABUserSessionFactory aBUserSessionFactory = new ABUserSessionFactory();
        ABUserSession aBUserSession = null;
        String string = (String)httpSession.getAttribute("domainname");
        if (aBUserSessionFactory != null) {
            aBUserSession = (ABUserSession)aBUserSessionFactory.newUserSession(httpSession);
        }
        Logging.trace(32, "Got UserSession");
        return aBUserSession;
    }
}

