/*
 * Decompiled with CFR 0.152.
 */
package com.sun.uwc.common.util;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.model.ModelExecutionContext;
import com.iplanet.jato.util.NonSyncStringBuffer;
import com.iplanet.jato.view.html.Option;
import com.iplanet.jato.view.html.OptionList;
import com.sun.comclient.calendar.CalendarStore;
import com.sun.comclient.calendar.DateTime;
import com.sun.comclient.calendar.Duration;
import com.sun.comclient.calendar.ICalendar;
import com.sun.uwc.calclient.model.CalendarACL;
import com.sun.uwc.calclient.model.CalendarBaseModel;
import com.sun.uwc.calclient.model.ICalendarModel;
import com.sun.uwc.calclient.model.UWCCalendar;
import com.sun.uwc.common.UWCApplicationHelper;
import com.sun.uwc.common.UWCException;
import com.sun.uwc.common.UWCUserHelper;
import com.sun.uwc.common.model.CalUserPreferencesModel;
import com.sun.uwc.common.model.CalendarExecutionModelContext;
import com.sun.uwc.common.model.FilterAction;
import com.sun.uwc.common.model.FilterCondition;
import com.sun.uwc.common.util.UWCConstants;
import com.sun.uwc.common.util.UWCLogger;
import com.sun.uwc.common.util.UWCPreferences;
import com.sun.uwc.common.util.VCard;
import com.sun.uwc.common.util.ValMailAddress;
import com.sun.uwc.common.util.ValMailTo;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;

public class UWCUtils {
    private static Logger _utilsLogger = null;
    private static final String CLASS_NAME = "UWCUtils";
    private UWCPreferences uwcResourceBundle = null;
    private static final String UNDERSCORE = "_";
    private static final String HYPHEN = "-";
    private static String[] leapYearFebDays;
    private static String[] FebDays;
    private static String[] Thirtydays;
    private static String[] Thirty1days;
    private static String[] days;
    private static String[] months;
    private static String[] monthAsNumbers;

    private UWCUtils() {
    }

    public static VCard convertToVCard(String string) {
        VCard vCard = new VCard();
        vCard.setVCard(string);
        vCard.parse();
        return vCard;
    }

    public static int isStringContainedInStringArray(String string, String[] stringArray) {
        return UWCUtils.isStringContainedInStringArray(string, stringArray, false);
    }

    public static int isStringContainedInStringArray(String string, String[] stringArray, boolean bl) {
        if (null == string || null == stringArray) {
            return -1;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (!(bl ? stringArray[i].equalsIgnoreCase(string) : stringArray[i].equals(string))) continue;
            return i;
        }
        return -1;
    }

    public static String[] initializeStringArray(String[] stringArray, String string) {
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = string;
        }
        return stringArray;
    }

    public static boolean isValidEmailAddress(String string) {
        if (null == string) {
            return false;
        }
        return new ValMailAddress().validate(string);
    }

    public static boolean isValidMailToAddress(String string) {
        if (null == string) {
            return false;
        }
        return new ValMailTo().validate(string);
    }

    public static boolean isValidInternetAddress(String string) {
        return true;
    }

    public static Object[] getObjectArray(String[] stringArray) {
        if (null == stringArray) {
            return null;
        }
        Object[] objectArray = new Object[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            objectArray[i] = stringArray[i];
        }
        return objectArray;
    }

    public static String[] getStringArray(Object[] objectArray) {
        if (null == objectArray) {
            return null;
        }
        String[] stringArray = new String[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            stringArray[i] = (String)objectArray[i];
        }
        return stringArray;
    }

    public static boolean isValidDate(int n, int n2, int n3) {
        if (n < 0 || n > 31 || n2 < 0 || n2 > 11 || n3 < 0) {
            return false;
        }
        if ((n2 == 1 || n2 == 3 || n2 == 5 || n2 == 8 || n2 == 10) && n > 30) {
            return false;
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        boolean bl = gregorianCalendar.isLeapYear(n3);
        return n2 != 1 || bl || n <= 28;
    }

    public static String[] getMonthsOfYear() {
        return months;
    }

    public static String[] getWeekDays() {
        return days;
    }

    public static String[] getDaysOfMonth(int n, int n2) {
        if (n < 0 || n > 11 || n2 < 0) {
            return null;
        }
        switch (n) {
            case 1: {
                GregorianCalendar gregorianCalendar = new GregorianCalendar();
                boolean bl = gregorianCalendar.isLeapYear(n2);
                if (bl) {
                    return leapYearFebDays;
                }
                return FebDays;
            }
            case 0: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 11: {
                return Thirty1days;
            }
        }
        return Thirtydays;
    }

    public static int[] parseDelimitedStringToInt(String string, String string2) {
        if (string == null || string.length() <= 0) {
            return null;
        }
        if (string2 == null || string2.length() <= 0) {
            return new int[]{Integer.parseInt(string)};
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2, false);
        int n = stringTokenizer.countTokens();
        int[] nArray = null;
        int n2 = 0;
        if (n <= 0) {
            return new int[]{Integer.parseInt(string)};
        }
        nArray = new int[n];
        while (stringTokenizer.hasMoreTokens()) {
            nArray[n2] = Integer.parseInt(stringTokenizer.nextToken());
            ++n2;
        }
        return nArray;
    }

    public static String[] parseDelimiterSeperatedString(String string, String string2) {
        if (string == null || string.length() <= 0) {
            return null;
        }
        if (string2 == null || string2.length() <= 0) {
            return new String[]{string};
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2, false);
        int n = stringTokenizer.countTokens();
        String[] stringArray = null;
        int n2 = 0;
        if (n <= 0) {
            return new String[]{string};
        }
        stringArray = new String[n];
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n2] = stringTokenizer.nextToken();
            ++n2;
        }
        return stringArray;
    }

    public static String getDelimiterSeperatedString(String[] stringArray, String string) {
        if (null == stringArray) {
            return null;
        }
        NonSyncStringBuffer nonSyncStringBuffer = new NonSyncStringBuffer(16 * stringArray.length);
        int n = 0;
        int n2 = stringArray.length;
        if (n2 > 0) {
            for (n = 0; n < n2 - 1; ++n) {
                nonSyncStringBuffer.append(stringArray[n] + string);
            }
            nonSyncStringBuffer.append(stringArray[n2 - 1]);
        }
        String string2 = nonSyncStringBuffer.toString();
        return string2;
    }

    public static DateTime getWeekStartDate(DateTime dateTime, String string) {
        int n;
        int n2 = 0;
        if (string == null) {
            string = "1";
        }
        try {
            n2 = Integer.parseInt(string);
        }
        catch (Exception exception) {
            n2 = 1;
        }
        int n3 = dateTime.get(7);
        if (n2 < 1 || n2 > 7) {
            n2 = 1;
        }
        if ((n = n3 - n2) > 6 || n < -6) {
            n = 0;
        }
        if (n < 0) {
            n = 7 + n;
        }
        DateTime dateTime2 = (DateTime)dateTime.clone();
        dateTime2.add(5, -n);
        return dateTime2;
    }

    public static void printStackTrace(Exception exception) {
        if (_utilsLogger.isLoggable(Level.FINEST)) {
            if (null == exception) {
                _utilsLogger.finest("printStackTrace: Exception is null");
                return;
            }
            String string = UWCUtils.getStackTraceString(exception.getStackTrace());
            if (null == string) {
                _utilsLogger.finest("printStackTrace: StackTrace is not available");
            } else {
                _utilsLogger.finest("***** Printing Stack Trace *****");
                _utilsLogger.finest("\n");
                _utilsLogger.finest(string);
                _utilsLogger.finest("\n");
            }
            Throwable throwable = exception.getCause();
            String string2 = string = null == throwable ? null : UWCUtils.getStackTraceString(throwable.getStackTrace());
            if (null != string) {
                _utilsLogger.finest("***** Printing Root Cause *****");
                _utilsLogger.finest("\n");
                _utilsLogger.finest(string);
                _utilsLogger.finest("\n");
            }
        }
    }

    public static String getStackTraceString(StackTraceElement[] stackTraceElementArray) {
        if (null == stackTraceElementArray) {
            return null;
        }
        NonSyncStringBuffer nonSyncStringBuffer = new NonSyncStringBuffer(stackTraceElementArray.length * 64);
        for (int i = 0; i < stackTraceElementArray.length; ++i) {
            nonSyncStringBuffer.append(stackTraceElementArray[i].toString());
            nonSyncStringBuffer.append("\n");
        }
        return nonSyncStringBuffer.toString();
    }

    public static void printArray(String[] stringArray, String string) {
        if (_utilsLogger.isLoggable(Level.FINEST)) {
            if (null == string) {
                string = "";
            }
            if (null != stringArray) {
                for (int i = 0; i < stringArray.length; ++i) {
                }
            }
        }
    }

    public static void printOptions(OptionList optionList, String string) {
        if (_utilsLogger.isLoggable(Level.FINEST)) {
            if (null == string) {
                string = "";
            }
            if (null != optionList) {
                for (int i = 0; i < optionList.size(); ++i) {
                }
            }
        }
    }

    public static OptionList getOptionList(String[] stringArray) {
        OptionList optionList = new OptionList();
        if (null != stringArray) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (null == stringArray[i]) continue;
                optionList.add(new Option(stringArray[i], stringArray[i]));
            }
        }
        return optionList;
    }

    public static OptionList getOptionList(HashMap hashMap) {
        String[] stringArray;
        OptionList optionList = new OptionList();
        if (null != hashMap && null != (stringArray = hashMap.keySet().toArray(UWCConstants.ZERO_STRING_ARRAY))) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (null == hashMap.get(stringArray[i])) continue;
                optionList.add(new Option((String)hashMap.get(stringArray[i]), stringArray[i]));
            }
        }
        return optionList;
    }

    public static UWCCalendar getUWCCalendar(RequestContext requestContext, String string, boolean bl) {
        if (null == string) {
            return null;
        }
        return UWCUtils.getUWCCalendar(requestContext, string, bl, true, true);
    }

    public static UWCCalendar getUWCCalendar(RequestContext requestContext, String string, boolean bl, boolean bl2, boolean bl3) {
        block8: {
            Object object;
            Object object2;
            Object object3;
            if (null == string) {
                return null;
            }
            if (bl2 && null != (object3 = UWCUserHelper.getOwnedCalendars(requestContext)) && null != (object2 = (UWCCalendar)object3.get(string))) {
                return object2;
            }
            if (bl3 && null != (object3 = UWCUserHelper.getSubscribedCalendars(requestContext)) && null != (object2 = (UWCCalendar)object3.get(string))) {
                return object2;
            }
            object3 = UWCUserHelper.getCalendarBaseModel(requestContext);
            object2 = ((CalendarBaseModel)((Object)object3)).getCalendars();
            if (object2 != null && null != (object = (UWCCalendar)((HashMap)object2).get(string))) {
                return object;
            }
            if (bl && null != (object = UWCUserHelper.getICalendarModel(requestContext))) {
                try {
                    ((ICalendarModel)((Object)object)).setCalID(string);
                    ((ICalendarModel)((Object)object)).execute((ModelExecutionContext)new CalendarExecutionModelContext(CalendarExecutionModelContext.LOAD_CALENDAR_CONTEXT));
                    UWCCalendar uWCCalendar = ((ICalendarModel)((Object)object)).getCalendar();
                    if (null != uWCCalendar) {
                        return uWCCalendar;
                    }
                }
                catch (ModelControlException modelControlException) {
                    if (!_utilsLogger.isLoggable(Level.WARNING)) break block8;
                    _utilsLogger.warning("Error while loading the calendar thru ICalendarModel: " + (Object)((Object)modelControlException));
                }
            }
        }
        return null;
    }

    public static String convertToVirtualDomainForm(RequestContext requestContext, String string) {
        String string2;
        if (null != string && UWCApplicationHelper.isVirtualDomainEnabled() && string.indexOf("@") < 0 && null != (string2 = UWCUserHelper.getDomain(requestContext))) {
            return string + "@" + string2;
        }
        return string;
    }

    public static String getDefaultCalendar(RequestContext requestContext) {
        if (null == requestContext) {
            return null;
        }
        String string = null;
        CalUserPreferencesModel calUserPreferencesModel = UWCUserHelper.getCalUserPrefModel(requestContext);
        if (null != calUserPreferencesModel) {
            if (!calUserPreferencesModel.getInitialized()) {
                try {
                    calUserPreferencesModel.initializeCalendarPreferences();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            string = calUserPreferencesModel.getDefaultCalendarId();
        }
        if (null == string) {
            CalendarStore calendarStore = null;
            try {
                ICalendar iCalendar;
                calendarStore = UWCUserHelper.getCalStore(requestContext, false);
                if (null != calendarStore && null != (iCalendar = calendarStore.openCalendar())) {
                    string = iCalendar.getCalID();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return string;
    }

    public static OptionList getLocalizedOptionList(UWCPreferences uWCPreferences, String string, String[] stringArray, String[] stringArray2) {
        OptionList optionList = new OptionList();
        if (null == uWCPreferences) {
            return optionList;
        }
        if (null == stringArray) {
            return optionList;
        }
        if (null == stringArray2) {
            return optionList;
        }
        if (stringArray.length != stringArray2.length) {
            return optionList;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = null == string ? stringArray[i] : string + stringArray[i];
            String string3 = uWCPreferences.get(string2, null);
            if (null == string3) {
                string3 = stringArray[i];
            }
            if (null == string3) continue;
            optionList.add(new Option(string3, stringArray2[i]));
        }
        return optionList;
    }

    public static String[] getMonthsOfYearAsNumbers() {
        return monthAsNumbers;
    }

    public static String getHoursValue(DateTime dateTime, String string) {
        if (null == dateTime) {
            return null;
        }
        int n = dateTime.get(11);
        if ("24".equals(string)) {
            return UWCConstants.hoursIn24HourFormatValues[n];
        }
        n = (n + 12 - 1) % 12;
        return UWCConstants.hoursIn12HourFormatValues[n];
    }

    public static String getMinutesValue(DateTime dateTime, String string) {
        if (null == dateTime) {
            return null;
        }
        int n = dateTime.get(11);
        int n2 = dateTime.get(12) / 5;
        if ("24".equals(string)) {
            return UWCConstants.minutesIn24HourFormatValues[n2];
        }
        n2 = n > 11 ? n2 + 12 : n2;
        return UWCConstants.minutesIn12HourFormatValues[n2];
    }

    public static String getDisplayableHours(RequestContext requestContext, DateTime dateTime, String string) {
        if (null == dateTime) {
            return null;
        }
        int n = dateTime.get(11);
        if ("24".equals(string)) {
            return UWCUserHelper.getLocalizedStringLabel(requestContext, "uwc-common-" + UWCConstants.hoursIn24HourFormatNames[n]);
        }
        n = (n + 12 - 1) % 12;
        return UWCUserHelper.getLocalizedStringLabel(requestContext, "uwc-common-" + UWCConstants.hoursIn12HourFormatNames[n]);
    }

    public static String getDisplayableMinutes(RequestContext requestContext, DateTime dateTime, String string) {
        if (null == dateTime) {
            return null;
        }
        int n = dateTime.get(11);
        int n2 = dateTime.get(12) / 5;
        if ("24".equals(string)) {
            return UWCUserHelper.getLocalizedStringLabel(requestContext, "uwc-common-" + UWCConstants.minutesIn24HourFormatNames[n2]);
        }
        n2 = n > 11 ? n2 + 12 : n2;
        return UWCUserHelper.getLocalizedStringLabel(requestContext, "uwc-common-" + UWCConstants.minutesIn12HourFormatNames[n2]);
    }

    public static String getDisplayableTime(RequestContext requestContext, DateTime dateTime, String string) {
        String string2 = UWCUtils.getDisplayableHours(requestContext, dateTime, string);
        String string3 = UWCUtils.getDisplayableMinutes(requestContext, dateTime, string);
        string2 = null == string2 ? "??" : string2;
        string3 = null == string3 ? ":??" : string3;
        return string2 + string3;
    }

    public static String getYearValue(RequestContext requestContext, DateTime dateTime) {
        if (null != dateTime) {
            int n = dateTime.get(1) - 2000;
            if (n >= 0 && n <= 6) {
                return UWCConstants.yearValues[n];
            }
            return Integer.toString(dateTime.get(1));
        }
        return null;
    }

    public static String getYearLabel(RequestContext requestContext, DateTime dateTime) {
        if (null != dateTime) {
            int n = dateTime.get(1) - 2000;
            if (n >= 0 && n <= 6) {
                return UWCUserHelper.getLocalizedStringLabel(requestContext, "uwc-common-" + UWCConstants.yearNames[n]);
            }
            return Integer.toString(dateTime.get(1));
        }
        return null;
    }

    public static String getDisplayableDate(RequestContext requestContext, DateTime dateTime, String string, String string2) {
        if (null == dateTime) {
            return null;
        }
        int n = dateTime.get(2);
        int n2 = dateTime.get(5) - 1;
        String string3 = UWCUserHelper.getLocalizedStringLabel(requestContext, "uwc-common-" + UWCConstants.displayableMonthLabels[n]);
        String string4 = UWCUserHelper.getLocalizedStringLabel(requestContext, "uwc-common-" + UWCConstants.displayableDayLabels[n2]);
        String string5 = UWCUtils.getYearLabel(requestContext, dateTime);
        if (null == string3) {
            string3 = "??";
        }
        if (null == string4) {
            string4 = "??";
        }
        if (null == string5) {
            string5 = "????";
        }
        if (null == string2) {
            string2 = "/";
        }
        if (null == string) {
            string = "M/D/Y";
        }
        NonSyncStringBuffer nonSyncStringBuffer = new NonSyncStringBuffer(16);
        if ("D/M/Y".equalsIgnoreCase(string)) {
            nonSyncStringBuffer.append(string4);
            nonSyncStringBuffer.append(string2);
            nonSyncStringBuffer.append(string3);
            nonSyncStringBuffer.append(string2);
            nonSyncStringBuffer.append(string5);
        } else if ("Y/M/D".equalsIgnoreCase(string)) {
            nonSyncStringBuffer.append(string5);
            nonSyncStringBuffer.append(string2);
            nonSyncStringBuffer.append(string3);
            nonSyncStringBuffer.append(string2);
            nonSyncStringBuffer.append(string4);
        } else {
            nonSyncStringBuffer.append(string3);
            nonSyncStringBuffer.append(string2);
            nonSyncStringBuffer.append(string4);
            nonSyncStringBuffer.append(string2);
            nonSyncStringBuffer.append(string5);
        }
        return nonSyncStringBuffer.toString();
    }

    public static String getDisplayableDateWithoutYear(RequestContext requestContext, DateTime dateTime, String string, String string2) {
        if (null == dateTime) {
            return null;
        }
        int n = dateTime.get(2);
        int n2 = dateTime.get(5) - 1;
        String string3 = UWCUserHelper.getLocalizedStringLabel(requestContext, "uwc-common-" + UWCConstants.displayableMonthLabels[n]);
        String string4 = UWCUserHelper.getLocalizedStringLabel(requestContext, "uwc-common-" + UWCConstants.displayableDayLabels[n2]);
        if (null == string3) {
            string3 = "??";
        }
        if (null == string4) {
            string4 = "??";
        }
        if (null == string2) {
            string2 = "/";
        }
        if (null == string) {
            string = "M/D/Y";
        }
        NonSyncStringBuffer nonSyncStringBuffer = new NonSyncStringBuffer(8);
        if ("D/M/Y".equalsIgnoreCase(string)) {
            nonSyncStringBuffer.append(string4);
            nonSyncStringBuffer.append(string2);
            nonSyncStringBuffer.append(string3);
        } else if ("Y/M/D".equalsIgnoreCase(string)) {
            nonSyncStringBuffer.append(string3);
            nonSyncStringBuffer.append(string2);
            nonSyncStringBuffer.append(string4);
        } else {
            nonSyncStringBuffer.append(string3);
            nonSyncStringBuffer.append(string2);
            nonSyncStringBuffer.append(string4);
        }
        return nonSyncStringBuffer.toString();
    }

    public static String getDisplayableDayDate(RequestContext requestContext, DateTime dateTime) {
        if (null == dateTime) {
            return null;
        }
        int n = dateTime.get(7);
        int n2 = dateTime.get(2);
        int n3 = dateTime.get(5) - 1;
        String string = UWCUserHelper.getLocalizedStringLabel(requestContext, "uwc-calclient-common-" + UWCConstants.daysOfWeekNames[n - 1]);
        String string2 = UWCUserHelper.getLocalizedStringLabel(requestContext, "uwc-common-" + UWCConstants.monthNames[n2]);
        String string3 = UWCUserHelper.getLocalizedStringLabel(requestContext, "uwc-common-" + UWCConstants.displayableDayLabels[n3]);
        String string4 = UWCUtils.getYearLabel(requestContext, dateTime);
        if (null == string) {
            string = "??";
        }
        if (null == string2) {
            string2 = "??";
        }
        if (null == string3) {
            string3 = "??";
        }
        if (null == string4) {
            string4 = "????";
        }
        NonSyncStringBuffer nonSyncStringBuffer = new NonSyncStringBuffer(32);
        nonSyncStringBuffer.append(string);
        nonSyncStringBuffer.append(",");
        nonSyncStringBuffer.append(" ");
        nonSyncStringBuffer.append(string2);
        nonSyncStringBuffer.append(" ");
        nonSyncStringBuffer.append(string3);
        nonSyncStringBuffer.append(",");
        nonSyncStringBuffer.append(" ");
        nonSyncStringBuffer.append(string4);
        return nonSyncStringBuffer.toString();
    }

    public static String getDisplayableMonth(RequestContext requestContext, DateTime dateTime) {
        if (null == dateTime) {
            return null;
        }
        int n = dateTime.get(2);
        String string = UWCUserHelper.getLocalizedStringLabel(requestContext, "uwc-common-" + UWCConstants.monthNames[n]);
        String string2 = UWCUtils.getYearLabel(requestContext, dateTime);
        if (null == string) {
            string = "??";
        }
        if (null == string2) {
            string2 = "????";
        }
        NonSyncStringBuffer nonSyncStringBuffer = new NonSyncStringBuffer(8);
        nonSyncStringBuffer.append(string);
        nonSyncStringBuffer.append(" ");
        nonSyncStringBuffer.append(string2);
        return nonSyncStringBuffer.toString();
    }

    public static String getDisplayableDateTime(RequestContext requestContext, DateTime dateTime, DateTime dateTime2, String string, String string2, String string3) {
        NonSyncStringBuffer nonSyncStringBuffer = new NonSyncStringBuffer(32);
        nonSyncStringBuffer.append(UWCUtils.getDisplayableDate(requestContext, dateTime, string, string2));
        nonSyncStringBuffer.append(" ");
        nonSyncStringBuffer.append(UWCUtils.getDisplayableTime(requestContext, dateTime, string3));
        nonSyncStringBuffer.append(" ");
        Duration duration = null;
        try {
            duration = new Duration(dateTime, dateTime2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (null != duration) {
            nonSyncStringBuffer.append("(");
            nonSyncStringBuffer.append(duration.getHours());
            if (duration.getMinutes() > 5) {
                nonSyncStringBuffer.append(".");
                nonSyncStringBuffer.append(duration.getMinutes() / 6);
            }
            nonSyncStringBuffer.append(" ");
            String string4 = UWCUserHelper.getLocalizedStringLabel(requestContext, "hours", "uwc-calclient-options-");
            if (null == string4) {
                string4 = "hours";
            }
            nonSyncStringBuffer.append(string4);
            nonSyncStringBuffer.append(")");
        }
        return nonSyncStringBuffer.toString();
    }

    public static String getDisplayableContextName(RequestContext requestContext, String string) {
        if ("day".equalsIgnoreCase(string)) {
            return UWCUserHelper.getLocalizedStringLabel(requestContext, "uwc-calclient-toolbar-Day", "Day");
        }
        if ("week".equalsIgnoreCase(string)) {
            return UWCUserHelper.getLocalizedStringLabel(requestContext, "uwc-calclient-toolbar-Week", "Week");
        }
        if ("month".equalsIgnoreCase(string)) {
            return UWCUserHelper.getLocalizedStringLabel(requestContext, "uwc-calclient-toolbar-Month", "Month");
        }
        return UWCUserHelper.getLocalizedStringLabel(requestContext, "uwc-calclient-toolbar-Day", "Day");
    }

    public static String getDisplayableContextDuration(RequestContext requestContext, DateTime dateTime, DateTime dateTime2, String string) {
        if ("day".equalsIgnoreCase(string)) {
            return UWCUtils.getDisplayableDayDate(requestContext, dateTime);
        }
        if ("week".equalsIgnoreCase(string)) {
            if (null == dateTime || null == dateTime2) {
                return null;
            }
            int n = dateTime.get(2);
            int n2 = dateTime.get(5) - 1;
            int n3 = dateTime2.get(2);
            int n4 = dateTime2.get(5) - 1;
            String string2 = UWCUserHelper.getLocalizedStringLabel(requestContext, "uwc-common-" + UWCConstants.monthNames[n]);
            String string3 = UWCUserHelper.getLocalizedStringLabel(requestContext, "uwc-common-" + UWCConstants.displayableDayLabels[n2]);
            String string4 = UWCUserHelper.getLocalizedStringLabel(requestContext, "uwc-common-" + UWCConstants.monthNames[n3]);
            String string5 = UWCUserHelper.getLocalizedStringLabel(requestContext, "uwc-common-" + UWCConstants.displayableDayLabels[n4]);
            String string6 = UWCUtils.getYearLabel(requestContext, dateTime2);
            if (null == string2) {
                string2 = "??";
            }
            if (null == string3) {
                string3 = "??";
            }
            if (null == string4) {
                string4 = "??";
            }
            if (null == string5) {
                string5 = "??";
            }
            if (null == string6) {
                string6 = "????";
            }
            NonSyncStringBuffer nonSyncStringBuffer = new NonSyncStringBuffer(32);
            nonSyncStringBuffer.append(string2);
            nonSyncStringBuffer.append(" ");
            nonSyncStringBuffer.append(string3);
            nonSyncStringBuffer.append(" - ");
            nonSyncStringBuffer.append(string4);
            nonSyncStringBuffer.append(" ");
            nonSyncStringBuffer.append(string5);
            nonSyncStringBuffer.append(",");
            nonSyncStringBuffer.append(" ");
            nonSyncStringBuffer.append(string6);
            return nonSyncStringBuffer.toString();
        }
        if ("month".equalsIgnoreCase(string)) {
            if (null == dateTime) {
                return null;
            }
            int n = dateTime.get(2);
            String string7 = UWCUserHelper.getLocalizedStringLabel(requestContext, "uwc-common-" + UWCConstants.monthNames[n]);
            String string8 = UWCUtils.getYearLabel(requestContext, dateTime);
            if (null == string7) {
                string7 = "??";
            }
            if (null == string8) {
                string8 = "????";
            }
            return string7 + " " + string8;
        }
        return UWCUtils.getDisplayableDayDate(requestContext, dateTime);
    }

    public static DateTime getContextStart(DateTime dateTime, String string, int n) {
        if (null == dateTime) {
            return null;
        }
        dateTime = (DateTime)dateTime.clone();
        dateTime.setTime(0, 0, 0);
        dateTime.set(14, 0);
        if ("week".equalsIgnoreCase(string)) {
            int n2 = dateTime.get(7);
            int n3 = (7 + n2 - n) % 7;
            dateTime.add(6, -n3);
        } else if ("month".equalsIgnoreCase(string)) {
            dateTime.set(5, 1);
        }
        return dateTime;
    }

    public static DateTime getContextEnd(DateTime dateTime, String string) {
        if (null == dateTime) {
            return null;
        }
        dateTime = (DateTime)dateTime.clone();
        if ("day".equalsIgnoreCase(string)) {
            dateTime.add(6, 1);
            dateTime.add(13, -1);
        } else if ("week".equalsIgnoreCase(string)) {
            dateTime.add(6, 7);
            dateTime.add(13, -1);
        } else if ("month".equalsIgnoreCase(string)) {
            dateTime.add(2, 1);
            dateTime.add(13, -1);
        } else {
            dateTime.add(6, 1);
            dateTime.add(13, -1);
        }
        return dateTime;
    }

    public static TimeZone getTimeZone(String string, boolean bl) {
        if (null == string || string.trim().equals("")) {
            if (bl) {
                string = "GMT";
            } else {
                return null;
            }
        }
        TimeZone timeZone = TimeZone.getTimeZone(string);
        return timeZone;
    }

    public static DateTime getDateTime(String string, String string2, String string3, String string4, String string5, String string6, String string7) throws IllegalArgumentException, NumberFormatException {
        int n = UWCUtils.isStringContainedInStringArray(string, UWCConstants.dayValues);
        int n2 = UWCUtils.isStringContainedInStringArray(string2, UWCConstants.monthValues);
        int n3 = UWCUtils.isStringContainedInStringArray(string3, UWCConstants.yearValues);
        if (-1 == n) {
            throw new IllegalArgumentException("Invalid day");
        }
        if (-1 == n2) {
            throw new IllegalArgumentException("Invalid month");
        }
        if (-1 == n3) {
            throw new IllegalArgumentException("Invalid year");
        }
        int n4 = UWCUtils.parseInteger(string, "Couldn't parse day value");
        int n5 = UWCUtils.parseInteger(string3, "Couldn't parse year value");
        int n6 = UWCUtils.parseInteger(string4, "Couldn't parse hours value");
        int n7 = UWCUtils.parseInteger(string5, "Couldn't parse minutes value");
        int n8 = UWCUtils.parseInteger(string6, "Couldn't parse seconds value");
        if (0 > n6 && 23 < n6) {
            throw new IllegalArgumentException("Invalid hours: Not between 0 and 23");
        }
        n6 += n7 / 60;
        TimeZone timeZone = UWCUtils.getTimeZone(string7, false);
        DateTime dateTime = null == timeZone ? new DateTime() : new DateTime(timeZone);
        dateTime.setDate(n5, n2, n4);
        dateTime.setTime(n6, n7 %= 60, n8 %= 60);
        dateTime.set(14, 0);
        return dateTime;
    }

    public static int parseInteger(String string, String string2) throws NumberFormatException {
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new NumberFormatException(string2);
        }
    }

    public static String getFormattedDateTime(DateTime dateTime, String string) {
        if (null == dateTime) {
            return null;
        }
        if (null == string) {
            string = "EEE, dd MMM yyyy HH:mm:ss z Z";
        }
        TimeZone timeZone = dateTime.getTimeZone();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string);
        if (null != timeZone) {
            simpleDateFormat.setTimeZone(timeZone);
        }
        simpleDateFormat.setLenient(false);
        return simpleDateFormat.format(dateTime.getTime());
    }

    public static String getContextPathPrefix(RequestContext requestContext) {
        if (null == requestContext) {
            return null;
        }
        String string = requestContext.getRequest().getContextPath();
        String string2 = null;
        string2 = null == string || string.trim().equals("") || string.equals("/") ? "/" : (string.endsWith("/") ? string : string + "/");
        return string2;
    }

    public static String getCtxQueryString(HttpServletRequest httpServletRequest, HashMap hashMap, String[] stringArray, boolean bl) {
        boolean bl2 = true;
        boolean bl3 = true;
        if (httpServletRequest == null) {
            bl3 = false;
        }
        if (hashMap == null) {
            bl2 = false;
        }
        if (!bl3 && !bl2) {
            return "";
        }
        if (stringArray == null) {
            stringArray = UWCConstants.VIEW_CONTEXT_PARAMS;
        }
        NonSyncStringBuffer nonSyncStringBuffer = new NonSyncStringBuffer(128);
        if (bl) {
            nonSyncStringBuffer.append("?");
        }
        int n = stringArray.length;
        String string = null;
        boolean bl4 = false;
        for (int i = 0; i < n; ++i) {
            if (bl3) {
                string = httpServletRequest.getParameter(stringArray[i]);
            }
            if (string == null && bl2) {
                string = (String)hashMap.get(stringArray[i]);
            }
            if (string == null) continue;
            bl4 = true;
            nonSyncStringBuffer.append(stringArray[i]);
            nonSyncStringBuffer.append("=");
            nonSyncStringBuffer.append(string);
            if (i >= n - 1) continue;
            nonSyncStringBuffer.append("&");
        }
        if (!bl4) {
            return "";
        }
        return String.valueOf(nonSyncStringBuffer);
    }

    public static String getCalendarNameToDisplay(String string, String string2, int n, int n2) {
        if (string == null) {
            throw new IllegalArgumentException("Calid is a mandatory parameter");
        }
        String string3 = string;
        if (0 < n && string3.length() > n) {
            string3 = string3.substring(0, n) + "..";
        }
        if (0 < n2 && null != string2 && string2.length() > n2) {
            string2 = string2.substring(0, n2) + "..";
        }
        return null != string2 ? string3 + " (" + string2 + ") " : string3;
    }

    public static String getCalendarNameToDisplay(String string, String string2) {
        return UWCUtils.getCalendarNameToDisplay(string, string2, 0, 0);
    }

    public static int checkCalendarPermission(RequestContext requestContext, String string, String string2, String string3, String string4) {
        UWCCalendar uWCCalendar = UWCUtils.getUWCCalendar(requestContext, string, true);
        if (null == uWCCalendar) {
            return -1;
        }
        ICalendar iCalendar = uWCCalendar.getCalendar();
        if (null == iCalendar) {
            return -1;
        }
        boolean bl = false;
        boolean bl2 = false;
        try {
            bl = iCalendar.isUserTheOwner(string2);
        }
        catch (Exception exception) {
            if (_utilsLogger.isLoggable(Level.WARNING)) {
                _utilsLogger.warning("checkCalendarPermission: isUserTheOwner failed: " + exception);
            }
            return -1;
        }
        if (bl) {
            return 0;
        }
        CalendarACL calendarACL = uWCCalendar.getACL();
        if (null == calendarACL) {
            return -1;
        }
        try {
            bl2 = calendarACL.checkPermission(string2, string3, string4);
        }
        catch (UWCException uWCException) {
            if (_utilsLogger.isLoggable(Level.WARNING)) {
                _utilsLogger.warning("checkCalendarPermission: checkPermission failed: " + uWCException);
            }
            return -1;
        }
        if (!bl2) {
            return -1;
        }
        return 0;
    }

    public static String getPercentValue(String string) {
        int n = -1;
        String string2 = null;
        if (string == null) {
            return "0";
        }
        n = UWCUtils.isStringContainedInStringArray(string, UWCConstants.calendarTaskPercentValues, true);
        if (n != -1) {
            string2 = UWCConstants.calendarTaskPercentValues[n];
            return string2;
        }
        n = UWCUtils.isStringContainedInStringArray(string, UWCConstants.calendarTaskPercentNames, true);
        string2 = -1 == n ? "0" : UWCConstants.calendarTaskPercentValues[n];
        return string2;
    }

    public static String getPercentText(String string) {
        int n = -1;
        String string2 = null;
        if (string == null) {
            return "0% (Not Started)";
        }
        n = UWCUtils.isStringContainedInStringArray(string, UWCConstants.calendarTaskPercentValues, true);
        string2 = -1 == n ? "0% (Not Started)" : UWCConstants.calendarTaskPercentNames[n];
        return string2;
    }

    public static String getAnonAccessURL(RequestContext requestContext, String string) {
        HttpServletRequest httpServletRequest;
        if (string != null && string.length() > 0 && requestContext != null && (httpServletRequest = requestContext.getRequest()) != null) {
            String string2 = httpServletRequest.getServerName();
            int n = httpServletRequest.getServerPort();
            if (string2 != null) {
                URL uRL = null;
                try {
                    uRL = new URL("http", string2, n, "");
                }
                catch (Exception exception) {
                    if (_utilsLogger.isLoggable(Level.WARNING)) {
                        _utilsLogger.warning("Exception: " + exception.getMessage() + " Returning Null");
                    }
                    return null;
                }
                String string3 = requestContext.getRequest().getContextPath();
                string3 = "/".equals(string3) ? string3 : string3 + "/";
                String string4 = uRL.toString() + string3 + "?" + "calid" + "=" + string;
                return string4;
            }
        }
        return null;
    }

    public static String getViewURLFromCtx(String string) {
        if (string == null || string != null && string.equals("day")) {
            return "DayView";
        }
        if (string.equals("week")) {
            return "WeekView";
        }
        if (string.equals("month")) {
            return "MonthView";
        }
        if (string.equals("year")) {
            return "YearView";
        }
        return "DayView";
    }

    public static String unescape_crlf(String string) {
        char[] cArray = string.toCharArray();
        NonSyncStringBuffer nonSyncStringBuffer = new NonSyncStringBuffer("");
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] == '$') {
                nonSyncStringBuffer.append('\n');
                continue;
            }
            if (cArray[i] == '\\') {
                if (cArray[i + 1] == '2' && cArray[i + 2] == '4') {
                    nonSyncStringBuffer.append('$');
                } else if (cArray[i + 1] == '3' && cArray[i + 2] == 'a') {
                    nonSyncStringBuffer.append(':');
                } else if (cArray[i + 1] == '2' && cArray[i + 2] == '2') {
                    nonSyncStringBuffer.append('\"');
                } else if (cArray[i + 1] == '7' && cArray[i + 2] == 'c') {
                    nonSyncStringBuffer.append('|');
                } else if (cArray[i + 1] == '2' && cArray[i + 2] == '5') {
                    nonSyncStringBuffer.append('%');
                } else if (cArray[i + 1] == '5' && cArray[i + 2] == 'e') {
                    nonSyncStringBuffer.append('^');
                } else if (cArray[i + 1] == '5' && cArray[i + 2] == 'c') {
                    nonSyncStringBuffer.append('\\');
                } else if (cArray[i + 1] == '2' && cArray[i + 2] == '8') {
                    nonSyncStringBuffer.append('(');
                } else if (cArray[i + 1] == '2' && cArray[i + 2] == '9') {
                    nonSyncStringBuffer.append(')');
                }
                i += 2;
                continue;
            }
            nonSyncStringBuffer.append(cArray[i]);
        }
        return nonSyncStringBuffer.toString();
    }

    public static String escape_crlf(String string) {
        char[] cArray = string.toCharArray();
        NonSyncStringBuffer nonSyncStringBuffer = new NonSyncStringBuffer("");
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] == '$') {
                nonSyncStringBuffer.append("\\24");
                continue;
            }
            if (cArray[i] == '\r') {
                nonSyncStringBuffer.append('$');
                if (cArray[i + 1] != '\n') continue;
                ++i;
                continue;
            }
            if (cArray[i] == '\n') {
                nonSyncStringBuffer.append('$');
                continue;
            }
            if (cArray[i] == ':') {
                nonSyncStringBuffer.append("\\3a");
                continue;
            }
            if (cArray[i] == '\"') {
                nonSyncStringBuffer.append("\\22");
                continue;
            }
            if (cArray[i] == '|') {
                nonSyncStringBuffer.append("\\7c");
                continue;
            }
            if (cArray[i] == '%') {
                nonSyncStringBuffer.append("\\25");
                continue;
            }
            if (cArray[i] == '^') {
                nonSyncStringBuffer.append("\\5e");
                continue;
            }
            if (cArray[i] == '\\') {
                nonSyncStringBuffer.append("\\5c");
                continue;
            }
            if (cArray[i] == '(') {
                nonSyncStringBuffer.append("\\28");
                continue;
            }
            if (cArray[i] == ')') {
                nonSyncStringBuffer.append("\\29");
                continue;
            }
            nonSyncStringBuffer.append(cArray[i]);
        }
        return nonSyncStringBuffer.toString();
    }

    public static String mapFieldName(RequestContext requestContext, String[] stringArray) {
        if (stringArray == null || stringArray[0] == null) {
            return "";
        }
        if (stringArray[0].equalsIgnoreCase("From")) {
            return UWCUserHelper.getLocalizedLabel(requestContext, "sender-label", "uwc-mail-options-");
        }
        if (stringArray[0].equalsIgnoreCase("Subject")) {
            return UWCUserHelper.getLocalizedLabel(requestContext, "subject-label", "uwc-mail-options-");
        }
        if (stringArray[0].equalsIgnoreCase("To") && stringArray[1].equalsIgnoreCase("Cc") && stringArray[2].equalsIgnoreCase("Bcc")) {
            return UWCUserHelper.getLocalizedLabel(requestContext, "recipient-label", "uwc-mail-options-");
        }
        return "INVALID-FIELD";
    }

    public static String mapOperator(RequestContext requestContext, FilterCondition filterCondition) {
        String string = filterCondition.getCompOperator();
        boolean bl = filterCondition.isNegated();
        String string2 = filterCondition.getFieldValueList()[0];
        if (string.equals(":contains")) {
            if (bl) {
                return UWCUserHelper.getLocalizedLabel(requestContext, "doesnotcontain-label", "uwc-mail-options-");
            }
            return UWCUserHelper.getLocalizedLabel(requestContext, "contains-label", "uwc-mail-options-");
        }
        if (string.equals(":is")) {
            if (bl) {
                return UWCUserHelper.getLocalizedLabel(requestContext, "isnot-label", "uwc-mail-options-");
            }
            return UWCUserHelper.getLocalizedLabel(requestContext, "is-label", "uwc-mail-options-");
        }
        if (string.equals(":matches")) {
            if (string2.startsWith("*")) {
                return UWCUserHelper.getLocalizedLabel(requestContext, "endswith-label", "uwc-mail-options-");
            }
            if (string2.endsWith("*")) {
                return UWCUserHelper.getLocalizedLabel(requestContext, "beginswith-label", "uwc-mail-options-");
            }
            return UWCUserHelper.getLocalizedLabel(requestContext, "matches-label", "uwc-mail-options-");
        }
        if (string.equals(":under")) {
            return UWCUserHelper.getLocalizedLabel(requestContext, "sizeUnder-label", "uwc-mail-options-");
        }
        if (string.equals(":over")) {
            return UWCUserHelper.getLocalizedLabel(requestContext, "sizeOver-label", "uwc-mail-options-");
        }
        return "INVALID-OPERATOR";
    }

    public static String mapCommandName(RequestContext requestContext, FilterAction filterAction, boolean bl) {
        String string = filterAction.getCommandName();
        String string2 = filterAction.getArgument();
        if (string.equals("fileinto")) {
            return UWCUserHelper.getLocalizedLabel(requestContext, "filemsg-action", "uwc-mail-options-");
        }
        if (string.equals("redirect")) {
            if (bl) {
                return UWCUserHelper.getLocalizedLabel(requestContext, "fwdmsgmobile-action", "uwc-mail-options-");
            }
            return UWCUserHelper.getLocalizedLabel(requestContext, "fwdmsg-action", "uwc-mail-options-");
        }
        if (string.equals("keep")) {
            return UWCUserHelper.getLocalizedLabel(requestContext, "keepcopy-action", "uwc-mail-options-");
        }
        if (string.equals("discard")) {
            return UWCUserHelper.getLocalizedLabel(requestContext, "discardmsg-action", "uwc-mail-options-");
        }
        if (string.equals("stop") || string.equals("require")) {
            return "";
        }
        return "INVALID-ACTIONCOMMAND";
    }

    public static String convertUnderScoreToHypen(String string) {
        if (null != string) {
            string = string.trim();
            if ((string = string.toLowerCase()).indexOf(UNDERSCORE) > -1) {
                string = string.replaceAll(UNDERSCORE, HYPHEN);
            }
        }
        return string;
    }

    static {
        _utilsLogger = UWCLogger.getLogger("uwc.common");
        leapYearFebDays = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "25", "26", "27", "28"};
        FebDays = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "25", "26", "27", "28", "29"};
        Thirtydays = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "30"};
        Thirty1days = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "30", "31"};
        days = new String[]{"Sunday", "Monday", "Tuesday", "Wednesday", "Thrusday", "Friday", "Saturday"};
        months = new String[]{"January", "Feb", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};
        monthAsNumbers = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11"};
    }
}

