/*
 * Decompiled with CFR 0.152.
 */
package com.sun.uwc.common.util;

import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMOrganization;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.uwc.common.UWCException;
import com.sun.uwc.common.auth.Domain;
import com.sun.uwc.common.auth.LDAPDomainMap;
import com.sun.uwc.common.util.UWCLogger;
import com.sun.uwc.common.util.UWCPreferences;
import java.security.Principal;
import java.util.HashMap;
import java.util.logging.Logger;

public class UWCDomainManager {
    public static final String CONFIG_DEFAULTDOMAIN = "defaultdomain";
    public static final String CONFIG_IDENTITY_ENABLED = "uwcauth.identity.enabled";
    public static final String CONFIG_BINDDN = "uwcauth.identity.binddn";
    public static final String CONFIG_BINDCRED = "uwcauth.identity.bindcred";
    private HashMap domainmap = new HashMap();
    private boolean isISEnabled = false;
    private static final Logger log = UWCLogger.getLogger("uwc");
    private String defaultdomain = null;
    private UWCPreferences uwcconfig;
    private UWCPreferences uwcauth;
    private LDAPDomainMap ldapDomainMap = null;
    private SSOTokenManager manager = null;
    private String amadmindn = null;
    private String amadmincred = null;
    private String CLASS_NAME = "UWCDomainManager";

    public void init(UWCPreferences uWCPreferences, UWCPreferences uWCPreferences2) throws UWCException {
        log.entering(this.CLASS_NAME, "init()");
        if (null == uWCPreferences) {
            throw new UWCException("Config Object is null");
        }
        if (null == uWCPreferences2) {
            throw new UWCException("Config Object is null");
        }
        this.uwcconfig = uWCPreferences;
        this.uwcauth = uWCPreferences2;
        this.isISEnabled = this.uwcauth.getBoolean(CONFIG_IDENTITY_ENABLED, false);
        this.defaultdomain = this.uwcauth.get(CONFIG_DEFAULTDOMAIN, "india.sun.com");
        if (!this.isISEnabled) {
            log.finest("IS Enabled");
            this.ldapDomainMap = LDAPDomainMap.getInstance(this.uwcauth);
            if (null == this.ldapDomainMap) {
                log.finest("Domain Map is NULL !!");
                log.exiting(this.CLASS_NAME, "init()");
                throw new UWCException("ldapdomainmap is  null");
            }
        } else {
            this.amadmindn = this.uwcauth.get(CONFIG_BINDDN, null);
            this.amadmincred = this.uwcauth.get(CONFIG_BINDCRED, null);
            if (null == this.amadmindn || null == this.amadmincred) {
                throw new UWCException("amadmin information is  null");
            }
            try {
                this.manager = SSOTokenManager.getInstance();
            }
            catch (SSOException sSOException) {
                log.severe("SSOException.." + sSOException.getMessage());
                throw new UWCException(sSOException.getMessage());
            }
        }
        log.exiting(this.CLASS_NAME, "init()");
    }

    public String getAttributeValue(String string, String string2) throws UWCException {
        log.entering(this.CLASS_NAME, "getAttributeValue()");
        String string3 = null;
        if (!this.isISEnabled) {
            Domain domain = this.loadDomainFromLDAP(string);
            if (null == domain) {
                log.finest("DomaiObj is NULL !!");
                return null;
            }
            string3 = domain.getAttribute(string2);
            log.finest("Value for Attribute" + string2 + " is " + string3);
        } else {
            AMOrganization aMOrganization = this.loadDomainFromIS(string);
            if (null == aMOrganization) {
                return null;
            }
            try {
                string3 = aMOrganization.getStringAttribute(string2);
            }
            catch (AMException aMException) {
                log.warning("AMException.." + aMException.getMessage());
                return null;
            }
            catch (SSOException sSOException) {
                log.severe("SSOException.." + sSOException.getMessage());
                return null;
            }
            catch (Exception exception) {
                log.warning("Exception.." + exception.getMessage());
                return null;
            }
        }
        log.exiting(this.CLASS_NAME, "getAttributeValue()");
        return string3;
    }

    public boolean loadDomain(String string) throws UWCException {
        if (null == string) {
            throw new UWCException("domain is null");
        }
        return !(!this.isISEnabled ? this.loadDomainFromLDAP(string) == null : this.loadDomainFromIS(string) == null);
    }

    private Domain loadDomainFromLDAP(String string) throws UWCException {
        Domain domain = this.ldapDomainMap.getDomainObject(string, true);
        return domain;
    }

    public AMOrganization loadDomainFromIS(String string) throws UWCException {
        AMOrganization aMOrganization = null;
        try {
            aMOrganization = (AMOrganization)this.domainmap.get(string);
            if (null == aMOrganization) {
                UWCDomainManagerPrincipal uWCDomainManagerPrincipal = (UWCDomainManagerPrincipal)this.getAdminPrincipal();
                SSOToken sSOToken = this.manager.createSSOToken((Principal)uWCDomainManagerPrincipal, this.amadmincred);
                AMStoreConnection aMStoreConnection = new AMStoreConnection(sSOToken);
                String string2 = aMStoreConnection.getOrganizationDN(string, null);
                if (null == string2) {
                    throw new UWCException("orgDN  is  null");
                }
                aMOrganization = aMStoreConnection.getOrganization(string2);
                if (null == aMOrganization) {
                    return null;
                }
                this.domainmap.put(aMOrganization, string);
            }
        }
        catch (AMException aMException) {
            log.warning("AMException.." + aMException.getMessage());
            return null;
        }
        catch (SSOException sSOException) {
            log.severe("SSOException.." + sSOException.getMessage());
            return null;
        }
        catch (Exception exception) {
            log.warning("Exception.." + exception.getMessage());
            return null;
        }
        return aMOrganization;
    }

    public Principal getAdminPrincipal() {
        UWCDomainManagerPrincipal uWCDomainManagerPrincipal = new UWCDomainManagerPrincipal(this.amadmindn);
        return uWCDomainManagerPrincipal;
    }

    static class UWCDomainManagerPrincipal
    implements Principal {
        String name;

        UWCDomainManagerPrincipal(String string) {
            this.name = string;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            return object.toString().equals(this.name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }
    }
}

