/*
 * Decompiled with CFR 0.152.
 */
package com.sun.uwc.common.model;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.RequestManager;
import com.iplanet.jato.RequestParticipant;
import com.iplanet.jato.model.SessionModel;
import com.sun.uwc.common.UWCApplicationHelper;
import com.sun.uwc.common.UWCException;
import com.sun.uwc.common.UWCUserHelper;
import com.sun.uwc.common.ldap.LDAPPool;
import com.sun.uwc.common.ldap.LDAPUtil;
import com.sun.uwc.common.util.UWCLogger;
import com.sun.uwc.common.util.UWCPreferences;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.PatternSyntaxException;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPModificationSet;

public class UserPreferencesModel
extends SessionModel
implements RequestParticipant {
    protected static Logger _prefsLogger = null;
    public static final String USER_PREFS_CLASS_NAME = "UserPreferencesModel";
    public static final String UC_PREFERENCES_OC = "sunUCPreferences";
    public static final String UC_DEFAULT_APPLICATION_ATTR = "sunUCDefaultApplication";
    public static final String UC_THEME_ATTR = "sunUCTheme";
    public static final String UC_COLOR_SCHEME_ATTR = "sunUCColorScheme";
    public static final String UC_DEFAULT_MAIL_HANDLER_ATTR = "sunUCDefaultEmailHandler";
    public static final String UC_DATE_FORMAT_ATTR = "sunUCDateFormat";
    public static final String UC_DATE_DELIMITER_ATTR = "sunUCDateDelimiter";
    public static final String UC_TIME_FORMAT_ATTR = "sunUCTimeFormat";
    public static final String UC_TIME_ZONE_ATTR = "sunUCTimeZone";
    public static final String UC_PREFERRED_LANGUAGE_ATTR = "preferredLanguage";
    public static final String UC_PREFERRED_LOCALE_ATTR = "preferredLocale";
    public static final String UC_EXTENDED_USER_PREFS_ATTR = "sunUCExtendedUserPrefs";
    public static final String UC_INITIALIZED = "sunUCInitialized";
    protected static final String MULTI_VAL_ATTR_DELIMITER = "!!!INTERNAL_DELIMITER!!!";
    private String _DN = null;
    private LDAPPool _ldPool = null;
    private Hashtable _commonPrefs = new Hashtable();
    protected RequestContext _reqCtx = null;
    private static String[] _commonUserPrefAttrsTable;
    private static String[] _commonUserPrefsMultiValAttrsTable;
    private static String[][] _commonUserPrefsMultiValAttrValsTable;
    protected Hashtable changedAttrsCache = null;
    protected LDAPModificationSet modSet = null;
    protected boolean _isAnonymous = false;
    private String DEFAULT_ATTR_PREFIX = "uwc-user-attr-";
    private static final String[] ZERO_STRING_ARRAY;

    public UserPreferencesModel() throws UWCException {
        this(RequestManager.getRequestContext());
        _prefsLogger.entering(USER_PREFS_CLASS_NAME, "UserPrefrencesModel()");
        _prefsLogger.exiting(USER_PREFS_CLASS_NAME, "UserPrefrencesModel()");
    }

    public UserPreferencesModel(RequestContext requestContext) throws UWCException {
        super(requestContext.getRequest().getSession());
        this.setAllowSettingEquivalentValue(true);
        _prefsLogger.entering(USER_PREFS_CLASS_NAME, "UserPrefrencesModel(RequestContext)");
        this._isAnonymous = UWCUserHelper.isAnonymous(this._reqCtx);
        if (!this._isAnonymous) {
            this._DN = UWCUserHelper.getUserDN(this._reqCtx);
        }
        _prefsLogger.exiting(USER_PREFS_CLASS_NAME, "UserPrefrencesModel(RequestContext)");
    }

    protected String getUserDN() {
        _prefsLogger.entering(USER_PREFS_CLASS_NAME, "getUserDN()");
        _prefsLogger.exiting(USER_PREFS_CLASS_NAME, "getUserDN()");
        return this._DN;
    }

    protected void setUserDN(String string) {
        _prefsLogger.entering(USER_PREFS_CLASS_NAME, "setUserDN()");
        _prefsLogger.exiting(USER_PREFS_CLASS_NAME, "setUserDN()");
        this._DN = string;
    }

    protected LDAPConnection getLdapConnection() throws LDAPException {
        _prefsLogger.entering(USER_PREFS_CLASS_NAME, "getLdapConnection()");
        if (this._ldPool == null) {
            this._ldPool = UWCApplicationHelper.getLDAPPool();
            if (this._ldPool == null) {
                if (_prefsLogger.isLoggable(Level.WARNING)) {
                    _prefsLogger.warning("No valid LDAP pool!");
                }
                _prefsLogger.exiting(USER_PREFS_CLASS_NAME, "getLdapConnection()");
                return null;
            }
        }
        LDAPConnection lDAPConnection = null;
        lDAPConnection = this._ldPool.getConnection();
        _prefsLogger.exiting(USER_PREFS_CLASS_NAME, "getLdapConnection()");
        return lDAPConnection;
    }

    protected void releaseLdapConnection(LDAPConnection lDAPConnection) {
        _prefsLogger.entering(USER_PREFS_CLASS_NAME, "releaseLdapConnection()");
        if (this._ldPool == null) {
            _prefsLogger.exiting(USER_PREFS_CLASS_NAME, "releaseLdapConnection()");
            return;
        }
        if (lDAPConnection != null) {
            this._ldPool.close(lDAPConnection);
        }
        _prefsLogger.exiting(USER_PREFS_CLASS_NAME, "releaseLdapConnection()");
    }

    public void initializeCommonPreferences() throws UWCException {
        this._commonPrefs = new Hashtable();
        _prefsLogger.entering(USER_PREFS_CLASS_NAME, "initializeCommonPreferences()");
        if (this._isAnonymous) {
            if (_prefsLogger.isLoggable(Level.FINE)) {
                _prefsLogger.fine("Anonymous Access");
            }
            this._commonPrefs = this.initializeForAnonAccess(_commonUserPrefAttrsTable, _commonUserPrefsMultiValAttrsTable, _commonUserPrefsMultiValAttrValsTable, this._commonPrefs);
        } else {
            if (_prefsLogger.isLoggable(Level.FINE)) {
                _prefsLogger.fine("Not an Anonymous Access");
            }
            this._commonPrefs = this.initializeForAuthUser();
        }
        this.setAttrValuesInSession(this._commonPrefs, _commonUserPrefAttrsTable, _commonUserPrefsMultiValAttrsTable, _commonUserPrefsMultiValAttrValsTable);
        _prefsLogger.exiting(USER_PREFS_CLASS_NAME, "UserPrefrencesModel()");
    }

    protected Hashtable initializeForAnonAccess(String[] stringArray, String[] stringArray2, String[][] stringArray3, Hashtable hashtable) throws UWCException {
        _prefsLogger.entering(USER_PREFS_CLASS_NAME, "initializeForAnonAccess()");
        String[] stringArray4 = null;
        String string = null;
        String string2 = null;
        String string3 = null;
        Object var9_9 = null;
        UWCPreferences uWCPreferences = null;
        int n = -1;
        try {
            uWCPreferences = UWCUserHelper.getDomainPreferences(this._reqCtx);
        }
        catch (UWCException uWCException) {
            if (_prefsLogger.isLoggable(Level.WARNING)) {
                _prefsLogger.warning("Failed to obtain domain Configuration!");
            }
            throw uWCException;
        }
        if (uWCPreferences == null) {
            if (_prefsLogger.isLoggable(Level.WARNING)) {
                _prefsLogger.warning("Domain Configuration could not be obtained");
            }
            throw new UWCException("Domain Configuration could not be obtained");
        }
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray4 = null;
            string = null;
            string2 = null;
            string3 = null;
            n = -1;
            if (_prefsLogger.isLoggable(Level.FINE)) {
                _prefsLogger.fine("AttrName: " + stringArray[i]);
            }
            if ((n = this.getMultiValAttrIndex(stringArray[i], stringArray2)) > -1) {
                if (_prefsLogger.isLoggable(Level.FINE)) {
                    _prefsLogger.fine("AttrName: " + stringArray[i] + " is Multi-valued");
                }
                for (int j = 0; j < stringArray3[n].length; ++j) {
                    string2 = null;
                    string = null;
                    string3 = null;
                    stringArray4 = null;
                    string3 = stringArray3[n][j].trim().equals("") ? stringArray[i] : stringArray[i] + "-" + stringArray3[n][j];
                    string2 = uWCPreferences.get(this.DEFAULT_ATTR_PREFIX + string3, null);
                    string = stringArray3[n][j].trim().equals("") ? string2 : stringArray3[n][j] + "=" + string2;
                    if (string2 != null && string != null && string.length() > 0) {
                        stringArray4 = new String[]{string};
                    }
                    if (stringArray4 == null) continue;
                    hashtable = this.setAttrValueInCache(hashtable, stringArray[i], stringArray4);
                }
                continue;
            }
            stringArray4 = null;
            string2 = null;
            string2 = uWCPreferences.get(this.DEFAULT_ATTR_PREFIX + stringArray[i], null);
            if (_prefsLogger.isLoggable(Level.INFO)) {
                _prefsLogger.info("Value in domain config for attr: " + stringArray[i] + " : " + string2);
            }
            if (string2 != null && string2.length() > 0) {
                stringArray4 = new String[]{string2};
            }
            if (stringArray4 == null) continue;
            hashtable = this.setAttrValueInCache(hashtable, stringArray[i], stringArray4);
        }
        _prefsLogger.exiting(USER_PREFS_CLASS_NAME, "initializeForAnonAccess()");
        return hashtable;
    }

    protected Hashtable initializeForAuthUser() throws UWCException {
        String string;
        _prefsLogger.entering(USER_PREFS_CLASS_NAME, "initializeForAuthUser()");
        LDAPUtil lDAPUtil = null;
        boolean bl = false;
        boolean bl2 = false;
        Hashtable hashtable = new Hashtable();
        try {
            lDAPUtil = this.getLDAPUtilObj();
        }
        catch (UWCException uWCException) {
            if (_prefsLogger.isLoggable(Level.WARNING)) {
                _prefsLogger.warning("Couldnot obtain LDAPUtil obj");
            }
            throw uWCException;
        }
        try {
            lDAPUtil.loadValues();
        }
        catch (LDAPException lDAPException) {
            if (_prefsLogger.isLoggable(Level.WARNING)) {
                _prefsLogger.warning("Couldnot Load entry for DN: " + this._DN);
            }
            this.releaseLdapConnection(lDAPUtil.getLDAPConnection());
            throw new UWCException(lDAPException.getMessage());
        }
        if (_prefsLogger.isLoggable(Level.FINE)) {
            _prefsLogger.fine("Checking ObjectClass: sunUCPreferences for DN: " + this._DN);
        }
        if (!this.isAttrValuePresent(lDAPUtil, "ObjectClass", UC_PREFERENCES_OC)) {
            if (_prefsLogger.isLoggable(Level.INFO)) {
                _prefsLogger.info("UC preferences OC: sunUCPreferences is not present");
            }
            try {
                lDAPUtil.modifyAttribute(0, "ObjectClass", UC_PREFERENCES_OC);
            }
            catch (LDAPException lDAPException) {
                if (_prefsLogger.isLoggable(Level.WARNING)) {
                    _prefsLogger.warning("Couldnot create ObjectClass: sunUCPreferences for DN: " + this._DN);
                }
                this.releaseLdapConnection(lDAPUtil.getLDAPConnection());
                throw new UWCException(lDAPException.getMessage());
            }
        } else if (_prefsLogger.isLoggable(Level.INFO)) {
            _prefsLogger.info("ObjectClass: sunUCPreferences for DN: " + this._DN + " is present");
        }
        String string2 = "sunUCInitialized=true";
        if (lDAPUtil.isValuePresentIgnoreCase(UC_EXTENDED_USER_PREFS_ATTR, string2)) {
            if (_prefsLogger.isLoggable(Level.INFO)) {
                _prefsLogger.info("UC Prefs Initialized : sunUCInitialized is present and value is true");
            }
            bl = true;
            bl2 = true;
        }
        if (lDAPUtil.isValuePresentIgnoreCase(UC_EXTENDED_USER_PREFS_ATTR, string = "sunUCInitialized=false")) {
            if (_prefsLogger.isLoggable(Level.INFO)) {
                _prefsLogger.info("UC Prefs Initialized : sunUCInitialized is present and value is false");
            }
            bl = true;
            bl2 = false;
        }
        try {
            hashtable = this.initializeAndObtainPrefs(lDAPUtil, _commonUserPrefAttrsTable, _commonUserPrefsMultiValAttrsTable, _commonUserPrefsMultiValAttrValsTable, hashtable, !bl2);
        }
        catch (UWCException uWCException) {
            if (_prefsLogger.isLoggable(Level.WARNING)) {
                _prefsLogger.warning("UC Prefs Initialization Failed!");
            }
            this.releaseLdapConnection(lDAPUtil.getLDAPConnection());
            throw uWCException;
        }
        if (!bl2) {
            if (bl) {
                LDAPModificationSet lDAPModificationSet = null;
                lDAPModificationSet = this.constructModificationSet(lDAPModificationSet, 1, UC_EXTENDED_USER_PREFS_ATTR, new String[]{string});
                lDAPModificationSet = this.constructModificationSet(lDAPModificationSet, 0, UC_EXTENDED_USER_PREFS_ATTR, new String[]{string2});
                try {
                    this.modifyMultipleAttributes(lDAPModificationSet);
                }
                catch (LDAPException lDAPException) {
                    if (_prefsLogger.isLoggable(Level.WARNING)) {
                        _prefsLogger.warning("Unable to modify attr: sunUCExtendedUserPrefs:sunUCInitialized");
                    }
                    throw new UWCException(lDAPException.getMessage());
                }
            }
            try {
                if (_prefsLogger.isLoggable(Level.INFO)) {
                    _prefsLogger.info("Attr: sunUCExtendedUserPrefs:sunUCInitialized was not present. So, adding it to DN: " + this._DN);
                }
                lDAPUtil.modifyAttribute(0, UC_EXTENDED_USER_PREFS_ATTR, "sunUCInitialized=true");
            }
            catch (LDAPException lDAPException) {
                if (_prefsLogger.isLoggable(Level.WARNING)) {
                    _prefsLogger.warning("Unable to add attr: sunUCInitialized to true in " + this._DN);
                }
                this.releaseLdapConnection(lDAPUtil.getLDAPConnection());
                throw new UWCException(lDAPException.getMessage());
            }
        }
        this.releaseLdapConnection(lDAPUtil.getLDAPConnection());
        _prefsLogger.exiting(USER_PREFS_CLASS_NAME, "initializeForAuthUser()");
        return hashtable;
    }

    protected Hashtable initializeAndObtainPrefs(LDAPUtil lDAPUtil, String[] stringArray, String[] stringArray2, String[][] stringArray3, Hashtable hashtable, boolean bl) throws UWCException {
        _prefsLogger.entering(USER_PREFS_CLASS_NAME, "initializeAndObtainPrefs()");
        String[] stringArray4 = null;
        String string = null;
        String string2 = null;
        String string3 = null;
        LDAPModificationSet lDAPModificationSet = null;
        int n = -1;
        UWCPreferences uWCPreferences = UWCUserHelper.getDomainPreferences(this._reqCtx);
        if (uWCPreferences == null) {
            if (_prefsLogger.isLoggable(Level.WARNING)) {
                _prefsLogger.warning("Domain Configuration could not be obtained");
            }
            throw new UWCException("Domain Configuration could not be obtained");
        }
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray4 = null;
            string = null;
            string2 = null;
            string3 = null;
            n = -1;
            if (_prefsLogger.isLoggable(Level.FINE)) {
                _prefsLogger.fine("AttrName: " + stringArray[i]);
            }
            if ((n = this.getMultiValAttrIndex(stringArray[i], stringArray2)) > -1) {
                if (_prefsLogger.isLoggable(Level.FINE)) {
                    _prefsLogger.fine("AttrName: " + stringArray[i] + " is Multi-valued");
                }
                for (int j = 0; j < stringArray3[n].length; ++j) {
                    string2 = null;
                    string = null;
                    string3 = null;
                    stringArray4 = null;
                    if (!this.isAttrValuePresent(lDAPUtil, stringArray[i], stringArray3[n][j])) {
                        if (_prefsLogger.isLoggable(Level.INFO)) {
                            _prefsLogger.info("UC multi-val Attribute : " + stringArray[i] + ": " + stringArray3[n][j] + " is not obtained");
                        }
                        if (bl) {
                            string3 = stringArray3[n][j].trim().equals("") ? stringArray[i] : stringArray[i] + "-" + stringArray3[n][j];
                            string2 = uWCPreferences.get(this.DEFAULT_ATTR_PREFIX + string3, null);
                            string = stringArray3[n][j].trim().equals("") ? string2 : stringArray3[n][j] + "=" + string2;
                            if (string2 != null && string != null && string.length() > 0) {
                                if (_prefsLogger.isLoggable(Level.INFO)) {
                                    _prefsLogger.info("Adding attr: " + stringArray[i] + ":" + string + " to Modification Set");
                                }
                                lDAPModificationSet = this.constructModificationSet(lDAPModificationSet, 0, stringArray[i], new String[]{string});
                                stringArray4 = new String[]{string};
                            }
                        }
                    } else {
                        if (_prefsLogger.isLoggable(Level.FINE)) {
                            _prefsLogger.fine("The Multi-val attribute: " + stringArray[i] + ":" + stringArray3[n][j] + " is already Obtained");
                        }
                        string2 = null;
                        string = null;
                        if (stringArray3[n][j].trim().equals("")) {
                            if (_prefsLogger.isLoggable(Level.FINE)) {
                                _prefsLogger.fine("Multi-value attribute " + stringArray[i] + " doesnot have sub-type");
                            }
                            stringArray4 = this.getMultiValAttrVal(lDAPUtil, stringArray[i], " ");
                            if (_prefsLogger.isLoggable(Level.INFO)) {
                                _prefsLogger.info("Value from LDAP for: " + stringArray[i] + " is: ");
                            }
                        } else {
                            stringArray4 = this.getMultiValAttrVal(lDAPUtil, stringArray[i], stringArray3[n][j]);
                            if (_prefsLogger.isLoggable(Level.INFO)) {
                                _prefsLogger.info("Value from LDAP for: " + stringArray[i] + ":" + stringArray3[n][j] + " is " + stringArray4[0]);
                            }
                            if (stringArray4 != null) {
                                // empty if block
                            }
                        }
                    }
                    if (stringArray4 == null) continue;
                    hashtable = this.setAttrValueInCache(hashtable, stringArray[i], stringArray4);
                }
                continue;
            }
            stringArray4 = null;
            string2 = null;
            if (!this.isAttrValuePresent(lDAPUtil, stringArray[i], null)) {
                if (_prefsLogger.isLoggable(Level.FINE)) {
                    _prefsLogger.fine("UC preference Attribute : " + stringArray[i] + " is not present");
                }
                if (bl) {
                    string2 = uWCPreferences.get(this.DEFAULT_ATTR_PREFIX + stringArray[i], null);
                    if (_prefsLogger.isLoggable(Level.INFO)) {
                        _prefsLogger.info("Value in domain config for attr: " + stringArray[i] + " : " + string2);
                    }
                    if (string2 != null && string2.length() > 0) {
                        if (_prefsLogger.isLoggable(Level.INFO)) {
                            _prefsLogger.info("Adding attr: " + stringArray[i] + ":" + string2 + " to Modification Set");
                        }
                        lDAPModificationSet = this.constructModificationSet(lDAPModificationSet, 0, stringArray[i], new String[]{string2});
                        stringArray4 = new String[]{string2};
                    }
                }
            } else {
                stringArray4 = new String[1];
                try {
                    if (_prefsLogger.isLoggable(Level.FINE)) {
                        _prefsLogger.fine("Already Existing Attr " + stringArray[i]);
                    }
                    stringArray4[0] = lDAPUtil.getValue(stringArray[i]);
                }
                catch (LDAPException lDAPException) {
                    if (_prefsLogger.isLoggable(Level.WARNING)) {
                        _prefsLogger.warning("Could not read attr value: " + lDAPException.getMessage());
                    }
                    stringArray4 = null;
                }
            }
            if (stringArray4 == null) continue;
            hashtable = this.setAttrValueInCache(hashtable, stringArray[i], stringArray4);
        }
        if (lDAPModificationSet != null) {
            try {
                this.modifyMultipleAttributes(lDAPModificationSet);
            }
            catch (LDAPException lDAPException) {
                if (_prefsLogger.isLoggable(Level.WARNING)) {
                    _prefsLogger.warning("Unable to attrs in the Modification Set ");
                }
                throw new UWCException(lDAPException.getMessage());
            }
        }
        _prefsLogger.exiting(USER_PREFS_CLASS_NAME, "initializeAndObtainPrefs()");
        return hashtable;
    }

    public void updateCommonUserPrefs() throws UWCException {
        if (this._isAnonymous) {
            if (_prefsLogger.isLoggable(Level.WARNING)) {
                _prefsLogger.warning("Preferences Cannot be updated for Anonymous access");
            }
            throw new UWCException("Preferences Cannot be updated for Anonymous access!");
        }
        this.updatePreferences(_commonUserPrefAttrsTable, _commonUserPrefsMultiValAttrsTable, _commonUserPrefsMultiValAttrValsTable);
    }

    protected boolean isAttrValuePresent(LDAPUtil lDAPUtil, String string, String string2) {
        _prefsLogger.entering(USER_PREFS_CLASS_NAME, "isAttrValuePresent()");
        String[] stringArray = null;
        if (lDAPUtil == null) {
            if (_prefsLogger.isLoggable(Level.WARNING)) {
                _prefsLogger.warning("LDAPUtil not present");
            }
            _prefsLogger.exiting(USER_PREFS_CLASS_NAME, "isAttrValuePresent()");
            return false;
        }
        try {
            stringArray = lDAPUtil.getValues(string);
        }
        catch (LDAPException lDAPException) {
            if (_prefsLogger.isLoggable(Level.WARNING)) {
                _prefsLogger.warning("Could not read LDAP value from LDAPUtil for: " + string + lDAPException.getMessage());
            }
            stringArray = null;
        }
        if (stringArray == null) {
            if (_prefsLogger.isLoggable(Level.FINE)) {
                _prefsLogger.fine("No LDAP Values for: " + string);
            }
            _prefsLogger.exiting(USER_PREFS_CLASS_NAME, "isAttrValuePresent()");
            return false;
        }
        if (string2 != null && string2.trim().equals("")) {
            if (_prefsLogger.isLoggable(Level.FINE)) {
                _prefsLogger.fine("Attr Value is empty");
            }
            _prefsLogger.exiting(USER_PREFS_CLASS_NAME, "isAttrValuePresent()");
            return true;
        }
        if (string2 == null) {
            if (_prefsLogger.isLoggable(Level.FINE)) {
                _prefsLogger.fine("Attr Value is null");
            }
            return stringArray != null;
        }
        if (string2 != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].toLowerCase().startsWith(string2.toLowerCase())) continue;
                if (_prefsLogger.isLoggable(Level.FINE)) {
                    _prefsLogger.fine("LDAP Value for: " + string + "present");
                }
                _prefsLogger.exiting(USER_PREFS_CLASS_NAME, "isAttrValuePresent()");
                return true;
            }
        }
        _prefsLogger.exiting(USER_PREFS_CLASS_NAME, "isAttrValuePresent()");
        return false;
    }

    private String[] getMultiValAttrVal(LDAPUtil lDAPUtil, String string, String string2) {
        _prefsLogger.entering(USER_PREFS_CLASS_NAME, "getMultiValAttrVal()");
        String[] stringArray = null;
        if (lDAPUtil == null) {
            _prefsLogger.exiting(USER_PREFS_CLASS_NAME, "getMultiValAttrVal()");
            return null;
        }
        try {
            stringArray = lDAPUtil.getValues(string);
        }
        catch (LDAPException lDAPException) {
            if (_prefsLogger.isLoggable(Level.WARNING)) {
                _prefsLogger.warning("Failed to get attribute values from LDAP Util ");
            }
            stringArray = null;
        }
        if (stringArray == null) {
            if (_prefsLogger.isLoggable(Level.FINE)) {
                _prefsLogger.fine("No Values Present for this attr: " + string);
            }
            _prefsLogger.exiting(USER_PREFS_CLASS_NAME, "getMultiValAttrVal()");
            return null;
        }
        if (string2 == null || string2.trim().equals("")) {
            if (_prefsLogger.isLoggable(Level.FINE)) {
                _prefsLogger.fine("No Sub-type passed for this attr");
            }
            _prefsLogger.exiting(USER_PREFS_CLASS_NAME, "getMultiValAttrVal()");
            return stringArray;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].toLowerCase().startsWith(string2.toLowerCase())) continue;
            String[] stringArray2 = new String[]{stringArray[i]};
            if (_prefsLogger.isLoggable(Level.FINE)) {
                _prefsLogger.fine("Found Value for this attr: " + string + ":" + string2);
            }
            _prefsLogger.exiting(USER_PREFS_CLASS_NAME, "getMultiValAttrVal()");
            return stringArray2;
        }
        _prefsLogger.exiting(USER_PREFS_CLASS_NAME, "getMultiValAttrVal()");
        return null;
    }

    protected int getMultiValAttrIndex(String string, String[] stringArray) {
        _prefsLogger.entering(USER_PREFS_CLASS_NAME, "getMultiValAttrIndex()");
        int n = -1;
        if (stringArray == null) {
            _prefsLogger.exiting(USER_PREFS_CLASS_NAME, "getMultiValAttrIndex()");
            return n;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equalsIgnoreCase(string)) continue;
            n = i;
        }
        _prefsLogger.exiting(USER_PREFS_CLASS_NAME, "getMultiValAttrIndex()");
        return n;
    }

    protected int getMultiValAttrSubTypeIndex(String string, String[][] stringArray) {
        int n = -1;
        if (stringArray != null && stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                n = -1;
                for (int j = 0; j < stringArray[i].length; ++j) {
                    n = this.getMultiValAttrIndex(string, stringArray[i]);
                    if (n <= -1) continue;
                    return i;
                }
            }
        }
        return n;
    }

    private Hashtable setAttrValueInCache(Hashtable hashtable, String string, String[] stringArray) {
        _prefsLogger.entering(USER_PREFS_CLASS_NAME, "setAttrValueInCache()");
        String[] stringArray2 = null;
        String[] stringArray3 = null;
        if (hashtable == null) {
            hashtable = new Hashtable<String, String[]>();
        }
        if (string == null) {
            _prefsLogger.exiting(USER_PREFS_CLASS_NAME, "setAttrValueInCache()");
            return hashtable;
        }
        if (stringArray == null && string != null) {
            if (hashtable.containsKey(string)) {
                if (_prefsLogger.isLoggable(Level.FINE)) {
                    _prefsLogger.fine("Attr : " + string + " already in cache - removing it ");
                }
                hashtable.remove(string);
            }
            _prefsLogger.exiting(USER_PREFS_CLASS_NAME, "setAttrValueInCache()");
            return hashtable;
        }
        if (hashtable.containsKey(string)) {
            int n;
            if (_prefsLogger.isLoggable(Level.FINE)) {
                _prefsLogger.fine("Attr : " + string + " already in cache ");
            }
            stringArray2 = (String[])hashtable.get(string);
            stringArray3 = new String[stringArray2.length + stringArray.length];
            for (n = 0; n < stringArray2.length; ++n) {
                if (_prefsLogger.isLoggable(Level.FINE)) {
                    _prefsLogger.fine("Copying Old Value to New Value");
                }
                stringArray3[n] = stringArray2[n];
            }
            n = 0;
            int n2 = stringArray3.length;
            for (int i = stringArray2.length; i < n2; ++i) {
                stringArray3[i] = stringArray[n];
                ++n;
            }
            hashtable.put(string, stringArray3);
        } else {
            if (_prefsLogger.isLoggable(Level.FINE)) {
                _prefsLogger.fine("Attribute " + string + " is not present in cache. So, adding");
            }
            hashtable.put(string, stringArray);
        }
        _prefsLogger.exiting(USER_PREFS_CLASS_NAME, "setAttrValueInCache()");
        return hashtable;
    }

    protected void setAttrValuesInSession(Hashtable hashtable, String[] stringArray, String[] stringArray2, String[][] stringArray3) {
        _prefsLogger.entering(USER_PREFS_CLASS_NAME, "setAttrValuesInSession()");
        String[] stringArray4 = null;
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        if (hashtable != null && stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                int n = -1;
                if (!hashtable.containsKey(stringArray[i])) continue;
                stringArray4 = (String[])hashtable.get(stringArray[i]);
                n = this.getMultiValAttrIndex(stringArray[i], stringArray2);
                if (n > -1) {
                    if (stringArray3[n][0] != null && stringArray3[n][0].trim().equals("")) {
                        String string5 = new String("");
                        string4 = null;
                        if (_prefsLogger.isLoggable(Level.INFO)) {
                            _prefsLogger.info("Setting Multi-val attr without subtype: " + stringArray[i] + " in Session");
                        }
                        for (int j = 0; j < stringArray4.length; ++j) {
                            string5 = string5 + new String(stringArray4[j] + MULTI_VAL_ATTR_DELIMITER);
                        }
                        if (string5 != null && string5.length() > 0) {
                            string4 = new String(string5.substring(0, string5.length() - MULTI_VAL_ATTR_DELIMITER.length()));
                            if (_prefsLogger.isLoggable(Level.INFO)) {
                                _prefsLogger.info("Value to store in Session for: " + stringArray[i] + " is: " + string4);
                            }
                        }
                        super.setValue(stringArray[i], string4);
                        continue;
                    }
                    for (int j = 0; j < stringArray4.length; ++j) {
                        string = stringArray4[j];
                        StringTokenizer stringTokenizer = new StringTokenizer(string, "=", false);
                        if (stringTokenizer.hasMoreTokens()) {
                            string3 = stringTokenizer.nextToken();
                        }
                        string2 = new String();
                        if (stringTokenizer.hasMoreTokens()) {
                            string2 = stringTokenizer.nextToken();
                        }
                        for (int k = 0; k < stringArray3[n].length; ++k) {
                            if (stringArray3[n][k] == null || !string3.equalsIgnoreCase(stringArray3[n][k])) continue;
                            super.setValue(string3, (Object)string2);
                        }
                    }
                    continue;
                }
                if (_prefsLogger.isLoggable(Level.INFO)) {
                    _prefsLogger.info("Not Multi-val " + stringArray[i] + " value: " + stringArray4[0]);
                }
                super.setValue(stringArray[i], (Object)stringArray4[0]);
            }
        }
        _prefsLogger.exiting(USER_PREFS_CLASS_NAME, "setAttrValuesInSession()");
    }

    protected void setValueInSession(String string, Object object) {
        super.setValue(string, object);
    }

    public String getDefaultApplication() {
        _prefsLogger.entering(USER_PREFS_CLASS_NAME, "getDefaultApplication()");
        _prefsLogger.exiting(USER_PREFS_CLASS_NAME, "getDefaultApplication()");
        return (String)this.getValue(UC_DEFAULT_APPLICATION_ATTR);
    }

    public String getTheme() {
        _prefsLogger.entering(USER_PREFS_CLASS_NAME, "getTheme()");
        _prefsLogger.exiting(USER_PREFS_CLASS_NAME, "getTheme()");
        return (String)this.getValue(UC_THEME_ATTR);
    }

    public String getColorScheme() {
        _prefsLogger.entering(USER_PREFS_CLASS_NAME, "getColorScheme()");
        _prefsLogger.exiting(USER_PREFS_CLASS_NAME, "getColorScheme()");
        return (String)this.getValue(UC_COLOR_SCHEME_ATTR);
    }

    public String getDefaultMailHandler() {
        _prefsLogger.entering(USER_PREFS_CLASS_NAME, "getDefaultMailHandler()");
        _prefsLogger.exiting(USER_PREFS_CLASS_NAME, "getDefaultMailHandler()");
        return (String)this.getValue(UC_DEFAULT_MAIL_HANDLER_ATTR);
    }

    public String getDateFormat() {
        _prefsLogger.entering(USER_PREFS_CLASS_NAME, "getDateFormat()");
        _prefsLogger.exiting(USER_PREFS_CLASS_NAME, "getDateFormat()");
        return (String)this.getValue(UC_DATE_FORMAT_ATTR);
    }

    public String getDateDelimiter() {
        _prefsLogger.entering(USER_PREFS_CLASS_NAME, "getDateDelimiter()");
        _prefsLogger.exiting(USER_PREFS_CLASS_NAME, "getDateDelimiter()");
        return (String)this.getValue(UC_DATE_DELIMITER_ATTR);
    }

    public String getTimeFormat() {
        _prefsLogger.entering(USER_PREFS_CLASS_NAME, "getTimeFormat()");
        _prefsLogger.exiting(USER_PREFS_CLASS_NAME, "getTimeFormat()");
        return (String)this.getValue(UC_TIME_FORMAT_ATTR);
    }

    public String getTimeZone() {
        _prefsLogger.entering(USER_PREFS_CLASS_NAME, "getTimeZone()");
        _prefsLogger.exiting(USER_PREFS_CLASS_NAME, "getTimeZone()");
        return (String)this.getValue(UC_TIME_ZONE_ATTR);
    }

    public String getPreferredLanguage() {
        _prefsLogger.entering(USER_PREFS_CLASS_NAME, "getPreferredLanguage()");
        _prefsLogger.exiting(USER_PREFS_CLASS_NAME, "getPreferredLanguage()");
        return (String)this.getValue(UC_PREFERRED_LANGUAGE_ATTR);
    }

    public String getPreferredLocale() {
        _prefsLogger.entering(USER_PREFS_CLASS_NAME, "getPreferredLocale()");
        _prefsLogger.exiting(USER_PREFS_CLASS_NAME, "getPreferredLocale()");
        return (String)this.getValue(UC_PREFERRED_LOCALE_ATTR);
    }

    public void setDefaultApplication(String string) {
        _prefsLogger.entering(USER_PREFS_CLASS_NAME, "setDefaultApplication()");
        this.setValue(UC_DEFAULT_APPLICATION_ATTR, string);
        _prefsLogger.exiting(USER_PREFS_CLASS_NAME, "setDefaultApplication()");
    }

    public void setTheme(String string) {
        _prefsLogger.entering(USER_PREFS_CLASS_NAME, "setTheme()");
        this.setValue(UC_THEME_ATTR, string);
        _prefsLogger.exiting(USER_PREFS_CLASS_NAME, "setTheme()");
    }

    public void setColorScheme(String string) {
        _prefsLogger.entering(USER_PREFS_CLASS_NAME, "setColorScheme()");
        this.setValue(UC_COLOR_SCHEME_ATTR, string);
        _prefsLogger.exiting(USER_PREFS_CLASS_NAME, "colorSchemeValue()");
    }

    public void setDefaultMailHandler(String string) {
        _prefsLogger.entering(USER_PREFS_CLASS_NAME, "setDefaultMailHandler()");
        this.setValue(UC_DEFAULT_MAIL_HANDLER_ATTR, string);
        _prefsLogger.exiting(USER_PREFS_CLASS_NAME, "setDefaultMailHandler()");
    }

    public void setDateFormat(String string) {
        _prefsLogger.entering(USER_PREFS_CLASS_NAME, "setDateFormat()");
        this.setValue(USER_PREFS_CLASS_NAME, string);
        _prefsLogger.exiting(USER_PREFS_CLASS_NAME, "setDateFormat()");
    }

    public void setDateDelimiter(String string) {
        _prefsLogger.entering(USER_PREFS_CLASS_NAME, "setDateDelimiter()");
        this.setValue(UC_DATE_DELIMITER_ATTR, string);
        _prefsLogger.exiting(USER_PREFS_CLASS_NAME, "setDateDelimiter()");
    }

    public void setTimeFormat(String string) {
        _prefsLogger.entering(USER_PREFS_CLASS_NAME, "setTimeFormat()");
        this.setValue(UC_TIME_FORMAT_ATTR, string);
        _prefsLogger.exiting(USER_PREFS_CLASS_NAME, "setTimeFormat()");
    }

    public void setTimeZone(String string) {
        _prefsLogger.entering(USER_PREFS_CLASS_NAME, "setTimeZone()");
        this.setValue(UC_TIME_ZONE_ATTR, string);
        _prefsLogger.exiting(USER_PREFS_CLASS_NAME, "setTimeZone()");
    }

    public void setPreferredLanguage(String string) {
        _prefsLogger.entering(USER_PREFS_CLASS_NAME, "setPreferredLanguage()");
        this.setValue(UC_PREFERRED_LANGUAGE_ATTR, string);
        _prefsLogger.exiting(USER_PREFS_CLASS_NAME, "setPreferredLanguage()");
    }

    protected void modifyMultipleAttributes(LDAPModificationSet lDAPModificationSet) throws LDAPException {
        _prefsLogger.entering(USER_PREFS_CLASS_NAME, "modifyMultipleAttributes()");
        if (lDAPModificationSet == null) {
            return;
        }
        LDAPConnection lDAPConnection = null;
        try {
            lDAPConnection = this.getLdapConnection();
        }
        catch (LDAPException lDAPException) {
            if (_prefsLogger.isLoggable(Level.WARNING)) {
                _prefsLogger.warning("Unable to obtain LDAP Connection");
            }
            throw lDAPException;
        }
        if (lDAPConnection == null) {
            if (_prefsLogger.isLoggable(Level.WARNING)) {
                _prefsLogger.warning("Failed to obtain LDAP Connection");
            }
            throw new LDAPException("Unable to obtain LDAP Connection");
        }
        try {
            _prefsLogger.fine("ATTRIBUTESET undergoing change:" + lDAPModificationSet.toString());
            lDAPConnection.modify(this._DN, lDAPModificationSet);
        }
        catch (LDAPException lDAPException) {
            if (_prefsLogger.isLoggable(Level.WARNING)) {
                _prefsLogger.warning("Failed to Modify attrs in DN: " + this._DN + " " + lDAPException.getMessage());
            }
            throw lDAPException;
        }
        finally {
            this.releaseLdapConnection(lDAPConnection);
        }
        _prefsLogger.exiting(USER_PREFS_CLASS_NAME, "modifyMultipleAttributes()");
    }

    public void setValue(String string, Object object) {
        _prefsLogger.entering(USER_PREFS_CLASS_NAME, "setValue()");
        if (this.changedAttrsCache == null) {
            this.changedAttrsCache = new Hashtable();
        }
        if (string != null && string.length() > 0) {
            if (_prefsLogger.isLoggable(Level.FINE)) {
                _prefsLogger.fine("Adding in dirty Cache: " + string + ": " + object);
            }
            this.changedAttrsCache.put(string, object);
        }
        _prefsLogger.exiting(USER_PREFS_CLASS_NAME, "setValue()");
    }

    public void setValues(String string, Object[] objectArray) {
        if (objectArray != null && objectArray.length > 0) {
            this.setValue(string, objectArray[0]);
        } else {
            this.setValue(string, null);
        }
    }

    public Object getValue(String string) {
        _prefsLogger.entering(USER_PREFS_CLASS_NAME, "getValue()");
        Object object = null;
        if (string != null && string.length() > 0) {
            if (this.changedAttrsCache != null && this.changedAttrsCache.containsKey(string)) {
                if (_prefsLogger.isLoggable(Level.FINE)) {
                    _prefsLogger.fine("Info in cache, so returning that");
                }
                object = this.changedAttrsCache.get(string);
            } else {
                if (_prefsLogger.isLoggable(Level.FINE)) {
                    _prefsLogger.fine("Info not in cache, so returning from session");
                }
                object = super.getValue(string);
            }
        }
        _prefsLogger.exiting(USER_PREFS_CLASS_NAME, "getValue()");
        return object;
    }

    public Object[] getValues(String string) {
        Object[] objectArray = new Object[]{this.getValue(string)};
        return objectArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updatePreferences(String[] stringArray, String[] stringArray2, String[][] stringArray3) throws UWCException {
        _prefsLogger.entering(USER_PREFS_CLASS_NAME, "updatePreferences()");
        Object var4_4 = null;
        String string = null;
        String string2 = null;
        String string3 = null;
        int n = -1;
        this.modSet = null;
        if (this.changedAttrsCache != null && !this.changedAttrsCache.isEmpty() && stringArray != null && stringArray2 != null && stringArray3 != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                n = this.getMultiValAttrIndex(stringArray[i], stringArray2);
                if (n > -1) {
                    for (int j = 0; j < stringArray3[n].length; ++j) {
                        string2 = stringArray3[n][j];
                        string = null;
                        string3 = null;
                        if (string2.trim().equals("")) {
                            string2 = stringArray[i];
                        }
                        if (!this.changedAttrsCache.containsKey(string2)) continue;
                        string = (String)super.getValue(string2);
                        string3 = (String)this.changedAttrsCache.get(string2);
                        if (string != null) {
                            if (_prefsLogger.isLoggable(Level.INFO)) {
                                _prefsLogger.info("The Value in session for Multi-Val Attr: " + string2 + " is: " + string);
                            }
                            if (stringArray3[n][j].trim().equals("")) {
                                if (_prefsLogger.isLoggable(Level.FINE)) {
                                    _prefsLogger.fine("Constructing ModSet with DELETE for Multi-Val Attr: " + string2);
                                }
                                this.modSet = this.constructModificationSet(this.modSet, 1, stringArray[i], null);
                                if (_prefsLogger.isLoggable(Level.INFO)) {
                                    _prefsLogger.info("Constructed ModSet with DELETE for Multi-Val Attr: " + string2);
                                }
                            } else {
                                if (_prefsLogger.isLoggable(Level.FINE)) {
                                    _prefsLogger.fine("Constructing ModSet with DELETE for Multi-Val Attr: " + string2 + "=" + string);
                                }
                                this.modSet = this.constructModificationSet(this.modSet, 1, stringArray2[i], new String[]{string2 + "=" + string});
                            }
                        }
                        if (string3.equals("")) continue;
                        if (stringArray3[n][j].trim().equals("")) {
                            if (_prefsLogger.isLoggable(Level.INFO)) {
                                _prefsLogger.info("Adding to LDAP Set with op as ADD: " + stringArray[i] + ": " + string3);
                            }
                            this.modSet = this.constructModificationSet(this.modSet, 0, stringArray[i], this.convertDelimiterSeperatedString(string3, MULTI_VAL_ATTR_DELIMITER));
                            continue;
                        }
                        if (_prefsLogger.isLoggable(Level.INFO)) {
                            _prefsLogger.info("Adding to LDAP Set with op as ADD: " + stringArray2[i] + ": " + string2 + "=" + string3);
                        }
                        this.modSet = this.constructModificationSet(this.modSet, 0, stringArray2[i], new String[]{string2 + "=" + string3});
                    }
                    continue;
                }
                string = null;
                string3 = null;
                if (!this.changedAttrsCache.containsKey(stringArray[i])) continue;
                string = (String)super.getValue(stringArray[i]);
                string3 = (String)this.changedAttrsCache.get(stringArray[i]);
                if (string != null) {
                    if (string3 == null) {
                        this.modSet = this.constructModificationSet(this.modSet, 1, stringArray[i], null);
                        continue;
                    }
                    if (string3.trim().equals("")) {
                        this.modSet = this.constructModificationSet(this.modSet, 1, stringArray[i], null);
                        continue;
                    }
                    if (string.equals(string3)) continue;
                    this.modSet = this.constructModificationSet(this.modSet, 2, stringArray[i], new String[]{(String)this.changedAttrsCache.get(stringArray[i])});
                    continue;
                }
                if (string3 == null || string3.trim().length() <= 0) continue;
                this.modSet = this.constructModificationSet(this.modSet, 0, stringArray[i], new String[]{(String)this.changedAttrsCache.get(stringArray[i])});
            }
            Hashtable hashtable = this.changedAttrsCache;
            synchronized (hashtable) {
                try {
                    this.modifyMultipleAttributes(this.modSet);
                }
                catch (LDAPException lDAPException) {
                    throw new UWCException("Unable to modify the LDAP attrs in User's entry");
                }
                String string4 = null;
                String string5 = null;
                Enumeration enumeration = this.changedAttrsCache.keys();
                while (enumeration.hasMoreElements()) {
                    string4 = (String)enumeration.nextElement();
                    string5 = (String)this.changedAttrsCache.get(string4);
                    if (string5.length() > 0) {
                        super.setValue(string4, (Object)string5);
                        if (!_prefsLogger.isLoggable(Level.FINE)) continue;
                        _prefsLogger.fine("After setting in session: " + string4 + "=" + super.getValue(string4));
                        continue;
                    }
                    super.setValue(string4, null);
                }
                this.resetChangedAttributesCache();
            }
        }
        _prefsLogger.exiting(USER_PREFS_CLASS_NAME, "updatePreferences()");
    }

    protected LDAPModificationSet constructModificationSet(LDAPModificationSet lDAPModificationSet, int n, String string, String[] stringArray) {
        _prefsLogger.entering(USER_PREFS_CLASS_NAME, "constructModificationSet()");
        if (string == null) {
            return lDAPModificationSet;
        }
        if (lDAPModificationSet == null) {
            lDAPModificationSet = new LDAPModificationSet();
        }
        lDAPModificationSet.add(n, new LDAPAttribute(string, stringArray));
        _prefsLogger.exiting(USER_PREFS_CLASS_NAME, "constructModificationSet()");
        return lDAPModificationSet;
    }

    public void resetChangedAttributesCache() {
        this.changedAttrsCache = null;
    }

    protected String[] extendStringArray(String[] stringArray, String string) {
        String[] stringArray2 = null;
        if (stringArray == null) {
            stringArray2 = new String[]{string};
        } else {
            int n = stringArray.length + 1;
            stringArray2 = new String[n];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray2[i] = stringArray[i];
            }
            stringArray2[stringArray.length] = string;
        }
        return stringArray2;
    }

    protected LDAPUtil getLDAPUtilObj() throws UWCException {
        _prefsLogger.entering(USER_PREFS_CLASS_NAME, "getLDAPUtilObj()");
        LDAPConnection lDAPConnection = null;
        String string = null;
        LDAPUtil lDAPUtil = null;
        string = this.getUserDN();
        if (string == null) {
            string = UWCUserHelper.getUserDN(this._reqCtx);
            if (string == null) {
                if (_prefsLogger.isLoggable(Level.WARNING)) {
                    _prefsLogger.warning("Empty User DN");
                }
                throw new UWCException("User DN is empty!");
            }
            this.setUserDN(string);
        }
        try {
            lDAPConnection = this.getLdapConnection();
        }
        catch (LDAPException lDAPException) {
            if (_prefsLogger.isLoggable(Level.WARNING)) {
                _prefsLogger.warning("Unable to obtain LDAP Connection");
            }
            throw new UWCException(lDAPException.getMessage());
        }
        if (lDAPConnection == null) {
            if (_prefsLogger.isLoggable(Level.WARNING)) {
                _prefsLogger.warning("Timedout in obtaining LDAP Connection");
            }
            throw new UWCException("Could not obtain LDAP Connection object");
        }
        try {
            lDAPUtil = new LDAPUtil(lDAPConnection, string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (_prefsLogger.isLoggable(Level.WARNING)) {
                _prefsLogger.warning("Couldnot obtain LDAPUtil obj");
            }
            throw new UWCException(illegalArgumentException.getMessage());
        }
        _prefsLogger.exiting(USER_PREFS_CLASS_NAME, "getLDAPUtilObj()");
        return lDAPUtil;
    }

    public boolean getInitialized() {
        _prefsLogger.entering(USER_PREFS_CLASS_NAME, "getInitialized()");
        String string = (String)this.getValue(UC_INITIALIZED);
        if (string == null) {
            string = "false";
        }
        _prefsLogger.exiting(USER_PREFS_CLASS_NAME, "getInitialized()");
        return new Boolean(string);
    }

    public void setRequestContext(RequestContext requestContext) {
        _prefsLogger.entering(USER_PREFS_CLASS_NAME, "setRequestContext()");
        this._reqCtx = requestContext;
        _prefsLogger.exiting(USER_PREFS_CLASS_NAME, "setRequestContext()");
    }

    protected String[] convertDelimiterSeperatedString(String string, String string2) {
        _prefsLogger.entering(USER_PREFS_CLASS_NAME, "convertDelimiterSeperatedString()");
        String[] stringArray = null;
        if (string == null || string.length() <= 0) {
            return null;
        }
        if (string2 == null || string2.length() <= 0) {
            return new String[]{string};
        }
        try {
            stringArray = string.split(string2);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            if (_prefsLogger.isLoggable(Level.WARNING)) {
                _prefsLogger.warning("Exception: " + patternSyntaxException.getMessage());
            }
            return null;
        }
        catch (NullPointerException nullPointerException) {
            if (_prefsLogger.isLoggable(Level.WARNING)) {
                _prefsLogger.warning("Exception: " + nullPointerException.getMessage());
            }
            return null;
        }
        _prefsLogger.exiting(USER_PREFS_CLASS_NAME, "convertDelimiterSeperatedString()");
        return stringArray;
    }

    static {
        _prefsLogger = UWCLogger.getLogger("uwc.common.model");
        _commonUserPrefAttrsTable = new String[]{UC_DEFAULT_APPLICATION_ATTR, UC_THEME_ATTR, UC_COLOR_SCHEME_ATTR, UC_DEFAULT_MAIL_HANDLER_ATTR, UC_DATE_FORMAT_ATTR, UC_DATE_DELIMITER_ATTR, UC_TIME_FORMAT_ATTR, UC_TIME_ZONE_ATTR, UC_PREFERRED_LANGUAGE_ATTR, UC_PREFERRED_LOCALE_ATTR, UC_EXTENDED_USER_PREFS_ATTR};
        _commonUserPrefsMultiValAttrsTable = new String[]{UC_EXTENDED_USER_PREFS_ATTR};
        _commonUserPrefsMultiValAttrValsTable = new String[][]{{UC_INITIALIZED}};
        ZERO_STRING_ARRAY = new String[0];
    }
}

