/*
 * Decompiled with CFR 0.152.
 */
package com.sun.uwc.common.model;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.RequestParticipant;
import com.iplanet.jato.model.DefaultModel;
import com.sun.uwc.common.model.FilterConstants;
import com.sun.uwc.common.model.FilterRecord;
import com.sun.uwc.common.model.TimedFilter;
import com.sun.uwc.common.util.UWCLogger;
import com.sun.uwc.common.util.UWCUtils;
import java.io.BufferedReader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MailFilterModel
extends DefaultModel
implements RequestParticipant {
    protected static Logger _sieveLogger = null;
    private static final transient String CLASS_NAME = "MailFilterModel";
    private FilterRecord[] filterList = null;
    private boolean dirtyFlag = false;
    private boolean saveFlag = false;
    private String accSieveList = "";
    private String accOrder = "";
    private Vector advCond = null;
    private Vector advAct = null;
    private int curFilterIndex = 0;
    private int instCount = 0;
    private RequestContext _reqCtx = null;
    private HashMap filterStateMap;

    public MailFilterModel() {
    }

    public MailFilterModel(String string) {
        super(string);
    }

    private int _getCommentPosition(String string) {
        int n = 0;
        Pattern pattern = Pattern.compile("\"[^\"]*\"");
        Matcher matcher = pattern.matcher(string);
        int n2 = string.length();
        while (n < n2 && string.charAt(n) != '#') {
            if (matcher.find(n)) {
                n = matcher.end();
                continue;
            }
            ++n;
        }
        return n;
    }

    private String[] migrateSieve(BufferedReader bufferedReader) throws Exception {
        String string = "";
        Vector vector = new Vector();
        String string2 = "";
        String string3 = "";
        try {
            while ((string3 = bufferedReader.readLine()) != null && !string3.startsWith("#ENDFILTER")) {
                if (string3.length() == 0 || string3.startsWith("require")) continue;
                if (string3.equals("{")) {
                    string2 = string2 + "{ ";
                    continue;
                }
                if (string3.startsWith("reject")) {
                    string = string + "#" + string3 + "\n";
                    string3 = null;
                    while (true) {
                        if (string3 == null) {
                            string3 = bufferedReader.readLine();
                        }
                        string = string + "#" + string3 + "\n";
                        if (string3.equals(".")) {
                            string3 = bufferedReader.readLine();
                            if (string3.length() == 0) break;
                            string = string + "#" + string3 + "\n";
                            continue;
                        }
                        string3 = null;
                    }
                    string = string + "#\n";
                    string3 = bufferedReader.readLine();
                    string = string + "#" + string3 + "\n";
                    string2 = string2 + "discard ;";
                    continue;
                }
                int n = this._getCommentPosition(string3);
                if (n == 0) {
                    string = string + string3 + "\n";
                    continue;
                }
                String string4 = string3.substring(0, n);
                string2 = string2 + string4 + " ";
            }
        }
        catch (Exception exception) {
            if (_sieveLogger.isLoggable(Level.WARNING)) {
                _sieveLogger.warning("Exception while reading old-style sieve data:");
            }
            throw exception;
        }
        return new String[]{string2, string};
    }

    public void loadFilterList(String[] stringArray) throws IllegalArgumentException {
        _sieveLogger.entering(CLASS_NAME, "loadFilterList");
        String string = "";
        String string2 = "1";
        String string3 = "";
        String string4 = "";
        FilterRecord filterRecord = null;
        Vector<Object> vector = new Vector<Object>();
        boolean bl = false;
        Pattern pattern = Pattern.compile("[^\\$]*\\$Name=\"([^\"]+)\"\\s+\\$Order=(\\-?\\d+)\\s+\\$Type=\"([^\"]+)\"(\\s+\\$Mobile=(\\d+))?");
        try {
            String[] stringArray2 = stringArray;
            for (int i = 0; i < stringArray2.length; ++i) {
                Object object;
                String string5 = UWCUtils.unescape_crlf(stringArray2[i]);
                if (_sieveLogger.isLoggable(Level.FINE)) {
                    _sieveLogger.fine("Sieve found - " + string5);
                }
                boolean bl2 = false;
                boolean bl3 = false;
                String string6 = "";
                int n = -1;
                BufferedReader bufferedReader = new BufferedReader(new StringReader(string5));
                String string7 = "";
                String string8 = "";
                String[] stringArray3 = null;
                String string9 = bufferedReader.readLine();
                if ((string9 = string9.substring(1)).indexOf("$Template") != -1) {
                    bl = true;
                    if (_sieveLogger.isLoggable(Level.FINE)) {
                        _sieveLogger.fine("Found old-style sieve");
                    }
                    string9 = string9 + "  $Type=\"DEFAULT_TYPE\"";
                }
                Matcher matcher = pattern.matcher(string9);
                if (_sieveLogger.isLoggable(Level.FINE)) {
                    _sieveLogger.fine("To check nameordstr = " + string9);
                }
                if (matcher.find()) {
                    string = matcher.group(1);
                    string2 = matcher.group(2);
                    string4 = matcher.group(3);
                    object = matcher.group(5);
                    if (_sieveLogger.isLoggable(Level.FINE)) {
                        _sieveLogger.fine("name=" + string + ",ord=" + string2 + ",type=" + string4);
                    }
                    if (object != null) {
                        n = Integer.parseInt((String)object);
                    }
                    if (string4.startsWith("TIMED_")) {
                        bl3 = true;
                    }
                    bl2 = true;
                    if (bl) {
                        stringArray3 = this.migrateSieve(bufferedReader);
                        string6 = stringArray3[0];
                        if (_sieveLogger.isLoggable(Level.FINE)) {
                            _sieveLogger.fine("converted Sieve #" + i + " from migrateSieve:" + string6);
                            _sieveLogger.fine("extra comments from migrateSieve:" + stringArray3[1]);
                        }
                    }
                } else {
                    if (_sieveLogger.isLoggable(Level.FINE)) {
                        _sieveLogger.fine("Error matching first comment line syntax");
                    }
                    throw new IllegalArgumentException("Syntax Error");
                }
                if (!bl) {
                    while ((string3 = bufferedReader.readLine()) != null && !string3.startsWith("#BEGINFILTER")) {
                        int n2 = this._getCommentPosition(string3);
                        String string10 = string3.substring(0, n2);
                        if (string10.indexOf("\n") != -1 && _sieveLogger.isLoggable(Level.FINE)) {
                            _sieveLogger.fine("mfmodel:found newline in script var");
                        }
                        if (n2 >= string3.length() - 1) continue;
                        string8 = string3.substring(n2 + 1);
                        string7 = string7 + "#" + string8 + "\n";
                    }
                    if (string3 == null) {
                        if (_sieveLogger.isLoggable(Level.FINE)) {
                            _sieveLogger.fine("Error in filter:unexpected end reached. Sieve=" + string5);
                        }
                        throw new IllegalArgumentException("Syntax Error");
                    }
                    while ((string3 = bufferedReader.readLine()) != null && !string3.startsWith("#ENDFILTER")) {
                        string6 = string6 + string3 + " ";
                    }
                }
                if ((string6 = string6.trim()).matches(FilterConstants.filterRegex.getRegex())) {
                    filterRecord = new FilterRecord(string, string2, string4, string6, this._reqCtx);
                    filterRecord.setMobileIndex(n);
                    if (stringArray3 != null) {
                        string7 = string7 + stringArray3[1];
                    }
                    if (_sieveLogger.isLoggable(Level.FINE)) {
                        _sieveLogger.fine("Setting extra comments = " + string7);
                    }
                    filterRecord.setExtraComments(string7);
                    if (bl3) {
                        if (_sieveLogger.isLoggable(Level.FINE)) {
                            _sieveLogger.fine("Got a Timed sieve!fs = " + string6 + "name,ord,type=" + string + "," + string2 + "," + string4);
                        }
                        object = new TimedFilter(filterRecord, string5, this._reqCtx);
                        vector.addElement(object);
                        continue;
                    }
                    if (_sieveLogger.isLoggable(Level.FINE)) {
                        _sieveLogger.fine("Got a sieve!fs = " + string6 + "name,ord,type=" + string + "," + string2 + "," + string4);
                    }
                    vector.addElement(filterRecord);
                    continue;
                }
                if (_sieveLogger.isLoggable(Level.FINE)) {
                    _sieveLogger.fine("In model: " + string6 + " didn't match actual filter syntax");
                }
                throw new IllegalArgumentException("Syntax Error");
            }
        }
        catch (Exception exception) {
            if (_sieveLogger.isLoggable(Level.WARNING)) {
                _sieveLogger.warning("In model: exception while reading filter data:");
            }
            if (exception instanceof IllegalArgumentException) {
                throw (IllegalArgumentException)exception;
            }
            return;
        }
        this.filterList = new FilterRecord[vector.size()];
        this.filterList = vector.toArray(this.filterList);
        if (_sieveLogger.isLoggable(Level.FINE)) {
            _sieveLogger.fine("filterList size = " + this.filterList.length);
        }
        FilterRecord.sort(this.filterList);
        if (bl) {
            this.genAccSieve();
            this.setSaveFlag();
        }
    }

    public FilterRecord[] getFilterList() {
        return this.filterList;
    }

    public void addFilter(FilterRecord filterRecord) {
        if (this.filterList == null) {
            FilterRecord[] filterRecordArray = new FilterRecord[]{filterRecord};
            this.filterList = filterRecordArray;
            return;
        }
        FilterRecord[] filterRecordArray = new FilterRecord[this.filterList.length + 1];
        System.arraycopy(this.filterList, 0, filterRecordArray, 0, this.filterList.length);
        filterRecordArray[this.filterList.length] = filterRecord;
        this.filterList = filterRecordArray;
        FilterRecord.sort(this.filterList);
    }

    public void replaceFilter(int n, FilterRecord filterRecord) {
        this.filterList[n] = filterRecord;
    }

    public void deleteFilter(int n) {
        if (this.filterList.length == 1) {
            this.filterList = null;
            return;
        }
        String string = this.filterList[n].getName();
        FilterRecord[] filterRecordArray = new FilterRecord[this.filterList.length - 1];
        System.arraycopy(this.filterList, 0, filterRecordArray, 0, n);
        System.arraycopy(this.filterList, n + 1, filterRecordArray, n, this.filterList.length - n - 1);
        this.filterList = filterRecordArray;
        if (_sieveLogger.isLoggable(Level.FINE)) {
            _sieveLogger.fine("model:deleted filter " + string + ",new list size=" + this.filterList.length);
        }
    }

    public String getNextOrder() {
        int n;
        block7: {
            n = 0;
            if (_sieveLogger.isLoggable(Level.FINE)) {
                _sieveLogger.fine("inside getnxorder");
            }
            try {
                if (_sieveLogger.isLoggable(Level.FINE)) {
                    _sieveLogger.fine("getting the highest abs order");
                }
                if (this.filterList != null && this.filterList.length > 0) {
                    n = Math.abs(Integer.parseInt(this.filterList[this.filterList.length - 1].getOrder()));
                    if (_sieveLogger.isLoggable(Level.FINE)) {
                        _sieveLogger.fine("Order of Previous Sieve: " + n);
                    }
                }
            }
            catch (Exception exception) {
                if (!_sieveLogger.isLoggable(Level.WARNING)) break block7;
                _sieveLogger.warning("inside getnxorder");
            }
        }
        ++n;
        if (_sieveLogger.isLoggable(Level.FINE)) {
            _sieveLogger.fine("Next Order : " + n);
        }
        Integer n2 = new Integer(n);
        return n2.toString();
    }

    public void updateFilterOrder(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        int n = stringTokenizer.countTokens();
        if (_sieveLogger.isLoggable(Level.FINE)) {
            _sieveLogger.fine("in uford:accum. ord = " + string + ",count=" + n);
        }
        String[] stringArray = new String[n];
        if (this.filterList == null || this.filterList.length == 0) {
            return;
        }
        for (int i = 0; i < n; ++i) {
            stringArray[i] = stringTokenizer.nextToken();
            this.filterList[i].setOrder(stringArray[i]);
            if (!_sieveLogger.isLoggable(Level.FINE)) continue;
            _sieveLogger.fine("new tuple #" + i + ":fil=" + this.filterList[i].getName() + ", ord=" + this.filterList[i].getOrder());
        }
        FilterRecord.sort(this.filterList);
    }

    public void genAccSieve() {
        if (this.filterList == null || this.filterList.length == 0) {
            this.accSieveList = "";
            return;
        }
        String string = UWCUtils.escape_crlf(this.filterList[0].toSieve());
        String string2 = this.filterList[0].getOrder();
        for (int i = 1; i < this.filterList.length; ++i) {
            string = string + "::" + UWCUtils.escape_crlf(this.filterList[i].toSieve());
            string2 = string2 + "," + this.filterList[i].getOrder();
        }
        if (_sieveLogger.isLoggable(Level.FINE)) {
            _sieveLogger.fine("genAccsieve:setting acc. sieve escaped-->" + string);
            _sieveLogger.fine("genAccsieve:setting acc. order -->" + string2);
        }
        this.accSieveList = string;
        this.accOrder = string2;
    }

    public boolean sieveContains(String string) {
        if (this.filterList == null || this.filterList.length == 0) {
            return false;
        }
        for (int i = 0; i < this.filterList.length; ++i) {
            if (!string.equals(this.filterList[i].getName())) continue;
            if (_sieveLogger.isLoggable(Level.FINE)) {
                _sieveLogger.fine("Duplicate filter name detected:" + string);
            }
            return true;
        }
        return false;
    }

    public void setRequestContext(RequestContext requestContext) {
        _sieveLogger.entering(CLASS_NAME, "setRequestContext()");
        this._reqCtx = requestContext;
        _sieveLogger.exiting(CLASS_NAME, "setRequestContext()");
    }

    public void setFilterStateInfo(HashMap hashMap) {
        this.filterStateMap = hashMap;
    }

    public HashMap getFilterStateInfo() {
        return this.filterStateMap;
    }

    public void setDirty() {
        this.dirtyFlag = true;
    }

    public void resetDirty() {
        this.dirtyFlag = false;
    }

    public void setSaveFlag() {
        this.saveFlag = true;
    }

    public void clearSaveFlag() {
        this.saveFlag = false;
    }

    public boolean isDirty() {
        return this.dirtyFlag;
    }

    public boolean saveRequested() {
        return this.saveFlag;
    }

    public int getCurFilterIndex() {
        return this.curFilterIndex;
    }

    public void setCurFilterIndex(int n) {
        this.curFilterIndex = n;
    }

    public String getAccSieve() {
        return this.accSieveList;
    }

    public String getAccOrder() {
        return this.accOrder;
    }

    public void setAdvancedConditions(Vector vector) {
        this.advCond = vector;
    }

    public Vector getAdvancedConditions() {
        return this.advCond;
    }

    public void setAdvancedActions(Vector vector) {
        this.advAct = vector;
    }

    public Vector getAdvancedActions() {
        return this.advAct;
    }

    public static void main(String[] stringArray) {
    }

    static {
        _sieveLogger = UWCLogger.getLogger("uwc");
    }
}

