/*
 * Decompiled with CFR 0.152.
 */
package com.sun.uwc.common.model;

import com.iplanet.jato.RequestContext;
import com.iplanet.xslui.auth.ABUserSession;
import com.iplanet.xslui.auth.UserSession;
import com.iplanet.xslui.ui.SessionObjectFactory;
import com.iplanet.xslui.ui.XSLUIEngineServlet;
import com.sun.uwc.common.UWCException;
import com.sun.uwc.common.ldap.LDAPUtil;
import com.sun.uwc.common.model.UserPreferencesModel;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.logging.Level;
import javax.servlet.http.HttpSession;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPException;

public class ABUserPreferencesModel
extends UserPreferencesModel {
    private static final String CLASS_NAME = "ABUserPreferencesModel";
    public static final String AB_EXTENDED_USER_PREFS = "sunAbExtendedUserPrefs";
    public static final String AB_INITIALIZED = "sunAbInitialized";
    public static final String AB_DEFAULT_ADD_CATEGORY = "abDefaultAddCategory";
    public static final String AB_ENTRIES_PER_PAGE = "abEntriesPerPage";
    public static final String AB_NAME = "abName";
    public static final String AB_DESCRIPTION = "abDescription";
    public static final String AB_SEARCH_DISPLAY_COLUMN1 = "abSearchDisplayColumn1";
    public static final String AB_SEARCH_DISPLAY_COLUMN2 = "abSearchDisplayColumn2";
    public static final String AB_SEARCH_DISPLAY_COLUMN3 = "abSearchDisplayColumn3";
    public static final String AB_SEARCH_DISPLAY_COLUMN4 = "abSearchDisplayColumn4";
    public static final String AB_SEARCH_DISPLAY_COLUMN5 = "abSearchDisplayColumn5";
    public static final String AB_SEARCH_DISPLAY_COLUMN6 = "abSearchDisplayColumn6";
    public static final String AB_SEARCH_DISPLAY_COLUMN7 = "abSearchDisplayColumn7";
    public static final String IP_USER_OC = "ipUser";
    public static final String PSROOT_ATTR_NAME = "psRoot";
    private static String[] _abUserAttrs = new String[]{"sunAbExtendedUserPrefs", "psRoot"};
    private static String[] _abUserMultiValuedAttrs = new String[]{"sunAbExtendedUserPrefs"};
    private static String[] _abUserABExtendedPrefAttrs = new String[]{"sunAbInitialized", "abName", "abDescription", "abEntriesPerPage", "abSearchDisplayColumn1", "abSearchDisplayColumn2", "abSearchDisplayColumn3", "abSearchDisplayColumn4", "abSearchDisplayColumn5", "abSearchDisplayColumn6", "abSearchDisplayColumn7"};
    private static SessionObjectFactory _sessionFactory = null;
    private static String[][] _abUserMultiValuedAttrsSubTypes = new String[][]{_abUserABExtendedPrefAttrs};

    public ABUserPreferencesModel() throws UWCException {
    }

    public ABUserPreferencesModel(RequestContext requestContext) throws UWCException {
        super(requestContext);
    }

    public void initializeAddressBookPreferences() throws UWCException {
        Hashtable hashtable = new Hashtable();
        hashtable = this._isAnonymous ? this.initializeForAnonAccess(_abUserAttrs, _abUserMultiValuedAttrs, _abUserMultiValuedAttrsSubTypes, hashtable) : this.initializeForAuthUser();
        this.setAttrValuesInSession(hashtable, _abUserAttrs, _abUserMultiValuedAttrs, _abUserMultiValuedAttrsSubTypes);
    }

    protected Hashtable initializeForAuthUser() throws UWCException {
        LDAPConnection lDAPConnection = null;
        String string = null;
        LDAPUtil lDAPUtil = null;
        string = this.getUserDN();
        if (null == string) {
            _prefsLogger.warning("Empty User DN");
            throw new UWCException("User DN is empty!");
        }
        try {
            lDAPConnection = this.getLdapConnection();
        }
        catch (LDAPException lDAPException) {
            _prefsLogger.warning("Unable to obtain LDAP Connection");
            throw new UWCException(lDAPException.getMessage());
        }
        if (null == lDAPConnection) {
            _prefsLogger.warning("Timedout in obtaining LDAP Connection");
            throw new UWCException("Could not obtain LDAP Connection object");
        }
        try {
            lDAPUtil = new LDAPUtil(lDAPConnection, string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            _prefsLogger.warning("Couldnot obtain LDAPUtil object!");
            throw new UWCException(illegalArgumentException.getMessage());
        }
        try {
            lDAPUtil.loadValues();
        }
        catch (LDAPException lDAPException) {
            if (_prefsLogger.isLoggable(Level.WARNING)) {
                _prefsLogger.warning("Couldnot Load entry for DN: " + string);
            }
            this.releaseLdapConnection(lDAPUtil.getLDAPConnection());
            throw new UWCException(lDAPException.getMessage());
        }
        String string2 = "sunAbInitialized=true";
        boolean bl = lDAPUtil.isValuePresentIgnoreCase(AB_EXTENDED_USER_PREFS, string2);
        boolean bl2 = false == bl;
        Hashtable hashtable = new Hashtable();
        hashtable = this.initializeAndObtainPrefs(lDAPUtil, _abUserAttrs, _abUserMultiValuedAttrs, _abUserMultiValuedAttrsSubTypes, hashtable, bl2);
        if (bl2) {
            if (_prefsLogger.isLoggable(Level.FINE)) {
                _prefsLogger.fine("AB Prefs not initialized in LDAP. Will add AB_EXTENDED_USER_PREFS and PSROOT if required");
            }
            try {
                lDAPUtil.modifyAttribute(0, AB_EXTENDED_USER_PREFS, string2);
            }
            catch (LDAPException lDAPException) {
                if (_prefsLogger.isLoggable(Level.WARNING)) {
                    _prefsLogger.warning("Unable to modify attr: sunAbExtendedUserPrefs to \"" + string2 + "\" in " + string);
                }
                this.releaseLdapConnection(lDAPUtil.getLDAPConnection());
                throw new UWCException(lDAPException.getMessage());
            }
            if (!this.isAttrValuePresent(lDAPUtil, "ObjectClass", IP_USER_OC)) {
                if (_prefsLogger.isLoggable(Level.INFO)) {
                    _prefsLogger.info("OC: ipUser is not present. Will add it.");
                }
                try {
                    lDAPUtil.modifyAttribute(0, "ObjectClass", IP_USER_OC);
                }
                catch (LDAPException lDAPException) {
                    if (_prefsLogger.isLoggable(Level.WARNING)) {
                        _prefsLogger.warning("Couldnot create ObjectClass: ipUser for DN: " + lDAPUtil.getDN());
                    }
                    this.releaseLdapConnection(lDAPUtil.getLDAPConnection());
                    throw new UWCException(lDAPException.getMessage());
                }
            }
            if (!this.isAttrValuePresent(lDAPUtil, PSROOT_ATTR_NAME, null)) {
                if (_prefsLogger.isLoggable(Level.FINE)) {
                    _prefsLogger.fine("PSROOT not present. Will try to setvalue");
                }
                if (!this.setDefaultPsRoot(lDAPUtil) && _prefsLogger.isLoggable(Level.SEVERE)) {
                    _prefsLogger.severe("Could NOT set the default psRoot value");
                }
            }
        }
        this.releaseLdapConnection(lDAPConnection);
        return hashtable;
    }

    public boolean setDefaultPsRoot(LDAPUtil lDAPUtil) {
        if (_prefsLogger.isLoggable(Level.FINER)) {
            _prefsLogger.entering(CLASS_NAME, "setDefaultPsRoot()");
        }
        SessionObjectFactory sessionObjectFactory = ABUserPreferencesModel.getSessionObjFactory();
        String string = null;
        if (sessionObjectFactory != null) {
            if (_prefsLogger.isLoggable(Level.FINE)) {
                _prefsLogger.fine("Got sessionObjFactory");
            }
            ABUserSession aBUserSession = ABUserSession.createUserSession((HttpSession)this._reqCtx.getRequest().getSession());
            string = sessionObjectFactory.getDefaultPsRoot((UserSession)aBUserSession);
            if (_prefsLogger.isLoggable(Level.FINE)) {
                _prefsLogger.fine("ABUserPreferencesModel.setPsRootValue(): Default psRoot obtained " + string);
            }
            if (string != null) {
                try {
                    lDAPUtil.modifyAttribute(0, PSROOT_ATTR_NAME, string);
                    if (_prefsLogger.isLoggable(Level.FINE)) {
                        _prefsLogger.fine("About to call SessionModel.setValue: psRoot=" + string);
                    }
                    HttpSession httpSession = this._reqCtx.getRequest().getSession(false);
                    httpSession.setAttribute(PSROOT_ATTR_NAME, (Object)string);
                    if (_prefsLogger.isLoggable(Level.FINE)) {
                        _prefsLogger.fine("After SessionModel.setValue, value in Session: " + httpSession.getAttribute(PSROOT_ATTR_NAME));
                    }
                }
                catch (LDAPException lDAPException) {
                    _prefsLogger.severe("Got Exception : " + lDAPException.getMessage());
                    return false;
                }
                if (_prefsLogger.isLoggable(Level.FINER)) {
                    _prefsLogger.exiting(CLASS_NAME, "setDefaultPsRoot()");
                }
                return true;
            }
        }
        if (_prefsLogger.isLoggable(Level.FINER)) {
            _prefsLogger.exiting(CLASS_NAME, "setDefaultPsRoot()");
        }
        return false;
    }

    private static SessionObjectFactory getSessionObjFactory() {
        if (_sessionFactory != null) {
            return _sessionFactory;
        }
        Hashtable hashtable = XSLUIEngineServlet.getSessionObjectTable();
        if (hashtable != null) {
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                _sessionFactory = (SessionObjectFactory)hashtable.get(string);
            }
        }
        return _sessionFactory;
    }

    public void updateAddressBookPreferences() throws UWCException {
        super.updatePreferences(_abUserAttrs, _abUserMultiValuedAttrs, _abUserMultiValuedAttrsSubTypes);
    }

    public boolean getInitialized() {
        return new Boolean((String)this.getValue(AB_INITIALIZED));
    }

    public int getEntriesPerPage() {
        try {
            return Integer.parseInt((String)this.getValue(AB_ENTRIES_PER_PAGE));
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public String getABName() {
        return (String)this.getValue(AB_NAME);
    }

    public String getABDescription() {
        return (String)this.getValue(AB_DESCRIPTION);
    }

    public String getSearchDisplayColumn1() {
        return (String)this.getValue(AB_SEARCH_DISPLAY_COLUMN1);
    }

    public String getSearchDisplayColumn2() {
        return (String)this.getValue(AB_SEARCH_DISPLAY_COLUMN2);
    }

    public String getSearchDisplayColumn3() {
        return (String)this.getValue(AB_SEARCH_DISPLAY_COLUMN3);
    }

    public String getSearchDisplayColumn4() {
        return (String)this.getValue(AB_SEARCH_DISPLAY_COLUMN4);
    }

    public String getSearchDisplayColumn5() {
        return (String)this.getValue(AB_SEARCH_DISPLAY_COLUMN5);
    }

    public String getSearchDisplayColumn6() {
        return (String)this.getValue(AB_SEARCH_DISPLAY_COLUMN6);
    }

    public String getSearchDisplayColumn7() {
        return (String)this.getValue(AB_SEARCH_DISPLAY_COLUMN7);
    }

    public void setInitialized(boolean bl) {
        this.setValue(AB_INITIALIZED, new Boolean(bl).toString());
    }

    public void setEntriesPerPage(int n) {
        this.setValue(AB_ENTRIES_PER_PAGE, Integer.toString(n));
    }

    public void setABName(String string) {
        this.setValue(AB_NAME, string);
    }

    public void setABDescription(String string) {
        this.setValue(AB_DESCRIPTION, string);
    }

    public void setSearchDisplayColumn1(String string) {
        this.setValue(AB_SEARCH_DISPLAY_COLUMN1, string);
    }

    public void setSearchDisplayColumn2(String string) {
        this.setValue(AB_SEARCH_DISPLAY_COLUMN2, string);
    }

    public void setSearchDisplayColumn3(String string) {
        this.setValue(AB_SEARCH_DISPLAY_COLUMN3, string);
    }

    public void setSearchDisplayColumn4(String string) {
        this.setValue(AB_SEARCH_DISPLAY_COLUMN4, string);
    }

    public void setSearchDisplayColumn5(String string) {
        this.setValue(AB_SEARCH_DISPLAY_COLUMN5, string);
    }

    public void setSearchDisplayColumn6(String string) {
        this.setValue(AB_SEARCH_DISPLAY_COLUMN6, string);
    }

    public void setSearchDisplayColumn7(String string) {
        this.setValue(AB_SEARCH_DISPLAY_COLUMN7, string);
    }
}

