/*
 * Decompiled with CFR 0.152.
 */
package com.sun.uwc.common.auth;

import com.iplanet.jato.util.NonSyncStringBuffer;
import com.sun.uwc.UWCServletBase;
import com.sun.uwc.common.util.UWCLogger;
import com.sun.uwc.common.util.UWCPreferences;
import java.io.File;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.logging.Logger;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class UWCAuthServlet
extends HttpServlet {
    private static final transient String DEFAULT_URL = "/base/UWCMain";
    private static final transient String LOGIN_PAGE_URL = "/uwc/common/login.jsp";
    private static final transient String IDENTITY_LOGIN_PAGE = "/UI/Login?service=adminconsoleservice&goto=";
    static String _defaultDomain = null;
    static String _identityURL = null;
    static boolean _identityEnabled = false;
    static boolean _sslEnabled = false;
    static boolean _sslForAuthOnly = false;
    static int _uwcPort = 80;
    static int _uwcSSLPort = 443;
    static Logger authLogger = UWCLogger.getLogger("uwc.common.auth");
    protected String _config_filename = "uwcauth.properties";
    public static final String CONFIG_IDENTITY_ENABLED = "uwcauth.identity.enabled";
    public static final String CONFIG_SSL_ENABLED = "uwcauth.ssl.enabled";
    public static final String CONFIG_SSL_AUTH_ONLY = "uwcauth.ssl.authonly";
    public static final String CONFIG_UWC_SSL_PORT = "uwcauth.https.port";
    public static final String CONFIG_UWC_PORT = "uwcauth.http.port";
    public static final String CONFIG_IDENTITY_URL = "uwcauth.identity.login.url";
    public static final String CONFIG_DEFAULT_DOMAIN = "defaultdomain";

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        authLogger.entering("UWCAuthServlet", "init()");
        String string = servletConfig.getInitParameter("configPath");
        ServletContext servletContext = null;
        if (string == null && (string = (servletContext = servletConfig.getServletContext()).getRealPath("/")) == null) {
            string = "./";
        }
        authLogger.finest("configPathRoot:" + string);
        authLogger.fine("get configPath:.....");
        File file = new File(new File(string, "local-conf"), "config");
        if (!file.isDirectory() && !(file = new File(string, "WEB-INF/config")).isDirectory()) {
            throw new ServletException("AuthFilter: can't open configuration dir " + file.toString());
        }
        authLogger.finest("configPath:" + file);
        String string2 = file.getPath() + "/" + this._config_filename;
        authLogger.fine("load configuration file:" + string2);
        UWCPreferences uWCPreferences = UWCPreferences.getSystemRootInstance();
        try {
            uWCPreferences = uWCPreferences.loadNode(string2, "/");
            _identityEnabled = uWCPreferences.getBoolean(CONFIG_IDENTITY_ENABLED, false);
            _sslEnabled = uWCPreferences.getBoolean(CONFIG_SSL_ENABLED, false);
            _sslForAuthOnly = uWCPreferences.getBoolean(CONFIG_SSL_AUTH_ONLY, false);
            _uwcSSLPort = uWCPreferences.getInt(CONFIG_UWC_SSL_PORT, 443);
            _uwcPort = uWCPreferences.getInt(CONFIG_UWC_PORT, 80);
            _identityURL = uWCPreferences.get(CONFIG_IDENTITY_URL, null);
            _defaultDomain = uWCPreferences.get(CONFIG_DEFAULT_DOMAIN, null);
        }
        catch (Exception exception) {
            throw new ServletException(exception.getMessage());
        }
        authLogger.exiting("UWCAuthServlet", "init()");
    }

    public final void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        authLogger.entering("UWCAuthServlet:", "doGet");
        String string = httpServletRequest.getContextPath();
        NonSyncStringBuffer nonSyncStringBuffer = new NonSyncStringBuffer("");
        if (string == null || string != null && string.equals("/")) {
            string = "";
        }
        HttpSession httpSession = httpServletRequest.getSession(false);
        String string2 = httpServletRequest.getParameter("gotoUri");
        String string3 = httpServletRequest.getServerName();
        String string4 = httpServletRequest.getQueryString();
        if (string4 != null && string4.length() > 0) {
            string4 = "?" + string4;
        }
        if (httpSession == null) {
            if (_sslForAuthOnly && !_identityEnabled) {
                httpServletRequest.setAttribute("sslAuth", (Object)"true");
                httpServletRequest.setAttribute("sslPort", (Object)new Integer(_uwcSSLPort));
            }
            nonSyncStringBuffer.append(LOGIN_PAGE_URL);
            if (string2 != null) {
                try {
                    nonSyncStringBuffer.append("?");
                    nonSyncStringBuffer.append("gotoUri");
                    nonSyncStringBuffer.append("=");
                    nonSyncStringBuffer.append(URLEncoder.encode(string2, "UTF-8"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            String string5 = httpServletRequest.getHeader("accept-language");
            try {
                UWCPreferences uWCPreferences = UWCServletBase.configMgr.getUWCResourceBundle(_defaultDomain, string5);
            }
            catch (Exception exception) {
                // empty catch block
            }
            httpServletRequest.getRequestDispatcher(nonSyncStringBuffer.toString()).forward((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
            return;
        }
        if (_sslEnabled && !_sslForAuthOnly) {
            nonSyncStringBuffer.append("https://");
            nonSyncStringBuffer.append(string3);
            nonSyncStringBuffer.append(":");
            nonSyncStringBuffer.append(_uwcSSLPort);
        }
        if (_sslForAuthOnly) {
            nonSyncStringBuffer.append("http://");
            nonSyncStringBuffer.append(string3);
            nonSyncStringBuffer.append(":");
            nonSyncStringBuffer.append(_uwcPort);
        }
        if (string2 != null) {
            nonSyncStringBuffer.append(string);
            nonSyncStringBuffer.append(string2);
        } else {
            nonSyncStringBuffer.append(string);
            nonSyncStringBuffer.append(DEFAULT_URL);
            if (_sslForAuthOnly) {
                nonSyncStringBuffer.append(";jsessionid=");
                nonSyncStringBuffer.append(httpSession.getId());
                if (string4 != null && string4.length() > 0) {
                    nonSyncStringBuffer.append(string4);
                }
                httpServletResponse.sendRedirect(httpServletResponse.encodeRedirectURL(nonSyncStringBuffer.toString()));
            }
        }
        if (!_sslForAuthOnly) {
            if (string4 != null && string4.length() > 0 && string2 == null) {
                nonSyncStringBuffer.append(string4);
            }
            httpServletResponse.sendRedirect(nonSyncStringBuffer.toString());
        }
    }

    public final void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.doGet(httpServletRequest, httpServletResponse);
    }
}

