/*
 * Decompiled with CFR 0.152.
 */
package com.sun.uwc.common.auth;

import com.sun.uwc.common.UWCApplicationHelper;
import com.sun.uwc.common.UWCException;
import com.sun.uwc.common.auth.MessagingSSO;
import com.sun.uwc.common.util.UWCLogger;
import com.sun.uwc.common.util.UWCPreferences;
import java.io.IOException;
import java.util.Vector;
import java.util.logging.Logger;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class MessagingVerifySSOServlet
extends HttpServlet {
    private boolean _enabled = true;
    private MessagingSSO _messagingSSO = null;
    private UWCPreferences _authConfig = null;
    private Logger _uwcLogger = UWCLogger.getLogger("uwc");

    public void init(ServletConfig servletConfig) throws ServletException {
        try {
            this._authConfig = UWCApplicationHelper.getApplicationAuthPreferences();
        }
        catch (UWCException uWCException) {
            throw new ServletException("Error in loading the authentication configuration:" + uWCException.getMessage());
        }
        if (this._authConfig == null) {
            throw new ServletException("Error in loading the authentication configuration file");
        }
        this._messagingSSO = new MessagingSSO(this._authConfig);
        this._enabled = this._messagingSSO.isEnabled();
    }

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
        if (!this._enabled) {
            this._messagingSSO.sendError(servletOutputStream, "SSO disabled");
            return;
        }
        Cookie[] cookieArray = httpServletRequest.getCookies();
        if (cookieArray == null || cookieArray.length == 0) {
            this._messagingSSO.sendError(servletOutputStream, "No cookie in request");
            return;
        }
        String string = httpServletRequest.getParameter("client");
        if (this._messagingSSO.hasSessionCookie(cookieArray)) {
            HttpSession httpSession = httpServletRequest.getSession(true);
            String string2 = (String)httpSession.getAttribute("clientIP");
            if (string == null || string2 == null || !string2.trim().equalsIgnoreCase(string)) {
                this._messagingSSO.sendError(servletOutputStream, "IP addresses dont match");
                return;
            }
            String string3 = (String)httpSession.getAttribute("domainname");
            String string4 = (String)httpSession.getAttribute("uid");
            String string5 = string4 + "@" + string3;
            this._uwcLogger.info("Sending this to Messaging server:" + string5);
            this._messagingSSO.sendSuccess(servletOutputStream, string5, "plaintext");
            return;
        }
        Vector vector = this._messagingSSO.verifySSO(cookieArray, string, false);
        if (vector == null) {
            this._messagingSSO.sendError(servletOutputStream, "Remote Server sent an error");
            return;
        }
        this._messagingSSO.relaySuccess(servletOutputStream, vector);
    }
}

