/*
 * Decompiled with CFR 0.152.
 */
package com.sun.uwc.common.auth;

import com.sun.uwc.common.auth.AuthFilter;
import com.sun.uwc.common.auth.MessagingSSO;
import java.io.IOException;
import java.util.Vector;
import java.util.prefs.Preferences;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class MessagingSSOAuthFilter
extends AuthFilter {
    public static final String CONFIG_FILENAME = "uwcauth.properties";
    private String _defaultDomain = null;
    private String _config_filename = null;
    private boolean _enabled = true;
    private MessagingSSO _messagingSSO = null;

    public void init(FilterConfig filterConfig) throws ServletException {
        this._config_filename = CONFIG_FILENAME;
        super.init(filterConfig);
        Preferences preferences = super.getPreferences();
        this._defaultDomain = preferences.get("defaultdomain", "iplanet.com");
        this._messagingSSO = new MessagingSSO(preferences);
        this._enabled = this._messagingSSO.isEnabled();
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws ServletException, IOException {
        authLogger.entering("MessagingSSOAuthFilter:", " doFilter");
        if (!this._enabled) {
            authLogger.exiting("MessagingSSOAuthFilter:", " doFilter");
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
        HttpSession httpSession = httpServletRequest.getSession(false);
        if (httpSession != null) {
            authLogger.exiting("MessagingSSOAuthFilter:", " doFilter");
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        Cookie[] cookieArray = httpServletRequest.getCookies();
        if (cookieArray == null || cookieArray.length == 0) {
            authLogger.finest("cookies are null");
            authLogger.exiting("MessagingSSOAuthFilter:", " doFilter");
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        String string = servletRequest.getRemoteAddr();
        authLogger.fine("Validate Cookies");
        Vector vector = this._messagingSSO.verifySSO(cookieArray, string, true);
        if (vector == null) {
            authLogger.fine("inValid Cookies");
            authLogger.exiting("MessagingSSOAuthFilter:", " doFilter");
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        authLogger.fine("Valid Cookies");
        String string2 = (String)vector.elementAt(0);
        String string3 = (String)vector.elementAt(1);
        if (string2 == null) {
            authLogger.fine("fquidStr is null");
            authLogger.exiting("MessagingSSOAuthFilter:", " doFilter");
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        authLogger.finest("fquidStr:...  " + string2);
        authLogger.finest("typeStr:... " + string3);
        int n = string2.indexOf("=");
        if (n <= 0 || n == string2.length() - 1) {
            authLogger.fine("inValid Response");
            authLogger.exiting("MessagingSSOAuthFilter:", " doFilter");
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        String string4 = string2.substring(n + 1);
        authLogger.finest("fquid:..  " + string4);
        n = string4.lastIndexOf("@");
        if (n <= 0 || n == string4.length() - 1) {
            authLogger.fine("inValid Response");
            authLogger.exiting("MessagingSSOAuthFilter:", " doFilter");
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        String string5 = string4.substring(0, n);
        String string6 = string4.substring(n + 1);
        authLogger.finest("uid :... " + string5);
        authLogger.finest("domain is:.... " + string6);
        httpSession = httpServletRequest.getSession(true);
        Cookie cookie = this._messagingSSO.getSSOCookie(httpSession, httpServletRequest.getHeader("Host"));
        HttpServletResponse httpServletResponse = (HttpServletResponse)servletResponse;
        httpServletResponse.addCookie(cookie);
        String string7 = null;
        httpSession.setAttribute("uid", (Object)string5);
        httpSession.setAttribute("domainname", (Object)string6);
        string7 = "true";
        httpSession.setAttribute("com.sun.uwc.newsession", (Object)string7);
        string7 = httpServletRequest.getHeader("user-agent");
        if (string7 != null) {
            httpSession.setAttribute("useragent", (Object)string7);
        }
        if ((string7 = httpServletRequest.getHeader("accept-language")) != null) {
            httpSession.setAttribute("acceptlang", (Object)string7);
        }
        if ((string7 = httpServletRequest.getHeader("accept-charset")) != null) {
            httpSession.setAttribute("charsetenc", (Object)string7);
        }
        authLogger.fine("Valid Response");
        authLogger.exiting("MessagingSSOAuthFilter:", " doFilter");
        filterChain.doFilter(servletRequest, servletResponse);
    }

    public void destroy() {
    }
}

