/*
 * Decompiled with CFR 0.152.
 */
package com.sun.uwc.common.auth;

import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMOrganization;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.sdk.AMUser;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenID;
import com.iplanet.sso.SSOTokenListener;
import com.iplanet.sso.SSOTokenManager;
import com.sun.comclient.calendar.DateTime;
import com.sun.uwc.common.auth.AuthFilter;
import com.sun.uwc.common.auth.IdentitySSO;
import com.sun.uwc.common.auth.UWCIdentitySSOTokenListener;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URLEncoder;
import java.security.Principal;
import java.util.Map;
import java.util.TimeZone;
import java.util.prefs.Preferences;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class IdentitySSOAuthFilter
extends AuthFilter {
    public static final String CONFIG_FILENAME = "uwcauth.properties";
    public String DEFAULT_DOMAIN = "defaultdomain";
    public static final String CONFIG_IDENTITY_URL = "uwcauth.identity.login.url";
    public static final String CONFIG_IDENTITY_COOKIE = "uwcauth.identity.cookiename";
    private final transient String GOTO_URI_PARAM = "goto=";
    private final transient String GOTO_URI_ON_FAIL_PARAM = "gotoOnFail=";
    private final transient String IS_AUTH_ERR_INDICATOR = "err";
    private final transient String USER_PARAM = "IDToken1=";
    private final transient String PASSWD_PARAM = "IDToken2=";
    private final transient String ORG_PARAM = "org=";
    private final transient String WABP = "wabp";
    private final transient String WABP_LOGIN_PATH = "wabp/login.wabp";
    public String AUTH_ERROR = "autherror";
    private String _defaultDomain = null;
    private String _identityCookieName = null;
    private String _cookieDomain = null;
    private String _config_filename = null;
    private String _identityURL = null;
    private boolean _enabled = true;
    private boolean _sslEnabled = false;
    private IdentitySSO _identitySSO = null;
    static int _uwcPort = 80;
    static int _uwcSSLPort = 443;

    public void init(FilterConfig filterConfig) throws ServletException {
        this._config_filename = CONFIG_FILENAME;
        super.init(filterConfig);
        Preferences preferences = super.getPreferences();
        this._defaultDomain = preferences.get("defaultdomain", "iplanet.com");
        this._sslEnabled = preferences.getBoolean("uwcauth.ssl.enabled", false);
        _uwcSSLPort = preferences.getInt("uwcauth.https.port", 443);
        _uwcPort = preferences.getInt("uwcauth.http.port", 80);
        this._identityURL = preferences.get(CONFIG_IDENTITY_URL, null);
        this._identityCookieName = preferences.get(CONFIG_IDENTITY_COOKIE, "iPlanetDirectoryPro");
        this._cookieDomain = preferences.get("uwcauth.cookiedomain", "iplanet.com");
        this._identitySSO = new IdentitySSO(preferences);
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws ServletException, IOException {
        authLogger.entering("IdentitySSOAuthFilter:", " doFilter");
        if (!this._identityEnabled) {
            authLogger.entering("IdentitySSOAuthFilter:", " identity not enabled");
            authLogger.exiting("IdentitySSOAuthFilter:", " doFilter");
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        String string = "false";
        String string2 = null;
        String string3 = null;
        authLogger.info("IdentitySSOAuthFilter: identity is enabled");
        HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
        authLogger.fine("IdentitySSOAuthFilter:check for presence of session");
        HttpSession httpSession = httpServletRequest.getSession(false);
        if (httpSession != null) {
            authLogger.exiting("IdentitySSOAuthFilter:", " doFilter");
            authLogger.fine("session is present.. return");
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        authLogger.fine("Session is null");
        String string4 = IdentitySSOAuthFilter.getUserFromRequest(httpServletRequest);
        String string5 = IdentitySSOAuthFilter.getPasswordFromRequest(httpServletRequest);
        String string6 = httpServletRequest.getParameter("fromlogin");
        authLogger.fine("username is... " + string4);
        if (string4 != null && string4.length() > 0 && string5 != null && string5.length() > 0) {
            authLogger.fine("get uid and domain");
            int n = string4.lastIndexOf("@");
            if (n != -1) {
                string2 = string4.substring(0, n);
                string3 = string4.substring(n + 1);
            } else {
                string2 = string4;
                string3 = this._defaultDomain;
            }
            authLogger.fine("uid... " + string2 + "domain..." + string3);
            StringBuffer stringBuffer = new StringBuffer("");
            if (this._identityURL == null) {
                string = "true";
                servletRequest.setAttribute(this.AUTH_ERROR, (Object)string);
                authLogger.fine("set defaultDomain attr in request..." + this._defaultDomain);
                authLogger.fine("Null IS URL! - Misconfiguration");
                servletRequest.setAttribute(this.DEFAULT_DOMAIN, (Object)this._defaultDomain);
                filterChain.doFilter(servletRequest, servletResponse);
                return;
            }
            stringBuffer.append(this._identityURL);
            stringBuffer.append("?");
            stringBuffer.append("goto=");
            String string7 = httpServletRequest.getServerName();
            String string8 = httpServletRequest.getContextPath();
            if (string8 == null || string8 != null && string8.equals("/")) {
                string8 = "";
            }
            StringBuffer stringBuffer2 = new StringBuffer("");
            if (this._sslEnabled) {
                stringBuffer2.append("https://");
                stringBuffer2.append(string7);
                stringBuffer2.append(":");
                stringBuffer2.append(_uwcSSLPort);
                stringBuffer2.append(string8);
                stringBuffer2.append("/");
            } else {
                stringBuffer2.append("http://");
                stringBuffer2.append(string7);
                stringBuffer2.append(":");
                stringBuffer2.append(_uwcPort);
                stringBuffer2.append(string8);
                stringBuffer2.append("/");
            }
            String string9 = ((HttpServletRequest)servletRequest).getRequestURI();
            if (string9.indexOf("wabp") > -1) {
                stringBuffer2.append("wabp/login.wabp");
            }
            stringBuffer.append(stringBuffer2);
            stringBuffer.append("&");
            stringBuffer.append("gotoOnFail=");
            stringBuffer.append(stringBuffer2);
            stringBuffer.append("?");
            stringBuffer.append("err");
            stringBuffer.append("=1");
            stringBuffer.append("&");
            stringBuffer.append("IDToken1=");
            stringBuffer.append(URLEncoder.encode(string2, "UTF-8"));
            stringBuffer.append("&");
            stringBuffer.append("IDToken2=");
            stringBuffer.append(URLEncoder.encode(string5, "UTF-8"));
            stringBuffer.append("&");
            stringBuffer.append("org=");
            stringBuffer.append(string3);
            ((HttpServletResponse)servletResponse).sendRedirect(stringBuffer.toString());
            return;
        }
        authLogger.fine("username or password is null");
        Map map = httpServletRequest.getParameterMap();
        if (map != null && map.containsKey("err")) {
            authLogger.warning("IS Auth Error!");
            string = "true";
            servletRequest.setAttribute(this.AUTH_ERROR, (Object)string);
            authLogger.fine("set defaultDomain attr in request..." + this._defaultDomain);
            servletRequest.setAttribute(this.DEFAULT_DOMAIN, (Object)this._defaultDomain);
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        if (string6 != null && string6.equals("true")) {
            string = "true";
            servletRequest.setAttribute(this.AUTH_ERROR, (Object)string);
            authLogger.fine("set defaultDomain attr in request..." + this._defaultDomain);
            servletRequest.setAttribute(this.DEFAULT_DOMAIN, (Object)this._defaultDomain);
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        try {
            authLogger.fine("session is not present.. ");
            authLogger.fine("get token manager.. ");
            map = SSOTokenManager.getInstance();
            authLogger.fine("create token .. ");
            SSOToken sSOToken = map.createSSOToken(httpServletRequest);
            authLogger.info(" check for the token validity ");
            boolean bl = map.isValidToken(sSOToken);
            if (bl) {
                authLogger.info(" valid IdentitySSO Token ");
                authLogger.info(" get Store  conenction ");
                AMStoreConnection aMStoreConnection = new AMStoreConnection(sSOToken);
                authLogger.info(" get the amuser ");
                AMUser aMUser = aMStoreConnection.getUser(sSOToken.getPrincipal().getName());
                authLogger.info(" get the sessionAddr ");
                InetAddress inetAddress = sSOToken.getIPAddress();
                authLogger.info(" sessionAddr is " + inetAddress);
                authLogger.info(" get the paramAddr ");
                InetAddress inetAddress2 = InetAddress.getByName(httpServletRequest.getRemoteAddr());
                authLogger.info(" paramAddr is " + inetAddress2);
                if (!inetAddress.equals(inetAddress2)) {
                    authLogger.info(" invalid IdentitySSO Token...  IP does not match");
                    filterChain.doFilter(servletRequest, servletResponse);
                    return;
                }
                authLogger.fine("Valid Response");
                authLogger.fine("create session");
                httpSession = httpServletRequest.getSession(true);
                SSOTokenID sSOTokenID = sSOToken.getTokenID();
                httpSession.setAttribute("identitytokenid", (Object)sSOTokenID.toString());
                String string10 = new DateTime(TimeZone.getTimeZone("GMT")).toISO8601();
                sSOToken.setProperty("uwcstatus", "active");
                httpSession.setAttribute("identitylastaccessGMTtime", (Object)string10);
                Cookie cookie = this._identitySSO.getSSOCookie(httpSession);
                HttpServletResponse httpServletResponse = (HttpServletResponse)servletResponse;
                httpServletResponse.addCookie(cookie);
                authLogger.fine(" added the UWC cookie...");
                String string11 = aMUser.getStringAttribute("uid");
                authLogger.fine(" uid is " + string11);
                String string12 = aMUser.getOrganizationDN();
                authLogger.fine(" orgDN is " + string12);
                String string13 = aMUser.getDN();
                authLogger.fine(" userDN is " + string13);
                String string14 = aMUser.getStringAttribute("inetUserStatus");
                if (string14 != null && string14.length() == 0) {
                    string14 = null;
                }
                authLogger.fine(" inetUserStatus is " + string14);
                String string15 = aMUser.getStringAttribute("mailUserStatus");
                if (string15 != null && string15.length() == 0) {
                    string15 = null;
                }
                authLogger.fine(" mailUserStatus is " + string15);
                String string16 = aMUser.getStringAttribute("icsStatus");
                authLogger.fine(" icsStatus is " + string16);
                if (string16 != null && string16.length() == 0) {
                    string16 = null;
                }
                String string17 = aMUser.getStringAttribute("preferredLanguage");
                authLogger.fine(" preferredLanguage is " + string17);
                String string18 = aMUser.getStringAttribute("cn;lang-" + string17);
                if (string18 == null || string18 != null && string18.length() == 0) {
                    string18 = aMUser.getStringAttribute("cn");
                }
                authLogger.fine(" commonName is " + string18);
                Principal principal = this._identitySSO.getAdminPrincipal();
                String string19 = this._identitySSO.getAdminCredentials();
                authLogger.info(" create the token ");
                SSOToken sSOToken2 = map.createSSOToken(principal, string19);
                AMStoreConnection aMStoreConnection2 = new AMStoreConnection(sSOToken2);
                AMOrganization aMOrganization = aMStoreConnection2.getOrganization(string12);
                String string20 = aMOrganization.getStringAttribute("sunPreferredDomain");
                authLogger.info(" domainName is " + string20);
                String string21 = aMOrganization.getStringAttribute("inetDomainStatus");
                if (string21 != null && string21.length() == 0) {
                    string21 = null;
                }
                authLogger.info(" inetDomainStatus is " + string21);
                String string22 = aMOrganization.getStringAttribute("mailDomainStatus");
                if (string22 != null && string22.length() == 0) {
                    string22 = null;
                }
                authLogger.info(" mailDomainStatus is " + string22);
                String string23 = aMOrganization.getStringAttribute("icsStatus");
                if (string23 != null && string23.length() == 0) {
                    string23 = null;
                }
                authLogger.info(" icsDomainStatus is " + string23);
                if (string21 != null && !string21.equalsIgnoreCase("active")) {
                    authLogger.info(" settting mail and cal as false");
                    httpSession.setAttribute("mail.service.enabled", (Object)"false");
                    httpSession.setAttribute("calendar.service.enabled", (Object)"false");
                } else {
                    if (string22 == null || string22 != null && string22.equalsIgnoreCase("active")) {
                        if (string15 == null || string15 != null && string15.equalsIgnoreCase("active")) {
                            httpSession.setAttribute("mail.service.enabled", (Object)"true");
                            authLogger.info(" settting mail as true");
                        } else {
                            httpSession.setAttribute("mail.service.enabled", (Object)"false");
                            authLogger.info(" settting mail as false");
                        }
                    } else {
                        httpSession.setAttribute("mail.service.enabled", (Object)"false");
                    }
                    if (string23 == null || string23 != null && string23.equalsIgnoreCase("active")) {
                        if (string16 == null || string16 != null && string16.equalsIgnoreCase("active")) {
                            httpSession.setAttribute("calendar.service.enabled", (Object)"true");
                            authLogger.info(" settting cal as true");
                        } else {
                            httpSession.setAttribute("calendar.service.enabled", (Object)"false");
                            authLogger.info(" settting cal as false");
                        }
                    } else {
                        httpSession.setAttribute("calendar.service.enabled", (Object)"false");
                        authLogger.info(" settting cal as false");
                    }
                }
                String string24 = null;
                httpSession.setAttribute("uid", (Object)string11);
                httpSession.setAttribute("userdn", (Object)string13);
                httpSession.setAttribute("userauthdn", (Object)string13);
                httpSession.setAttribute("domaindn", (Object)string12);
                httpSession.setAttribute("domainname", (Object)string20);
                httpSession.setAttribute("userlang", (Object)string17);
                string24 = "true";
                httpSession.setAttribute("com.sun.uwc.newsession", (Object)string24);
                string24 = httpServletRequest.getHeader("user-agent");
                if (string24 != null) {
                    httpSession.setAttribute("useragent", (Object)string24);
                }
                if ((string24 = httpServletRequest.getHeader("accept-language")) != null) {
                    httpSession.setAttribute("acceptlang", (Object)string24);
                }
                if ((string24 = httpServletRequest.getHeader("accept-charset")) != null) {
                    httpSession.setAttribute("charsetenc", (Object)string24);
                }
                httpSession.setAttribute("username", (Object)string18);
                authLogger.fine("Valid Response");
                UWCIdentitySSOTokenListener uWCIdentitySSOTokenListener = new UWCIdentitySSOTokenListener();
                sSOToken.addSSOTokenListener((SSOTokenListener)uWCIdentitySSOTokenListener);
                authLogger.exiting("IdentitySSOAuthFilter:", " doFilter");
                filterChain.doFilter(servletRequest, servletResponse);
                return;
            }
            authLogger.fine("Invalid Response");
            authLogger.exiting("IdentitySSOAuthFilter:", " doFilter");
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        catch (SSOException sSOException) {
            authLogger.warning("SSOException.." + sSOException.getMessage());
            if (httpSession != null) {
                httpSession.invalidate();
            }
            this.removeIdentityCookie(servletRequest, servletResponse);
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        catch (AMException aMException) {
            authLogger.warning("AMException.." + aMException.getMessage());
            if (httpSession != null) {
                httpSession.invalidate();
            }
            this.removeIdentityCookie(servletRequest, servletResponse);
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        catch (Exception exception) {
            authLogger.warning("Exception.." + exception.getMessage());
            if (httpSession != null) {
                httpSession.invalidate();
            }
            this.removeIdentityCookie(servletRequest, servletResponse);
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
    }

    public void destroy() {
    }

    private void removeIdentityCookie(ServletRequest servletRequest, ServletResponse servletResponse) {
        HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
        HttpServletResponse httpServletResponse = (HttpServletResponse)servletResponse;
        Cookie[] cookieArray = httpServletRequest.getCookies();
        String string = null;
        String string2 = null;
        if (cookieArray != null && cookieArray.length > 0) {
            boolean bl = false;
            for (int i = 0; i < cookieArray.length; ++i) {
                if (!cookieArray[i].getName().equalsIgnoreCase(this._identityCookieName)) continue;
                bl = true;
                string = cookieArray[i].getPath();
                string2 = cookieArray[i].getDomain();
                authLogger.fine("cDomain: " + string2);
                break;
            }
            if (bl) {
                Cookie cookie = new Cookie(this._identityCookieName, null);
                if (string != null) {
                    cookie.setPath(string);
                } else {
                    cookie.setPath("/");
                }
                if (string2 != null) {
                    cookie.setDomain(string2);
                } else if (this._cookieDomain != null) {
                    cookie.setDomain(this._cookieDomain);
                }
                cookie.setMaxAge(0);
                httpServletResponse.addCookie(cookie);
            }
        }
    }
}

