/*
 * Decompiled with CFR 0.152.
 */
package com.sun.uwc.common.auth;

import com.sun.uwc.common.util.UWCLogger;
import com.sun.uwc.common.util.UWCPreferences;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.security.Principal;
import java.util.HashMap;
import java.util.Vector;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpSession;

public class IdentitySSO {
    public static final String UWC_AUTH = "uwcauth.";
    public static final String CONFIG_SSO_PREFIX = "identitysso.";
    public static final String CONFIG_IDENTITY_ENABLE = "identity.enabled";
    public static final String CONFIG_SESSIONCOOKIE = "sessioncookie";
    public static final String CONFIG_APPPREFIX = "appprefix";
    public static final String CONFIG_APPID = "appid";
    public static final String CONFIG_COOKIEDOMAIN = "cookiedomain";
    public static final String CONFIG_COOKIEPATH = "cookiepath";
    public static final String CONFIG_URL = ".url";
    public static final String CONFIG_BINDDN = "uwcauth.identity.binddn";
    public static final String CONFIG_BINDCRED = "uwcauth.identity.bindcred";
    public static final String CONFIG_DEFAULTDOMAIN = "defaultdomain";
    public static final String CLIENTIP = "client";
    static Logger ssoLogger = UWCLogger.getLogger("uwc.common.auth");
    private String _defaultDomain = null;
    private boolean _enabled = true;
    private String _appPrefix = null;
    private String _appID = null;
    private String _mySSOCookieName = null;
    private Cookie _ssoCookie = null;
    private String _sessionCookieName = null;
    private String _ldapbinddn = null;
    private String _ldapbindcred = null;
    private HashMap _verifySSOMap = null;

    public IdentitySSO(Preferences preferences) {
        ssoLogger.fine("Read Identity SSO Properties....");
        this._enabled = preferences.getBoolean("uwcauth.identity.enabled", false);
        ssoLogger.finest("enabled is...." + this._enabled);
        this._ldapbinddn = preferences.get(CONFIG_BINDDN, null);
        ssoLogger.finest("configbinddn is...." + this._ldapbinddn);
        this._ldapbindcred = preferences.get(CONFIG_BINDCRED, null);
        this._sessionCookieName = preferences.get("uwcauth.sessioncookie", "JSESSIONID");
        ssoLogger.finest("sessionCookieName is...." + this._sessionCookieName);
        this._appPrefix = preferences.get("uwcauth.appprefix", "ssogrp1");
        ssoLogger.finest("appPrefix is...." + this._appPrefix);
        this._appID = preferences.get("uwcauth.appid", "uwc");
        ssoLogger.finest("appID is...." + this._appID);
        this._mySSOCookieName = this._appPrefix + "-" + this._appID;
        String string = preferences.get("uwcauth.cookiedomain", "iplanet.com");
        ssoLogger.finest("cookieDomain is...." + string);
        String string2 = preferences.get("uwcauth.identitysso.cookiepath", "/");
        ssoLogger.finest("cookiePath is...." + string2);
        this._ssoCookie = new Cookie(this._mySSOCookieName, "");
        this._ssoCookie.setDomain(string);
        this._ssoCookie.setPath(string2);
        this._verifySSOMap = new HashMap();
        String[] stringArray = UWCPreferences.getKeyProperty(preferences, CONFIG_SSO_PREFIX, CONFIG_URL);
        for (int i = 0; i < stringArray.length; ++i) {
            String string3 = stringArray[i];
            ssoLogger.finest("appID  is...." + string3);
            String string4 = preferences.get(CONFIG_SSO_PREFIX + string3 + CONFIG_URL, "");
            String string5 = this._appPrefix + "-" + string3;
            ssoLogger.finest("cookieKey  is...." + string5);
            if (string4 == null || string4.length() <= 0) continue;
            this._verifySSOMap.put(string5, string4);
        }
        ssoLogger.finest("Identity SSOMap  is...." + this._verifySSOMap.toString());
        ssoLogger.fine("Read Identity SSO Properties....: Done");
    }

    public boolean isEnabled() {
        return this._enabled;
    }

    public Principal getAdminPrincipal() {
        UWCPrincipal uWCPrincipal = new UWCPrincipal(this._ldapbinddn);
        return uWCPrincipal;
    }

    public String getAdminDN() {
        return this._ldapbinddn;
    }

    public String getAdminCredentials() {
        return this._ldapbindcred;
    }

    public Vector verifySSO(Cookie[] cookieArray, String string, boolean bl) {
        ssoLogger.entering("IdentitySSO:", " verifySSO");
        if (!this._enabled) {
            return null;
        }
        if (cookieArray == null || cookieArray.length == 0) {
            ssoLogger.finest("cookies: null");
            return null;
        }
        int n = cookieArray.length;
        Vector vector = null;
        String string2 = null;
        boolean bl2 = false;
        for (int i = 0; i < n; ++i) {
            string2 = cookieArray[i].getName();
            ssoLogger.finest("cookieName... : " + string2);
            bl2 = this._mySSOCookieName.equals(string2);
            if (bl2 && bl) continue;
            String string3 = (String)this._verifySSOMap.get(string2);
            ssoLogger.finest("verifyurl is : " + string3);
            if (string3 == null) continue;
            string3 = string3 + CLIENTIP + "=" + string;
            ssoLogger.fine("Validate cookie: " + string2 + " from: " + string3);
            vector = bl2 ? this.verifyOneSSO(string3, this._sessionCookieName, cookieArray[i].getValue()) : this.verifyOneSSO(string3, string2, cookieArray[i].getValue());
            if (vector == null || vector.size() < 2) {
                ssoLogger.fine("cookie: " + string2 + ": inValid");
                continue;
            }
            if (!this.isCredValid(vector)) continue;
            ssoLogger.fine("cookie: " + string2 + ": Valid");
            break;
        }
        ssoLogger.exiting("IdentitySSO:", "  VerifySSO");
        return vector;
    }

    public Cookie getSSOCookie(HttpSession httpSession) {
        Cookie cookie = (Cookie)this._ssoCookie.clone();
        cookie.setValue(httpSession.getId());
        return cookie;
    }

    public final void sendSuccess(ServletOutputStream servletOutputStream, String string, String string2) throws IOException {
        servletOutputStream.println("fquid=" + string);
        servletOutputStream.println("authtype=" + string2);
    }

    public final void relaySuccess(ServletOutputStream servletOutputStream, Vector vector) throws IOException {
        for (int i = 0; i < vector.size(); ++i) {
            servletOutputStream.println((String)vector.elementAt(i));
        }
    }

    public final void sendError(ServletOutputStream servletOutputStream, String string) throws IOException {
        servletOutputStream.println("Error=" + string);
    }

    public final boolean hasSessionCookie(Cookie[] cookieArray) {
        int n = cookieArray.length;
        for (int i = 0; i < n; ++i) {
            if (!this._sessionCookieName.equals(cookieArray[i].getName())) continue;
            return true;
        }
        return false;
    }

    private Vector verifyOneSSO(String string, String string2, String string3) {
        Vector<String> vector = new Vector<String>();
        try {
            URL uRL = new URL(string);
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.setDoOutput(true);
            httpURLConnection.setDoInput(true);
            httpURLConnection.setRequestMethod("GET");
            httpURLConnection.setRequestProperty("Accept-Language", "en");
            String string4 = string2 + "=" + URLEncoder.encode(string3);
            httpURLConnection.setRequestProperty("Cookie", string4);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream()));
            String string5 = null;
            while ((string5 = bufferedReader.readLine()) != null) {
                vector.addElement(string5);
            }
            httpURLConnection.disconnect();
        }
        catch (Exception exception) {
            return null;
        }
        if (vector.size() <= 0) {
            vector = null;
        }
        return vector;
    }

    private boolean isCredValid(Vector vector) {
        boolean bl = true;
        if (vector == null || vector.size() < 2) {
            return false;
        }
        for (int i = 0; i < vector.size(); ++i) {
            String string = (String)vector.elementAt(i);
            if (string.toLowerCase().indexOf("error") == -1) continue;
            bl = false;
            break;
        }
        return bl;
    }

    static class UWCPrincipal
    implements Principal {
        String name;

        UWCPrincipal(String string) {
            this.name = string;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            return object.toString().equals(this.name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }
    }
}

