/*
 * Decompiled with CFR 0.152.
 */
package com.sun.uwc.common.auth;

import com.sun.uwc.common.UWCApplicationHelper;
import com.sun.uwc.common.UWCException;
import com.sun.uwc.common.auth.GZIPResponseWrapper;
import com.sun.uwc.common.util.UWCLogger;
import com.sun.uwc.common.util.UWCPreferences;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class GZIPFilter
implements Filter {
    private static final Logger _logger = UWCLogger.getLogger("uwc");
    private static final String GZIP_CONFIG_PARAM = "uwc.gzipcompression";
    private String _useGZIPCompression;

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        UWCPreferences uWCPreferences;
        ((HttpServletResponse)servletResponse).setHeader("Cache-Control", "no-cache,no-store,max-age=0");
        ((HttpServletResponse)servletResponse).setDateHeader("Expires", 0L);
        ((HttpServletResponse)servletResponse).setHeader("Pragma", "No-cache");
        if (this._useGZIPCompression == null) {
            try {
                uWCPreferences = UWCApplicationHelper.getApplicationPreferences();
                if (uWCPreferences != null) {
                    this._useGZIPCompression = uWCPreferences.get(GZIP_CONFIG_PARAM, "false");
                }
            }
            catch (UWCException uWCException) {
                // empty catch block
            }
        }
        if (this._useGZIPCompression != null && this._useGZIPCompression.equalsIgnoreCase("true")) {
            if (_logger.isLoggable(Level.INFO)) {
                _logger.info("[--- GZIP support is enabled in config ----] ");
            }
            if (servletRequest instanceof HttpServletRequest) {
                uWCPreferences = (HttpServletRequest)servletRequest;
                HttpServletResponse httpServletResponse = (HttpServletResponse)servletResponse;
                String string = uWCPreferences.getHeader("accept-encoding");
                if (string != null && string.indexOf("gzip") != -1) {
                    GZIPResponseWrapper gZIPResponseWrapper = new GZIPResponseWrapper(httpServletResponse);
                    if (_logger.isLoggable(Level.INFO)) {
                        _logger.info("[--- Using GZIPResponseWrapper for this request as browser supports it  ----]");
                    }
                    filterChain.doFilter(servletRequest, (ServletResponse)gZIPResponseWrapper);
                    gZIPResponseWrapper.finishResponse();
                    return;
                }
            }
        }
        filterChain.doFilter(servletRequest, servletResponse);
    }

    public void init(FilterConfig filterConfig) {
    }

    public void destroy() {
    }
}

