/*
 * Decompiled with CFR 0.152.
 */
package com.sun.uwc.common;

import com.iplanet.jato.CompleteRequestException;
import com.iplanet.jato.RequestContext;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.util.NonSyncStringBuffer;
import com.sun.uwc.UWCServletBase;
import com.sun.uwc.common.UWCException;
import com.sun.uwc.common.UWCUserHelper;
import com.sun.uwc.common.ldap.LDAPPool;
import com.sun.uwc.common.util.UWCLogger;
import com.sun.uwc.common.util.UWCPreferences;
import com.sun.uwc.common.util.UWCUtils;
import java.util.Enumeration;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class UWCApplicationHelper {
    private static final Logger _log = UWCLogger.getLogger("uwc.common");
    private static UWCPreferences _appPref = null;
    private static UWCPreferences _appAuthPref = null;
    private static ServletContext _appContext;
    private static int _ldapAuthPort;
    private static String _ldapAuthHost;
    private static int _ugLdapPort;
    private static String _ugLdapHost;
    private static String _wcapProvider;
    private static int _wcapPort;
    private static String _wcapHost;
    private static LDAPPool _ldappool;
    private static String _mailHelpUrl;
    private static String _mailComposeUrl;
    private static String _abLogoutUrl;
    private static String _abServerUrl;
    private static String _abLoginUrl;
    private static Vector _invalidIdentityTokens;
    private static String _virtualDomainMode;
    private static String _mailCookieName;
    private static final String LOGIN_PAGE_URI = "/uwc/common/login.jsp";
    private static final String ERROR_PAGE_URI = "/base/SysError";
    private static final String DEFAULT_VIEW_URI = "base/UWCMain?forwardtodefview=true";
    private static final String DEFAULT_MESSAGE = "Application is unable to serve request. Contact your administrator.";
    private static final String IS_VIRTUAL_DOMAIN_ENABLED = "virtualdomain.mode";
    public static final boolean IS_SEVERE_LVL_LOGGABLE;
    public static final boolean IS_WARNING_LVL_LOGGABLE;
    public static final boolean IS_INFO_LVL_LOGGABLE;
    public static final boolean IS_FINE_LVL_LOGGABLE;
    public static final boolean IS_FINEST_LVL_LOGGABLE;

    private UWCApplicationHelper() {
    }

    public static void setApplicationContext(ServletContext servletContext) {
        _appContext = servletContext;
    }

    public static boolean isIdentityEnabled() {
        return UWCServletBase.isIdentityEnabled();
    }

    public static Vector getInvalidIdentityTokens() {
        return _invalidIdentityTokens;
    }

    public static UWCPreferences getApplicationPreferences() throws UWCException {
        if (null == _appPref) {
            _appPref = UWCServletBase.configMgr.getUWCConfigProperties();
        }
        return _appPref;
    }

    public static UWCPreferences getApplicationAuthPreferences() throws UWCException {
        if (null == _appAuthPref) {
            _appAuthPref = UWCServletBase.configMgr.getUWCAuthConfigProperties();
        }
        return _appAuthPref;
    }

    public static LDAPPool getLDAPPool() {
        if (null == _ldappool) {
            _ldappool = (LDAPPool)_appContext.getAttribute("com.sun.uwc.common.ldappool");
        }
        return _ldappool;
    }

    public static String getABURL() {
        block3: {
            if (null == _abServerUrl) {
                UWCPreferences uWCPreferences = null;
                try {
                    uWCPreferences = UWCApplicationHelper.getApplicationPreferences();
                    String string = uWCPreferences.get("ab.host", null);
                    String string2 = uWCPreferences.get("ab.port", null);
                    String string3 = uWCPreferences.get("ab.appcontextpath", null);
                    int n = uWCPreferences.getInt("uwc.enable.ssl", 0);
                    String string4 = "http" + (n == 1 ? "s" : "");
                    _abServerUrl = string4 + "://" + string + ":" + string2 + string3;
                }
                catch (UWCException uWCException) {
                    if (!IS_SEVERE_LVL_LOGGABLE) break block3;
                    _log.severe("\t Error in getting the Application preferences: " + uWCException.getMessage());
                }
            }
        }
        _log.finest("getABURL: Returning: " + _abServerUrl);
        return _abServerUrl;
    }

    public static String getABLogoutURL() {
        block3: {
            if (null == _abLogoutUrl) {
                UWCPreferences uWCPreferences = null;
                try {
                    uWCPreferences = UWCApplicationHelper.getApplicationPreferences();
                    String string = uWCPreferences.get("ab.host", null);
                    String string2 = uWCPreferences.get("ab.port", null);
                    String string3 = uWCPreferences.get("ab.appcontextpath", null);
                    int n = uWCPreferences.getInt("uwc.enable.ssl", 0);
                    String string4 = "http" + (n == 1 ? "s" : "");
                    _abLogoutUrl = string4 + "://" + string + ":" + string2 + "/" + string3 + "/logout.xml?";
                }
                catch (UWCException uWCException) {
                    if (!IS_SEVERE_LVL_LOGGABLE) break block3;
                    _log.severe("\t Error in getting the Application preferences: " + uWCException.getMessage());
                }
            }
        }
        return _abLogoutUrl;
    }

    public static String getContextURI(HttpServletRequest httpServletRequest) {
        String string = httpServletRequest.getContextPath();
        if (string.equals("/")) {
            string = "";
        }
        return string;
    }

    public static String getLogoutURL(HttpServletRequest httpServletRequest) {
        boolean bl = false;
        HttpSession httpSession = httpServletRequest.getSession(false);
        String string = (String)httpSession.getAttribute("mail.service.enabled");
        _log.finest("IS MAIL ENABLED" + string);
        if (!UWCApplicationHelper.isIdentityEnabled() && string != null && string.equalsIgnoreCase("true")) {
            Cookie[] cookieArray = httpServletRequest.getCookies();
            _log.finest("bna cookiname :" + UWCApplicationHelper.getMailCookieName());
            for (int i = 0; i < cookieArray.length; ++i) {
                _log.finest("bna cookie reading:" + cookieArray[i].getName());
                if (!cookieArray[i].getName().equalsIgnoreCase(UWCApplicationHelper.getMailCookieName())) continue;
                bl = true;
                break;
            }
        }
        if (bl) {
            return UWCApplicationHelper.getMailLogoutURL(httpServletRequest);
        }
        return UWCApplicationHelper.getContextURI(httpServletRequest) + "/base/UWCMain?op=logout";
    }

    public static String getMailLogoutURL(HttpServletRequest httpServletRequest) {
        return UWCApplicationHelper.getMailURL(httpServletRequest) + "/cmd.msc?mbox=&cmd=logout&laurel=on&sid=";
    }

    public static String getABLoginURL() {
        block3: {
            if (null == _abLoginUrl) {
                UWCPreferences uWCPreferences = null;
                try {
                    uWCPreferences = UWCApplicationHelper.getApplicationPreferences();
                    String string = uWCPreferences.get("ab.host", null);
                    String string2 = uWCPreferences.get("ab.port", null);
                    String string3 = uWCPreferences.get("ab.appcontextpath", null);
                    int n = uWCPreferences.getInt("uwc.enable.ssl", 0);
                    String string4 = "http" + (n == 1 ? "s" : "");
                    _abLoginUrl = string4 + "://" + string + ":" + string2 + "/" + string3 + "/login.xml?";
                }
                catch (UWCException uWCException) {
                    _abLoginUrl = null;
                    if (!IS_SEVERE_LVL_LOGGABLE) break block3;
                    _log.severe("\t Error in getting the Application preferences: " + uWCException.getMessage());
                }
            }
        }
        return _abLoginUrl;
    }

    public static String getMailURL(HttpServletRequest httpServletRequest) {
        String string;
        block3: {
            string = null;
            String string2 = httpServletRequest.getHeader("Host");
            int n = string2.indexOf(":");
            if (n != -1) {
                string2 = string2.substring(0, n);
            }
            UWCPreferences uWCPreferences = null;
            try {
                uWCPreferences = UWCApplicationHelper.getApplicationPreferences();
                String string3 = uWCPreferences.get("webmail.port", null);
                uWCPreferences = UWCApplicationHelper.getApplicationAuthPreferences();
                boolean bl = uWCPreferences.getBoolean("uwcauth.ssl.enabled", false);
                String string4 = "http" + (bl ? "s" : "");
                string = string4 + "://" + string2 + ":" + string3;
            }
            catch (UWCException uWCException) {
                string = null;
                if (!IS_SEVERE_LVL_LOGGABLE) break block3;
                _log.severe("\t Error in getting the Application preferences: " + uWCException.getMessage());
            }
        }
        return string;
    }

    public static String getMailLoginURL(RequestContext requestContext) {
        String string = UWCApplicationHelper.getMailURL(requestContext.getRequest());
        HttpSession httpSession = requestContext.getRequest().getSession(false);
        String string2 = (String)httpSession.getAttribute("calendar.service.enabled");
        string = string2 != null && string2.equalsIgnoreCase("true") ? string + "?argv=laurel=on%26cal=1" : string + "?argv=laurel=on%26cal=0";
        return string;
    }

    public static String getMailHelpURL(RequestContext requestContext) {
        if (null == _mailHelpUrl) {
            _mailHelpUrl = UWCApplicationHelper.getMailURL(requestContext.getRequest());
            _mailHelpUrl = _mailHelpUrl + "/" + UWCUserHelper.getPreferredLanguage(requestContext) + "/help/topics.html";
        }
        return _mailHelpUrl;
    }

    public static String getMailComposeURL() {
        block4: {
            if (null == _mailComposeUrl) {
                UWCPreferences uWCPreferences = null;
                try {
                    uWCPreferences = UWCApplicationHelper.getApplicationPreferences();
                    String string = uWCPreferences.get("webmail.host", null);
                    String string2 = uWCPreferences.get("webmail.port", null);
                    int n = uWCPreferences.getInt("uwc.enable.ssl", 0);
                    String string3 = "http" + (n == 1 ? "s" : "");
                    if (string != null && string2 != null) {
                        _mailComposeUrl = string3 + "://" + string + ":" + string2 + "?argv=view=compose&argv=laurel=on";
                    }
                }
                catch (UWCException uWCException) {
                    if (!IS_SEVERE_LVL_LOGGABLE) break block4;
                    _log.severe("\t Error in getting the Application preferences: " + uWCException.getMessage());
                }
            }
        }
        return _mailComposeUrl;
    }

    public static String getWCAPHost() {
        block3: {
            if (null == _wcapHost) {
                try {
                    _wcapHost = UWCApplicationHelper.getApplicationPreferences().get("calendar.wcap.host", null);
                }
                catch (UWCException uWCException) {
                    if (!IS_SEVERE_LVL_LOGGABLE) break block3;
                    _log.severe("\t Error in getting the Application preferences: " + uWCException.getMessage());
                }
            }
        }
        return _wcapHost;
    }

    public static int getWCAPPort() {
        block3: {
            if (-1 == _wcapPort) {
                try {
                    _wcapPort = UWCApplicationHelper.getApplicationPreferences().getInt("calendar.wcap.port", -1);
                }
                catch (UWCException uWCException) {
                    if (!IS_SEVERE_LVL_LOGGABLE) break block3;
                    _log.severe("\t Error in getting the Application preferences: " + uWCException.getMessage());
                }
            }
        }
        return _wcapPort;
    }

    public static String getWCAPProvider() {
        block3: {
            if (null == _wcapProvider) {
                try {
                    _wcapProvider = UWCApplicationHelper.getApplicationPreferences().get("calendar.jcapi.serviceclass.socs", null);
                }
                catch (UWCException uWCException) {
                    if (!IS_SEVERE_LVL_LOGGABLE) break block3;
                    _log.severe("\t Error in getting the Application preferences: " + uWCException.getMessage());
                }
            }
        }
        return _wcapProvider;
    }

    public static String getMailCookieName() {
        block3: {
            if (null == _mailCookieName) {
                String string = null;
                String string2 = null;
                try {
                    string = UWCApplicationHelper.getApplicationAuthPreferences().get("uwcauth.appprefix", "ssogrp1");
                    string2 = UWCApplicationHelper.getApplicationAuthPreferences().get("messagingsso.appid", "ims");
                    _mailCookieName = string + "-" + string2;
                }
                catch (UWCException uWCException) {
                    if (!IS_SEVERE_LVL_LOGGABLE) break block3;
                    _log.severe("\t Error in getting the Application preferences: " + uWCException.getMessage());
                }
            }
        }
        return _mailCookieName;
    }

    public static String getLDAPAuthHost() {
        block3: {
            if (null == _ldapAuthHost) {
                try {
                    _ldapAuthHost = UWCApplicationHelper.getApplicationAuthPreferences().get("ldapauth.ldaphost", null);
                }
                catch (UWCException uWCException) {
                    if (!IS_SEVERE_LVL_LOGGABLE) break block3;
                    _log.severe("\t Error in getting the Application preferences: " + uWCException.getMessage());
                }
            }
        }
        return _ldapAuthHost;
    }

    public static int getLDAPAuthPort() {
        block3: {
            if (-1 == _ldapAuthPort) {
                try {
                    _ldapAuthPort = UWCApplicationHelper.getApplicationAuthPreferences().getInt("ldapauth.ldapport", 389);
                }
                catch (UWCException uWCException) {
                    if (!IS_SEVERE_LVL_LOGGABLE) break block3;
                    _log.severe("\t Error in getting the Application preferences: " + uWCException.getMessage());
                }
            }
        }
        return _ldapAuthPort;
    }

    public static String getUserGroupLdapHost() {
        block3: {
            if (null == _ugLdapHost) {
                try {
                    _ugLdapHost = UWCApplicationHelper.getApplicationAuthPreferences().get("ldapusersession.ldaphost", null);
                }
                catch (UWCException uWCException) {
                    if (!IS_SEVERE_LVL_LOGGABLE) break block3;
                    _log.severe("\t Error in getting the Application preferences: " + uWCException.getMessage());
                }
            }
        }
        return _ugLdapHost;
    }

    public static int getUserGroupLdapPort() {
        block3: {
            if (-1 == _ugLdapPort) {
                try {
                    _ugLdapPort = UWCApplicationHelper.getApplicationAuthPreferences().getInt("ldapusersession.ldapport", 389);
                }
                catch (UWCException uWCException) {
                    if (!IS_SEVERE_LVL_LOGGABLE) break block3;
                    _log.severe("\t Error in getting the Application preferences: " + uWCException.getMessage());
                }
            }
        }
        return _ugLdapPort;
    }

    public static void gotoErrorView(RequestContext requestContext, String string, String string2) throws ModelControlException {
        UWCApplicationHelper.gotoErrorView(requestContext, string, string2, false);
    }

    public static void gotoErrorView(RequestContext requestContext, String string, String string2, boolean bl) throws ModelControlException {
        try {
            if (bl) {
                requestContext.getRequest().setAttribute("ispopup", (Object)"true");
            }
            UWCApplicationHelper.forwardToErrorPage(requestContext, string, string2);
        }
        catch (ServletException servletException) {
            String string3;
            if (IS_WARNING_LVL_LOGGABLE) {
                _log.warning("forwardToErrorPage() failed with exception: " + (Object)((Object)servletException));
            }
            if (null == (string3 = UWCUserHelper.getLocalizedLabel(requestContext, string, string2))) {
                string3 = UWCUserHelper.getLocalizedLabel(requestContext, "cant-serve-request", "uwc-common-error-");
            }
            if (null == string3) {
                string3 = DEFAULT_MESSAGE;
            }
            throw new ModelControlException(string3);
        }
    }

    public static void forwardToErrorPage(RequestContext requestContext, String string, String string2) throws ServletException {
        String string3 = UWCUserHelper.getLocalizedLabel(requestContext, string, string2);
        if (null == string3) {
            string3 = UWCUserHelper.getLocalizedLabel(requestContext, "cant-serve-request", "uwc-common-error-");
        }
        if (null == string3) {
            string3 = DEFAULT_MESSAGE;
        }
        requestContext.getRequest().setAttribute("UWCFullPageErrorDescription", (Object)string3);
        UWCApplicationHelper.forwardToURI(requestContext, ERROR_PAGE_URI);
    }

    public static void forwardToErrorPage(RequestContext requestContext, String string) {
        try {
            String string2 = UWCUserHelper.getLocalizedLabel(requestContext, string, "uwc-common-error-");
            if (string2 == null && (string2 = UWCUserHelper.getLocalizedLabel(requestContext, "cant-serve-request", "uwc-common-error-")) == null) {
                string2 = DEFAULT_MESSAGE;
            }
            requestContext.getRequest().setAttribute("UWCFullPageErrorDescription", (Object)string2);
            UWCApplicationHelper.forwardToURI(requestContext, ERROR_PAGE_URI);
        }
        catch (ServletException servletException) {
            _log.info("[Error:forwardtoErrorPage] - We got error here");
        }
    }

    public static void redirectToLogin(RequestContext requestContext) throws ServletException {
        String string = requestContext.getRequest().getContextPath() + LOGIN_PAGE_URI;
        UWCApplicationHelper.redirectToURL(requestContext, string);
    }

    public static void redirectToURL(RequestContext requestContext, String string, String string2) throws ServletException {
        UWCApplicationHelper.redirectToURL(requestContext, string + ":" + string2);
    }

    public static void redirectToURL(RequestContext requestContext, String string) throws ServletException {
        try {
            HttpServletResponse httpServletResponse = requestContext.getResponse();
            httpServletResponse.sendRedirect(string);
        }
        catch (Exception exception) {
            throw new ServletException(exception.getMessage());
        }
        finally {
            throw new CompleteRequestException();
        }
    }

    public static void redirectToURI(RequestContext requestContext, String string) throws ServletException {
        String string2 = UWCUtils.getContextPathPrefix(requestContext) + string;
        UWCApplicationHelper.redirectToURL(requestContext, string2);
    }

    public static void forwardToURI(RequestContext requestContext, String string) throws ServletException {
        UWCApplicationHelper.forwardToURL(requestContext, string);
    }

    public static void forwardToURL(RequestContext requestContext, String string) throws ServletException {
        try {
            HttpServletResponse httpServletResponse = requestContext.getResponse();
            HttpServletRequest httpServletRequest = requestContext.getRequest();
            httpServletRequest.getRequestDispatcher(string).forward((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
        }
        catch (Exception exception) {
            throw new ServletException(exception.getMessage());
        }
        finally {
            throw new CompleteRequestException();
        }
    }

    public static void redirectToDefaultView(RequestContext requestContext, boolean bl) throws ModelControlException {
        try {
            String string;
            NonSyncStringBuffer nonSyncStringBuffer = new NonSyncStringBuffer(DEFAULT_VIEW_URI);
            if (bl && (string = UWCApplicationHelper.getQueryString(requestContext.getRequest(), false)) != null && string.length() > 0) {
                nonSyncStringBuffer.append("&");
                nonSyncStringBuffer.append(string);
            }
            UWCApplicationHelper.redirectToURI(requestContext, nonSyncStringBuffer.toString());
            return;
        }
        catch (ServletException servletException) {
            throw new ModelControlException(servletException.getMessage());
        }
    }

    public static String getQueryString(HttpServletRequest httpServletRequest, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = httpServletRequest.getParameterNames();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                if (bl && stringBuffer.indexOf("?") < 0) {
                    stringBuffer.append("?");
                }
                String string = (String)enumeration.nextElement();
                stringBuffer.append(string);
                stringBuffer.append("=");
                stringBuffer.append(httpServletRequest.getParameter(string));
                stringBuffer.append("&");
            }
            int n = stringBuffer.length();
            if (n > 0) {
                return new String(stringBuffer.substring(0, n - 1));
            }
        }
        return new String(stringBuffer);
    }

    public static boolean isVirtualDomainEnabled() {
        UWCPreferences uWCPreferences;
        if (_virtualDomainMode == null && (uWCPreferences = UWCServletBase.configMgr.getUWCAuthConfigProperties()) != null) {
            _virtualDomainMode = new String(uWCPreferences.get(IS_VIRTUAL_DOMAIN_ENABLED, "n"));
        }
        if (_virtualDomainMode != null) {
            _virtualDomainMode = _virtualDomainMode.trim();
        }
        return _virtualDomainMode.equalsIgnoreCase("y");
    }

    static {
        _ldapAuthPort = -1;
        _ldapAuthHost = null;
        _ugLdapPort = -1;
        _ugLdapHost = null;
        _wcapProvider = null;
        _wcapPort = -1;
        _wcapHost = null;
        _ldappool = null;
        _mailHelpUrl = null;
        _mailComposeUrl = null;
        _abLogoutUrl = null;
        _abServerUrl = null;
        _abLoginUrl = null;
        _invalidIdentityTokens = new Vector();
        _virtualDomainMode = null;
        _mailCookieName = null;
        IS_SEVERE_LVL_LOGGABLE = _log.isLoggable(Level.SEVERE);
        IS_WARNING_LVL_LOGGABLE = _log.isLoggable(Level.WARNING);
        IS_INFO_LVL_LOGGABLE = _log.isLoggable(Level.INFO);
        IS_FINE_LVL_LOGGABLE = _log.isLoggable(Level.FINE);
        IS_FINEST_LVL_LOGGABLE = _log.isLoggable(Level.FINEST);
    }
}

