/*
 * Decompiled with CFR 0.152.
 */
package com.sun.uwc.calclient.model;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.RequestParticipant;
import com.iplanet.jato.model.DefaultModel;
import com.iplanet.jato.model.InsertingModel;
import com.iplanet.jato.model.InvalidContextException;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.model.ModelExecutionContext;
import com.sun.comclient.calendar.CalendarStore;
import com.sun.comclient.calendar.DateTime;
import com.sun.comclient.calendar.Organizer;
import com.sun.comclient.calendar.RecurrencePattern;
import com.sun.comclient.calendar.VAlarm;
import com.sun.comclient.calendar.VTodo;
import com.sun.comclient.calendar.socs.SOCSTodo;
import com.sun.uwc.calclient.model.CalendarBaseModel;
import com.sun.uwc.common.UWCException;
import com.sun.uwc.common.UWCUserHelper;
import com.sun.uwc.common.model.CalendarExecutionModelContext;
import com.sun.uwc.common.model.UWCModelControlException;
import com.sun.uwc.common.util.UWCConstants;
import com.sun.uwc.common.util.UWCLogger;
import com.sun.uwc.common.util.UWCUtils;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TasksModel
extends DefaultModel
implements InsertingModel,
RequestParticipant {
    private VTodo _currentTodo = null;
    private String _todoUid = null;
    private String _todoRid = null;
    private String _calId = null;
    private VAlarm _alarm = null;
    private Organizer _organizer = null;
    private RecurrencePattern _recurrence = null;
    private int _percent = -1;
    private DateTime _dueDate = null;
    private DateTime _startDate = null;
    private String _modifier = null;
    private static final String CLASS_NAME = "TasksModel";
    private static Logger _log = null;
    protected RequestContext _reqCtx = null;
    public static final String calendarTaskPrivacyPrefix = "uwc-calclient-task-classification-";
    public static final String[] calendarTaskPrivacyNames = new String[]{"PUBLIC", "PRIVATE", "CONFIDENTIAL"};
    public static final String[] calendarTaskPrivacyValues = new String[]{"PUBLIC", "PRIVATE", "CONFIDENTIAL"};
    public static final String calendarTaskPercentPrefix = "uwc-calclient-task-percent-";
    public static final String[] calendarTaskPercentNames = new String[]{"0%(Not Started)", "25%", "50%", "75%", "100% (Completed)"};
    public static final String[] calendarTaskPercentValues = new String[]{"0", "25", "50", "75", "100"};
    private static final String _defaultPercent = "0";
    public static final String FIELD_TITLE = "Title";
    public static final String FIELD_CALID = "calid";
    public static final String FIELD_TIME_ZONE = "timezone";
    public static final String FIELD_TASK_UID = "todoUid";
    public static final String FIELD_TASK_RID = "todoRid";
    public static final String FIELD_NO_DUE_DATE = "NoDueDate";
    public static final String FIELD_DUE_DATE_MONTH = "DueDateMonth";
    public static final String FIELD_DUE_DATE_DAY = "DueDateDay";
    public static final String FIELD_DUE_DATE_YEAR = "DueDateYear";
    public static final String FIELD_START_DATE_MONTH = "StartDateMonth";
    public static final String FIELD_START_DATE_DAY = "StartDateDay";
    public static final String FIELD_START_DATE_YEAR = "StartDateYear";
    public static final String FIELD_NO_DUE_TIME = "NoDueTime";
    public static final String FIELD_DUE_TIME_HOUR = "DueTimeHour";
    public static final String FIELD_DUE_TIME_MINUTE = "DueTimeMinute";
    public static final String FIELD_DISPLAYABLE_START_DATE = "DisplayableStartDate";
    public static final String FIELD_DISPLAYABLE_DUE_DATE = "DisplayableDueDate";
    public static final String FIELD_DISPLAYABLE_DUE_TIME = "DisplayableDueTime";
    public static final String FIELD_CATEGORY = "Category";
    public static final String FIELD_PRIORITY = "Priority";
    public static final String FIELD_PERCENT = "Percent";
    public static final String FIELD_PRIVACY = "Privacy";
    public static final String FIELD_LOCATION = "Location";
    public static final String FIELD_DESCRIPTION = "Description";
    public static final String FIELD_ORGANIZER = "OrganizerDisplayName";
    public static final String FIELD_IS_RECURRING = "IsRecurring";
    public static final String FIELD_HAS_ALARM = "HasAlarm";
    public static final String FIELD_IS_PUBLIC = "IsPublic";
    public static final String FIELD_ORIG_START_DATE = "origStartDate";
    public static final String FIELD_ORIG_DUE_DATE = "origDueDate";
    public static final String FIELD_ORIG_RRULE = "origRRule";

    public TasksModel() {
    }

    public TasksModel(String string) {
        super(string);
    }

    public void setRequestContext(RequestContext requestContext) {
        this._reqCtx = requestContext;
    }

    public VTodo getCurrentTask() {
        return this._currentTodo;
    }

    public void setCurrentTask(VTodo vTodo) {
        this._currentTodo = vTodo;
        this._todoUid = null;
    }

    public String getTaskUID() {
        return this._todoUid;
    }

    public void setTaskUID(String string) {
        this._todoUid = string;
        this._currentTodo = null;
    }

    public String getTaskRID() {
        return this._todoRid;
    }

    public void setTaskRID(String string) {
        this._todoRid = string;
    }

    public void setCalId(String string) {
        this._calId = string;
    }

    public int getPercent() {
        return this._percent;
    }

    public void setPercent(int n) {
        this._percent = n;
    }

    public VAlarm getAlarm() {
        return this._alarm;
    }

    public void setAlarm(VAlarm vAlarm) {
        this._alarm = vAlarm;
    }

    public RecurrencePattern getRecurrencePattern() {
        return this._recurrence;
    }

    public void setRecurrencePattern(RecurrencePattern recurrencePattern) {
        this._recurrence = recurrencePattern;
    }

    public String getRecurrenceModifier() {
        return this._modifier;
    }

    public void setRecurrenceModifier(String string) {
        this._modifier = string;
    }

    public Organizer getOrganizer() {
        return this._organizer;
    }

    public DateTime getDueDate() {
        return this._dueDate;
    }

    public void setDefaultDates(DateTime dateTime) {
        this._dueDate = dateTime;
        this._startDate = (DateTime)dateTime.clone();
    }

    public Object execute(ModelExecutionContext modelExecutionContext) throws ModelControlException {
        throw new UWCModelControlException((Throwable)new InvalidContextException("Cuurently TasksModel doesn't support any Execute Contexts"));
    }

    public Object retrieve(ModelExecutionContext modelExecutionContext) throws ModelControlException {
        String string = null;
        string = null != modelExecutionContext ? modelExecutionContext.getOperationName() : CalendarExecutionModelContext.LOAD_TODO_CONTEXT;
        if (string.equals(CalendarExecutionModelContext.LOAD_TODO_CONTEXT)) {
            try {
                this.loadTask();
            }
            catch (UWCException uWCException) {
                UWCUtils.printStackTrace(uWCException);
                throw new UWCModelControlException(uWCException.getReason());
            }
        }
        if (string.equals(CalendarExecutionModelContext.LOAD_TODO_DEFAULTS_CONTEXT)) {
            try {
                this.loadTaskDefaults();
            }
            catch (UWCException uWCException) {
                UWCUtils.printStackTrace(uWCException);
                throw new UWCModelControlException(uWCException.getReason(), uWCException.getDetails());
            }
        }
        return null;
    }

    public Object insert(ModelExecutionContext modelExecutionContext) throws ModelControlException {
        String string = null;
        string = null != modelExecutionContext ? modelExecutionContext.getOperationName() : CalendarExecutionModelContext.ADD_TODO_CONTEXT;
        if (string.equals(CalendarExecutionModelContext.ADD_TODO_CONTEXT)) {
            try {
                this.addTask();
            }
            catch (UWCException uWCException) {
                throw new UWCModelControlException(uWCException.getReason());
            }
        }
        if (string.equals(CalendarExecutionModelContext.MODIFY_TODO_CONTEXT)) {
            try {
                this.modifyTask(this._modifier, false);
            }
            catch (UWCException uWCException) {
                throw new UWCModelControlException(uWCException.getReason());
            }
        }
        if (string.equals(CalendarExecutionModelContext.UPDATE_TODO_CONTEXT)) {
            try {
                this.updateTask();
            }
            catch (UWCException uWCException) {
                throw new UWCModelControlException(uWCException.getReason());
            }
        }
        if (string.equals(CalendarExecutionModelContext.DELETE_TODO_CONTEXT)) {
            try {
                this.deleteTask(this._modifier, false);
            }
            catch (UWCException uWCException) {
                throw new UWCModelControlException(uWCException.getReason());
            }
        }
        return null;
    }

    private void loadTask() throws UWCException, ModelControlException {
        try {
            RecurrencePattern[] recurrencePatternArray;
            String string;
            Object[] objectArray;
            CalendarBaseModel calendarBaseModel;
            this._alarm = null;
            this._recurrence = null;
            this._organizer = null;
            TimeZone timeZone = null;
            if (null != this._todoUid) {
                calendarBaseModel = UWCUserHelper.getCalendarBaseModel(this._reqCtx);
                if (null == calendarBaseModel) {
                    if (_log.isLoggable(Level.SEVERE)) {
                        _log.severe("Couldn't get CalendarBaseModel: Can't retrieve the task object for taskUID \"" + this._todoUid + "\"");
                    }
                    throw new UWCException(62);
                }
                if (null == this._calId) {
                    if (_log.isLoggable(Level.SEVERE)) {
                        _log.severe("null Calid : Can't retrieve the task object for taskUID \"" + this._todoUid + "\"");
                    }
                    throw new UWCException(5);
                }
                calendarBaseModel.removeAllCalids();
                calendarBaseModel.addCalid(this._calId);
                calendarBaseModel.setComponentUID(this._todoUid);
                if (null != this._todoRid) {
                    calendarBaseModel.setComponentRID(this._todoRid);
                }
                calendarBaseModel.execute((ModelExecutionContext)new CalendarExecutionModelContext(CalendarExecutionModelContext.FETCH_TODO_BY_ID_CONTEXT));
                ArrayList arrayList = calendarBaseModel.getAllTodos();
                timeZone = calendarBaseModel.getTimeZone();
                if (null != arrayList && arrayList.size() > 0) {
                    this._currentTodo = (VTodo)arrayList.get(0);
                }
            }
            if (null == this._currentTodo) {
                if (_log.isLoggable(Level.SEVERE)) {
                    _log.severe("Current Todo object is null: Can't load the todo data");
                }
                return;
            }
            calendarBaseModel = null;
            boolean bl = this._currentTodo.hasProperty("DUE");
            if (bl) {
                calendarBaseModel = this._currentTodo.getEnd();
            }
            DateTime dateTime = null;
            boolean bl2 = this._currentTodo.hasProperty("DTSTART");
            if (bl2) {
                dateTime = this._currentTodo.getStart();
            }
            boolean bl3 = false;
            String string2 = null;
            String string3 = null;
            String string4 = null;
            String string5 = null;
            String string6 = null;
            String string7 = null;
            String string8 = null;
            String string9 = null;
            String string10 = UWCUserHelper.getUserPrefModel(this._reqCtx).getTimeFormat();
            String string11 = UWCUserHelper.getUserPrefModel(this._reqCtx).getDateFormat();
            String string12 = UWCUserHelper.getUserPrefModel(this._reqCtx).getDateDelimiter();
            if (null != calendarBaseModel && bl) {
                this._dueDate = calendarBaseModel;
                string5 = UWCConstants.monthValues[calendarBaseModel.getMonth()];
                string6 = UWCConstants.dayValues[calendarBaseModel.getDay() - 1];
                string7 = UWCConstants.yearValues[calendarBaseModel.getYear() - 2000];
                if (!this._currentTodo.isAllDay()) {
                    bl3 = true;
                    string8 = UWCUtils.getHoursValue((DateTime)calendarBaseModel, string10);
                    string9 = UWCUtils.getMinutesValue((DateTime)calendarBaseModel, string10);
                } else {
                    bl3 = false;
                    calendarBaseModel.setTime(0, 0, 0);
                }
            }
            if (null != dateTime && bl2) {
                if (!bl3) {
                    dateTime.setTime(0, 0, 0);
                }
                this.setValue(FIELD_ORIG_START_DATE, dateTime.toISOString());
                string2 = UWCConstants.monthValues[dateTime.getMonth()];
                string3 = UWCConstants.dayValues[dateTime.getDay() - 1];
                string4 = UWCConstants.yearValues[dateTime.getYear() - 2000];
            }
            this.setValue(FIELD_TITLE, this._currentTodo.getSummary());
            this.setValue(FIELD_CALID, this._currentTodo.getCalID());
            if (bl2) {
                this.setValue(FIELD_START_DATE_MONTH, string2);
                this.setValue(FIELD_START_DATE_DAY, string3);
                this.setValue(FIELD_START_DATE_YEAR, string4);
                objectArray = UWCUtils.getDisplayableDate(this._reqCtx, dateTime, string11, string12);
                this.setValue(FIELD_DISPLAYABLE_START_DATE, objectArray);
            } else {
                this.setValue(FIELD_START_DATE_MONTH, null);
                this.setValue(FIELD_START_DATE_DAY, null);
                this.setValue(FIELD_START_DATE_YEAR, null);
                this.setValue(FIELD_DISPLAYABLE_START_DATE, null);
            }
            if (bl) {
                this.setValue(FIELD_DUE_DATE_MONTH, string5);
                this.setValue(FIELD_DUE_DATE_DAY, string6);
                this.setValue(FIELD_DUE_DATE_YEAR, string7);
                this.setValue(FIELD_NO_DUE_DATE, "false");
                objectArray = UWCUtils.getDisplayableDate(this._reqCtx, (DateTime)calendarBaseModel, string11, string12);
                this.setValue(FIELD_DISPLAYABLE_DUE_DATE, objectArray);
                if (bl3) {
                    this.setValue(FIELD_DUE_TIME_HOUR, string8);
                    this.setValue(FIELD_DUE_TIME_MINUTE, string9);
                    this.setValue(FIELD_NO_DUE_TIME, "false");
                    string = UWCUtils.getDisplayableTime(this._reqCtx, (DateTime)calendarBaseModel, string10);
                    this.setValue(FIELD_DISPLAYABLE_DUE_TIME, string);
                } else {
                    this.setValue(FIELD_DUE_TIME_HOUR, null);
                    this.setValue(FIELD_DUE_TIME_MINUTE, null);
                    this.setValue(FIELD_NO_DUE_TIME, "true");
                    this.setValue(FIELD_DISPLAYABLE_DUE_TIME, null);
                }
                this.setValue(FIELD_ORIG_DUE_DATE, calendarBaseModel.toISOString());
            } else {
                this.setValue(FIELD_NO_DUE_DATE, "true");
                this.setValue(FIELD_NO_DUE_TIME, "true");
                this.setValue(FIELD_DUE_DATE_MONTH, null);
                this.setValue(FIELD_DUE_DATE_DAY, null);
                this.setValue(FIELD_DUE_DATE_YEAR, null);
                this.setValue(FIELD_DUE_TIME_HOUR, null);
                this.setValue(FIELD_DUE_TIME_MINUTE, null);
                this.setValue(FIELD_DISPLAYABLE_DUE_DATE, null);
                this.setValue(FIELD_DISPLAYABLE_DUE_TIME, null);
            }
            objectArray = this._currentTodo.getCategories();
            if (objectArray == null) {
                objectArray = new String[]{"Other"};
            }
            this.setValues(FIELD_CATEGORY, objectArray);
            this.setValue(FIELD_PRIVACY, this._currentTodo.getClassification());
            this.setValue(FIELD_LOCATION, this._currentTodo.getLocation());
            this.setValue(FIELD_DESCRIPTION, this._currentTodo.getDescription());
            this.setValue(FIELD_TASK_UID, this._currentTodo.getID());
            string = this._currentTodo.getRecurrenceID();
            if (string != null) {
                this.setValue(FIELD_TASK_RID, string.toISO8601());
            } else {
                this.setValue(FIELD_TASK_RID, null);
            }
            String string13 = Integer.toString(this._currentTodo.getPercent());
            this.setValue(FIELD_PERCENT, string13);
            int n = this._currentTodo.getPriority();
            n = this.getPriorityFromMap(n);
            String string14 = Integer.toString(n);
            this.setValue(FIELD_PRIORITY, string14);
            VAlarm[] vAlarmArray = this._currentTodo.getAlarmComponents();
            if (null != vAlarmArray) {
                this._alarm = vAlarmArray[0];
            }
            if (null != (recurrencePatternArray = this._currentTodo.getRecurrenceRules())) {
                this._recurrence = recurrencePatternArray[0];
                this.setValue(FIELD_ORIG_RRULE, this._recurrence.toRFC2445());
            }
            this.setValue(FIELD_IS_RECURRING, this._currentTodo.isRecurring() ? "true" : "false");
            this.setValue(FIELD_HAS_ALARM, this._currentTodo.hasAlarm() ? "true" : "false");
            this.setValue(FIELD_IS_PUBLIC, this._currentTodo.isPublic() ? "true" : "false");
            this.setValue(FIELD_TIME_ZONE, null == timeZone ? null : timeZone.getID());
            this._organizer = this._currentTodo.getOrganizer();
            String string15 = null;
            if (null != this._organizer && null == (string15 = this._organizer.getCommonName())) {
                string15 = this._organizer.getValue();
            }
            this.setValue(FIELD_ORGANIZER, string15);
            if (_log.isLoggable(Level.FINEST)) {
                _log.finest("loadTask: todo _calId: " + this._calId);
                _log.finest("loadTask: todo FIELD_CALID: " + (String)this.getValue(FIELD_CALID));
                _log.finest("loadTask: dump todo \n: " + ((SOCSTodo)this._currentTodo).toRFC2445());
                this.dumpValues();
            }
        }
        catch (UWCException uWCException) {
            if (_log.isLoggable(Level.SEVERE)) {
                _log.severe("Error while loading the task, Couldn't load the task.  Reason: " + uWCException.getMessage());
            }
            throw uWCException;
        }
        catch (Exception exception) {
            if (_log.isLoggable(Level.SEVERE)) {
                _log.severe("Error while loading the task, Couldn't load the task.  Reason: " + exception.getMessage());
            }
            throw new UWCException(63);
        }
    }

    public void dumpValues() {
    }

    private void loadTaskDefaults() throws UWCException, ModelControlException {
        try {
            CalendarBaseModel calendarBaseModel = UWCUserHelper.getCalendarBaseModel(this._reqCtx);
            String string = UWCUserHelper.getUserPrefModel(this._reqCtx).getTimeFormat();
            String string2 = UWCUserHelper.getUserPrefModel(this._reqCtx).getDateFormat();
            String string3 = UWCUserHelper.getUserPrefModel(this._reqCtx).getDateDelimiter();
            String string4 = UWCUserHelper.getCalUserPrefModel(this._reqCtx).getDefaultCategory();
            TimeZone timeZone = this.getTaskTimeZone(true);
            if (null == this._dueDate) {
                this._dueDate = new DateTime(timeZone);
            }
            if (null == this._startDate) {
                this._startDate = new DateTime(timeZone);
            }
            String string5 = null;
            String string6 = null;
            String string7 = null;
            string5 = UWCConstants.monthValues[this._startDate.getMonth()];
            string6 = UWCConstants.dayValues[this._startDate.getDay() - 1];
            string7 = UWCConstants.yearValues[this._startDate.getYear() - 2000];
            this.setValue(FIELD_START_DATE_MONTH, string5);
            this.setValue(FIELD_START_DATE_DAY, string6);
            this.setValue(FIELD_START_DATE_YEAR, string7);
            String string8 = UWCUtils.getDisplayableDate(this._reqCtx, this._dueDate, string2, string3);
            this.setValue(FIELD_DISPLAYABLE_START_DATE, string8);
            String string9 = null;
            String string10 = null;
            String string11 = null;
            String string12 = null;
            String string13 = null;
            string9 = UWCConstants.monthValues[this._dueDate.getMonth()];
            string10 = UWCConstants.dayValues[this._dueDate.getDay() - 1];
            string11 = UWCConstants.yearValues[this._dueDate.getYear() - 2000];
            this.setValue(FIELD_DUE_DATE_MONTH, string9);
            this.setValue(FIELD_DUE_DATE_DAY, string10);
            this.setValue(FIELD_DUE_DATE_YEAR, string11);
            this.setValue(FIELD_NO_DUE_DATE, "false");
            String string14 = UWCUtils.getDisplayableDate(this._reqCtx, this._dueDate, string2, string3);
            this.setValue(FIELD_DISPLAYABLE_DUE_DATE, string14);
            this.setValue(FIELD_NO_DUE_TIME, "false");
            DateTime dateTime = (DateTime)this._dueDate.clone();
            string12 = UWCUtils.getHoursValue(dateTime, string);
            string13 = UWCUtils.getMinutesValue(dateTime, string);
            this.setValue(FIELD_DUE_TIME_HOUR, string12);
            this.setValue(FIELD_DUE_TIME_MINUTE, string13);
            this.setValue(FIELD_NO_DUE_TIME, "false");
            String string15 = UWCUtils.getDisplayableTime(this._reqCtx, dateTime, string);
            this.setValue(FIELD_DISPLAYABLE_DUE_TIME, string15);
            String string16 = "PRIVATE";
            this.setValue(FIELD_PRIVACY, string16);
            this.setValue(FIELD_PERCENT, _defaultPercent);
            this.setValue(FIELD_PRIORITY, null);
            this.setValue(FIELD_TITLE, null);
            this.setValue(FIELD_DESCRIPTION, null);
            this.setValue(FIELD_LOCATION, null);
            this.setValue(FIELD_CATEGORY, string4);
            this.setValue(FIELD_TASK_RID, null);
            this.setValue(FIELD_IS_RECURRING, "false");
            this.setValue(FIELD_HAS_ALARM, "false");
            this.setValue(FIELD_IS_PUBLIC, "false");
            this._recurrence = null;
            this._alarm = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void addTask() throws UWCException {
        CalendarBaseModel calendarBaseModel = UWCUserHelper.getCalendarBaseModel(this._reqCtx);
        if (null == calendarBaseModel) {
            if (_log.isLoggable(Level.SEVERE)) {
                _log.severe("addTask(): Couldn't get CalendarBaseModel: Can't add the task");
            }
            throw new UWCException(62);
        }
        this.makeTask(true);
        calendarBaseModel.setTimeZone(this.getTaskTimeZone(false));
        calendarBaseModel.removeAllCalids();
        calendarBaseModel.addCalid((String)this.getValue(FIELD_CALID));
        calendarBaseModel.addTodo(this._currentTodo, false);
    }

    private void modifyTask(String string, boolean bl) throws UWCException {
        CalendarBaseModel calendarBaseModel = UWCUserHelper.getCalendarBaseModel(this._reqCtx);
        if (null == calendarBaseModel) {
            if (_log.isLoggable(Level.SEVERE)) {
                _log.severe("modifyTask(): Couldn't get CalendarBaseModel: Can't modify the task");
            }
            throw new UWCException(62);
        }
        this.makeTask(false);
        ((SOCSTodo)this._currentTodo).setAlarmChange(true);
        ((SOCSTodo)this._currentTodo).setAttendeeChange(false);
        ((SOCSTodo)this._currentTodo).setAttachmentChange(false);
        ((SOCSTodo)this._currentTodo).setCategoryChange(true);
        ((SOCSTodo)this._currentTodo).setContactChange(false);
        ((SOCSTodo)this._currentTodo).setDescriptionChange(true);
        ((SOCSTodo)this._currentTodo).setExceptionDateChange(false);
        ((SOCSTodo)this._currentTodo).setExceptionRuleChange(false);
        ((SOCSTodo)this._currentTodo).setLocationChange(true);
        ((SOCSTodo)this._currentTodo).setRecurrenceDateChange(false);
        ((SOCSTodo)this._currentTodo).setRelatedToChange(false);
        ((SOCSTodo)this._currentTodo).setResourceChange(false);
        ((SOCSTodo)this._currentTodo).setSummaryChange(true);
        ((SOCSTodo)this._currentTodo).setUrlChange(false);
        calendarBaseModel.setTimeZone(this.getTaskTimeZone(false));
        calendarBaseModel.removeAllCalids();
        calendarBaseModel.addCalid((String)this.getValue(FIELD_CALID));
        calendarBaseModel.modifyTodo(this._currentTodo, string, false);
    }

    private void updateTask() throws UWCException {
        CalendarBaseModel calendarBaseModel = UWCUserHelper.getCalendarBaseModel(this._reqCtx);
        if (null == calendarBaseModel) {
            if (_log.isLoggable(Level.SEVERE)) {
                _log.severe("Couldn't get CalendarBaseModel:Can't update the task");
            }
            throw new UWCException(62);
        }
        this.makeTaskToUpdateStatus();
        ((SOCSTodo)this._currentTodo).setAlarmChange(false);
        ((SOCSTodo)this._currentTodo).setAttendeeChange(false);
        ((SOCSTodo)this._currentTodo).setAttachmentChange(false);
        ((SOCSTodo)this._currentTodo).setCategoryChange(false);
        ((SOCSTodo)this._currentTodo).setContactChange(false);
        ((SOCSTodo)this._currentTodo).setDescriptionChange(false);
        ((SOCSTodo)this._currentTodo).setExceptionDateChange(false);
        ((SOCSTodo)this._currentTodo).setExceptionRuleChange(false);
        ((SOCSTodo)this._currentTodo).setLocationChange(false);
        ((SOCSTodo)this._currentTodo).setRecurrenceDateChange(false);
        ((SOCSTodo)this._currentTodo).setRecurrenceRuleChange(false);
        ((SOCSTodo)this._currentTodo).setRelatedToChange(false);
        ((SOCSTodo)this._currentTodo).setResourceChange(false);
        ((SOCSTodo)this._currentTodo).setSummaryChange(false);
        ((SOCSTodo)this._currentTodo).setUrlChange(false);
        calendarBaseModel.setTimeZone(this.getTaskTimeZone(false));
        if (this._calId != null) {
            calendarBaseModel.removeAllCalids();
            calendarBaseModel.addCalid(this._calId);
        } else {
            calendarBaseModel.removeAllCalids();
            calendarBaseModel.addCalid((String)this.getValue(FIELD_CALID));
        }
        calendarBaseModel.modifyTodo(this._currentTodo, this._modifier, false);
    }

    private void deleteTask(String string, boolean bl) throws UWCException {
        CalendarBaseModel calendarBaseModel = UWCUserHelper.getCalendarBaseModel(this._reqCtx);
        if (null == calendarBaseModel) {
            if (_log.isLoggable(Level.SEVERE)) {
                _log.severe("deleteTask(): Couldn't get CalendarBaseModel: Can't delete the task");
            }
            throw new UWCException(62);
        }
        this.makeTaskToDelete();
        calendarBaseModel.setTimeZone(this.getTaskTimeZone(false));
        if (this._calId != null) {
            calendarBaseModel.removeAllCalids();
            calendarBaseModel.addCalid(this._calId);
        } else {
            calendarBaseModel.removeAllCalids();
            calendarBaseModel.addCalid((String)this.getValue(FIELD_CALID));
        }
        calendarBaseModel.deleteTodo(this._currentTodo, string, bl);
    }

    private void makeTask(boolean bl) throws UWCException {
        try {
            int n;
            DateTime dateTime;
            int n2;
            String string;
            String[] stringArray;
            String string2;
            String string3;
            CalendarStore calendarStore = UWCUserHelper.getCalStore(this._reqCtx, false);
            if (null == calendarStore) {
                if (_log.isLoggable(Level.SEVERE)) {
                    _log.severe("Couldn't get CalendarStore object: Couldn't prepare the todo");
                }
                throw new Exception("Couldn't prepare the todo");
            }
            this._currentTodo = calendarStore.openCalendar().createTodo();
            if (null == this._currentTodo) {
                if (_log.isLoggable(Level.SEVERE)) {
                    _log.severe("Couldn't get Todo object: Couldn't prepare the task");
                }
                throw new Exception("Couldn't prepare the task");
            }
            boolean bl2 = !"true".equalsIgnoreCase((String)this.getValue(FIELD_NO_DUE_DATE));
            boolean bl3 = !"true".equalsIgnoreCase((String)this.getValue(FIELD_NO_DUE_TIME));
            DateTime dateTime2 = null;
            DateTime dateTime3 = null;
            TimeZone timeZone = this.getTaskTimeZone(false);
            String string4 = (String)this.getValue(FIELD_START_DATE_MONTH);
            String string5 = (String)this.getValue(FIELD_START_DATE_DAY);
            String string6 = (String)this.getValue(FIELD_START_DATE_YEAR);
            int n3 = UWCUtils.isStringContainedInStringArray(string4, UWCConstants.monthValues);
            int n4 = UWCUtils.isStringContainedInStringArray(string5, UWCConstants.dayValues);
            int n5 = UWCUtils.isStringContainedInStringArray(string6, UWCConstants.yearValues);
            if (-1 == n3) {
                throw new IllegalArgumentException("Invalid task start date: Month value component [-1] is invalid");
            }
            if (-1 == n4) {
                throw new IllegalArgumentException("Invalid task start date: Day value component [-1] is invalid");
            }
            if (-1 == n5) {
                throw new IllegalArgumentException("Invalid task start date: Year value component [-1] is invalid");
            }
            int n6 = Integer.parseInt(string5);
            int n7 = Integer.parseInt(string6);
            dateTime2 = null == timeZone ? new DateTime() : new DateTime(timeZone);
            dateTime2.setDate(n7, n3, n6);
            dateTime2.setTime(0, 0, 0);
            if (bl2) {
                string3 = (String)this.getValue(FIELD_DUE_DATE_MONTH);
                string2 = (String)this.getValue(FIELD_DUE_DATE_DAY);
                stringArray = (String[])this.getValue(FIELD_DUE_DATE_YEAR);
                int n8 = UWCUtils.isStringContainedInStringArray(string3, UWCConstants.monthValues);
                int n9 = UWCUtils.isStringContainedInStringArray(string2, UWCConstants.dayValues);
                int n10 = UWCUtils.isStringContainedInStringArray((String)stringArray, UWCConstants.yearValues);
                if (-1 == n8) {
                    throw new IllegalArgumentException("Invalid task due date: Month value component [-1] is invalid");
                }
                if (-1 == n9) {
                    throw new IllegalArgumentException("Invalid task due date: Day value component [-1] is invalid");
                }
                if (-1 == n10) {
                    throw new IllegalArgumentException("Invalid task due date: Year value component [-1] is invalid");
                }
                int n11 = Integer.parseInt(string2);
                int n12 = Integer.parseInt((String)stringArray);
                if (bl3) {
                    string = (String)this.getValue(FIELD_DUE_TIME_HOUR);
                    String string7 = (String)this.getValue(FIELD_DUE_TIME_MINUTE);
                    int n13 = Integer.parseInt(string);
                    n2 = Integer.parseInt(string7);
                    if (0 > n13 && 23 < n13) {
                        throw new IllegalArgumentException("Invalid task due date: Hours value component [" + n13 + "] is invalid");
                    }
                    n13 += n2 / 60;
                    dateTime3 = null == timeZone ? new DateTime() : new DateTime(timeZone);
                    dateTime3.setDate(n12, n8, n11);
                    dateTime3.setTime(n13, n2 %= 60, 0);
                } else {
                    dateTime3 = new DateTime(timeZone);
                    dateTime3.setDate(n12, n8, n11);
                    dateTime3.setTime(0, 0, 0);
                }
            }
            if (!("PUBLIC".equalsIgnoreCase(string3 = (String)this.getValue(FIELD_PRIVACY)) || "PRIVATE".equalsIgnoreCase(string3) || "CONFIDENTIAL".equalsIgnoreCase(string3))) {
                string3 = "PRIVATE";
            }
            string2 = (String)this.getValue(FIELD_TITLE);
            stringArray = UWCUtils.getStringArray(this.getValues(FIELD_CATEGORY));
            String string8 = (String)this.getValue(FIELD_LOCATION);
            String string9 = (String)this.getValue(FIELD_DESCRIPTION);
            String string10 = (String)this.getValue(FIELD_PERCENT);
            String string11 = (String)this.getValue(FIELD_PRIORITY);
            if (!bl) {
                String string12 = null;
                string12 = this._todoUid != null ? this._todoUid : (String)this.getValue(FIELD_TASK_UID);
                if (null == string12) {
                    if (_log.isLoggable(Level.SEVERE)) {
                        _log.severe("Couldn't get task UID: Couldn't prepare the task");
                    }
                    throw new Exception("Couldn't modify the task");
                }
                this._currentTodo.setID(string12);
                string = this._todoRid;
                if (!this._modifier.equals("THIS_AND_ALL")) {
                    if (string == null) {
                        string = (String)this.getValue(FIELD_TASK_RID);
                    }
                    if (string != null && string.trim().length() == 0) {
                        string = null;
                    }
                    this.setTaskRecurrenceID(this._currentTodo, string);
                }
            }
            if (null != dateTime2 && null != this._recurrence && (dateTime = this._recurrence.getUntilDate()) != null && dateTime.before((Object)dateTime2)) {
                throw new UWCException(81);
            }
            String string13 = dateTime2.toISOString();
            string = (String)this.getValue(FIELD_ORIG_START_DATE);
            boolean bl4 = false;
            if (bl && string13 != null) {
                bl4 = true;
            } else if (string == null || string != null && !string.equals(string13)) {
                bl4 = true;
            }
            String string14 = (String)this.getValue(FIELD_ORIG_DUE_DATE);
            n2 = 0;
            String string15 = null;
            if (bl2) {
                string15 = dateTime3.toISOString();
                if (string14 == null || string14 != null && !string14.equals(string15)) {
                    n2 = 1;
                    this._currentTodo.setEnd(dateTime3);
                }
            }
            if (string14 != null && string15 == null) {
                n2 = 1;
            }
            if (bl4 || n2 != 0) {
                this._currentTodo.setStart(dateTime2);
                if (n2 != 0) {
                    ((SOCSTodo)this._currentTodo).setDueDateChange(true);
                }
            }
            if (!bl3) {
                this._currentTodo.setAllDay(true);
            } else {
                this._currentTodo.setAllDay(false);
            }
            int n14 = Integer.parseInt(UWCUtils.getPercentValue(string10));
            int n15 = n = null == string11 ? -1 : Integer.parseInt(string11);
            if (null != string2) {
                this._currentTodo.setSummary(string2);
            }
            if (null != string3) {
                this._currentTodo.setClassification(string3);
            }
            if (null != string8) {
                this._currentTodo.setLocation(string8);
            }
            if (null != string9) {
                this._currentTodo.setDescription(string9);
            }
            if (n14 != -1) {
                this._currentTodo.setPercent(n14);
            }
            if (n != -1) {
                n = this.getPriorityFromMap(n);
                this._currentTodo.setPriority(n);
            }
            if (null != stringArray) {
                for (int i = 0; i < stringArray.length; ++i) {
                    this._currentTodo.addCategory(stringArray[i]);
                }
            }
            String string16 = (String)this.getValue(FIELD_CALID);
            String string17 = UWCUserHelper.getUserName(this._reqCtx);
            String string18 = UWCUserHelper.getLanguage(this._reqCtx);
            String string19 = UWCUserHelper.getUserDN(this._reqCtx);
            if (null == string17) {
                string17 = string16;
            }
            Organizer organizer = new Organizer(string17, string16);
            if (null != string18) {
                organizer.setLanguage(string18);
            }
            if (null != string19) {
                organizer.setDir(string19);
            }
            this._currentTodo.setOrganizer(organizer);
            String string20 = (String)this.getValue(FIELD_ORIG_RRULE);
            if (null != this._recurrence) {
                String string21 = this._recurrence.toRFC2445();
                if (string20 == null || string20 != null && !string20.equalsIgnoreCase(string21)) {
                    ((SOCSTodo)this._currentTodo).setRecurrenceRuleChange(true);
                    this._currentTodo.addRecurrenceRule(this._recurrence);
                }
            }
            if (string20 != null && this._recurrence == null) {
                ((SOCSTodo)this._currentTodo).setRecurrenceRuleChange(true);
            }
            ((SOCSTodo)this._currentTodo).setProperty(SOCSTodo.METHOD, (Object)"REQUEST");
            if (null != this._alarm) {
                this._currentTodo.addAlarmComponent(this._alarm);
            }
            if (_log.isLoggable(Level.FINEST)) {
                _log.finest("makeTask: todo _calId: " + this._calId);
                _log.finest("makeTask: todo FIELD_CALID: " + (String)this.getValue(FIELD_CALID));
                _log.finest("makeTask: dump todo \n: " + ((SOCSTodo)this._currentTodo).toRFC2445());
            }
        }
        catch (UWCException uWCException) {
            if (_log.isLoggable(Level.SEVERE)) {
                _log.severe("Error preparing the Todo, couldn't prepare todo. Reason: " + uWCException.getMessage());
            }
            throw uWCException;
        }
        catch (Exception exception) {
            if (_log.isLoggable(Level.SEVERE)) {
                _log.severe("Error preparing the Todo, couldn't prepare todo. Reason: " + exception);
            }
            throw new UWCException(64);
        }
    }

    private void makeTaskToUpdateStatus() throws UWCException {
        try {
            CalendarStore calendarStore = UWCUserHelper.getCalStore(this._reqCtx, false);
            if (null == calendarStore) {
                if (_log.isLoggable(Level.SEVERE)) {
                    _log.severe("Couldn't get CalendarStore object: Couldn't prepare the todo");
                }
                throw new Exception("Couldn't prepare the task");
            }
            this._currentTodo = calendarStore.openCalendar().createTodo();
            if (null == this._currentTodo) {
                if (_log.isLoggable(Level.SEVERE)) {
                    _log.severe("Couldn't get Todo object: Couldn't prepare the task");
                }
                throw new Exception("Couldn't prepare the task");
            }
            String string = null;
            string = this._todoUid != null ? this._todoUid : (String)this.getValue(FIELD_TASK_UID);
            if (null == string) {
                if (_log.isLoggable(Level.SEVERE)) {
                    _log.severe("Couldn't get todo UID: Couldn't prepare the task");
                }
                throw new Exception("Couldn't update the task");
            }
            this._currentTodo.setID(string);
            String string2 = null;
            string2 = this._todoRid != null ? this._todoRid : (String)this.getValue(FIELD_TASK_RID);
            if (string2 != null && string2.trim().length() == 0) {
                string2 = null;
            }
            this.setTaskRecurrenceID(this._currentTodo, string2);
            int n = -1;
            if (this._percent != -1) {
                n = this._percent;
            } else {
                String string3 = (String)this.getValue(FIELD_PERCENT);
                if (string3 != null) {
                    n = Integer.parseInt(UWCUtils.getPercentValue(string3));
                }
            }
            if (n != -1) {
                this._currentTodo.setPercent(n);
            }
            if (_log.isLoggable(Level.FINEST)) {
                _log.finest("makeTaskToUpdateStatus: todo _calId: " + this._calId);
                _log.finest("makeTaskToUpdateStatus: todo FIELD_CALID: " + (String)this.getValue(FIELD_CALID));
                _log.finest("makeTaskToUpdateStatus: dump todo \n: " + ((SOCSTodo)this._currentTodo).toRFC2445());
            }
        }
        catch (UWCException uWCException) {
            if (_log.isLoggable(Level.SEVERE)) {
                _log.severe("Error preparing the task, couldn't prepare task. Reason: " + uWCException.getDetails());
            }
            throw uWCException;
        }
        catch (Exception exception) {
            if (_log.isLoggable(Level.SEVERE)) {
                _log.severe("Error preparing the task, couldn't prepare task. Reason: " + exception);
            }
            throw new UWCException(64);
        }
    }

    private void makeTaskToDelete() throws UWCException {
        try {
            CalendarStore calendarStore = UWCUserHelper.getCalStore(this._reqCtx, false);
            if (null == calendarStore) {
                _log.severe("Couldn't get CalendarStore object: Couldn't prepare the task");
                throw new Exception(" Couldn't prepare task");
            }
            this._currentTodo = calendarStore.openCalendar().createTodo();
            if (null == this._currentTodo) {
                _log.severe("Can't get Todo object:Couldn't prepare the task");
                throw new Exception("Couldn't prepare task ");
            }
            String string = null;
            string = this._todoUid != null ? this._todoUid : (String)this.getValue(FIELD_TASK_UID);
            if (null == string) {
                _log.severe("Couldn't get Todo UID: Couldn't prepare the task");
                throw new Exception("Couldn't update task");
            }
            this._currentTodo.setID(string);
            String string2 = null;
            string2 = this._todoRid != null ? this._todoRid : (String)this.getValue(FIELD_TASK_RID);
            if (string2 != null && string2.trim().length() == 0) {
                string2 = null;
            }
            this.setTaskRecurrenceID(this._currentTodo, string2);
            if (_log.isLoggable(Level.FINEST)) {
                _log.finest("makeTaskToDelete: todo _calId: " + this._calId);
                _log.finest("makeTaskToDelete: todo FIELD_CALID: " + (String)this.getValue(FIELD_CALID));
                _log.finest("makeTaskToDelete: dump todo \n: " + ((SOCSTodo)this._currentTodo).toRFC2445());
            }
        }
        catch (UWCException uWCException) {
            _log.severe("Error preparing the task, couldn't prepare Todo. Reason: " + uWCException.getDetails());
            throw uWCException;
        }
        catch (Exception exception) {
            _log.severe("Error preparing the task, couldn't prepare Todo. Reason: " + exception);
            throw new UWCException(64);
        }
    }

    private void setTaskRecurrenceID(VTodo vTodo, String string) throws ParseException {
        if (null == vTodo || null == string) {
            return;
        }
        DateTime dateTime = new DateTime(string);
        if (null != dateTime) {
            vTodo.setProperty("RECURRENCE-ID", (Object)dateTime);
        }
    }

    private TimeZone getTaskTimeZone(boolean bl) {
        String string = (String)this.getValue(FIELD_TIME_ZONE);
        if (null == string || string.trim().equals("")) {
            if (bl) {
                string = "GMT";
            } else {
                return null;
            }
        }
        TimeZone timeZone = TimeZone.getTimeZone(string);
        return timeZone;
    }

    private int getPriorityFromMap(int n) {
        if (n == 0 || n == 5 || n > 9) {
            return 5;
        }
        if (n >= 1 && n <= 4) {
            return 1;
        }
        if (n >= 6 && n <= 9) {
            return 9;
        }
        return 5;
    }

    static {
        _log = UWCLogger.getLogger("uwc.calclient.model");
    }
}

