/*
 * Decompiled with CFR 0.152.
 */
package com.sun.uwc.calclient.model;

import com.iplanet.jato.model.InvalidContextException;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.model.ModelExecutionContext;
import com.iplanet.jato.model.RetrievingModel;
import com.iplanet.jato.util.NonSyncStringBuffer;
import com.sun.comclient.calendar.DateTime;
import com.sun.comclient.calendar.Organizer;
import com.sun.comclient.calendar.VTodo;
import com.sun.comclient.calendar.socs.SOCSCalendar;
import com.sun.comclient.calendar.socs.SOCSTodo;
import com.sun.uwc.calclient.model.CalendarBaseModel;
import com.sun.uwc.calclient.model.TasksModel;
import com.sun.uwc.calclient.model.UWCCalendar;
import com.sun.uwc.common.UWCException;
import com.sun.uwc.common.UWCUserHelper;
import com.sun.uwc.common.model.CalendarExecutionModelContext;
import com.sun.uwc.common.model.UWCModelControlException;
import com.sun.uwc.common.util.UWCConstants;
import com.sun.uwc.common.util.UWCLogger;
import com.sun.uwc.common.util.UWCUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TasksListModel
extends TasksModel
implements RetrievingModel {
    private transient HashMap _calendars = null;
    private transient ArrayList _tasks = null;
    private transient ArrayList _calids = null;
    private transient DateTime _start = null;
    private transient DateTime _end = null;
    private transient DateTime _selectedDate = null;
    private transient boolean _anonymous = false;
    private transient boolean _searchMode = false;
    private transient boolean _taskSorting = false;
    private transient int _firstDayOfWeek = 1;
    private static final transient String CLASS_NAME = "TasksListModel";
    private static transient Logger _log = null;
    private transient String _methodTitle = null;
    public static final transient String SORT_CRITERIA_NO_SORTING = "NoSorting";
    public static final transient String SORT_CRITERIA_PRIORITY_ASCENDING = "PriorityAscending";
    public static final transient String SORT_CRITERIA_PRIORITY_DECENDING = "PriorityDescending";
    public static final transient String SORT_CRITERIA_TITLE_ASCENDING = "TitleAscending";
    public static final transient String SORT_CRITERIA_TITLE_DECENDING = "TitleDescending";
    public static final transient String SORT_CRITERIA_DUE_DATE_ASCENDING = "DueDateAscending";
    public static final transient String SORT_CRITERIA_DUE_DATE_DECENDING = "DueDateDescending";
    public static final transient String SORT_CRITERIA_PERCENT_STATUS_ASCENDING = "PercentStatusAscending";
    public static final transient String SORT_CRITERIA_PERCENT_STATUS_DECENDING = "PercentStatusDescending";
    public static final transient String SORT_CRITERIA_CATEGORY_ASCENDING = "CategoryAscending";
    public static final transient String SORT_CRITERIA_CATEGORY_DECENDING = "CategoryDescending";
    public static final String FIELD_TIME_ZONE = "TimeZone";
    public static final String FIELD_SEARCH_TEXT = "SearchText";
    public static final String FIELD_SORT_CRITERIA = "SortCriteria";
    public static final String FIELD_START_MONTH = "StartMonth";
    public static final String FIELD_START_DAY = "StartDay";
    public static final String FIELD_START_YEAR = "StartYear";
    public static final String FIELD_VIEW_CONTEXT = "ViewContext";
    public static final String FIELD_VIEW_CATEGORY = "ViewCategory";
    public static final String FIELD_CONTEXT_NAME = "ContextText";
    public static final String FIELD_CONTEXT_DURATION = "ContextDuration";
    public static final String FIELD_SELECTED_DATE_IN_UTC = "SelectedDateInUTC";
    public static final String FIELD_TASK_CALID = "TaskCalID";
    public static final String FIELD_TASK_UID = "TaskUID";
    public static final String FIELD_TASK_RID = "TaskRID";
    public static final String FIELD_TASK_TIME_ZONE = "TaskTZN";
    public static final String FIELD_IS_TASK_SELECTED = "IsTaskSelected";
    public static final String FIELD_PRIORITY = "Priority";
    public static final String FIELD_TITLE = "Title";
    public static final String FIELD_VIEW_TASK_URL = "ViewTaskUrl";
    public static final String FIELD_OWNER_NAME = "OwnerName";
    public static final String FIELD_CALENDAR_NAME = "CalendarName";
    public static final String FIELD_IS_CONFIDENTIAL = "IsConfidential";
    public static final String FIELD_IS_RECURRING = "IsRecurring";
    public static final String FIELD_IS_REMINDING = "IsReminding";
    public static final String FIELD_IS_PUBLIC = "IsPublic";
    public static final String FIELD_IS_EXTERNAL = "IsExternal";
    public static final String FIELD_IS_WRITABLE = "IsWritable";
    public static final String FIELD_CAN_DELETE = "CanDelete";
    public static final String FIELD_DUE_DATE = "DueDate";
    public static final String FIELD_DUE_TIME = "DueTime";
    public static final String FIELD_PERCENT_STATUS = "PercentStatus";
    public static final String FIELD_PERCENT_STATUS_AS_TEXT = "PercentStatusAsText";
    public static final String FIELD_PREVIOUS_PERCENT_STATUS = "PreviousPercentStatus";
    public static final String FIELD_CATEGORY = "Category";
    public static final String FIELD_EDIT_TASK_URL = "EditTaskUrl";
    public static final String IS_LAST_ROW = "IsLastRow";

    public TasksListModel() {
    }

    public TasksListModel(String string) {
        super(string);
    }

    public ArrayList getTasks() {
        return this._tasks;
    }

    public void setTasks(ArrayList arrayList) {
        this._tasks = arrayList;
    }

    public HashMap getCalendars() {
        return this._calendars;
    }

    public void setCalendars(HashMap hashMap) {
        this._calendars = hashMap;
    }

    public DateTime getDateFromDateFields() throws IllegalArgumentException, NumberFormatException {
        return UWCUtils.getDateTime((String)this.getValue(FIELD_START_DAY), (String)this.getValue(FIELD_START_MONTH), (String)this.getValue(FIELD_START_YEAR), "0", "0", "0", (String)this.getValue(FIELD_TIME_ZONE));
    }

    public void setDateInDateFields(DateTime dateTime) {
        String string = null;
        String string2 = null;
        String string3 = null;
        TimeZone timeZone = null;
        if (null != dateTime) {
            string = UWCConstants.monthValues[dateTime.get(2)];
            string2 = UWCConstants.dayValues[dateTime.get(5) - 1];
            string3 = UWCUtils.getYearValue(this._reqCtx, dateTime);
            timeZone = dateTime.getTimeZone();
        }
        this.setValue(FIELD_START_MONTH, string);
        this.setValue(FIELD_START_DAY, string2);
        this.setValue(FIELD_START_YEAR, string3);
        this.setValue(FIELD_SELECTED_DATE_IN_UTC, null == dateTime ? null : dateTime.toISO8601());
        this.setValue(FIELD_TIME_ZONE, null == timeZone ? null : timeZone.getID());
    }

    public DateTime getStartTime() {
        return this._start;
    }

    public void setStartTime(DateTime dateTime) {
        this._start = dateTime;
    }

    public void setSelectedDate(DateTime dateTime) {
        this._selectedDate = dateTime;
    }

    public DateTime getEndTime() {
        return this._end;
    }

    public void setEndTime(DateTime dateTime) {
        this._end = dateTime;
    }

    public boolean getAnonymous() {
        return this._anonymous;
    }

    public void setAnonymous(boolean bl) {
        this._anonymous = bl;
    }

    public String getCategory() {
        return (String)this.getValue(FIELD_VIEW_CATEGORY);
    }

    public void setCategory(String string) {
        this.setValue(FIELD_VIEW_CATEGORY, string);
    }

    public String getViewContext() {
        return (String)this.getValue(FIELD_VIEW_CONTEXT);
    }

    public void setViewContext(String string) {
        this.setValue(FIELD_VIEW_CONTEXT, string);
    }

    public String getSearchText() {
        return (String)this.getValue(FIELD_SEARCH_TEXT);
    }

    public void setSearchText(String string) {
        this.setValue(FIELD_SEARCH_TEXT, string);
    }

    public void enableSearchTextMode(boolean bl) {
        this._searchMode = bl;
    }

    public void enableTaskSorting(boolean bl) {
        this._taskSorting = bl;
    }

    public String getSortCriteria() {
        return (String)this.getValue(FIELD_SORT_CRITERIA);
    }

    public void setSortCriteria(String string) {
        this.setValue(FIELD_SORT_CRITERIA, string);
    }

    public void setFirstDayOfWeek(int n) {
        this._firstDayOfWeek = n;
    }

    public ArrayList getCalids() {
        return this._calids;
    }

    public String[] getCalidsStringArray() {
        if (null == this._calids) {
            return null;
        }
        if (this._calids.size() < 1) {
            return null;
        }
        return this._calids.toArray(UWCConstants.ZERO_STRING_ARRAY);
    }

    public void addCalid(ArrayList arrayList) {
        if (null == arrayList) {
            return;
        }
        if (null == this._calids) {
            this._calids = new ArrayList();
        }
        this._calids.addAll(arrayList);
    }

    public void addCalid(String string) {
        if (null == string) {
            return;
        }
        if (null == this._calids) {
            this._calids = new ArrayList();
        }
        this._calids.add(string);
    }

    public void removeCalid(String string) {
        if (null == this._calids || null == string) {
            return;
        }
        int n = this._calids.size();
        for (int i = 0; i < n; ++i) {
            if (!string.equals((String)this._calids.get(i))) continue;
            this._calids.remove(i);
            return;
        }
    }

    public void removeAllCalids() {
        if (null != this._calids) {
            this._calids.clear();
        }
    }

    public Object execute(ModelExecutionContext modelExecutionContext) throws ModelControlException {
        Object var2_2 = null;
        String string = null;
        string = null != modelExecutionContext ? modelExecutionContext.getOperationName() : CalendarExecutionModelContext.LOAD_TODO_CONTEXT;
        if (string.equals(CalendarExecutionModelContext.LOAD_TODO_CONTEXT)) {
            try {
                this.fetchTasks();
            }
            catch (UWCException uWCException) {
                if (_log.isLoggable(Level.SEVERE)) {
                    _log.severe("UWCException while fetching the tasks: " + uWCException);
                }
                UWCUtils.printStackTrace(uWCException);
                throw new UWCModelControlException(uWCException.getReason(), uWCException.getDetails());
            }
        } else {
            throw new UWCModelControlException((Throwable)new InvalidContextException("Task execute context failed: \"" + string + "\" is invalid task execute context"));
        }
        return null;
    }

    public Object retrieve(ModelExecutionContext modelExecutionContext) throws ModelControlException {
        Object var2_2 = null;
        String string = null;
        string = null != modelExecutionContext ? modelExecutionContext.getOperationName() : CalendarExecutionModelContext.LOAD_TODO_CONTEXT;
        if (!string.equals(CalendarExecutionModelContext.LOAD_TODO_CONTEXT)) {
            throw new UWCModelControlException((Throwable)new InvalidContextException("Task retrieve context failed: \"" + string + "\" is invalid task retrieve context"));
        }
        this.loadTasks();
        return null;
    }

    private void fetchTasks() throws UWCException {
        this._tasks = null;
        CalendarBaseModel calendarBaseModel = UWCUserHelper.getCalendarBaseModel(this._reqCtx);
        if (null == calendarBaseModel) {
            throw new UWCException(63, "Couldn't get CalendarBaseModel: Can't retrieve tasks");
        }
        try {
            Object object;
            String string = (String)this.getValue(FIELD_VIEW_CONTEXT);
            if (null == string) {
                string = "day";
            }
            if (null == this._start && null == this._end) {
                object = this.getDateFromDateFields();
                this._start = UWCUtils.getContextStart(object, string, this._firstDayOfWeek);
                this._end = UWCUtils.getContextEnd(object, string);
            } else if (null == this._start) {
                this._end = UWCUtils.getContextEnd(this._start, string);
            } else if (null == this._end) {
                this._start = UWCUtils.getContextStart(this._end, string, this._firstDayOfWeek);
            }
            this.setDateInDateFields(null != this._selectedDate ? this._selectedDate : this._start);
            this.setValue(FIELD_CONTEXT_NAME, UWCUtils.getDisplayableContextName(this._reqCtx, string));
            this.setValue(FIELD_CONTEXT_DURATION, UWCUtils.getDisplayableContextDuration(this._reqCtx, this._start, this._end, string));
            calendarBaseModel.removeAllCalids();
            if (null != this._calids) {
                calendarBaseModel.addCalid(this._calids);
            }
            calendarBaseModel.setAnonymous(this._anonymous);
            if (this._searchMode) {
                object = (String)this.getValue(FIELD_SEARCH_TEXT);
                if (null != object && !object.trim().equals("")) {
                    String string2 = "ALL=" + (String)object;
                    calendarBaseModel.setComponentSearchFilter(string2);
                    calendarBaseModel.setComponentSearchOption(0);
                }
                calendarBaseModel.execute((ModelExecutionContext)new CalendarExecutionModelContext(CalendarExecutionModelContext.SEARCH_TODOS_CONTEXT));
                if (this._taskSorting) {
                    this.sortTheTasks(calendarBaseModel);
                }
                this._tasks = calendarBaseModel.getAllTodos();
                this._calendars = calendarBaseModel.getCalendars();
            } else {
                String string3;
                calendarBaseModel.setStartTime(this._start);
                calendarBaseModel.setEndTime(this._end);
                object = new CalendarExecutionModelContext(CalendarExecutionModelContext.FETCH_TODOS_CONTEXT);
                String string4 = (String)this.getValue(FIELD_VIEW_CATEGORY);
                if (null != string4 && !string4.equals("Other") && !string4.equals("All") && null != (string3 = "CATEGORY=" + string4)) {
                    calendarBaseModel.setComponentSearchFilter(string3);
                    calendarBaseModel.setComponentSearchOption(0);
                    object = new CalendarExecutionModelContext(CalendarExecutionModelContext.SEARCH_TODOS_CONTEXT);
                }
                calendarBaseModel.execute((ModelExecutionContext)object);
                if (this._taskSorting) {
                    this.sortTheTasks(calendarBaseModel);
                }
                this._tasks = calendarBaseModel.getAllTodos();
                if ("Other".equals(string4)) {
                    int n;
                    int n2 = n = null == this._tasks ? -1 : this._tasks.size();
                    if (n > 0) {
                        ArrayList<VTodo> arrayList = new ArrayList<VTodo>();
                        for (int i = 0; i < n; ++i) {
                            VTodo vTodo = null;
                            try {
                                vTodo = (VTodo)this._tasks.get(i);
                            }
                            catch (Exception exception) {
                                vTodo = null;
                            }
                            if (null == vTodo) continue;
                            String[] stringArray = null;
                            try {
                                stringArray = vTodo.getCategories();
                            }
                            catch (Exception exception) {
                                stringArray = null;
                            }
                            if (null == stringArray) {
                                arrayList.add(vTodo);
                                continue;
                            }
                            if (-1 == UWCUtils.isStringContainedInStringArray("Other", stringArray, false)) continue;
                            arrayList.add(vTodo);
                        }
                        this._tasks = arrayList;
                    }
                }
                this._calendars = calendarBaseModel.getCalendars();
            }
            object = calendarBaseModel.getTimeZone();
            this.setValue(FIELD_TIME_ZONE, null == object ? null : object.getID());
        }
        catch (ModelControlException modelControlException) {
            if (_log.isLoggable(Level.SEVERE)) {
                _log.severe("Couldn't retrieve the tasks. Reason: " + (Object)((Object)modelControlException));
            }
            UWCUtils.printStackTrace((Exception)((Object)modelControlException));
            throw new UWCException(63, "Couldn't retrieve the tasks. Reason: " + (Object)((Object)modelControlException));
        }
    }

    private void sortTheTasks(CalendarBaseModel calendarBaseModel) throws UWCModelControlException {
        if (null == calendarBaseModel) {
            return;
        }
        calendarBaseModel.setContextDate(null != this._selectedDate ? this._selectedDate : this._start);
        String string = (String)this.getValue(FIELD_SORT_CRITERIA);
        if (SORT_CRITERIA_NO_SORTING.equalsIgnoreCase(string)) {
            // empty if block
        }
        if (SORT_CRITERIA_PRIORITY_ASCENDING.equalsIgnoreCase(string)) {
            calendarBaseModel.sortTodos("PRIORITY", 1);
        }
        if (SORT_CRITERIA_PRIORITY_DECENDING.equalsIgnoreCase(string)) {
            calendarBaseModel.sortTodos("PRIORITY", 0);
        }
        if (SORT_CRITERIA_TITLE_ASCENDING.equalsIgnoreCase(string)) {
            calendarBaseModel.sortTodos("SUMMARY", 1);
        }
        if (SORT_CRITERIA_TITLE_DECENDING.equalsIgnoreCase(string)) {
            calendarBaseModel.sortTodos("SUMMARY", 0);
        }
        if (SORT_CRITERIA_DUE_DATE_ASCENDING.equalsIgnoreCase(string)) {
            calendarBaseModel.sortTodos("DUE", 1);
        }
        if (SORT_CRITERIA_DUE_DATE_DECENDING.equalsIgnoreCase(string)) {
            calendarBaseModel.sortTodos("DUE", 0);
        }
        if (SORT_CRITERIA_PERCENT_STATUS_ASCENDING.equalsIgnoreCase(string)) {
            calendarBaseModel.sortTodos("PERCENT", 1);
        }
        if (SORT_CRITERIA_PERCENT_STATUS_DECENDING.equalsIgnoreCase(string)) {
            calendarBaseModel.sortTodos("PERCENT", 0);
        }
        if (SORT_CRITERIA_CATEGORY_ASCENDING.equalsIgnoreCase(string)) {
            calendarBaseModel.sortTodos("CATEGORIES", 1);
        }
        if (SORT_CRITERIA_CATEGORY_DECENDING.equalsIgnoreCase(string)) {
            calendarBaseModel.sortTodos("CATEGORIES", 0);
        }
    }

    private void loadTasks() throws ModelControlException {
        this.clear();
        if (null == this._tasks || null != this._tasks && this._tasks.size() < 1) {
            this.beforeFirst();
            return;
        }
        int n = this._tasks.size();
        if (_log.isLoggable(Level.FINEST)) {
            _log.finest("Total tasks to process: " + n);
        }
        for (int i = 0; i < n; ++i) {
            VTodo vTodo = null;
            try {
                vTodo = (VTodo)this._tasks.get(i);
                if (null == vTodo) {
                    throw new IllegalArgumentException("task[" + i + "] is null");
                }
            }
            catch (Exception exception) {
                continue;
            }
            this.appendRow();
            try {
                if (_log.isLoggable(Level.FINEST)) {
                    _log.finest("About to process the task[" + i + "]....");
                    _log.finest("Task Dump[" + i + "]: \n" + ((SOCSTodo)vTodo).toRFC2445());
                }
                if (i < n - 1) {
                    this.setValue(IS_LAST_ROW, "false");
                } else {
                    this.setValue(IS_LAST_ROW, "true");
                }
                this.writeTaskTileData(vTodo);
                continue;
            }
            catch (Exception exception) {
                if (_log.isLoggable(Level.SEVERE)) {
                    _log.severe("Couldn't load the task[" + i + "]. Reason: " + exception);
                }
                UWCUtils.printStackTrace(exception);
            }
        }
        this.beforeFirst();
    }

    private void writeTaskTileData(VTodo vTodo) throws UWCException {
        try {
            boolean bl;
            String string;
            String string2;
            String string3;
            Object object;
            String string4 = UWCUserHelper.getUserPrefModel(this._reqCtx).getTimeFormat();
            String string5 = UWCUserHelper.getUserPrefModel(this._reqCtx).getDateFormat();
            String string6 = UWCUserHelper.getUserPrefModel(this._reqCtx).getDateDelimiter();
            DateTime dateTime = vTodo.getRecurrenceID();
            Organizer organizer = vTodo.getOrganizer();
            int n = vTodo.getPercent();
            if (n < 0) {
                n = -1 * n;
            }
            if (n > 100) {
                n -= n / 100 * 100;
            }
            n -= n % 25;
            String string7 = vTodo.getCalID();
            String string8 = null;
            if (null != string7 && null != this._calendars) {
                object = (UWCCalendar)this._calendars.get(string7);
                string3 = null == object ? null : (SOCSCalendar)((UWCCalendar)object).getCalendar();
                String string9 = string2 = null == string3 ? null : string3.getRelativeCalId();
                if (null != string2) {
                    string7 = string2;
                }
                try {
                    TimeZone timeZone;
                    TimeZone timeZone2 = timeZone = null == string3 ? null : string3.getTimeZone();
                    if (null != timeZone) {
                        string8 = timeZone.getID();
                    }
                }
                catch (Exception exception) {
                    string8 = null;
                }
            }
            object = vTodo.getID();
            string3 = null == dateTime ? null : dateTime.toISO8601();
            string2 = vTodo.getSummary();
            int n2 = vTodo.getPriority();
            String string10 = string = Integer.toString(n);
            String[] stringArray = vTodo.getCategories();
            String string11 = UWCUserHelper.getLocalizedStringLabel(this._reqCtx, "uwc-calclient-common-Other", "Other");
            String string12 = null == organizer ? null : organizer.getCommonName();
            String string13 = null == organizer ? null : organizer.getValue();
            String string14 = null == string12 ? string13 : string12;
            String string15 = this.getTaskPopupUrl("calclient/ViewTask", string7, (String)object, string3);
            String string16 = this.getTaskPopupUrl("calclient/EditTask", string7, (String)object, string3);
            boolean bl2 = vTodo.hasProperty("DUE");
            String string17 = null;
            String string18 = null;
            String string19 = "false";
            String string20 = vTodo.isRecurring() ? "true" : "false";
            String string21 = vTodo.hasAlarm() ? "true" : "false";
            String string22 = vTodo.isPublic() ? "true" : "false";
            String string23 = null;
            String string24 = null;
            String string25 = null;
            String string26 = null;
            String string27 = null;
            if (1 <= n2 && n2 <= 4) {
                string26 = "uwc-calclient-task-priority-1";
                string27 = "High";
            } else if (5 == n2) {
                string26 = "uwc-calclient-task-priority-5";
                string27 = "Normal";
            } else if (6 <= n2 && n2 <= 9) {
                string26 = "uwc-calclient-task-priority-9";
                string27 = "Low";
            } else {
                string26 = "uwc-calclient-task-priority-5";
                string27 = "Normal";
            }
            String string28 = UWCUserHelper.getLocalizedStringLabel(this._reqCtx, string26, string27);
            if (null == string2) {
                string2 = UWCUserHelper.getLocalizedStringLabel(this._reqCtx, "uwc-calclient-tasks-UntitledTaskLabel", "Untitled Task");
            }
            if (bl2) {
                string17 = UWCUtils.getDisplayableDate(this._reqCtx, vTodo.getDueTime(), string5, string6);
                string18 = vTodo.isAllDay() ? "" : UWCUtils.getDisplayableTime(this._reqCtx, vTodo.getDueTime(), string4);
            } else {
                string17 = UWCUserHelper.getLocalizedStringLabel(this._reqCtx, "uwc-calclient-tasks-NoDueDateLabel", "No Due Date");
                string18 = "";
            }
            int n3 = UWCUtils.isStringContainedInStringArray(string, UWCConstants.calendarTaskPercentValues, false);
            if (-1 != n3) {
                string10 = UWCUserHelper.getLocalizedStringLabel(this._reqCtx, "uwc-calclient-task-percent-" + string, string);
            }
            if (null != stringArray && stringArray.length > 0 && null != stringArray[0]) {
                string11 = UWCUserHelper.getLocalizedStringLabel(this._reqCtx, "uwc-calclient-common-" + stringArray[0], stringArray[0]);
            }
            String string29 = UWCUserHelper.getUID(this._reqCtx);
            UWCCalendar uWCCalendar = UWCUtils.getUWCCalendar(this._reqCtx, string7, true, true, true);
            boolean bl3 = false;
            boolean bl4 = false;
            boolean bl5 = false;
            try {
                bl3 = UWCUserHelper.isUserTheCalendarOwner(uWCCalendar, string29);
            }
            catch (Exception exception) {
                bl3 = false;
                UWCUtils.printStackTrace(exception);
            }
            try {
                if (UWCUserHelper.hasCalendarPermission(uWCCalendar, string29, "c", "w") && vTodo.isCalIdTheOrganizer(string7)) {
                    bl4 = true;
                }
            }
            catch (Exception exception) {
                bl4 = false;
                UWCUtils.printStackTrace(exception);
            }
            try {
                bl5 = UWCUserHelper.hasCalendarPermission(uWCCalendar, string29, "c", "d");
            }
            catch (Exception exception) {
                bl5 = false;
                UWCUtils.printStackTrace(exception);
            }
            string23 = bl3 ? "false" : "true";
            string24 = bl4 ? "true" : "false";
            string25 = bl5 ? "true" : "false";
            String string30 = vTodo.getClassification();
            boolean bl6 = bl = bl3 ? false : "CONFIDENTIAL".equalsIgnoreCase(string30);
            if (bl) {
                string25 = "false";
                string24 = "&nbsp;";
                string28 = "&nbsp;";
                string10 = "&nbsp;";
                string11 = "&nbsp;";
            }
            this.setValue(FIELD_TASK_CALID, string7);
            this.setValue(FIELD_TASK_UID, object);
            this.setValue(FIELD_TASK_RID, string3);
            this.setValue(FIELD_TASK_TIME_ZONE, string8);
            this.setValue(FIELD_IS_TASK_SELECTED, string19);
            this.setValue(FIELD_PRIORITY, string28);
            this.setValue(FIELD_TITLE, string2);
            this.setValue(FIELD_VIEW_TASK_URL, string15);
            this.setValue(FIELD_OWNER_NAME, string14);
            this.setValue(FIELD_CALENDAR_NAME, string7);
            this.setValue(FIELD_IS_CONFIDENTIAL, bl ? "true" : "false");
            this.setValue(FIELD_IS_RECURRING, string20);
            this.setValue(FIELD_IS_REMINDING, string21);
            this.setValue(FIELD_IS_PUBLIC, string22);
            this.setValue(FIELD_IS_EXTERNAL, string23);
            this.setValue(FIELD_IS_WRITABLE, string24);
            this.setValue(FIELD_CAN_DELETE, string25);
            this.setValue(FIELD_DUE_DATE, string17);
            this.setValue(FIELD_DUE_TIME, string18);
            this.setValue(FIELD_PERCENT_STATUS, string);
            this.setValue(FIELD_PERCENT_STATUS_AS_TEXT, string10);
            this.setValue(FIELD_PREVIOUS_PERCENT_STATUS, string);
            this.setValue(FIELD_CATEGORY, string11);
            this.setValue(FIELD_EDIT_TASK_URL, string16);
        }
        catch (Exception exception) {
            if (_log.isLoggable(Level.SEVERE)) {
                _log.severe("Couldn't load the task. Reason: " + exception);
            }
            UWCUtils.printStackTrace(exception);
            throw new UWCException(63, "Couldn't load the task. Reason: " + exception);
        }
    }

    public void dumpModelData(String string) {
    }

    private void dumpTaskTileData() {
    }

    private String getTaskPopupUrl(String string, String string2, String string3, String string4) {
        NonSyncStringBuffer nonSyncStringBuffer = new NonSyncStringBuffer(256);
        nonSyncStringBuffer.append(UWCUtils.getContextPathPrefix(this._reqCtx));
        nonSyncStringBuffer.append(string);
        nonSyncStringBuffer.append("?");
        if (null != string2) {
            nonSyncStringBuffer.append("calid");
            nonSyncStringBuffer.append("=");
            nonSyncStringBuffer.append(string2);
            nonSyncStringBuffer.append("&");
        }
        if (null != string3) {
            nonSyncStringBuffer.append("todoUid");
            nonSyncStringBuffer.append("=");
            nonSyncStringBuffer.append(string3);
            nonSyncStringBuffer.append("&");
        }
        if (null != string4) {
            nonSyncStringBuffer.append("rid");
            nonSyncStringBuffer.append("=");
            nonSyncStringBuffer.append(string4);
            nonSyncStringBuffer.append("&");
        }
        return nonSyncStringBuffer.toString();
    }

    static {
        _log = UWCLogger.getLogger("uwc.common.model");
    }
}

