/*
 * Decompiled with CFR 0.152.
 */
package com.sun.uwc.calclient.model;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.RequestParticipant;
import com.iplanet.jato.model.DefaultModel;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.model.ModelExecutionContext;
import com.iplanet.jato.model.RetrievingModel;
import com.iplanet.jato.util.NonSyncStringBuffer;
import com.sun.comclient.calendar.CalendarComponentException;
import com.sun.comclient.calendar.DateTime;
import com.sun.comclient.calendar.OperationNotSupportedException;
import com.sun.comclient.calendar.Organizer;
import com.sun.comclient.calendar.VEvent;
import com.sun.comclient.calendar.socs.SOCSCalendar;
import com.sun.uwc.calclient.model.CalendarBaseModel;
import com.sun.uwc.calclient.model.UWCCalendar;
import com.sun.uwc.common.UWCApplicationHelper;
import com.sun.uwc.common.UWCException;
import com.sun.uwc.common.UWCUserHelper;
import com.sun.uwc.common.model.CalendarExecutionModelContext;
import com.sun.uwc.common.model.UserPreferencesModel;
import com.sun.uwc.common.util.UWCConstants;
import com.sun.uwc.common.util.UWCLogger;
import com.sun.uwc.common.util.UWCUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MonthEventsModel
extends DefaultModel
implements RetrievingModel,
RequestParticipant {
    public static final String FIELD_EVENTTITLE = "eventtitle";
    public static final String FIELD_EVENT_START_TIME = "starttime";
    public static final String FIELD_CALNAME = "calname";
    public static final String FIELD_EVENTURL = "eventurl";
    public static final String FIELD_EVENTID = "eventid";
    public static final String FIELD_CALID = "calid";
    public static final String FIELD_MODIFIABLE = "modifiable";
    public static final String FIELD_DELETEABLE = "deleteable";
    public static final String FIELD_OWNEDCAL = "ownedcal";
    public static final String FIELD_ISCONFLICT = "isconflict";
    public static final String FIELD_ISRECURRING = "isRecurring";
    public static final String FIELD_ISCONFIDENTIAL = "isConfidential";
    public static final String FIELD_ISALLDAY = "isAllDay";
    public static final String FIELD_RID = "rid";
    private RequestContext _reqCtx = null;
    private static Logger _monthEventsModelLogger = null;
    private static final String CLASS_NAME = "MonthEventsModel";
    private static String EDIT_UPDATE_EVENT_URL = "../calclient/ViewEvent?update=true&edit=true&";
    private static String EDIT_EVENT_URL = "../calclient/ViewEvent?edit=true&";
    private static String UPDATE_EVENT_URL = "../calclient/ViewEvent?update=true&";
    private static String VIEW_EVENT_URL = "../calclient/ViewEvent?";
    private CalendarBaseModel calendarBaseModelObject = null;
    private UserPreferencesModel _userPrefsModel = null;
    private ArrayList events = null;
    private ArrayList currMonthDayNums = null;
    private HashMap daywiseSortedEvents = null;
    private String _originalCtxName = null;
    private String dateFormat = null;
    private String dateDelimiter = null;
    private String timeFormat = null;
    private String _userId = null;
    private String[] ownedCalIds = null;
    private HashMap calendars = null;
    private boolean isAnon = false;

    public MonthEventsModel() {
        _monthEventsModelLogger.entering(CLASS_NAME, "MonthEventsModel()");
        this.setUseDefaultValues(false);
        this.getCalendarBaseModel();
        _monthEventsModelLogger.exiting(CLASS_NAME, "MonthEventsModel()");
    }

    public MonthEventsModel(String string) {
        super(string);
        _monthEventsModelLogger.entering(CLASS_NAME, "MonthEventsModel( " + string + ")");
        this.setUseDefaultValues(false);
        this.getCalendarBaseModel();
        _monthEventsModelLogger.exiting(CLASS_NAME, "MonthEventsModel( " + string + ")");
    }

    public void setTimeFormat(String string) {
        _monthEventsModelLogger.entering(CLASS_NAME, "setTimeFormat()");
        this.timeFormat = string;
        _monthEventsModelLogger.exiting(CLASS_NAME, "setTimeFormat()");
    }

    public void setCurrentMonthDays(ArrayList arrayList) {
        _monthEventsModelLogger.entering(CLASS_NAME, "setCurrentMonthDays()");
        this.currMonthDayNums = arrayList;
        _monthEventsModelLogger.exiting(CLASS_NAME, "setCurrentMonthDays()");
    }

    public boolean dayHasEvents(Integer n) {
        _monthEventsModelLogger.entering(CLASS_NAME, "dayHasEvents()");
        if (this.daywiseSortedEvents != null && this.daywiseSortedEvents.size() > 0) {
            ArrayList arrayList = (ArrayList)this.daywiseSortedEvents.get(n);
            if (arrayList != null && arrayList.size() > 0) {
                _monthEventsModelLogger.exiting(CLASS_NAME, "dayHasEvents()");
                return true;
            }
            _monthEventsModelLogger.exiting(CLASS_NAME, "dayHasEvents()");
            return false;
        }
        _monthEventsModelLogger.exiting(CLASS_NAME, "dayHasEvents()");
        return false;
    }

    public Object execute(ModelExecutionContext modelExecutionContext) throws ModelControlException {
        _monthEventsModelLogger.entering(CLASS_NAME, "execute()");
        String string = null;
        string = modelExecutionContext != null ? modelExecutionContext.getOperationName() : CalendarExecutionModelContext.MONTHVIEW_CONTEXT;
        if (string.equals(CalendarExecutionModelContext.MONTHVIEW_CONTEXT)) {
            this.events = this.fetchMonthEvents();
            this.daywiseSortedEvents = this.sortEventsDayWise();
        }
        _monthEventsModelLogger.exiting(CLASS_NAME, "execute()");
        return null;
    }

    public Object retrieve(ModelExecutionContext modelExecutionContext) throws ModelControlException {
        _monthEventsModelLogger.entering(CLASS_NAME, "retrieve()");
        ArrayList arrayList = null;
        VEvent vEvent = null;
        this.isAnon = UWCUserHelper.isAnonymous(this._reqCtx);
        if (this._userId == null) {
            this._userId = !this.isAnon ? UWCUserHelper.getUID(this._reqCtx) : "@";
        }
        String string = null;
        if (modelExecutionContext != null) {
            string = modelExecutionContext.getOperationName();
        }
        if (string == null) {
            string = CalendarExecutionModelContext.MONTHVIEW_CONTEXT;
        }
        this.clear();
        if (this.currMonthDayNums != null && this.currMonthDayNums.size() > 0 && this.daywiseSortedEvents != null && this.daywiseSortedEvents.size() > 0) {
            int n = this.currMonthDayNums.size();
            for (int i = 0; i < n; ++i) {
                Integer n2 = (Integer)this.currMonthDayNums.get(i);
                Object v = this.daywiseSortedEvents.get(n2);
                if (v == null) continue;
                arrayList = (ArrayList)v;
                for (int j = 0; j < arrayList.size(); ++j) {
                    Properties properties;
                    Properties properties2;
                    this.appendRow();
                    vEvent = (VEvent)arrayList.get(j);
                    String string2 = null;
                    String string3 = null;
                    Object var12_12 = null;
                    Object var13_13 = null;
                    String string4 = null;
                    String string5 = null;
                    Organizer organizer = null;
                    DateTime dateTime = null;
                    String string6 = null;
                    boolean bl = false;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    boolean bl4 = false;
                    DateTime dateTime2 = null;
                    UWCCalendar uWCCalendar = null;
                    boolean bl5 = false;
                    boolean bl6 = false;
                    boolean bl7 = false;
                    try {
                        string2 = vEvent.getSummary();
                        dateTime = vEvent.getStartTime();
                        string3 = vEvent.getID();
                        organizer = vEvent.getOrganizer();
                        bl4 = vEvent.isRecurring();
                        dateTime2 = vEvent.getRecurrenceID();
                        string5 = vEvent.getClassification();
                        bl7 = vEvent.isAllDay();
                    }
                    catch (OperationNotSupportedException operationNotSupportedException) {
                        string2 = null;
                        dateTime = null;
                        string3 = null;
                        organizer = null;
                        bl4 = false;
                        dateTime2 = null;
                        string5 = null;
                    }
                    catch (CalendarComponentException calendarComponentException) {
                        string2 = null;
                        dateTime = null;
                        string3 = null;
                        organizer = null;
                        bl4 = false;
                        dateTime2 = null;
                        string5 = null;
                    }
                    if (_monthEventsModelLogger.isLoggable(Level.INFO)) {
                        _monthEventsModelLogger.info("Event for day Num: " + n2);
                    }
                    this.setValue(n2.toString(), "T");
                    if (string2 != null) {
                        if (_monthEventsModelLogger.isLoggable(Level.INFO)) {
                            _monthEventsModelLogger.info("Summary is: " + string2);
                        }
                        this.setValue(FIELD_EVENTTITLE, string2);
                    } else {
                        this.setValue(FIELD_EVENTTITLE, UWCUserHelper.getLocalizedStringLabel(this._reqCtx, "uwc-calclient-events-UntitledEventLabel", "UnTitled Event"));
                    }
                    if (string3 != null) {
                        this.setValue(FIELD_EVENTID, string3);
                    }
                    if (dateTime != null) {
                        if (this.timeFormat == null) {
                            this.timeFormat = UWCConstants.timeFormatValues[0];
                        }
                        if ((string6 = bl7 ? "" : UWCUtils.getDisplayableTime(this._reqCtx, dateTime, this.timeFormat)) != null) {
                            this.setValue(FIELD_EVENT_START_TIME, string6);
                        }
                    }
                    if (this.calendars == null) {
                        this.calendars = this.getCalendarBaseModel().getCalendars();
                    }
                    String string7 = null;
                    SOCSCalendar sOCSCalendar = null;
                    string4 = "";
                    try {
                        string7 = vEvent.getCalID();
                        if (!this.isAnon) {
                            uWCCalendar = (UWCCalendar)this.calendars.get(string7);
                            if (uWCCalendar != null) {
                                sOCSCalendar = (SOCSCalendar)uWCCalendar.getCalendar();
                            }
                            if (sOCSCalendar != null) {
                                string4 = sOCSCalendar.getRelativeCalId();
                            }
                        } else {
                            properties2 = new Properties();
                            properties = SOCSCalendar.getCalProps((String)string7, (String)UWCApplicationHelper.getWCAPHost(), (int)UWCApplicationHelper.getWCAPPort(), (Properties)properties2);
                            if (properties != null) {
                                string4 = properties.getProperty("RELATIVE-CALID");
                            }
                        }
                    }
                    catch (OperationNotSupportedException operationNotSupportedException) {
                        string4 = "";
                    }
                    catch (CalendarComponentException calendarComponentException) {
                        string4 = "";
                    }
                    catch (Exception exception) {
                        if (_monthEventsModelLogger.isLoggable(Level.WARNING)) {
                            _monthEventsModelLogger.warning("Exception: " + exception.getMessage());
                        }
                        string4 = "";
                    }
                    if (_monthEventsModelLogger.isLoggable(Level.INFO)) {
                        _monthEventsModelLogger.info("CalID of event: " + string4);
                    }
                    this.setValue(FIELD_CALID, string4);
                    if (bl4) {
                        this.setValue(FIELD_ISRECURRING, "T");
                        if (dateTime2 != null) {
                            if (_monthEventsModelLogger.isLoggable(Level.INFO)) {
                                _monthEventsModelLogger.info("RID of Event is: " + dateTime2.toISOString());
                            }
                            this.setValue(FIELD_RID, dateTime2.toISOString());
                        }
                    } else {
                        this.setValue(FIELD_ISRECURRING, "F");
                    }
                    if (bl7) {
                        if (_monthEventsModelLogger.isLoggable(Level.INFO)) {
                            _monthEventsModelLogger.info("Event is an All Day Event");
                        }
                        this.setValue(FIELD_ISALLDAY, "T");
                    } else {
                        if (_monthEventsModelLogger.isLoggable(Level.INFO)) {
                            _monthEventsModelLogger.info("Event is not an All Day Event");
                        }
                        this.setValue(FIELD_ISALLDAY, "F");
                    }
                    if (this.ownedCalIds == null) {
                        this.ownedCalIds = UWCUserHelper.getOwnedCalIDs(this._reqCtx);
                    }
                    if (!this.isAnon) {
                        try {
                            bl2 = UWCUserHelper.hasCalendarPermission(uWCCalendar, this._userId, "c", "w");
                            bl5 = UWCUserHelper.isUserTheCalendarOwner(uWCCalendar, this._userId);
                        }
                        catch (UWCException uWCException) {
                            if (_monthEventsModelLogger.isLoggable(Level.WARNING)) {
                                _monthEventsModelLogger.warning("Failed to verify the permissions of the calendar: " + string4);
                            }
                            bl2 = false;
                        }
                        try {
                            bl3 = UWCUserHelper.hasCalendarPermission(uWCCalendar, this._userId, "c", "d");
                        }
                        catch (UWCException uWCException) {
                            if (_monthEventsModelLogger.isLoggable(Level.WARNING)) {
                                _monthEventsModelLogger.warning("Failed to verify the delete permissions of the calendar: " + string4);
                            }
                            bl3 = false;
                        }
                    } else {
                        bl2 = false;
                        bl3 = false;
                        bl5 = false;
                    }
                    if (!bl2) {
                        if (_monthEventsModelLogger.isLoggable(Level.INFO)) {
                            _monthEventsModelLogger.info("Event Calendar " + string4 + " does not belong to user nor does it have write permission");
                        }
                        this.setValue(FIELD_MODIFIABLE, "F");
                    } else {
                        if (_monthEventsModelLogger.isLoggable(Level.INFO)) {
                            _monthEventsModelLogger.info("Event Calendar " + string4 + " either belongs to user or it has write permission");
                        }
                        this.setValue(FIELD_MODIFIABLE, "T");
                    }
                    if (bl5) {
                        this.setValue(FIELD_OWNEDCAL, "T");
                    } else {
                        this.setValue(FIELD_OWNEDCAL, "F");
                    }
                    if (!bl3) {
                        if (_monthEventsModelLogger.isLoggable(Level.INFO)) {
                            _monthEventsModelLogger.info("Event Calendar " + string4 + " does not have delete permission");
                        }
                        this.setValue(FIELD_DELETEABLE, "F");
                    } else {
                        if (_monthEventsModelLogger.isLoggable(Level.INFO)) {
                            _monthEventsModelLogger.info("Event Calendar " + string4 + " has delete permission");
                        }
                        this.setValue(FIELD_DELETEABLE, "T");
                    }
                    if (_monthEventsModelLogger.isLoggable(Level.INFO)) {
                        _monthEventsModelLogger.info("Privacy Classification of Event: " + string5);
                    }
                    if (string5 != null && (string5.equalsIgnoreCase("CONFIDENTIAL") || string5.equalsIgnoreCase("PRIVATE")) && !bl5) {
                        this.setValue(FIELD_ISCONFIDENTIAL, "T");
                    } else {
                        this.setValue(FIELD_ISCONFIDENTIAL, "F");
                    }
                    properties2 = new NonSyncStringBuffer("");
                    properties = null;
                    try {
                        properties = vEvent.getAttendee(string4);
                        bl6 = vEvent.isCalIdTheOrganizer(string4);
                    }
                    catch (OperationNotSupportedException operationNotSupportedException) {
                        properties = null;
                    }
                    catch (CalendarComponentException calendarComponentException) {
                        properties = null;
                    }
                    if (bl2) {
                        if (organizer != null) {
                            if (bl6) {
                                if (properties != null) {
                                    properties2.append(EDIT_UPDATE_EVENT_URL);
                                } else {
                                    properties2.append(EDIT_EVENT_URL);
                                }
                            } else if (properties != null) {
                                properties2.append(UPDATE_EVENT_URL);
                            } else {
                                properties2.append(VIEW_EVENT_URL);
                            }
                        }
                    } else {
                        properties2.append(VIEW_EVENT_URL);
                    }
                    if (bl3) {
                        properties2.append("delete");
                        properties2.append("=true&");
                    }
                    properties2.append(FIELD_EVENTID);
                    properties2.append("=");
                    properties2.append(string3);
                    properties2.append("&");
                    properties2.append(FIELD_CALID);
                    properties2.append("=");
                    properties2.append(string4);
                    if (dateTime2 != null) {
                        properties2.append("&");
                        properties2.append(FIELD_RID);
                        properties2.append("=");
                        properties2.append(dateTime2.toISOString());
                    }
                    if (UWCUserHelper.isAnonymous(this._reqCtx)) {
                        properties2.append("&");
                        properties2.append("anon=");
                        properties2.append("true");
                    }
                    this.setValue(FIELD_EVENTURL, properties2.toString());
                    boolean bl8 = this.isConflictingEvent(vEvent, arrayList, j);
                    if (bl8) {
                        this.setValue(FIELD_ISCONFLICT, "T");
                        continue;
                    }
                    this.setValue(FIELD_ISCONFLICT, "F");
                }
            }
        } else if (_monthEventsModelLogger.isLoggable(Level.INFO)) {
            _monthEventsModelLogger.info("No events obtained for the month!");
        }
        this.events = null;
        this.beforeFirst();
        _monthEventsModelLogger.exiting(CLASS_NAME, "retrieve()");
        return null;
    }

    private ArrayList fetchMonthEvents() {
        _monthEventsModelLogger.entering(CLASS_NAME, "fetchMonthEvents()");
        ArrayList arrayList = null;
        ArrayList arrayList2 = null;
        arrayList2 = this.getCalendarBaseModel().getAllEvents();
        if (arrayList2 != null && arrayList2.size() > 0) {
            if (_monthEventsModelLogger.isLoggable(Level.INFO)) {
                _monthEventsModelLogger.info("Obtained Events for Month!");
            }
            arrayList = (ArrayList)arrayList2.clone();
        }
        _monthEventsModelLogger.exiting(CLASS_NAME, "fetchMonthEvents()");
        return arrayList;
    }

    private HashMap sortEventsDayWise() {
        _monthEventsModelLogger.entering(CLASS_NAME, "sortEventsDayWise()");
        HashMap hashMap = null;
        DateTime dateTime = null;
        VEvent vEvent = null;
        int n = 0;
        ArrayList<VEvent> arrayList = null;
        Integer n2 = null;
        Object var7_7 = null;
        if (this.events != null && this.events.size() > 0) {
            hashMap = new HashMap();
            for (int i = 0; i < this.events.size(); ++i) {
                var7_7 = null;
                vEvent = (VEvent)this.events.get(i);
                try {
                    dateTime = vEvent.getStartTime();
                }
                catch (OperationNotSupportedException operationNotSupportedException) {
                    hashMap = null;
                }
                catch (CalendarComponentException calendarComponentException) {
                    hashMap = null;
                }
                n = dateTime.getDay();
                n2 = new Integer(n);
                var7_7 = hashMap.get(n2);
                arrayList = var7_7 == null ? new ArrayList<VEvent>() : (ArrayList<VEvent>)var7_7;
                arrayList.add(vEvent);
                hashMap.put(n2, arrayList);
            }
        }
        _monthEventsModelLogger.exiting(CLASS_NAME, "sortEventsDayWise()");
        return hashMap;
    }

    private boolean isConflictingEvent(VEvent vEvent, ArrayList arrayList, int n) {
        _monthEventsModelLogger.entering(CLASS_NAME, "isConflictingEvent()");
        boolean bl = false;
        if (arrayList == null || arrayList.size() <= 1) {
            return false;
        }
        boolean bl2 = false;
        DateTime dateTime = null;
        DateTime dateTime2 = null;
        try {
            bl2 = vEvent.isAllDay();
            dateTime = vEvent.getStart();
            dateTime2 = vEvent.getEnd();
        }
        catch (CalendarComponentException calendarComponentException) {
            if (_monthEventsModelLogger.isLoggable(Level.WARNING)) {
                _monthEventsModelLogger.warning("Failed to obtain Data from Event");
            }
            return false;
        }
        catch (OperationNotSupportedException operationNotSupportedException) {
            if (_monthEventsModelLogger.isLoggable(Level.WARNING)) {
                _monthEventsModelLogger.warning("Failed to obtain Data from Event");
            }
            return false;
        }
        if (bl2) {
            return false;
        }
        boolean bl3 = false;
        DateTime dateTime3 = null;
        DateTime dateTime4 = null;
        for (int i = 0; i < arrayList.size(); ++i) {
            if (i == n) continue;
            VEvent vEvent2 = (VEvent)arrayList.get(i);
            try {
                bl3 = vEvent2.isAllDay();
                dateTime3 = vEvent2.getStart();
                dateTime4 = vEvent2.getEnd();
            }
            catch (CalendarComponentException calendarComponentException) {
                if (!_monthEventsModelLogger.isLoggable(Level.WARNING)) continue;
                _monthEventsModelLogger.warning("Failed to obtain Data from Event");
                continue;
            }
            catch (OperationNotSupportedException operationNotSupportedException) {
                if (!_monthEventsModelLogger.isLoggable(Level.WARNING)) continue;
                _monthEventsModelLogger.warning("Failed to obtain Data from Event");
                continue;
            }
            if (bl3) continue;
            if (dateTime.equals((Object)dateTime3) || dateTime2.equals((Object)dateTime4)) {
                bl = true;
                break;
            }
            if (dateTime.after((Object)dateTime3) && dateTime2.before((Object)dateTime4)) {
                bl = true;
                break;
            }
            if (dateTime.before((Object)dateTime3) && dateTime2.after((Object)dateTime3) && dateTime2.before((Object)dateTime4)) {
                bl = true;
                break;
            }
            if (dateTime.after((Object)dateTime3) && dateTime.before((Object)dateTime4)) {
                bl = true;
                break;
            }
            if (!dateTime.before((Object)dateTime3) || !dateTime2.after((Object)dateTime4)) continue;
            bl = true;
            break;
        }
        _monthEventsModelLogger.exiting(CLASS_NAME, "isConflictingEvent()");
        return bl;
    }

    public void setRequestContext(RequestContext requestContext) {
        _monthEventsModelLogger.entering(CLASS_NAME, "setRequestContext()");
        this._reqCtx = requestContext;
        _monthEventsModelLogger.exiting(CLASS_NAME, "setRequestContext()");
    }

    private CalendarBaseModel getCalendarBaseModel() {
        _monthEventsModelLogger.entering(CLASS_NAME, "getCalendarBaseModel()");
        if (this.calendarBaseModelObject == null) {
            this.calendarBaseModelObject = UWCUserHelper.getCalendarBaseModel(this._reqCtx);
        }
        _monthEventsModelLogger.exiting(CLASS_NAME, "getCalendarBaseModel()");
        return this.calendarBaseModelObject;
    }

    private void dumpRecordValues() {
        _monthEventsModelLogger.entering(CLASS_NAME, "dumpRecordValues()");
        Map map = null;
        int n = this.getNumRows();
        _monthEventsModelLogger.info("Total Number of records: " + n);
        for (int i = 0; i < n; ++i) {
            this.setRowIndex(i);
            map = this.getValueMap(i);
            if (map != null) {
                if (map.isEmpty()) {
                    _monthEventsModelLogger.info("Map is empty for row: " + i);
                    continue;
                }
                Set set = map.keySet();
                String[] stringArray = UWCUtils.getStringArray(set.toArray());
                if (stringArray == null || stringArray.length <= 0) continue;
                _monthEventsModelLogger.info("Key-Value Pairs for record: " + i);
                for (int j = 0; j < stringArray.length; ++j) {
                    _monthEventsModelLogger.info("Key: " + stringArray[j] + " Value: " + (String)this.getValue(stringArray[j]));
                }
                continue;
            }
            _monthEventsModelLogger.info("No Value map present for the row: " + i);
        }
        _monthEventsModelLogger.exiting(CLASS_NAME, "dumpRecordValues()");
    }

    static {
        _monthEventsModelLogger = UWCLogger.getLogger("uwc.calclient.model");
    }
}

