/*
 * Decompiled with CFR 0.152.
 */
package com.sun.uwc.calclient.model;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.RequestParticipant;
import com.iplanet.jato.model.DefaultModel;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.model.ModelExecutionContext;
import com.iplanet.jato.model.RetrievingModel;
import com.sun.comclient.calendar.DateTime;
import com.sun.comclient.calendar.Duration;
import com.sun.comclient.calendar.PropertiesException;
import com.sun.uwc.calclient.model.FreeBusyModel;
import com.sun.uwc.common.UWCException;
import com.sun.uwc.common.UWCUserHelper;
import com.sun.uwc.common.model.CalendarExecutionModelContext;
import com.sun.uwc.common.model.UserPreferencesModel;
import com.sun.uwc.common.util.UWCLogger;
import com.sun.uwc.common.util.UWCUtils;
import java.util.ArrayList;
import java.util.TimeZone;
import java.util.logging.Logger;

public final class FreeBusyTimeSlotModel
extends DefaultModel
implements RequestParticipant,
RetrievingModel {
    public static final String FIELD_TIMESLOT_TO_DISPLAY = "timeSlotToDisplay";
    public static final String FIELD_TIMESTAMP_TO_DISPLAY = "timeStampToDisplay";
    public static final String FIELD_FREEBUSY_INFO = "freeBusyInfo";
    public static final String FIELD_NAME_TO_DISPLAY = "calNameToDisplay";
    public static final String FIELD_START_DATE_DAY = "startday";
    public static final String FIELD_START_DATE_MONTH = "startmonth";
    public static final String FIELD_START_DATE_YEAR = "startyear";
    public static final String FIELD_START_TIME_HOURS = "starthour";
    public static final String FIELD_START_TIME_MINUTES = "startminutes";
    public static final String FIELD_DURATION_HOURS = "durationHours";
    public static final String FIELD_DURATION_MINUTES = "durationMinutes";
    public static final String FIELD_NUMBEROF_SLOTS = "slotnos";
    private RequestContext _reqCtx = null;
    private static Logger _fbtsModelLogger = null;
    private static final String CLASS_NAME = "FreeBusyTimeSlotModel";
    private UserPreferencesModel uPrefs = null;
    private DateTime start = null;
    private DateTime end = null;
    private Duration splitHour = null;
    private Duration duration = null;
    private String usersTimeFormatPref = null;
    private transient String usersTimeZonePref = null;
    private ArrayList fieldTimeSlots = null;
    private ArrayList displayTimeSlots = null;
    private TimeZone timezone = null;
    static /* synthetic */ Class class$com$sun$uwc$calclient$model$FreeBusyModel;

    public FreeBusyTimeSlotModel() {
        _fbtsModelLogger.entering(CLASS_NAME, "FreeBusyTimeSlotModel()");
        _fbtsModelLogger.exiting(CLASS_NAME, "FreeBusyTimeSlotModel()");
    }

    public FreeBusyTimeSlotModel(String string) {
        super(string);
        _fbtsModelLogger.entering(CLASS_NAME, "FreeBusyTimeSlotModel(name)");
        _fbtsModelLogger.exiting(CLASS_NAME, "FreeBusyTimeSlotModel(name)");
    }

    public void setStartTime(DateTime dateTime) {
        _fbtsModelLogger.entering(CLASS_NAME, "setStartTime()");
        this.start = dateTime;
        _fbtsModelLogger.exiting(CLASS_NAME, "setStartTime()");
    }

    public void setDuration(Duration duration) {
        _fbtsModelLogger.entering(CLASS_NAME, "setDuration()");
        this.duration = duration;
        _fbtsModelLogger.entering(CLASS_NAME, "setDuration()");
    }

    public void setSplitHour(Duration duration) {
        _fbtsModelLogger.entering(CLASS_NAME, "setSplitHour()");
        this.splitHour = duration;
        _fbtsModelLogger.entering(CLASS_NAME, "setSplitHour()");
    }

    public void setTimeFormat(String string) {
        _fbtsModelLogger.entering(CLASS_NAME, "setTimeFormat()");
        this.usersTimeFormatPref = string;
        _fbtsModelLogger.entering(CLASS_NAME, "setTimeFormat()");
    }

    public void setEndTime(DateTime dateTime) {
        _fbtsModelLogger.entering(CLASS_NAME, "setEndTime()");
        this.end = dateTime;
        _fbtsModelLogger.exiting(CLASS_NAME, "setEndTime()");
    }

    public int getNumberofSlots() {
        if (null == this.displayTimeSlots) {
            return -1;
        }
        return this.displayTimeSlots.size();
    }

    public Object execute(ModelExecutionContext modelExecutionContext) throws ModelControlException {
        _fbtsModelLogger.entering(CLASS_NAME, "execute()");
        this.fieldTimeSlots = new ArrayList();
        this.displayTimeSlots = new ArrayList();
        this.getUserPreferences();
        if (this.start == null) {
            this.start = this.constructStartTime();
            if (this.start == null) {
                this.start = new DateTime();
                this.start.setTime(0, 0, 0);
            }
            this.setStartTime(this.start);
        }
        if (this.end == null) {
            this.end = this.constructEndTime();
            if (this.end == null) {
                this.end = (DateTime)this.start.clone();
                this.end.setTime(23, 59, 59);
            }
            this.setEndTime(this.end);
        }
        if (null == this.splitHour) {
            try {
                this.splitHour = new Duration(0, 30);
            }
            catch (PropertiesException propertiesException) {
                _fbtsModelLogger.info("Exception in creating Duration object");
            }
        }
        if (this.usersTimeFormatPref == null) {
            this.usersTimeFormatPref = "12";
        }
        while (!this.start.equals((Object)this.end) && !this.start.after((Object)this.end)) {
            _fbtsModelLogger.info("Adding Time Slot = " + this.start.toISOString());
            this.fieldTimeSlots.add(this.start.toISOString());
            this.displayTimeSlots.add(this.getDisplayableTime(this._reqCtx, this.start, this.usersTimeFormatPref));
            this.start.add(this.splitHour);
        }
        _fbtsModelLogger.exiting(CLASS_NAME, "execute()");
        return null;
    }

    public Object retrieve(ModelExecutionContext modelExecutionContext) throws ModelControlException {
        _fbtsModelLogger.entering(CLASS_NAME, "retrieve()");
        String string = null;
        string = modelExecutionContext != null ? modelExecutionContext.getOperationName() : CalendarExecutionModelContext.FREEBUSYMODEL_DISPLAYTIMESLOT_CONTEXT;
        if (string.equals(CalendarExecutionModelContext.FREEBUSYMODEL_DISPLAYTIMESLOT_CONTEXT)) {
            this.clear();
            if (null == this.displayTimeSlots) {
                return null;
            }
            String string2 = null;
            String string3 = null;
            _fbtsModelLogger.finest("No of Slots in TimeDisplaySlot is " + this.displayTimeSlots.size());
            for (int i = 0; i < this.displayTimeSlots.size(); ++i) {
                this.appendRow();
                string2 = (String)this.displayTimeSlots.get(i);
                string3 = (String)this.fieldTimeSlots.get(i);
                this.setValue(FIELD_TIMESLOT_TO_DISPLAY, string2);
                this.setValue(FIELD_TIMESTAMP_TO_DISPLAY, string3);
            }
            this.beforeFirst();
        } else if (string.equals(CalendarExecutionModelContext.FREEBUSYMODEL_GETFREEBUSY_CONTEXT)) {
            this.clear();
            if (null == this.displayTimeSlots) {
                return null;
            }
            FreeBusyModel freeBusyModel = this.getFreeBusyModel();
            freeBusyModel.setUseDefaultValues(false);
            String string4 = null;
            freeBusyModel.dumpRecordAtIndex(freeBusyModel.getRowIndex());
            for (int i = 0; i < this.displayTimeSlots.size(); ++i) {
                this.appendRow();
                string4 = (String)freeBusyModel.getValue((String)this.fieldTimeSlots.get(i));
                if (string4 == null) {
                    string4 = "FREE";
                }
                _fbtsModelLogger.finest("For Slot " + (String)this.fieldTimeSlots.get(i) + " FreeBusy is :" + string4);
                this.setValue(FIELD_FREEBUSY_INFO, string4);
            }
            this.beforeFirst();
        }
        _fbtsModelLogger.exiting(CLASS_NAME, "retrieve()");
        return null;
    }

    public void setRequestContext(RequestContext requestContext) {
        _fbtsModelLogger.entering(CLASS_NAME, "setRequestContext()");
        this._reqCtx = requestContext;
        _fbtsModelLogger.exiting(CLASS_NAME, "setRequestContext()");
    }

    public void setTimeZone(TimeZone timeZone) {
        _fbtsModelLogger.entering(CLASS_NAME, "setTimeZone()");
        this.timezone = timeZone;
        _fbtsModelLogger.exiting(CLASS_NAME, "setTimeZone()");
    }

    private FreeBusyModel getFreeBusyModel() {
        _fbtsModelLogger.entering(CLASS_NAME, "setRequestContext()");
        FreeBusyModel freeBusyModel = (FreeBusyModel)this._reqCtx.getModelManager().getModel(class$com$sun$uwc$calclient$model$FreeBusyModel == null ? (class$com$sun$uwc$calclient$model$FreeBusyModel = FreeBusyTimeSlotModel.class$("com.sun.uwc.calclient.model.FreeBusyModel")) : class$com$sun$uwc$calclient$model$FreeBusyModel, "calfreebusy");
        _fbtsModelLogger.exiting(CLASS_NAME, "setRequestContext()");
        return freeBusyModel;
    }

    private DateTime constructEndTime() {
        String string = null;
        String string2 = null;
        DateTime dateTime = null;
        if (this.start != null) {
            dateTime = (DateTime)this.start.clone();
        }
        string = (String)this.getValue(FIELD_DURATION_HOURS);
        string2 = (String)this.getValue(FIELD_DURATION_MINUTES);
        if (dateTime != null) {
            if (string != null) {
                dateTime.add(10, Integer.parseInt(string));
            } else {
                dateTime.setHours(23);
            }
            if (string2 != null) {
                dateTime.add(12, Integer.parseInt(string2));
            } else {
                dateTime.setMinutes(59);
            }
        }
        return dateTime;
    }

    private DateTime constructStartTime() {
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        DateTime dateTime = null;
        string = (String)this.getValue(FIELD_START_DATE_MONTH);
        string2 = (String)this.getValue(FIELD_START_DATE_DAY);
        string3 = (String)this.getValue(FIELD_START_DATE_YEAR);
        if (string != null && string2 != null && string3 != null && (dateTime = this.timezone != null ? new DateTime(this.timezone) : new DateTime()) != null) {
            dateTime.setMonth(Integer.parseInt(string) - 1);
            dateTime.setDay(Integer.parseInt(string2));
            dateTime.setYear(Integer.parseInt(string3));
            dateTime.setSeconds(0);
        }
        string4 = (String)this.getValue(FIELD_START_TIME_HOURS);
        string5 = (String)this.getValue(FIELD_START_TIME_MINUTES);
        if (dateTime != null) {
            if (string4 != null) {
                dateTime.setHours(Integer.parseInt(string4));
            } else {
                dateTime.setHours(0);
            }
            if (string5 != null) {
                dateTime.setMinutes(Integer.parseInt(string5));
            } else {
                dateTime.setMinutes(0);
            }
        }
        return dateTime;
    }

    private void getUserPreferences() {
        _fbtsModelLogger.entering(CLASS_NAME, ":getUserPreferences()");
        this.uPrefs = UWCUserHelper.getUserPrefModel(this._reqCtx);
        if (null != this.uPrefs) {
            try {
                if (!this.uPrefs.getInitialized()) {
                    this.uPrefs.initializeCommonPreferences();
                }
            }
            catch (UWCException uWCException) {
                _fbtsModelLogger.warning("initializeCommonPreferences: " + uWCException);
            }
            this.usersTimeFormatPref = this.uPrefs.getTimeFormat();
            this.usersTimeZonePref = this.uPrefs.getTimeZone();
            _fbtsModelLogger.finest("usersTimeFormatPref: " + this.usersTimeFormatPref);
            _fbtsModelLogger.finest("usersTimeZonePref: " + this.usersTimeZonePref);
            if (null == this.usersTimeFormatPref) {
                this.usersTimeFormatPref = "12";
                _fbtsModelLogger.finest("usersTimeFormatPref: setting to default value: " + this.usersTimeFormatPref);
            }
        } else {
            _fbtsModelLogger.severe("uPrefs: Couldn't get UserPreferencesModel object");
            this.usersTimeFormatPref = "12";
        }
    }

    private String getDisplayableTime(RequestContext requestContext, DateTime dateTime, String string) {
        String string2 = UWCUtils.getDisplayableHours(requestContext, dateTime, string);
        String string3 = UWCUtils.getDisplayableMinutes(requestContext, dateTime, "24");
        string2 = null == string2 ? "??" : string2;
        string3 = null == string3 ? ":??" : string3;
        return string2 + string3;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        _fbtsModelLogger = UWCLogger.getLogger("uwc.calclient.model");
    }
}

