/*
 * Decompiled with CFR 0.152.
 */
package com.sun.uwc.calclient.model;

import com.iplanet.jato.model.InvalidContextException;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.model.ModelExecutionContext;
import com.iplanet.jato.model.RetrievingModel;
import com.iplanet.jato.util.NonSyncStringBuffer;
import com.sun.comclient.calendar.DateTime;
import com.sun.comclient.calendar.Organizer;
import com.sun.comclient.calendar.VEvent;
import com.sun.comclient.calendar.socs.SOCSCalendar;
import com.sun.uwc.calclient.model.CalendarBaseModel;
import com.sun.uwc.calclient.model.EventsModel;
import com.sun.uwc.calclient.model.UWCCalendar;
import com.sun.uwc.common.UWCException;
import com.sun.uwc.common.UWCUserHelper;
import com.sun.uwc.common.model.CalendarExecutionModelContext;
import com.sun.uwc.common.model.UWCModelControlException;
import com.sun.uwc.common.util.UWCConstants;
import com.sun.uwc.common.util.UWCLogger;
import com.sun.uwc.common.util.UWCUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;

public class EventsListModel
extends EventsModel
implements RetrievingModel {
    private transient ArrayList _events = null;
    private transient ArrayList _calids = null;
    private transient DateTime _start = null;
    private transient DateTime _end = null;
    private transient boolean _anonymous = false;
    private transient boolean _searchMode = false;
    private transient boolean _eventSorting = false;
    private transient String _sortField = "DTSTART";
    private transient int _sortOrder = 1;
    private transient DateTime _selectedDate = null;
    private CalendarBaseModel cbm = null;
    private HashMap calids = null;
    private static final transient String CLASS_NAME = "EventsListModel";
    private static transient Logger _log = null;
    private transient String _methodTitle = null;
    public static final transient String SORT_CRITERIA_NO_SORTING = "NoSorting";
    public static final transient String SORT_CRITERIA_TITLE_ASCENDING = "TitleAscending";
    public static final transient String SORT_CRITERIA_TITLE_DECENDING = "TitleDescending";
    public static final transient String SORT_CRITERIA_START_DATE_ASCENDING = "StartDateAscending";
    public static final transient String SORT_CRITERIA_START_DATE_DECENDING = "StartDateDescending";
    public static final String FIELD_TIME_ZONE = "TimeZone";
    public static final String FIELD_SEARCH_TEXT = "SearchText";
    public static final String FIELD_SORT_CRITERIA = "SortCriteria";
    public static final String FIELD_START_MONTH = "StartMonth";
    public static final String FIELD_START_DAY = "StartDay";
    public static final String FIELD_START_YEAR = "StartYear";
    public static final String FIELD_VIEW_CONTEXT = "ViewContext";
    public static final String FIELD_VIEW_CATEGORY = "ViewCategory";
    public static final String FIELD_CONTEXT_NAME = "ContextText";
    public static final String FIELD_CONTEXT_DURATION = "ContextDuration";
    public static final String FIELD_SELECTED_DATE_IN_UTC = "SelectedDateInUTC";
    public static final String FIELD_INVITATIONS_COUNT = "InvitationsCount";
    public static final String FIELD_IS_EVENT_SELECTED = "IsEventSelected";
    public static final String FIELD_VIEW_EVENT_URL = "ViewEventUrl";
    public static final String FIELD_OWNER_NAME = "OwnerName";
    public static final String FIELD_CALENDAR_NAME = "CalendarName";
    public static final String FIELD_IS_EXTERNAL = "IsExternal";
    public static final String FIELD_IS_WRITABLE = "IsWritable";
    public static final String FIELD_CAN_DELETE = "CanDelete";
    public static final String FIELD_EDIT_EVENT_URL = "EditEventUrl";
    public static final String IS_LAST_ROW = "IsLastRow";
    public static final String FIELD_EVENTS_FILTER = "eventsFilter";
    public static final String FIELD_SHOW_EVENTS_LINK = "eventsLink";
    public static final String FIELD_IS_NO_EVENTS = "emptyevents";
    public static final String FIELD_DURATION_DISPLAY = "durationdisplay";

    public EventsListModel() {
    }

    public EventsListModel(String string) {
        super(string);
    }

    public ArrayList getEvents() {
        return this._events;
    }

    public void setEvents(ArrayList arrayList) {
        this._events = arrayList;
    }

    public DateTime getDateFromDateFields() throws IllegalArgumentException, NumberFormatException {
        return UWCUtils.getDateTime((String)this.getValue(FIELD_START_DAY), (String)this.getValue(FIELD_START_MONTH), (String)this.getValue(FIELD_START_YEAR), "0", "0", "0", (String)this.getValue(FIELD_TIME_ZONE));
    }

    public void setDateInDateFields(DateTime dateTime) {
        String string = null;
        String string2 = null;
        String string3 = null;
        TimeZone timeZone = null;
        if (null != dateTime) {
            string = UWCConstants.monthValues[dateTime.get(2)];
            string2 = UWCConstants.dayValues[dateTime.get(5) - 1];
            string3 = UWCConstants.yearValues[dateTime.get(1) - 2000];
            timeZone = dateTime.getTimeZone();
        }
        this.setValue(FIELD_START_MONTH, string);
        this.setValue(FIELD_START_DAY, string2);
        this.setValue(FIELD_START_YEAR, string3);
        this.setValue(FIELD_SELECTED_DATE_IN_UTC, null == dateTime ? null : dateTime.toISO8601());
        this.setValue(FIELD_TIME_ZONE, null == timeZone ? null : timeZone.getID());
    }

    public DateTime getStartTime() {
        return this._start;
    }

    public void setStartTime(DateTime dateTime) {
        this._start = dateTime;
    }

    public DateTime getEndTime() {
        return this._end;
    }

    public void setEndTime(DateTime dateTime) {
        this._end = dateTime;
    }

    public void setSelectedDate(DateTime dateTime) {
        this._selectedDate = dateTime;
    }

    public boolean getAnonymous() {
        return this._anonymous;
    }

    public void setAnonymous(boolean bl) {
        this._anonymous = bl;
    }

    public String getCategory() {
        return (String)this.getValue(FIELD_VIEW_CATEGORY);
    }

    public void setCategory(String string) {
        this.setValue(FIELD_VIEW_CATEGORY, string);
    }

    public String getViewContext() {
        return (String)this.getValue(FIELD_VIEW_CONTEXT);
    }

    public void setViewContext(String string) {
        this.setValue(FIELD_VIEW_CONTEXT, string);
    }

    public String getSearchText() {
        return (String)this.getValue(FIELD_SEARCH_TEXT);
    }

    public void setSearchText(String string) {
        this.setValue(FIELD_SEARCH_TEXT, string);
    }

    public void enableSearchTextMode(boolean bl) {
        this._searchMode = bl;
    }

    public void enableEventSorting(boolean bl) {
        this._eventSorting = bl;
    }

    public String getSortCriteria() {
        return (String)this.getValue(FIELD_SORT_CRITERIA);
    }

    public void setSortCriteria(String string) {
        this.setValue(FIELD_SORT_CRITERIA, string);
    }

    public ArrayList getCalids() {
        return this._calids;
    }

    public String[] getCalidsStringArray() {
        if (null == this._calids) {
            return null;
        }
        if (this._calids.size() < 1) {
            return null;
        }
        return this._calids.toArray(UWCConstants.ZERO_STRING_ARRAY);
    }

    public void addCalid(ArrayList arrayList) {
        if (null == arrayList) {
            return;
        }
        if (null == this._calids) {
            this._calids = new ArrayList();
        }
        this._calids.addAll(arrayList);
    }

    public void addCalid(String string) {
        if (null == string) {
            return;
        }
        if (null == this._calids) {
            this._calids = new ArrayList();
        }
        this._calids.add(string);
    }

    public void removeCalid(String string) {
        if (null == this._calids || null == string) {
            return;
        }
        int n = this._calids.size();
        for (int i = 0; i < n; ++i) {
            if (!string.equals((String)this._calids.get(i))) continue;
            this._calids.remove(i);
            return;
        }
    }

    public void removeAllCalids() {
        if (null != this._calids) {
            this._calids.clear();
        }
    }

    public Object execute(ModelExecutionContext modelExecutionContext) throws ModelControlException {
        Object var2_2 = null;
        String string = null;
        string = null != modelExecutionContext ? modelExecutionContext.getOperationName() : CalendarExecutionModelContext.LOAD_EVENT_CONTEXT;
        this._methodTitle = "execute(" + string + ")";
        _log.entering(CLASS_NAME, this._methodTitle);
        if (string.equals(CalendarExecutionModelContext.LOAD_EVENT_CONTEXT)) {
            try {
                this.fetchEvents();
            }
            catch (UWCException uWCException) {
                if (_log.isLoggable(Level.SEVERE)) {
                    _log.severe("UWCException while fetching the events: " + uWCException);
                }
                UWCUtils.printStackTrace(uWCException);
                _log.exiting(CLASS_NAME, this._methodTitle);
                throw new UWCModelControlException(uWCException.getReason(), uWCException.getDetails());
            }
        } else {
            _log.exiting(CLASS_NAME, this._methodTitle);
            throw new UWCModelControlException((Throwable)new InvalidContextException("Event execute context failed: \"" + string + "\" is invalid event execute context"));
        }
        _log.exiting(CLASS_NAME, this._methodTitle);
        return null;
    }

    public Object retrieve(ModelExecutionContext modelExecutionContext) throws ModelControlException {
        Object var2_2 = null;
        String string = null;
        string = null != modelExecutionContext ? modelExecutionContext.getOperationName() : CalendarExecutionModelContext.LOAD_EVENT_CONTEXT;
        this._methodTitle = "retrieve(" + string + ")";
        _log.entering(CLASS_NAME, this._methodTitle);
        if (!string.equals(CalendarExecutionModelContext.LOAD_EVENT_CONTEXT)) {
            _log.exiting(CLASS_NAME, this._methodTitle);
            throw new UWCModelControlException((Throwable)new InvalidContextException("Event retrieve context failed: \"" + string + "\" is invalid event retrieve context"));
        }
        this.cbm = UWCUserHelper.getCalendarBaseModel(this._reqCtx);
        this.calids = this.cbm.getCalendars();
        this.loadEvents();
        _log.exiting(CLASS_NAME, this._methodTitle);
        return null;
    }

    private void fetchEvents() throws UWCException {
        _log.entering(CLASS_NAME, "fetchEvents()");
        this._events = null;
        CalendarBaseModel calendarBaseModel = UWCUserHelper.getCalendarBaseModel(this._reqCtx);
        if (null == calendarBaseModel) {
            _log.exiting(CLASS_NAME, "fetchEvents()");
            throw new UWCException(65, "Couldn't get CalendarBaseModel: Can't retrieve events");
        }
        try {
            Object object;
            Object object2;
            Object object3;
            String string = (String)this.getValue(FIELD_VIEW_CONTEXT);
            if (null == string) {
                string = "day";
            }
            if (null == this._start && null == this._end) {
                object3 = this.getDateFromDateFields();
                this._start = UWCUtils.getContextStart((DateTime)object3, string, object3.getFirstDayOfWeek());
                this._end = UWCUtils.getContextEnd((DateTime)object3, string);
                if (_log.isLoggable(Level.FINEST)) {
                    _log.finest("Start Date is " + this._start.toString());
                    _log.finest("End Date is " + this._end.toString());
                }
            } else if (null == this._start) {
                this._end = UWCUtils.getContextEnd(this._start, string);
            } else if (null == this._end) {
                this._start = UWCUtils.getContextStart(this._end, string, this._end.getFirstDayOfWeek());
            }
            this.setDateInDateFields(null != this._selectedDate ? this._selectedDate : this._start);
            if (_log.isLoggable(Level.FINEST)) {
                _log.finest("Start Date is " + this._start.toString());
                _log.finest("End Date is " + this._end.toString());
            }
            this.setValue(FIELD_CONTEXT_NAME, UWCUtils.getDisplayableContextName(this._reqCtx, string));
            this.setValue(FIELD_CONTEXT_DURATION, UWCUtils.getDisplayableContextDuration(this._reqCtx, this._start, this._end, string));
            this.setValue(FIELD_INVITATIONS_COUNT, "??");
            calendarBaseModel.removeAllCalids();
            if (null != this._calids) {
                calendarBaseModel.addCalid(this._calids);
            }
            calendarBaseModel.setAnonymous(this._anonymous);
            object3 = (String)this.getValue(FIELD_EVENTS_FILTER);
            if (object3 != null && ((String)object3).length() > 0) {
                calendarBaseModel.setEventsFilter((String)object3);
            }
            if (this._searchMode) {
                _log.finest("In searchMode: Searching the events....");
                object2 = (String)this.getValue(FIELD_SEARCH_TEXT);
                if (null != object2 && !object2.trim().equals("")) {
                    object = "ALL=" + object2;
                    calendarBaseModel.setComponentSearchFilter((String)object);
                    calendarBaseModel.setComponentSearchOption(0);
                    if (_log.isLoggable(Level.FINEST)) {
                        _log.finest("fetchEvents: Filter set to: " + (String)object);
                    }
                }
                _log.finest("fetchEvents: Executing SEARCH_EVENTS_CONTEXT");
                calendarBaseModel.execute((ModelExecutionContext)new CalendarExecutionModelContext(CalendarExecutionModelContext.SEARCH_EVENTS_CONTEXT));
                if (this._eventSorting) {
                    this.sortTheEvents(calendarBaseModel);
                }
                this._events = calendarBaseModel.getAllEvents();
            } else {
                String string2;
                _log.finest("In non-searchMode: Fetching the events ....");
                calendarBaseModel.setStartTime(this._start);
                calendarBaseModel.setEndTime(this._end);
                object2 = new CalendarExecutionModelContext(CalendarExecutionModelContext.FETCH_EVENTS_CONTEXT);
                object = (String)this.getValue(FIELD_VIEW_CATEGORY);
                if (null != object && !((String)object).equals("Other") && !((String)object).equals("All") && null != (string2 = "CATEGORY=" + (String)object)) {
                    calendarBaseModel.setComponentSearchFilter(string2);
                    calendarBaseModel.setComponentSearchOption(0);
                    if (_log.isLoggable(Level.FINEST)) {
                        _log.finest("fetchEvents: Filter set to: " + string2);
                    }
                    object2 = new CalendarExecutionModelContext(CalendarExecutionModelContext.SEARCH_EVENTS_CONTEXT);
                }
                if (_log.isLoggable(Level.FINEST)) {
                    _log.finest("fetchEvents: Executing " + object2.getOperationName());
                }
                calendarBaseModel.execute((ModelExecutionContext)object2);
                if (this._eventSorting) {
                    this.sortTheEvents(calendarBaseModel);
                }
                this._events = calendarBaseModel.getAllEvents();
                if ("Other".equals(object)) {
                    int n;
                    int n2 = n = null == this._events ? -1 : this._events.size();
                    if (n > 0) {
                        ArrayList<VEvent> arrayList = new ArrayList<VEvent>();
                        for (int i = 0; i < n; ++i) {
                            VEvent vEvent = null;
                            try {
                                vEvent = (VEvent)this._events.get(i);
                            }
                            catch (Exception exception) {
                                vEvent = null;
                            }
                            if (null == vEvent) continue;
                            String[] stringArray = null;
                            try {
                                stringArray = vEvent.getCategories();
                            }
                            catch (Exception exception) {
                                stringArray = null;
                            }
                            if (null == stringArray) {
                                arrayList.add(vEvent);
                                continue;
                            }
                            if (-1 == UWCUtils.isStringContainedInStringArray("Other", stringArray, false)) continue;
                            arrayList.add(vEvent);
                        }
                        this._events = arrayList;
                    }
                }
            }
            int n = this._events.size();
            if (n > 0) {
                this.setValue(FIELD_IS_NO_EVENTS, "false");
            } else {
                this.setValue(FIELD_IS_NO_EVENTS, "true");
            }
            object = calendarBaseModel.getTimeZone();
            this.setValue(FIELD_TIME_ZONE, null == object ? null : ((TimeZone)object).getID());
            if (_log.isLoggable(Level.FINEST)) {
                _log.finest("FIELD_TIME_ZONE set to: " + this.getValue(FIELD_TIME_ZONE));
            }
        }
        catch (ModelControlException modelControlException) {
            if (_log.isLoggable(Level.SEVERE)) {
                _log.severe("Couldn't retrieve the events. Reason: " + (Object)((Object)modelControlException));
            }
            UWCUtils.printStackTrace((Exception)((Object)modelControlException));
            _log.exiting(CLASS_NAME, "fetchEvents()");
            throw new UWCException(65, "Couldn't retrieve the events. Reason: " + (Object)((Object)modelControlException));
        }
        _log.exiting(CLASS_NAME, "fetchEvents()");
    }

    private void sortTheEvents(CalendarBaseModel calendarBaseModel) throws UWCModelControlException {
        _log.entering(CLASS_NAME, "sortTheEvents()");
        if (null == calendarBaseModel) {
            return;
        }
        String string = (String)this.getValue(FIELD_SORT_CRITERIA);
        if (_log.isLoggable(Level.FINEST)) {
            _log.finest("Event sorting: Sort criteria: " + string);
        }
        if (SORT_CRITERIA_NO_SORTING.equalsIgnoreCase(string)) {
            _log.finest("Event sorting: Skipping....");
        }
        if (SORT_CRITERIA_TITLE_ASCENDING.equalsIgnoreCase(string)) {
            _log.finest("Event sorting: TITLE_ASCENDING....");
            calendarBaseModel.sortEvents("SUMMARY", 1);
        }
        if (SORT_CRITERIA_TITLE_DECENDING.equalsIgnoreCase(string)) {
            _log.finest("Event sorting: TITLE_DECENDING....");
            calendarBaseModel.sortEvents("SUMMARY", 0);
        }
        if (SORT_CRITERIA_START_DATE_ASCENDING.equalsIgnoreCase(string)) {
            _log.finest("Event sorting: START_DATE_ASCENDING....");
            calendarBaseModel.sortEvents("DTSTART", 1);
        }
        if (SORT_CRITERIA_START_DATE_DECENDING.equalsIgnoreCase(string)) {
            _log.finest("Event sorting: START_DATE_DECENDING....");
            calendarBaseModel.sortEvents("DTSTART", 0);
        } else {
            _log.finest("Task sorting: Skipping....");
        }
        _log.exiting(CLASS_NAME, "sortTheEvents()");
    }

    private void loadEvents() throws ModelControlException {
        _log.entering(CLASS_NAME, "loadEvents()");
        String string = this.getSortCriteria();
        this.clear();
        if (null == this._events || null != this._events && this._events.size() < 1) {
            this.beforeFirst();
            _log.warning("No events found to load");
            _log.exiting(CLASS_NAME, "loadEvents()");
            return;
        }
        int n = this._events.size();
        if (_log.isLoggable(Level.FINEST)) {
            _log.finest("Total tasks to process: " + n);
        }
        for (int i = 0; i < n; ++i) {
            VEvent vEvent = null;
            try {
                vEvent = (VEvent)this._events.get(i);
                if (null == vEvent) {
                    throw new IllegalArgumentException("event[" + i + "] is null");
                }
            }
            catch (Exception exception) {
                if (!_log.isLoggable(Level.SEVERE)) continue;
                _log.severe("Couldn't get event[" + i + "]. Reason: " + exception);
                _log.severe("So, not writing the tile for event[" + i + "]");
                continue;
            }
            this.appendRow();
            if (i < n - 1) {
                this.setValue(IS_LAST_ROW, "false");
            } else {
                this.setValue(IS_LAST_ROW, "true");
            }
            this.setValue(FIELD_SORT_CRITERIA, string);
            try {
                if (_log.isLoggable(Level.FINEST)) {
                    _log.finest("About to process the event[" + i + "]....");
                }
                this.writeEventTileData(vEvent);
                continue;
            }
            catch (Exception exception) {
                if (_log.isLoggable(Level.SEVERE)) {
                    _log.severe("Couldn't load the event[" + i + "]. Reason: " + exception);
                }
                UWCUtils.printStackTrace(exception);
            }
        }
        this.beforeFirst();
        _log.exiting(CLASS_NAME, "loadEvents()");
    }

    private void writeEventTileData(VEvent vEvent) throws UWCException {
        _log.entering(CLASS_NAME, "writeEventTileData()");
        try {
            String string;
            String[] stringArray;
            Object object;
            Object object2;
            Object object3;
            CalendarExecutionModelContext calendarExecutionModelContext = new CalendarExecutionModelContext(CalendarExecutionModelContext.LOAD_EVENT_CONTEXT);
            this.setCurrentEvent(vEvent);
            super.retrieve((ModelExecutionContext)calendarExecutionModelContext);
            Organizer organizer = vEvent.getOrganizer();
            String string2 = null == organizer ? null : organizer.getCommonName();
            String string3 = null == organizer ? null : organizer.getValue();
            String string4 = null == string2 ? string3 : string2;
            String string5 = "false";
            String string6 = null;
            String string7 = null;
            String string8 = null;
            String string9 = null;
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            boolean bl5 = false;
            if (this._anonymous) {
                string9 = "@";
            } else {
                string9 = UWCUserHelper.getUID(this._reqCtx);
                if (_log.isLoggable(Level.FINEST)) {
                    _log.finest("EventsManager calid is : " + (String)this.getValue("calid"));
                }
                object3 = UWCUtils.getUWCCalendar(this._reqCtx, (String)this.getValue("calid"), true, true, true);
                try {
                    bl = UWCUserHelper.isUserTheCalendarOwner((UWCCalendar)object3, string9);
                }
                catch (Exception exception) {
                    bl = false;
                    if (_log.isLoggable(Level.SEVERE)) {
                        _log.severe("Exeception whilie doing isUserTheOwner: " + exception);
                    }
                    UWCUtils.printStackTrace(exception);
                }
                try {
                    bl2 = UWCUserHelper.hasCalendarPermission((UWCCalendar)object3, string9, "c", "w");
                }
                catch (Exception exception) {
                    bl2 = false;
                    if (_log.isLoggable(Level.SEVERE)) {
                        _log.severe("Exeception whilie doing hasWriteAccess: " + exception);
                    }
                    UWCUtils.printStackTrace(exception);
                }
                try {
                    bl3 = UWCUserHelper.hasCalendarPermission((UWCCalendar)object3, string9, "c", "d");
                }
                catch (Exception exception) {
                    bl3 = false;
                    if (_log.isLoggable(Level.SEVERE)) {
                        _log.severe("Exeception whilie doing hasDeleteAccess: " + exception);
                    }
                    UWCUtils.printStackTrace(exception);
                }
            }
            object3 = null;
            String string10 = vEvent.getCalID();
            String string11 = null;
            if (!this._anonymous) {
                object2 = (UWCCalendar)this.calids.get(string10);
                object = null;
                if (object2 != null) {
                    object = (SOCSCalendar)((UWCCalendar)object2).getCalendar();
                }
                if (object != null) {
                    string11 = object.getRelativeCalId();
                    bl5 = vEvent.isCalIdTheOrganizer(string11);
                    object3 = object.getOwnerCommonName();
                    stringArray = vEvent.getAttendee(string11);
                    if (stringArray != null) {
                        bl4 = true;
                    }
                }
            }
            string6 = bl ? "false" : "true";
            string7 = bl2 && (bl5 || bl4) ? "true" : "false";
            string8 = bl3 ? "true" : "false";
            object2 = this.getEventPopupUrl("calclient/ViewEvent", (String)this.getValue("calid"), (String)this.getValue("eventUid"), (String)this.getValue("eventRid"), bl2, bl4, bl5, string8);
            object = this.getEventPopupUrl("calclient/EditEvent", (String)this.getValue("calid"), (String)this.getValue("eventUid"), (String)this.getValue("eventRid"), bl2, bl4, bl5, string8);
            stringArray = UWCUtils.getStringArray(this.getValues("Category"));
            String string12 = UWCUserHelper.getLocalizedStringLabel(this._reqCtx, "uwc-calclient-common-Other", "Other");
            if (null != stringArray && stringArray.length > 0 && null != stringArray[0]) {
                string12 = UWCUserHelper.getLocalizedStringLabel(this._reqCtx, "uwc-calclient-common-" + stringArray[0], stringArray[0]);
            }
            this.setValue("Category", string12);
            String string13 = (String)this.getValue("Title");
            String string14 = (String)this.getValue("Privacy");
            boolean bl6 = false;
            if ("CONFIDENTIAL".equalsIgnoreCase(string14) && !bl) {
                bl6 = true;
            }
            if ("PRIVATE".equalsIgnoreCase(string14) && !bl) {
                bl6 = true;
            }
            if (null == string13) {
                string13 = bl6 ? UWCUserHelper.getLocalizedStringLabel(this._reqCtx, "uwc-calclient-view-month-Busy", "Busy") : UWCUserHelper.getLocalizedStringLabel(this._reqCtx, "uwc-calclient-events-UntitledEventLabel", "Untitled Event");
                this.setValue("Title", string13);
            }
            if (null == (string = (String)this.getValue("Location"))) {
                string = UWCUserHelper.getLocalizedStringLabel(this._reqCtx, "uwc-calclient-common-none", "none");
                this.setValue("Location", string);
            }
            this.setValue(FIELD_IS_EVENT_SELECTED, string5);
            this.setValue(FIELD_VIEW_EVENT_URL, object2);
            this.setValue(FIELD_OWNER_NAME, object3);
            this.setValue(FIELD_IS_EXTERNAL, string6);
            this.setValue(FIELD_IS_WRITABLE, string7);
            this.setValue(FIELD_CAN_DELETE, string8);
            this.setValue(FIELD_EDIT_EVENT_URL, object);
            if (bl6) {
                this.setValue(FIELD_SHOW_EVENTS_LINK, "true");
            } else {
                this.setValue(FIELD_SHOW_EVENTS_LINK, "false");
            }
            boolean bl7 = "true".equalsIgnoreCase((String)this.getValue("IsAllDay"));
            int n = bl7 ? 0 : UWCUtils.parseInteger((String)this.getValue("DurationHours"), "Couldn't parse duration hours value to integer");
            int n2 = bl7 ? 0 : UWCUtils.parseInteger((String)this.getValue("DurationMinutes"), "Couldn't parse duration minutes value to integer");
            String string15 = null;
            if (!bl7) {
                String string16 = string15 = UWCUserHelper.getLocalizedStringLabel(this._reqCtx, "uwc-calclient-availabilityview-hours", "hour(s)");
                String string17 = string15 = UWCUserHelper.getLocalizedStringLabel(this._reqCtx, "uwc-calclient-availabilityview-minutes", "minutes");
                if (n > 0 && n2 > 0) {
                    string15 = new String("(" + (String)this.getValue("DurationHours") + " " + string16 + " " + (String)this.getValue("DurationMinutes") + " " + string17 + ")");
                } else if (n == 0 && n2 > 0) {
                    string15 = new String("(" + (String)this.getValue("DurationMinutes") + " " + string17 + " " + ")");
                } else if (n > 0 && n2 == 0) {
                    string15 = new String("(" + (String)this.getValue("DurationHours") + " " + string16 + " " + ")");
                }
            }
            this.setValue(FIELD_DURATION_DISPLAY, string15);
        }
        catch (Exception exception) {
            if (_log.isLoggable(Level.SEVERE)) {
                _log.severe("Couldn't load the event. Reason: " + exception);
            }
            UWCUtils.printStackTrace(exception);
            _log.exiting(CLASS_NAME, "writeEventTileData()");
            throw new UWCException(65, "Couldn't load the event. Reason: " + exception);
        }
        _log.exiting(CLASS_NAME, "writeEventTileData()");
    }

    private String getEventPopupUrl(String string, String string2, String string3, String string4, boolean bl, boolean bl2, boolean bl3, String string5) {
        NonSyncStringBuffer nonSyncStringBuffer = new NonSyncStringBuffer(256);
        nonSyncStringBuffer.append(UWCUtils.getContextPathPrefix(this._reqCtx));
        nonSyncStringBuffer.append(string);
        nonSyncStringBuffer.append("?");
        if (null != string2) {
            nonSyncStringBuffer.append("calid");
            nonSyncStringBuffer.append("=");
            nonSyncStringBuffer.append(string2);
            nonSyncStringBuffer.append("&");
        }
        if (null != string3) {
            nonSyncStringBuffer.append("eventid");
            nonSyncStringBuffer.append("=");
            nonSyncStringBuffer.append(string3);
            nonSyncStringBuffer.append("&");
        }
        if (null != string4) {
            nonSyncStringBuffer.append("rid");
            nonSyncStringBuffer.append("=");
            nonSyncStringBuffer.append(string4);
            nonSyncStringBuffer.append("&");
        }
        String string6 = "false";
        String string7 = "false";
        if (bl) {
            if (bl3 && bl2) {
                string7 = "true";
                string6 = "true";
            } else if (bl2) {
                string7 = "false";
                string6 = "true";
            } else if (bl3) {
                string7 = "true";
                string6 = "false";
            }
        }
        nonSyncStringBuffer.append("edit");
        nonSyncStringBuffer.append("=");
        nonSyncStringBuffer.append(string7);
        nonSyncStringBuffer.append("&");
        nonSyncStringBuffer.append("update");
        nonSyncStringBuffer.append("=");
        nonSyncStringBuffer.append(string6);
        nonSyncStringBuffer.append("&");
        nonSyncStringBuffer.append("delete");
        nonSyncStringBuffer.append("=");
        nonSyncStringBuffer.append(string5);
        return nonSyncStringBuffer.toString();
    }

    static {
        _log = UWCLogger.getLogger("uwc.common.model");
    }
}

