/*
 * Decompiled with CFR 0.152.
 */
package com.sun.uwc.calclient.model;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.RequestParticipant;
import com.iplanet.jato.model.DefaultModel;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.model.ModelExecutionContext;
import com.iplanet.jato.model.RetrievingModel;
import com.sun.comclient.calendar.Attendee;
import com.sun.comclient.calendar.CalendarComponent;
import com.sun.comclient.calendar.CalendarComponentException;
import com.sun.comclient.calendar.CalendarException;
import com.sun.comclient.calendar.CalendarStore;
import com.sun.comclient.calendar.CalendarStoreException;
import com.sun.comclient.calendar.DateTime;
import com.sun.comclient.calendar.ICalendar;
import com.sun.comclient.calendar.OperationNotSupportedException;
import com.sun.comclient.calendar.VEvent;
import com.sun.comclient.calendar.VFreeBusy;
import com.sun.comclient.calendar.VTodo;
import com.sun.comclient.calendar.socs.SOCSCalendar;
import com.sun.comclient.calendar.socs.SOCSTodo;
import com.sun.uwc.calclient.model.CalendarACL;
import com.sun.uwc.calclient.model.CollectionQuickSorter;
import com.sun.uwc.calclient.model.EventKeyedComparator;
import com.sun.uwc.calclient.model.TaskKeyedComparator;
import com.sun.uwc.calclient.model.UWCCalendar;
import com.sun.uwc.common.UWCApplicationHelper;
import com.sun.uwc.common.UWCException;
import com.sun.uwc.common.UWCUserHelper;
import com.sun.uwc.common.model.CalUserPreferencesModel;
import com.sun.uwc.common.model.CalendarExecutionModelContext;
import com.sun.uwc.common.model.UWCModelControlException;
import com.sun.uwc.common.model.UserPreferencesModel;
import com.sun.uwc.common.util.UWCLogger;
import com.sun.uwc.common.util.UWCUtils;
import java.io.BufferedReader;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import java.util.TimeZone;
import java.util.logging.Logger;

public final class CalendarBaseModel
extends DefaultModel
implements RetrievingModel,
RequestParticipant {
    public static int TODOS_NORMAL_PRIORITY = 5;
    public static int TODOS_LOWEST_PRIORITY = 9;
    public static int TODOS_HIGHEST_PRIORITY = 1;
    public static final String CAL_EVENT_CATEGORY_OTHER = "Other";
    private ArrayList freeBusy = null;
    private ArrayList allDayEvents = null;
    private ArrayList nonAllDayEvents = null;
    private ArrayList invitationEvents = null;
    private ArrayList typeEvents = null;
    private ArrayList typeTodos = null;
    private ArrayList dueTodos = null;
    private ArrayList overDueTodos = null;
    private ArrayList completedTodos = null;
    private boolean anonymous = false;
    private boolean invitationsSortRequired = false;
    private boolean typeSortRequired = false;
    private boolean allDayEventsSortRequired = false;
    private boolean isInvitations = false;
    private ArrayList calids = null;
    private ArrayList emailids = null;
    private int numInvitations = 0;
    private String calendarSearchFilter = null;
    private String componentSearchFilter = null;
    private int componentSearchOption = -1;
    private String category = null;
    private String componentUid = null;
    private String componentRid = null;
    private String _userId = null;
    private String eventsFilter = null;
    private ArrayList allEvents = null;
    private ArrayList allTodos = null;
    private HashMap calendars = null;
    private HashMap ownedCalendars = null;
    private DateTime start = null;
    private DateTime end = null;
    private DateTime contextDate = null;
    private DateTime currentDate = null;
    private TimeZone timezone = null;
    private RequestContext reqCtx = null;
    private static Logger _calModelLogger = null;
    private static final String _classname = "CalendarBaseModel";

    public CalendarBaseModel() {
    }

    public CalendarBaseModel(String string) {
        super(string);
    }

    public void setRequestContext(RequestContext requestContext) {
        this.reqCtx = requestContext;
    }

    public void setCurrentDate(DateTime dateTime) {
        this.currentDate = dateTime;
    }

    public DateTime getCurrentDate() {
        return this.currentDate;
    }

    public DateTime getContextDate() {
        return this.contextDate;
    }

    public void setContextDate(DateTime dateTime) {
        this.contextDate = dateTime;
    }

    public DateTime getStartTime() {
        return this.start;
    }

    public void setStartTime(DateTime dateTime) {
        this.start = dateTime;
    }

    public DateTime getEndTime() {
        return this.end;
    }

    public void setEndTime(DateTime dateTime) {
        this.end = dateTime;
    }

    public void setAnonymous(boolean bl) {
        this.anonymous = bl;
    }

    public void setInvitationsSortRequired(boolean bl) {
        this.invitationsSortRequired = bl;
    }

    public void setAllDayEventsSortRequired(boolean bl) {
        this.allDayEventsSortRequired = bl;
    }

    public void setTypeSortRequired(boolean bl) {
        this.typeSortRequired = bl;
    }

    public void setType(String string) {
        this.category = string;
    }

    public void setComponentUID(String string) {
        this.componentUid = string;
    }

    public void setComponentRID(String string) {
        this.componentRid = string;
    }

    public void setComponentSearchFilter(String string) {
        this.componentSearchFilter = string;
    }

    public void setComponentSearchOption(int n) {
        this.componentSearchOption = n;
    }

    public void setCalendarSearchFilter(String string) {
        this.calendarSearchFilter = string;
    }

    public void setEventsFilter(String string) {
        this.eventsFilter = string;
    }

    public HashMap getCalendars() {
        return this.calendars;
    }

    public HashMap getOwnedCalendars() {
        return this.ownedCalendars;
    }

    public ArrayList getAllEvents() {
        return this.allEvents;
    }

    public ArrayList getAllTodos() {
        return this.allTodos;
    }

    public ArrayList getFreeBusy() {
        return this.freeBusy;
    }

    public ArrayList getAllDayEvents() {
        return this.allDayEvents;
    }

    public ArrayList getNonAllDayEvents() {
        return this.nonAllDayEvents;
    }

    public ArrayList getInvitationEvents() {
        return this.invitationEvents;
    }

    public ArrayList getTypeEvents() {
        return this.typeEvents;
    }

    public ArrayList getTypeTodos() {
        return this.typeTodos;
    }

    public ArrayList getDueTodos() {
        return this.dueTodos;
    }

    public ArrayList getOverDueTodos() {
        return this.overDueTodos;
    }

    public ArrayList getCompletedTodos() {
        return this.completedTodos;
    }

    public int getNumInvitations() {
        return this.numInvitations;
    }

    public TimeZone getTimeZone() {
        return this.timezone;
    }

    public void loadCalendar() throws UWCException {
        if (this.calids == null) {
            throw new UWCException(54);
        }
        CalendarStore calendarStore = UWCUserHelper.getCalStore(this.reqCtx, false);
        ICalendar iCalendar = null;
        UWCCalendar uWCCalendar = null;
        int n = this.calids.size();
        if (this.calendars == null) {
            this.calendars = new HashMap();
        }
        for (int i = 0; i < n; ++i) {
            try {
                iCalendar = calendarStore.openCalendar((String)this.calids.get(i));
                iCalendar.getCalProps();
                uWCCalendar = new UWCCalendar(iCalendar);
                this.calendars.put(this.calids.get(i), uWCCalendar);
                continue;
            }
            catch (CalendarStoreException calendarStoreException) {
                _calModelLogger.severe("loadCalendar Failed with CalendarStoreException: Unable to get ICalendar object: " + (Object)((Object)calendarStoreException));
                this.calendars.put(this.calids.get(i), null);
                continue;
            }
            catch (OperationNotSupportedException operationNotSupportedException) {
                _calModelLogger.severe("loadCalendar Failed with OperationNotSupportedException: " + (Object)((Object)operationNotSupportedException));
                this.calendars.put(this.calids.get(i), null);
                continue;
            }
            catch (CalendarException calendarException) {
                _calModelLogger.severe("loadCalendar Failed with CalendarException: " + (Object)((Object)calendarException));
                this.calendars.put(this.calids.get(i), null);
            }
        }
    }

    public void addCalid(String string) {
        if (this.calids == null) {
            this.calids = new ArrayList();
        }
        this.calids.add(string);
    }

    public void removeCalid(String string) {
        if (this.calids == null) {
            return;
        }
        int n = this.calids.size();
        for (int i = 0; i < n; ++i) {
            if (!string.equals((String)this.calids.get(i))) continue;
            this.calids.remove(i);
            --n;
            break;
        }
        if (n == 0) {
            this.calids = null;
        }
    }

    public void removeAllCalids() {
        if (this.calids != null) {
            this.calids.clear();
        }
    }

    public void addCalid(ArrayList arrayList) {
        if (this.calids == null) {
            this.calids = new ArrayList();
        }
        this.calids.addAll(arrayList);
    }

    public void sortEvents(String string, int n) throws UWCModelControlException {
        _calModelLogger.entering(_classname, "sortEvents");
        if (this.allEvents == null) {
            return;
        }
        try {
            EventKeyedComparator eventKeyedComparator = new EventKeyedComparator();
            eventKeyedComparator.setRequestContext(this.reqCtx);
            this.allEvents = (ArrayList)CollectionQuickSorter.SINGLETON.sort(eventKeyedComparator, this.allEvents, string, n);
        }
        catch (UWCException uWCException) {
            throw new UWCModelControlException(uWCException.getReason());
        }
    }

    public void sortTodos(String string, int n) throws UWCModelControlException {
        if (this.allTodos == null) {
            return;
        }
        try {
            TaskKeyedComparator taskKeyedComparator = new TaskKeyedComparator();
            taskKeyedComparator.setRequestContext(this.reqCtx);
            if (null == this.contextDate) {
                _calModelLogger.info("ContextDate not set before Sorting");
            }
            taskKeyedComparator.setContextDate(this.contextDate);
            this.allTodos = (ArrayList)CollectionQuickSorter.SINGLETON.sort(taskKeyedComparator, this.allTodos, string, n);
        }
        catch (UWCException uWCException) {
            throw new UWCModelControlException(uWCException.getReason());
        }
    }

    public Object execute(ModelExecutionContext modelExecutionContext) throws ModelControlException {
        String string = null;
        this.anonymous = UWCUserHelper.isAnonymous(this.reqCtx);
        string = modelExecutionContext != null ? modelExecutionContext.getOperationName() : CalendarExecutionModelContext.DAYVIEW_CONTEXT;
        if (string.equals(CalendarExecutionModelContext.DAYVIEW_CONTEXT)) {
            this.start = (DateTime)this.contextDate.clone();
            this.end = (DateTime)this.contextDate.clone();
            this.start.setTime(0, 0, 0);
            this.end.setTime(23, 59, 59);
            if (this.allEvents == null) {
                this.allEvents = new ArrayList();
            }
            if (this.allTodos == null) {
                this.allTodos = new ArrayList();
            }
            if (this.dueTodos == null) {
                this.dueTodos = new ArrayList();
            }
            if (this.overDueTodos == null) {
                this.overDueTodos = new ArrayList();
            }
            if (this.completedTodos == null) {
                this.completedTodos = new ArrayList();
            }
            if (this.allDayEvents == null) {
                this.allDayEvents = new ArrayList();
            }
            if (this.nonAllDayEvents == null) {
                this.nonAllDayEvents = new ArrayList();
            }
            if (this.typeEvents == null) {
                this.typeEvents = new ArrayList();
            }
            if (this.typeTodos == null) {
                this.typeTodos = new ArrayList();
            }
            if (this.calendars == null) {
                this.calendars = new HashMap();
            }
            this.executeViewContext();
        } else if (string.equals(CalendarExecutionModelContext.WEEKVIEW_CONTEXT)) {
            CalUserPreferencesModel calUserPreferencesModel = UWCUserHelper.getCalUserPrefModel(this.reqCtx);
            String string2 = calUserPreferencesModel.getFirstDay();
            this.start = UWCUtils.getWeekStartDate(this.contextDate, string2);
            this.end = (DateTime)this.start.clone();
            this.end.add(5, 6);
            this.start.setTime(0, 0, 0);
            this.end.setTime(23, 59, 59);
            if (this.allEvents == null) {
                this.allEvents = new ArrayList();
            }
            if (this.allTodos == null) {
                this.allTodos = new ArrayList();
            }
            if (this.dueTodos == null) {
                this.dueTodos = new ArrayList();
            }
            if (this.overDueTodos == null) {
                this.overDueTodos = new ArrayList();
            }
            if (this.completedTodos == null) {
                this.completedTodos = new ArrayList();
            }
            if (this.allDayEvents == null) {
                this.allDayEvents = new ArrayList();
            }
            if (this.nonAllDayEvents == null) {
                this.nonAllDayEvents = new ArrayList();
            }
            if (this.typeEvents == null) {
                this.typeEvents = new ArrayList();
            }
            if (this.typeTodos == null) {
                this.typeTodos = new ArrayList();
            }
            if (this.calendars == null) {
                this.calendars = new HashMap();
            }
            _calModelLogger.fine("execute the view context ");
            this.executeViewContext();
        } else if (string.equals(CalendarExecutionModelContext.MONTHVIEW_CONTEXT)) {
            this.start = (DateTime)this.contextDate.clone();
            this.end = (DateTime)this.contextDate.clone();
            this.start.setDay(1);
            this.start.setTime(0, 0, 0);
            int n = this.start.getActualMaximum(5);
            this.end.setDay(n);
            this.end.setTime(23, 59, 59);
            if (this.allEvents == null) {
                this.allEvents = new ArrayList();
            }
            if (this.allTodos == null) {
                this.allTodos = new ArrayList();
            }
            if (this.dueTodos == null) {
                this.dueTodos = new ArrayList();
            }
            if (this.overDueTodos == null) {
                this.overDueTodos = new ArrayList();
            }
            if (this.completedTodos == null) {
                this.completedTodos = new ArrayList();
            }
            if (this.allDayEvents == null) {
                this.allDayEvents = new ArrayList();
            }
            if (this.nonAllDayEvents == null) {
                this.nonAllDayEvents = new ArrayList();
            }
            if (this.typeEvents == null) {
                this.typeEvents = new ArrayList();
            }
            if (this.typeTodos == null) {
                this.typeTodos = new ArrayList();
            }
            if (this.calendars == null) {
                this.calendars = new HashMap();
            }
            this.executeViewContext();
        } else if (string.equals(CalendarExecutionModelContext.YEARVIEW_CONTEXT)) {
            this.start = (DateTime)this.contextDate.clone();
            this.end = (DateTime)this.contextDate.clone();
            this.start.set(this.contextDate.getYear(), 0, 1, 0, 0, 0);
            this.end.set(this.contextDate.getYear(), 11, 31, 23, 59, 59);
            this.executeYearViewContext();
        } else if (string.equals(CalendarExecutionModelContext.FETCH_INVITATIONS_CONTEXT)) {
            if (this.allEvents == null) {
                this.allEvents = new ArrayList();
            }
            if (this.invitationEvents == null) {
                this.invitationEvents = new ArrayList();
            }
            if (this.typeEvents == null) {
                this.typeEvents = new ArrayList();
            }
            if (this.calendars == null) {
                this.calendars = new HashMap();
            }
            this.isInvitations = true;
            this.executeFetchEvents(this.isInvitations);
        } else if (string.equals(CalendarExecutionModelContext.FETCH_EVENTS_CONTEXT)) {
            if (this.allEvents == null) {
                this.allEvents = new ArrayList();
            }
            if (this.allDayEvents == null) {
                this.allDayEvents = new ArrayList();
            }
            if (this.nonAllDayEvents == null) {
                this.nonAllDayEvents = new ArrayList();
            }
            if (this.invitationEvents == null) {
                this.invitationEvents = new ArrayList();
            }
            if (this.typeEvents == null) {
                this.typeEvents = new ArrayList();
            }
            this.isInvitations = false;
            this.executeFetchEvents(this.isInvitations);
        } else if (string.equals(CalendarExecutionModelContext.FETCH_TODOS_CONTEXT)) {
            if (this.allTodos == null) {
                this.allTodos = new ArrayList();
            }
            if (this.dueTodos == null) {
                this.dueTodos = new ArrayList();
            }
            if (this.overDueTodos == null) {
                this.overDueTodos = new ArrayList();
            }
            if (this.completedTodos == null) {
                this.completedTodos = new ArrayList();
            }
            if (this.typeTodos == null) {
                this.typeTodos = new ArrayList();
            }
            this.executeFetchTodos();
        } else if (string.equals(CalendarExecutionModelContext.FETCH_FREEBUSY_CONTEXT)) {
            if (this.freeBusy == null) {
                this.freeBusy = new ArrayList();
            }
            if (this.calendars == null) {
                this.calendars = new HashMap();
            }
            this.executeFetchFreeBusy();
        } else if (string.equals(CalendarExecutionModelContext.FETCH_EVENT_BY_ID_CONTEXT)) {
            if (this.allEvents == null) {
                this.allEvents = new ArrayList();
            }
            this.executeFetchEventById(this.componentUid, this.componentRid);
        } else if (string.equals(CalendarExecutionModelContext.FETCH_TODO_BY_ID_CONTEXT)) {
            if (this.allTodos == null) {
                this.allTodos = new ArrayList();
            }
            this.executeFetchTodoById(this.componentUid, this.componentRid);
        } else if (string.equals(CalendarExecutionModelContext.FETCH_OWNED_CALENDARS_CONTEXT)) {
            this.removeCalendarData();
            if (this.ownedCalendars == null) {
                this.ownedCalendars = new HashMap();
            }
            try {
                this.fetchOwnedCalendars();
            }
            catch (UWCException uWCException) {
                _calModelLogger.severe("fetchOwnedCalendars failed: " + uWCException);
                throw new UWCModelControlException(uWCException.getReason());
            }
        } else if (string.equals(CalendarExecutionModelContext.SEARCH_CALENDARS_CONTEXT)) {
            if (this.calendars == null) {
                this.calendars = new HashMap();
            }
            try {
                this.searchCalendars(this.calendarSearchFilter);
            }
            catch (UWCException uWCException) {
                _calModelLogger.severe("searchCalendars failed: " + uWCException);
                throw new UWCModelControlException(uWCException.getReason());
            }
        } else if (string.equals(CalendarExecutionModelContext.SEARCH_EVENTS_CONTEXT)) {
            if (this.allEvents == null) {
                this.allEvents = new ArrayList();
            }
            this.executeSearchEvents();
        } else if (string.equals(CalendarExecutionModelContext.SEARCH_TODOS_CONTEXT)) {
            if (this.allTodos == null) {
                this.allTodos = new ArrayList();
            }
            if (this.dueTodos == null) {
                this.dueTodos = new ArrayList();
            }
            if (this.overDueTodos == null) {
                this.overDueTodos = new ArrayList();
            }
            if (this.completedTodos == null) {
                this.completedTodos = new ArrayList();
            }
            if (this.typeTodos == null) {
                this.typeTodos = new ArrayList();
            }
            this.executeSearchTodos();
        }
        return null;
    }

    public Object retrieve(ModelExecutionContext modelExecutionContext) throws ModelControlException {
        String string = null;
        this.anonymous = UWCUserHelper.isAnonymous(this.reqCtx);
        string = modelExecutionContext != null ? modelExecutionContext.getOperationName() : CalendarExecutionModelContext.DAYVIEW_CONTEXT;
        if (string.equals(CalendarExecutionModelContext.DAYVIEW_CONTEXT)) {
            this.allDayEventsSortRequired = true;
            this.invitationsSortRequired = false;
            this.sortEvents();
            this.sortTodos();
        } else if (string.equals(CalendarExecutionModelContext.WEEKVIEW_CONTEXT)) {
            this.allDayEventsSortRequired = true;
            this.invitationsSortRequired = false;
            this.sortEvents("DTSTART", 1);
            this.sortEvents();
            this.sortTodos();
        } else if (string.equals(CalendarExecutionModelContext.MONTHVIEW_CONTEXT)) {
            this.allDayEventsSortRequired = false;
            this.invitationsSortRequired = false;
            this.sortEventsByType();
            this.sortTodos();
        } else if (!string.equals(CalendarExecutionModelContext.YEARVIEW_CONTEXT)) {
            if (string.equals(CalendarExecutionModelContext.FETCH_INVITATIONS_CONTEXT)) {
                this.allDayEventsSortRequired = false;
                this.invitationsSortRequired = true;
                this.sortEvents();
            } else if (string.equals(CalendarExecutionModelContext.FETCH_EVENTS_CONTEXT)) {
                this.sortEvents();
            } else if (string.equals(CalendarExecutionModelContext.FETCH_TODOS_CONTEXT)) {
                this.sortTodos();
            } else if (string.equals(CalendarExecutionModelContext.SEARCH_TODOS_CONTEXT)) {
                this.sortTodos();
            } else if (!string.equals(CalendarExecutionModelContext.FETCH_FREEBUSY_CONTEXT) && string.equals(CalendarExecutionModelContext.FETCH_MY_CALENDARS_CONTEXT)) {
                this.removeCalendarData();
                if (this.ownedCalendars == null) {
                    this.ownedCalendars = new HashMap();
                }
                try {
                    this.fetchOwnedCalendars();
                }
                catch (UWCException uWCException) {
                    _calModelLogger.severe("fetchOwnedCalendars failed: " + uWCException);
                    throw new UWCModelControlException(uWCException.getReason());
                }
            }
        }
        return null;
    }

    public void addEvent(VEvent vEvent, boolean bl) throws UWCException {
        try {
            CalendarStore calendarStore = UWCUserHelper.getCalStore(this.reqCtx, false);
            ICalendar iCalendar = null;
            if (this.calids.isEmpty()) {
                throw new UWCException(54);
            }
            iCalendar = calendarStore.openCalendar((String)this.calids.get(0));
            Properties properties = new Properties();
            if (null != this.timezone) {
                properties.put("cal.socs.preferredTimezone", this.timezone.getID());
            }
            ((SOCSCalendar)iCalendar).addEvent(vEvent, bl, properties);
        }
        catch (CalendarException calendarException) {
            _calModelLogger.severe("Add Event Failed with CalendarException: " + (Object)((Object)calendarException));
            throw new UWCException(18);
        }
        catch (CalendarStoreException calendarStoreException) {
            _calModelLogger.severe("Add Event Failed with CalendarStoreException: Unable to get ICalendar object: " + (Object)((Object)calendarStoreException));
            throw new UWCException(5);
        }
    }

    public void modifyEvent(VEvent vEvent, String string, boolean bl) throws UWCException {
        try {
            CalendarStore calendarStore = UWCUserHelper.getCalStore(this.reqCtx, false);
            ICalendar iCalendar = null;
            if (this.calids.isEmpty()) {
                throw new UWCException(54);
            }
            iCalendar = calendarStore.openCalendar((String)this.calids.get(0));
            Properties properties = new Properties();
            if (null != this.timezone) {
                properties.put("cal.socs.preferredTimezone", this.timezone.getID());
            }
            ((SOCSCalendar)iCalendar).modifyEvent(vEvent, string, bl, properties);
        }
        catch (CalendarException calendarException) {
            _calModelLogger.severe("Modify Event Failed with CalendarException: " + (Object)((Object)calendarException));
            throw new UWCException(20);
        }
        catch (CalendarStoreException calendarStoreException) {
            _calModelLogger.severe("Modify Event Failed with CalendarStoreException: Unable to get ICalendar object: " + (Object)((Object)calendarStoreException));
            throw new UWCException(5);
        }
    }

    public void deleteEvent(VEvent vEvent, String string, boolean bl) throws UWCException {
        try {
            CalendarStore calendarStore = UWCUserHelper.getCalStore(this.reqCtx, false);
            ICalendar iCalendar = null;
            if (this.calids.isEmpty()) {
                throw new UWCException(54);
            }
            iCalendar = calendarStore.openCalendar((String)this.calids.get(0));
            iCalendar.deleteEvent(vEvent, string, bl);
        }
        catch (CalendarException calendarException) {
            _calModelLogger.severe("Delete Event Failed with CalendarException: " + (Object)((Object)calendarException));
            throw new UWCException(22);
        }
        catch (CalendarStoreException calendarStoreException) {
            _calModelLogger.severe("Delete Event Failed with CalendarStoreException: Unable to get ICalendar object: " + (Object)((Object)calendarStoreException));
            throw new UWCException(5);
        }
    }

    public void addCalendar(String string, Properties properties) throws UWCException {
        try {
            CalendarStore calendarStore = UWCUserHelper.getCalStore(this.reqCtx, false);
            if (properties == null) {
                calendarStore.createCalendar(string);
            } else {
                calendarStore.createCalendar(string, properties);
            }
        }
        catch (OperationNotSupportedException operationNotSupportedException) {
            _calModelLogger.severe("addCalendar failed with OperationNotSupported Exception: " + (Object)((Object)operationNotSupportedException));
            throw new UWCException(48);
        }
        catch (CalendarStoreException calendarStoreException) {
            _calModelLogger.severe("Add Calendar Failed with CalendarStoreException: Unable to get ICalendar object: " + (Object)((Object)calendarStoreException));
            throw new UWCException(5);
        }
    }

    public void modifyCalendar(String string, Properties properties) throws UWCException {
        try {
            CalendarStore calendarStore = UWCUserHelper.getCalStore(this.reqCtx, false);
            ICalendar iCalendar = calendarStore.openCalendar(string);
            iCalendar.setCalProps(properties);
        }
        catch (OperationNotSupportedException operationNotSupportedException) {
            _calModelLogger.severe("OperationNotSupported Exception: " + (Object)((Object)operationNotSupportedException));
            throw new UWCException(55);
        }
        catch (CalendarException calendarException) {
            _calModelLogger.severe("Modify Calendar Failed; Calendar Exception: " + (Object)((Object)calendarException));
            throw new UWCException(25);
        }
        catch (CalendarStoreException calendarStoreException) {
            _calModelLogger.severe("Modify Calendar Failed with CalendarStoreException: Unable to get ICalendar object: " + (Object)((Object)calendarStoreException));
            throw new UWCException(5);
        }
    }

    public void deleteCalendar(String string) throws UWCException {
        try {
            CalendarStore calendarStore = UWCUserHelper.getCalStore(this.reqCtx, false);
            calendarStore.deleteCalendar(string);
        }
        catch (OperationNotSupportedException operationNotSupportedException) {
            _calModelLogger.severe("OperationNotSupported Exception");
            throw new UWCException(49);
        }
        catch (CalendarStoreException calendarStoreException) {
            _calModelLogger.severe("Delete Calendar Failed with CalendarStoreException: Unable to get ICalendar object: " + (Object)((Object)calendarStoreException));
            throw new UWCException(5);
        }
    }

    public void addTodo(VTodo vTodo, boolean bl) throws UWCException {
        try {
            CalendarStore calendarStore = UWCUserHelper.getCalStore(this.reqCtx, false);
            ICalendar iCalendar = null;
            if (this.calids.isEmpty()) {
                throw new UWCException(54);
            }
            iCalendar = calendarStore.openCalendar((String)this.calids.get(0));
            Properties properties = new Properties();
            if (null != this.timezone) {
                properties.put("cal.socs.preferredTimezone", this.timezone.getID());
            }
            ((SOCSCalendar)iCalendar).addTodo(vTodo, bl, properties);
        }
        catch (CalendarException calendarException) {
            _calModelLogger.severe("Add Todo Failed: " + (Object)((Object)calendarException));
            throw new UWCException(19);
        }
        catch (CalendarStoreException calendarStoreException) {
            _calModelLogger.severe("Add Todo Failed with CalendarStoreException: Unable to get ICalendar object: " + (Object)((Object)calendarStoreException));
            throw new UWCException(5);
        }
    }

    public void modifyTodo(VTodo vTodo, String string, boolean bl) throws UWCException {
        try {
            CalendarStore calendarStore = UWCUserHelper.getCalStore(this.reqCtx, false);
            ICalendar iCalendar = null;
            if (this.calids.isEmpty()) {
                throw new UWCException(54);
            }
            iCalendar = calendarStore.openCalendar((String)this.calids.get(0));
            Properties properties = new Properties();
            if (null != this.timezone) {
                properties.put("cal.socs.preferredTimezone", this.timezone.getID());
            }
            ((SOCSCalendar)iCalendar).modifyTodo(vTodo, string, bl, properties);
        }
        catch (CalendarException calendarException) {
            _calModelLogger.severe("Modify Todo Failed;Calendar Exception: " + (Object)((Object)calendarException));
            throw new UWCException(21);
        }
        catch (CalendarStoreException calendarStoreException) {
            _calModelLogger.severe("Modify Todo Failed with CalendarStoreException: Unable to get ICalendar object: " + (Object)((Object)calendarStoreException));
            throw new UWCException(5);
        }
    }

    public void deleteTodo(VTodo vTodo, String string, boolean bl) throws UWCException {
        try {
            CalendarStore calendarStore = UWCUserHelper.getCalStore(this.reqCtx, false);
            ICalendar iCalendar = null;
            if (this.calids.isEmpty()) {
                throw new UWCException(54);
            }
            iCalendar = calendarStore.openCalendar((String)this.calids.get(0));
            iCalendar.deleteTodo(vTodo, string, bl);
        }
        catch (CalendarException calendarException) {
            _calModelLogger.severe("Delete Todo Failed;Calendar Store Exception: " + (Object)((Object)calendarException));
            throw new UWCException(23);
        }
        catch (CalendarStoreException calendarStoreException) {
            _calModelLogger.severe("Delete Todo Failed with CalendarStoreException: Unable to get ICalendar object: " + (Object)((Object)calendarStoreException));
            throw new UWCException(5);
        }
    }

    public BufferedReader exportCalendar(String string, DateTime dateTime, DateTime dateTime2, String string2) throws UWCException {
        try {
            CalendarStore calendarStore = UWCUserHelper.getCalStore(this.reqCtx, false);
            return calendarStore.exportCalendar(string, dateTime, dateTime2, string2);
        }
        catch (OperationNotSupportedException operationNotSupportedException) {
            _calModelLogger.severe("OperationNotSupported Exception");
            throw new UWCException(50);
        }
        catch (CalendarStoreException calendarStoreException) {
            _calModelLogger.severe("Export Calendar Failed with CalendarStoreException: Unable to get ICalendar object: " + (Object)((Object)calendarStoreException));
            throw new UWCException(5);
        }
    }

    public void importCalendar(String string, String string2, InputStream inputStream) throws UWCException {
        try {
            CalendarStore calendarStore = UWCUserHelper.getCalStore(this.reqCtx, false);
            calendarStore.importCalendar(string, string2, inputStream);
        }
        catch (OperationNotSupportedException operationNotSupportedException) {
            _calModelLogger.severe("OperationNotSupported Exception");
            throw new UWCException(51);
        }
        catch (CalendarStoreException calendarStoreException) {
            _calModelLogger.severe("Import Calendar Failed with CalendarStoreException: Unable to get ICalendar object: " + (Object)((Object)calendarStoreException));
            throw new UWCException(5);
        }
    }

    public void importCalendar(String string, DateTime dateTime, DateTime dateTime2, String string2, InputStream inputStream) throws UWCException {
        try {
            CalendarStore calendarStore = UWCUserHelper.getCalStore(this.reqCtx, false);
            calendarStore.importCalendar(string, dateTime, dateTime2, string2, inputStream);
        }
        catch (OperationNotSupportedException operationNotSupportedException) {
            _calModelLogger.severe("OperationNotSupported Exception");
            throw new UWCException(51);
        }
        catch (CalendarStoreException calendarStoreException) {
            _calModelLogger.severe("Import Calendar Failed with CalendarStoreException: Unable to get ICalendar object: " + (Object)((Object)calendarStoreException));
            throw new UWCException(5);
        }
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timezone = timeZone;
    }

    private void calculateAnonTimeZone() throws UWCModelControlException {
        UserPreferencesModel userPreferencesModel;
        _calModelLogger.info("Entering calculateAnonTimeZone()");
        String string = UWCUserHelper.getAnonymousTZID(this.reqCtx);
        if (string != null) {
            this.timezone = TimeZone.getTimeZone(string);
        } else {
            userPreferencesModel = null;
            userPreferencesModel = UWCUserHelper.getUserPrefModel(this.reqCtx);
            if (null != userPreferencesModel) {
                try {
                    if (!userPreferencesModel.getInitialized()) {
                        userPreferencesModel.initializeCommonPreferences();
                    }
                }
                catch (UWCException uWCException) {
                    _calModelLogger.severe("Exception while initializeCommonPreferences: " + uWCException);
                    return;
                }
            }
            this.timezone = TimeZone.getTimeZone(userPreferencesModel.getTimeZone());
        }
        _calModelLogger.severe("TimeZone for Anon is - " + this.timezone.toString());
        if (this.calids != null && !this.calids.isEmpty() && this.calids.size() == 1) {
            _calModelLogger.info("Only one calid is present");
            userPreferencesModel = UWCUserHelper.getCalUserPrefModel(this.reqCtx);
            String string2 = ((CalUserPreferencesModel)userPreferencesModel).getSingleCalendarTZID();
            if ("1".equals(string2)) {
                _calModelLogger.info("User has selected use calendar timezone");
                try {
                    String string3;
                    Properties properties = SOCSCalendar.getCalProps((String)((String)this.calids.get(0)), (String)UWCApplicationHelper.getWCAPHost(), (int)UWCApplicationHelper.getWCAPPort(), null);
                    if (properties != null && (string3 = properties.getProperty("TZID")) != null) {
                        this.timezone = TimeZone.getTimeZone(string3);
                    }
                }
                catch (CalendarException calendarException) {
                    _calModelLogger.severe("Calendar Exception: " + (Object)((Object)calendarException));
                    throw new UWCModelControlException(58);
                }
            }
        }
        _calModelLogger.severe("TimeZone for Anon is - " + this.timezone.toString());
    }

    private void calculateTimeZone() throws UWCModelControlException {
        _calModelLogger.info("Entering calculateTimeZone()");
        UserPreferencesModel userPreferencesModel = null;
        userPreferencesModel = UWCUserHelper.getUserPrefModel(this.reqCtx);
        if (null != userPreferencesModel) {
            try {
                if (!userPreferencesModel.getInitialized()) {
                    userPreferencesModel.initializeCommonPreferences();
                }
            }
            catch (UWCException uWCException) {
                _calModelLogger.severe("Exception while initializeCommonPreferences: " + uWCException);
                return;
            }
        }
        this.timezone = TimeZone.getTimeZone(userPreferencesModel.getTimeZone());
        _calModelLogger.info("User's Time Zone from Global options is " + this.timezone.toString());
        if (this.calids != null && !this.calids.isEmpty() && this.calids.size() == 1) {
            _calModelLogger.info("Only one calid is present");
            CalUserPreferencesModel calUserPreferencesModel = UWCUserHelper.getCalUserPrefModel(this.reqCtx);
            String string = calUserPreferencesModel.getSingleCalendarTZID();
            if ("1".equals(string)) {
                Object object = null;
                _calModelLogger.info("User has selected use calendar timezone");
                try {
                    UWCCalendar uWCCalendar;
                    if (null != this.calendars && !this.calendars.isEmpty() && null != (uWCCalendar = (UWCCalendar)this.calendars.get((String)this.calids.get(0)))) {
                        object = uWCCalendar.getCalendar().getTimeZone();
                    }
                }
                catch (OperationNotSupportedException operationNotSupportedException) {
                    _calModelLogger.severe("OperationNotSupportedException: " + (Object)((Object)operationNotSupportedException));
                }
                catch (CalendarException calendarException) {
                    _calModelLogger.severe("Calendar Exception: " + (Object)((Object)calendarException));
                }
                if (object != null) {
                    _calModelLogger.info("TimeZone of the calendar is " + object.toString());
                    this.timezone = object;
                }
            }
        }
    }

    private void executeFetchFreeBusy() throws ModelControlException {
        block18: {
            Properties properties = new Properties();
            this.removeCalendarData();
            try {
                int n;
                if (this.anonymous) {
                    String string = UWCApplicationHelper.getWCAPHost();
                    int n2 = UWCApplicationHelper.getWCAPPort();
                    String string2 = null;
                    this.calculateAnonTimeZone();
                    if (null != this.timezone) {
                        properties.put("cal.socs.preferredTimezone", this.timezone.getID());
                    }
                    if (!this.calids.isEmpty()) {
                        for (int i = 0; i < this.calids.size(); ++i) {
                            try {
                                string2 = (String)this.calids.get(i);
                                VFreeBusy vFreeBusy = SOCSCalendar.fetchFreeBusy((String)string2, (DateTime)this.start, (DateTime)this.end, (String)string, (int)n2, (Properties)properties);
                                this.freeBusy.add(vFreeBusy);
                                continue;
                            }
                            catch (CalendarException calendarException) {
                                _calModelLogger.severe("Calendar Exception: " + (Object)((Object)calendarException));
                            }
                        }
                        break block18;
                    }
                    _calModelLogger.severe("CalId is not set");
                    throw new UWCModelControlException(54);
                }
                CalendarStore calendarStore = UWCUserHelper.getCalStore(this.reqCtx, false);
                SOCSCalendar sOCSCalendar = null;
                if (!this.calids.isEmpty()) {
                    for (n = 0; n < this.calids.size(); ++n) {
                        if (!this.loadViewContextCalendar(calendarStore, (String)this.calids.get(n))) continue;
                        _calModelLogger.fine("loaded Calendar.." + (String)this.calids.get(n));
                    }
                }
                this.calculateTimeZone();
                if (this.calids != null && !this.calids.isEmpty()) {
                    for (n = 0; n < this.calids.size(); ++n) {
                        try {
                            UWCCalendar uWCCalendar = (UWCCalendar)this.calendars.get((String)this.calids.get(n));
                            sOCSCalendar = null;
                            if (uWCCalendar != null) {
                                sOCSCalendar = (SOCSCalendar)uWCCalendar.getCalendar();
                            }
                            CalendarComponent[] calendarComponentArray = null;
                            properties.put("cal.socs.preferredTimezone", this.timezone.getID());
                            if (sOCSCalendar != null) {
                                calendarComponentArray = sOCSCalendar.fetchComponents(this.start, this.end, properties, 4);
                                calendarStore.closeCalendar((String)this.calids.get(n));
                            }
                            if (null == calendarComponentArray) continue;
                            for (int i = 0; i < calendarComponentArray.length; ++i) {
                                this.freeBusy.add(calendarComponentArray[i]);
                            }
                            continue;
                        }
                        catch (CalendarStoreException calendarStoreException) {
                            _calModelLogger.severe("executeFetchFreeBusy Failed with CalendarStoreException: Unable to get ICalendar object: " + (Object)((Object)calendarStoreException));
                            continue;
                        }
                        catch (CalendarException calendarException) {
                            _calModelLogger.severe("Calendar Exception: " + (Object)((Object)calendarException));
                        }
                    }
                    break block18;
                }
                _calModelLogger.severe("CalId is not set");
                throw new UWCModelControlException(54);
            }
            catch (UWCException uWCException) {
                _calModelLogger.severe("Unable to get Store object: " + uWCException);
                throw new UWCModelControlException(uWCException.getReason());
            }
        }
    }

    private void executeFetchEventById(String string, String string2) throws ModelControlException {
        block13: {
            Properties properties = new Properties();
            try {
                if (this.anonymous) {
                    String string3 = UWCApplicationHelper.getWCAPHost();
                    int n = UWCApplicationHelper.getWCAPPort();
                    this.calculateAnonTimeZone();
                    properties.put("cal.socs.compressed", "true");
                    if (null != this.timezone) {
                        properties.put("cal.socs.preferredTimezone", this.timezone.getID());
                    }
                    if (!this.calids.isEmpty()) {
                        for (int i = 0; i < this.calids.size(); ++i) {
                            String string4 = (String)this.calids.get(i);
                            VEvent[] vEventArray = SOCSCalendar.fetchEvents((String)string4, (String)string, (String)string2, (String)"THIS_INSTANCE", (String)string3, (int)n, (Properties)properties);
                            this.allEvents.add(vEventArray[0]);
                        }
                    }
                    return;
                }
                CalendarStore calendarStore = UWCUserHelper.getCalStore(this.reqCtx, false);
                SOCSCalendar sOCSCalendar = null;
                properties.put("cal.socs.compressed", "true");
                this.removeCalendarData();
                if (!this.calids.isEmpty()) {
                    if (this.loadViewContextCalendar(calendarStore, (String)this.calids.get(0))) {
                        sOCSCalendar = (SOCSCalendar)((UWCCalendar)this.calendars.get((String)this.calids.get(0))).getCalendar();
                    }
                    this.calculateTimeZone();
                    if (null != this.timezone) {
                        properties.put("cal.socs.preferredTimezone", this.timezone.getID());
                    }
                    if (sOCSCalendar != null) {
                        VEvent[] vEventArray = sOCSCalendar.fetchEvents(string, string2, "THIS_INSTANCE", properties);
                        this.allEvents.add(vEventArray[0]);
                        calendarStore.closeCalendar((ICalendar)sOCSCalendar);
                    }
                    break block13;
                }
                _calModelLogger.severe("CalId is not set");
                throw new UWCModelControlException(5);
            }
            catch (CalendarStoreException calendarStoreException) {
                _calModelLogger.severe("executeFetchEventById Failed with CalendarStoreException: Unable to get ICalendar object: " + (Object)((Object)calendarStoreException));
                throw new UWCModelControlException(5);
            }
            catch (CalendarException calendarException) {
                _calModelLogger.severe("Calendar Exception: " + (Object)((Object)calendarException));
                throw new UWCModelControlException(58);
            }
            catch (OperationNotSupportedException operationNotSupportedException) {
                _calModelLogger.severe("OperationNotSupported Exception");
                throw new ModelControlException("OperationNotSupported Exception");
            }
            catch (UWCException uWCException) {
                _calModelLogger.severe("Unable to get Store object: " + uWCException);
                throw new UWCModelControlException(uWCException.getReason());
            }
        }
    }

    private void executeFetchTodoById(String string, String string2) throws ModelControlException {
        block10: {
            try {
                if (this.anonymous) {
                    // empty if block
                }
                CalendarStore calendarStore = UWCUserHelper.getCalStore(this.reqCtx, false);
                VTodo[] vTodoArray = null;
                SOCSCalendar sOCSCalendar = null;
                Properties properties = new Properties();
                properties.put("cal.socs.compressed", "true");
                this.removeCalendarData();
                if (!this.calids.isEmpty()) {
                    if (this.loadViewContextCalendar(calendarStore, (String)this.calids.get(0))) {
                        sOCSCalendar = (SOCSCalendar)((UWCCalendar)this.calendars.get((String)this.calids.get(0))).getCalendar();
                    }
                    this.calculateTimeZone();
                    if (null != this.timezone) {
                        properties.put("cal.socs.preferredTimezone", this.timezone.getID());
                    }
                    if (sOCSCalendar != null) {
                        vTodoArray = sOCSCalendar.fetchTodos(string, string2, "THIS_INSTANCE", properties);
                        this.allTodos.add(vTodoArray[0]);
                        calendarStore.closeCalendar((ICalendar)sOCSCalendar);
                    }
                    break block10;
                }
                _calModelLogger.severe("CalId is not set");
                throw new UWCModelControlException(5);
            }
            catch (CalendarStoreException calendarStoreException) {
                _calModelLogger.severe("executeFetchTodoById Failed with CalendarStoreException: Unable to get ICalendar object: " + (Object)((Object)calendarStoreException));
                throw new UWCModelControlException(5);
            }
            catch (CalendarException calendarException) {
                _calModelLogger.severe("Calendar Exception: " + (Object)((Object)calendarException));
                throw new UWCModelControlException(58);
            }
            catch (OperationNotSupportedException operationNotSupportedException) {
                _calModelLogger.severe("OperationNotSupported Exception");
                throw new ModelControlException("OperationNotSupported Exception");
            }
            catch (UWCException uWCException) {
                _calModelLogger.severe("Unable to get Store object: " + uWCException);
                throw new UWCModelControlException(uWCException.getReason());
            }
        }
    }

    private void executeYearViewContext() throws ModelControlException {
        _calModelLogger.entering(_classname, "executeYearViewContext ");
        this.removeCalendarData();
        Properties properties = new Properties();
        String string = UWCUserHelper.getWCAPEventFilter(this.reqCtx);
        if (null != string) {
            properties.put("cal.socs.compstate", string);
            _calModelLogger.finest("Event filter is " + string);
        } else {
            _calModelLogger.finest("Event filter is null !!!");
        }
        Properties properties2 = null;
        if (this.anonymous) {
            String string2 = UWCApplicationHelper.getWCAPHost();
            int n = UWCApplicationHelper.getWCAPPort();
            String string3 = null;
            if (!this.calids.isEmpty()) {
                for (int i = 0; i < this.calids.size(); ++i) {
                    string3 = (String)this.calids.get(i);
                    _calModelLogger.fine("Calid is " + string3);
                    try {
                        properties2 = SOCSCalendar.getCalProps((String)string3, (String)string2, (int)n, (Properties)properties);
                    }
                    catch (Exception exception) {
                        throw new UWCModelControlException(exception.getMessage());
                    }
                    String string4 = properties2.getProperty("ACCESS-CONTROL-ENTRY");
                    String string5 = properties2.getProperty("PRIMARY-OWNER");
                    CalendarACL calendarACL = new CalendarACL(string4, null, string5);
                    boolean bl = false;
                    try {
                        bl = calendarACL.checkPermission("@", "a", "r");
                    }
                    catch (Exception exception) {
                        _calModelLogger.fine("Caught Exception" + exception.getMessage());
                        bl = false;
                    }
                    if (!bl) {
                        _calModelLogger.fine("Calendar" + string3 + "is not readable");
                        throw new ModelControlException(" calendar is not readable...");
                    }
                    _calModelLogger.fine("Calendar" + string3 + "is readable");
                }
            }
            return;
        }
        _calModelLogger.fine("loadCalendars");
        if (!this.calids.isEmpty()) {
            CalendarStore calendarStore = null;
            try {
                calendarStore = UWCUserHelper.getCalStore(this.reqCtx, false);
            }
            catch (Exception exception) {
                throw new UWCModelControlException(exception.getMessage());
            }
            String string6 = UWCUserHelper.getUID(this.reqCtx);
            for (int i = 0; i < this.calids.size(); ++i) {
                if (this.loadViewContextCalendar(calendarStore, (String)this.calids.get(i))) {
                    _calModelLogger.fine("loaded Calendar.." + (String)this.calids.get(i));
                    UWCCalendar uWCCalendar = (UWCCalendar)this.calendars.get((String)this.calids.get(i));
                    if (uWCCalendar == null) continue;
                    ICalendar iCalendar = uWCCalendar.getCalendar();
                    boolean bl = false;
                    try {
                        CalendarACL calendarACL = new CalendarACL(iCalendar);
                        bl = calendarACL.checkPermission(string6, "a", "r");
                    }
                    catch (Exception exception) {
                        bl = false;
                    }
                    if (bl) {
                        _calModelLogger.fine("Calendar" + (String)this.calids.get(i) + "is readable");
                        continue;
                    }
                    _calModelLogger.fine("Calendar" + (String)this.calids.get(i) + "is not readable");
                    throw new ModelControlException(" calendar is not readable...");
                }
                throw new ModelControlException(" calendar is not readable...");
            }
        }
    }

    private void executeViewContext() throws ModelControlException {
        _calModelLogger.entering(_classname, "executeViewContext ");
        try {
            this.removeCalendarData();
            Properties properties = new Properties();
            String string = UWCUserHelper.getWCAPEventFilter(this.reqCtx);
            if (null != string) {
                properties.put("cal.socs.compstate", string);
                _calModelLogger.finest("Event filter is " + string);
            } else {
                _calModelLogger.finest("Event filter is null !!!");
            }
            if (this.anonymous) {
                String string2 = UWCApplicationHelper.getWCAPHost();
                int n = UWCApplicationHelper.getWCAPPort();
                String string3 = null;
                this.calculateAnonTimeZone();
                if (null != this.timezone) {
                    properties.put("cal.preferredTimezone", this.timezone.getID());
                }
                if (!this.calids.isEmpty()) {
                    for (int i = 0; i < this.calids.size(); ++i) {
                        string3 = (String)this.calids.get(i);
                        _calModelLogger.fine("Calid is " + string3);
                        CalendarComponent[] calendarComponentArray = SOCSCalendar.fetchComponents((String)string3, (DateTime)this.start, (DateTime)this.end, (int)3, (String)string2, (int)n, (Properties)properties);
                        this.seperateComponentsIntoEventsTasks(calendarComponentArray);
                    }
                }
            } else {
                int n;
                _calModelLogger.fine("getCalStore");
                if (this._userId == null) {
                    this._userId = UWCUserHelper.getUID(this.reqCtx);
                }
                this.numInvitations = 0;
                CalendarStore calendarStore = UWCUserHelper.getCalStore(this.reqCtx, false);
                SOCSCalendar sOCSCalendar = null;
                boolean bl = false;
                _calModelLogger.fine("loadCalendars");
                if (!this.calids.isEmpty()) {
                    for (n = 0; n < this.calids.size(); ++n) {
                        if (!this.loadViewContextCalendar(calendarStore, (String)this.calids.get(n))) continue;
                        _calModelLogger.fine("loaded Calendar.." + (String)this.calids.get(n));
                    }
                }
                this.calculateTimeZone();
                if (!this.calids.isEmpty()) {
                    for (n = 0; n < this.calids.size(); ++n) {
                        CalendarComponent[] calendarComponentArray;
                        sOCSCalendar = null;
                        UWCCalendar uWCCalendar = (UWCCalendar)this.calendars.get(this.calids.get(n));
                        if (uWCCalendar != null) {
                            sOCSCalendar = (SOCSCalendar)uWCCalendar.getCalendar();
                        }
                        if (null != this.timezone) {
                            properties.put("cal.socs.preferredTimezone", this.timezone.getID());
                        }
                        if (sOCSCalendar != null) {
                            calendarComponentArray = sOCSCalendar.fetchComponents(this.start, this.end, properties, 3);
                            this.numInvitations += sOCSCalendar.getInvitationsCount();
                        } else {
                            throw new UWCModelControlException(5);
                        }
                        _calModelLogger.fine("separate Components..");
                        this.seperateComponentsIntoEventsTasks(calendarComponentArray);
                        calendarStore.closeCalendar((ICalendar)sOCSCalendar);
                    }
                    if (!this.currentDate.equals((Object)this.start) && !this.currentDate.equals((Object)this.end)) {
                        if (this.currentDate.after((Object)this.start) && this.currentDate.before((Object)this.end)) {
                            bl = false;
                        }
                        if (this.currentDate.before((Object)this.start) && this.currentDate.before((Object)this.end)) {
                            bl = false;
                        }
                        if (this.currentDate.after((Object)this.start) && this.currentDate.after((Object)this.end)) {
                            bl = true;
                        }
                    }
                    if (bl) {
                        this.executeOverDueTodos();
                    }
                } else {
                    _calModelLogger.severe("CalId is not set");
                    throw new UWCModelControlException(5);
                }
                UWCUserHelper.setInviteCount(this.reqCtx, this.numInvitations);
            }
        }
        catch (CalendarStoreException calendarStoreException) {
            _calModelLogger.severe("executeViewContext Failed with CalendarStoreException: Unable to get ICalendar object: " + (Object)((Object)calendarStoreException));
            throw new UWCModelControlException(5);
        }
        catch (CalendarException calendarException) {
            _calModelLogger.severe("Calendar Exception: " + (Object)((Object)calendarException));
            throw new UWCModelControlException(58);
        }
        catch (UWCException uWCException) {
            _calModelLogger.severe("Unable to get Store object: " + uWCException);
            throw new UWCModelControlException(uWCException.getReason());
        }
        catch (OperationNotSupportedException operationNotSupportedException) {
            _calModelLogger.severe("Unable to get Invite Count: " + (Object)((Object)operationNotSupportedException));
            throw new UWCModelControlException(operationNotSupportedException);
        }
        _calModelLogger.exiting(_classname, "executeViewContext ");
    }

    private boolean loadViewContextCalendar(CalendarStore calendarStore, String string) {
        if (null == string) {
            return false;
        }
        if (this.calendars == null) {
            this.calendars = new HashMap();
        }
        boolean bl = false;
        HashMap hashMap = UWCUserHelper.getOwnedCalendars(this.reqCtx);
        UWCCalendar uWCCalendar = null;
        if (null != hashMap && null != (uWCCalendar = (UWCCalendar)hashMap.get(string))) {
            this.calendars.put(string, uWCCalendar);
            bl = true;
            return bl;
        }
        if (!bl && null != (hashMap = UWCUserHelper.getSubscribedCalendars(this.reqCtx)) && null != (uWCCalendar = (UWCCalendar)hashMap.get(string))) {
            this.calendars.put(string, uWCCalendar);
            bl = true;
            return bl;
        }
        if (!bl) {
            try {
                SOCSCalendar sOCSCalendar = (SOCSCalendar)calendarStore.openCalendar(string);
                sOCSCalendar.getCalProps();
                uWCCalendar = new UWCCalendar((ICalendar)sOCSCalendar);
                this.calendars.put(string, uWCCalendar);
                bl = true;
                calendarStore.closeCalendar(string);
            }
            catch (CalendarStoreException calendarStoreException) {
                _calModelLogger.severe("loadViewContextCalendar Failed with CalendarStoreException: Unable to get ICalendar object: " + (Object)((Object)calendarStoreException));
                this.calendars.put(string, null);
                bl = false;
            }
            catch (OperationNotSupportedException operationNotSupportedException) {
                _calModelLogger.severe("loadViewContextCalendar Failed with OperationNotSupportedException: " + (Object)((Object)operationNotSupportedException));
                this.calendars.put(string, null);
                bl = false;
            }
            catch (CalendarException calendarException) {
                _calModelLogger.severe("loadViewContextCalendar Failed with CalendarException: " + (Object)((Object)calendarException));
                this.calendars.put(string, null);
                bl = false;
            }
            catch (UWCException uWCException) {
                _calModelLogger.severe("loadViewContextCalendar Failed with UWCException: " + uWCException);
                this.calendars.put(string, null);
                bl = false;
            }
            return bl;
        }
        return bl;
    }

    private void executeFetchEvents(boolean bl) throws ModelControlException {
        _calModelLogger.entering(_classname, "executeFetchEvents()");
        try {
            int n;
            Properties properties = new Properties();
            if (this.eventsFilter == null) {
                this.eventsFilter = UWCUserHelper.getWCAPEventFilter(this.reqCtx);
            } else if (this.eventsFilter.equals("needs-action")) {
                this.eventsFilter = new String("REQUEST-NEEDS-ACTION;REQUEST-NEEDSNOACTION") + ";" + "REQUEST-COMPLETED;REQUEST-PENDING;REQUEST-WAITFORREPLY;PUBLISH-COMPLETED";
            } else if (this.eventsFilter.equals("accepted")) {
                this.eventsFilter = new String("REPLY-ACCEPTED") + ";" + "REQUEST-COMPLETED;REQUEST-PENDING;REQUEST-WAITFORREPLY;PUBLISH-COMPLETED";
            } else if (this.eventsFilter.equals("declined")) {
                this.eventsFilter = new String("REPLY-DECLINED") + ";" + "REQUEST-COMPLETED;REQUEST-PENDING;REQUEST-WAITFORREPLY;PUBLISH-COMPLETED";
            } else if (this.eventsFilter.equals("tentative")) {
                this.eventsFilter = new String("REPLY-TENTATIVE") + ";" + "REQUEST-COMPLETED;REQUEST-PENDING;REQUEST-WAITFORREPLY;PUBLISH-COMPLETED";
            }
            if (null != this.eventsFilter) {
                properties.put("cal.socs.compstate", this.eventsFilter);
                _calModelLogger.finest("Event filter is " + this.eventsFilter);
            }
            this.removeCalendarData();
            if (this.anonymous) {
                String string = UWCApplicationHelper.getWCAPHost();
                int n2 = UWCApplicationHelper.getWCAPPort();
                String string2 = null;
                this.calculateAnonTimeZone();
                if (null != this.timezone) {
                    properties.put("cal.socs.preferredTimezone", this.timezone.getID());
                }
                if (this.calids != null && !this.calids.isEmpty()) {
                    for (int i = 0; i < this.calids.size(); ++i) {
                        string2 = (String)this.calids.get(i);
                        CalendarComponent[] calendarComponentArray = SOCSCalendar.fetchComponents((String)string2, (DateTime)this.start, (DateTime)this.end, (int)1, (String)string, (int)n2, (Properties)properties);
                        for (int j = 0; j < calendarComponentArray.length; ++j) {
                            this.allEvents.add(calendarComponentArray[j]);
                        }
                    }
                } else {
                    _calModelLogger.severe("CalId is not set");
                    throw new UWCModelControlException(5);
                }
                return;
            }
            CalendarStore calendarStore = UWCUserHelper.getCalStore(this.reqCtx, false);
            if (this._userId == null) {
                this._userId = UWCUserHelper.getUID(this.reqCtx);
            }
            this.numInvitations = 0;
            SOCSCalendar sOCSCalendar = null;
            if (!this.calids.isEmpty()) {
                for (n = 0; n < this.calids.size(); ++n) {
                    if (!this.loadViewContextCalendar(calendarStore, (String)this.calids.get(n))) continue;
                    _calModelLogger.fine("loaded Calendar.." + (String)this.calids.get(n));
                }
            }
            this.calculateTimeZone();
            if (this.calids != null && !this.calids.isEmpty()) {
                for (n = 0; n < this.calids.size(); ++n) {
                    sOCSCalendar = null;
                    CalendarComponent[] calendarComponentArray = null;
                    UWCCalendar uWCCalendar = (UWCCalendar)this.calendars.get((String)this.calids.get(n));
                    if (uWCCalendar != null) {
                        sOCSCalendar = (SOCSCalendar)uWCCalendar.getCalendar();
                    }
                    if (null != this.timezone) {
                        properties.put("cal.socs.preferredTimezone", this.timezone.getID());
                    }
                    if (bl && UWCUserHelper.isUserTheCalendarOwner(this.reqCtx, (String)this.calids.get(n), this._userId)) {
                        properties.put("cal.socs.invitecount", "true");
                    }
                    if (sOCSCalendar == null) continue;
                    calendarComponentArray = sOCSCalendar.fetchComponents(this.start, this.end, properties, 1);
                    this.numInvitations += sOCSCalendar.getInvitationsCount();
                    if (calendarComponentArray != null) {
                        for (int i = 0; i < calendarComponentArray.length; ++i) {
                            this.allEvents.add(calendarComponentArray[i]);
                        }
                    }
                    calendarStore.closeCalendar((ICalendar)sOCSCalendar);
                }
            } else {
                _calModelLogger.severe("CalId is not set");
                throw new UWCModelControlException(5);
            }
            UWCUserHelper.setInviteCount(this.reqCtx, this.numInvitations);
        }
        catch (CalendarStoreException calendarStoreException) {
            _calModelLogger.severe("executeFetchEvents Failed with CalendarStoreException: Unable to get ICalendar object: " + calendarStoreException.getMessage());
            throw new UWCModelControlException(5);
        }
        catch (CalendarException calendarException) {
            _calModelLogger.severe("Calendar Exception: " + calendarException.getMessage());
            throw new UWCModelControlException(58);
        }
        catch (UWCException uWCException) {
            _calModelLogger.severe("Unable to get Store object: " + uWCException.getMessage());
            throw new UWCModelControlException(uWCException.getReason());
        }
        catch (OperationNotSupportedException operationNotSupportedException) {
            _calModelLogger.severe("Unable to get Invite Count: " + (Object)((Object)operationNotSupportedException));
            throw new UWCModelControlException(operationNotSupportedException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void executeFetchTodos() throws ModelControlException {
        int n;
        String string;
        int n2;
        String string2;
        Properties properties;
        block21: {
            try {
                int n3;
                properties = new Properties();
                this.removeCalendarData();
                if (this.anonymous) {
                    string2 = UWCApplicationHelper.getWCAPHost();
                    n2 = UWCApplicationHelper.getWCAPPort();
                    string = null;
                    this.calculateAnonTimeZone();
                    if (null != this.timezone) {
                        properties.put("cal.socs.preferredTimezone", this.timezone.getID());
                    }
                    if (this.calids.isEmpty()) {
                        _calModelLogger.severe("CalId is not set");
                        throw new UWCModelControlException(5);
                    }
                    n = 0;
                    break block21;
                }
                if (this._userId == null) {
                    this._userId = UWCUserHelper.getUID(this.reqCtx);
                }
                this.numInvitations = 0;
                CalendarStore calendarStore = UWCUserHelper.getCalStore(this.reqCtx, false);
                SOCSCalendar sOCSCalendar = null;
                if (!this.calids.isEmpty()) {
                    for (n3 = 0; n3 < this.calids.size(); ++n3) {
                        if (!this.loadViewContextCalendar(calendarStore, (String)this.calids.get(n3))) continue;
                        _calModelLogger.fine("loaded Calendar.." + (String)this.calids.get(n3));
                    }
                }
                this.calculateTimeZone();
                if (this.calids.isEmpty()) {
                    _calModelLogger.severe("Calendar Exception");
                    throw new UWCModelControlException(58);
                }
                n3 = 0;
                while (true) {
                    if (n3 >= this.calids.size()) {
                        UWCUserHelper.setInviteCount(this.reqCtx, this.numInvitations);
                        return;
                    }
                    CalendarComponent[] calendarComponentArray = null;
                    sOCSCalendar = null;
                    UWCCalendar uWCCalendar = (UWCCalendar)this.calendars.get((String)this.calids.get(n3));
                    if (uWCCalendar != null) {
                        sOCSCalendar = (SOCSCalendar)uWCCalendar.getCalendar();
                    }
                    if (null != this.timezone) {
                        properties.put("cal.socs.preferredTimezone", this.timezone.getID());
                    }
                    if (sOCSCalendar != null) {
                        calendarComponentArray = sOCSCalendar.fetchComponents(this.start, this.end, properties, 2);
                        this.numInvitations += sOCSCalendar.getInvitationsCount();
                        if (calendarComponentArray != null) {
                            for (int i = 0; i < calendarComponentArray.length; ++i) {
                                this.allTodos.add(calendarComponentArray[i]);
                            }
                        }
                        calendarStore.closeCalendar((ICalendar)sOCSCalendar);
                    }
                    ++n3;
                }
            }
            catch (CalendarStoreException calendarStoreException) {
                _calModelLogger.severe("executeFetchTodos Failed with CalendarStoreException: Unable to get ICalendar object: " + (Object)((Object)calendarStoreException));
                throw new UWCModelControlException(5);
            }
            catch (CalendarException calendarException) {
                _calModelLogger.severe("Calendar Exception: " + (Object)((Object)calendarException));
                _calModelLogger.fine("Fetch Todos failed");
                throw new UWCModelControlException(58);
            }
            catch (UWCException uWCException) {
                _calModelLogger.severe("Unable to get Store object: " + uWCException);
                throw new UWCModelControlException(uWCException.getReason());
            }
            catch (OperationNotSupportedException operationNotSupportedException) {
                _calModelLogger.severe("Unable to get Invite Count: " + (Object)((Object)operationNotSupportedException));
                throw new UWCModelControlException(operationNotSupportedException);
            }
        }
        while (n < this.calids.size()) {
            string = (String)this.calids.get(n);
            CalendarComponent[] calendarComponentArray = SOCSCalendar.fetchComponents((String)string, (DateTime)this.start, (DateTime)this.end, (int)2, (String)string2, (int)n2, (Properties)properties);
            for (int i = 0; i < calendarComponentArray.length; ++i) {
                this.allTodos.add(calendarComponentArray[i]);
            }
            ++n;
        }
    }

    private void executeSearchEvents() throws ModelControlException {
        block18: {
            try {
                int n;
                Properties properties = new Properties();
                this.removeCalendarData();
                if (this.anonymous) {
                    String string = UWCApplicationHelper.getWCAPHost();
                    int n2 = UWCApplicationHelper.getWCAPPort();
                    this.calculateAnonTimeZone();
                    if (null != this.timezone) {
                        properties.put("cal.socs.preferredTimezone", this.timezone.getID());
                    }
                    if (this.calids != null && !this.calids.isEmpty()) {
                        for (int i = 0; i < this.calids.size(); ++i) {
                            CalendarComponent[] calendarComponentArray = SOCSCalendar.searchEvents((String)((String)this.calids.get(i)), (DateTime)this.start, (DateTime)this.end, (String)this.componentSearchFilter, (int)this.componentSearchOption, (String)string, (int)n2, (Properties)properties);
                            if (calendarComponentArray == null) continue;
                            for (int j = 0; j < calendarComponentArray.length; ++j) {
                                this.allEvents.add(calendarComponentArray[j]);
                            }
                        }
                    }
                    return;
                }
                CalendarStore calendarStore = UWCUserHelper.getCalStore(this.reqCtx, false);
                SOCSCalendar sOCSCalendar = null;
                if (!this.calids.isEmpty()) {
                    for (n = 0; n < this.calids.size(); ++n) {
                        if (!this.loadViewContextCalendar(calendarStore, (String)this.calids.get(n))) continue;
                        _calModelLogger.fine("loaded Calendar.." + (String)this.calids.get(n));
                    }
                }
                this.calculateTimeZone();
                if (this.calids != null && !this.calids.isEmpty()) {
                    for (n = 0; n < this.calids.size(); ++n) {
                        sOCSCalendar = null;
                        CalendarComponent[] calendarComponentArray = null;
                        UWCCalendar uWCCalendar = (UWCCalendar)this.calendars.get((String)this.calids.get(n));
                        if (uWCCalendar != null) {
                            sOCSCalendar = (SOCSCalendar)uWCCalendar.getCalendar();
                        }
                        if (null != this.timezone) {
                            properties.put("cal.socs.preferredTimezone", this.timezone.getID());
                        }
                        if (sOCSCalendar == null) continue;
                        calendarComponentArray = sOCSCalendar.searchEvents(this.start, this.end, this.componentSearchFilter, this.componentSearchOption, properties);
                        if (calendarComponentArray != null) {
                            for (int i = 0; i < calendarComponentArray.length; ++i) {
                                this.allEvents.add(calendarComponentArray[i]);
                            }
                        }
                        calendarStore.closeCalendar((ICalendar)sOCSCalendar);
                    }
                    break block18;
                }
                _calModelLogger.severe("CalId is not set");
                throw new UWCModelControlException(5);
            }
            catch (CalendarStoreException calendarStoreException) {
                _calModelLogger.severe("executeFetchEvents Failed with CalendarStoreException: Unable to get ICalendar object: " + (Object)((Object)calendarStoreException));
                throw new UWCModelControlException(5);
            }
            catch (OperationNotSupportedException operationNotSupportedException) {
                _calModelLogger.severe("OperationNotSupported Exception: " + (Object)((Object)operationNotSupportedException));
                throw new UWCModelControlException(58);
            }
            catch (CalendarException calendarException) {
                _calModelLogger.severe("Calendar Exception: " + (Object)((Object)calendarException));
                throw new UWCModelControlException(58);
            }
            catch (UWCException uWCException) {
                _calModelLogger.severe("Unable to get Store object: " + uWCException);
                throw new UWCModelControlException(uWCException.getReason());
            }
        }
    }

    private void executeSearchTodos() throws ModelControlException {
        try {
            Properties properties = null;
            this.removeCalendarData();
            if (!this.anonymous) {
                int n;
                this._userId = UWCUserHelper.getUID(this.reqCtx);
                this.numInvitations = 0;
                CalendarStore calendarStore = UWCUserHelper.getCalStore(this.reqCtx, false);
                SOCSCalendar sOCSCalendar = null;
                if (!this.calids.isEmpty()) {
                    for (n = 0; n < this.calids.size(); ++n) {
                        if (!this.loadViewContextCalendar(calendarStore, (String)this.calids.get(n))) continue;
                        _calModelLogger.fine("loaded Calendar.." + (String)this.calids.get(n));
                    }
                }
                this.calculateTimeZone();
                if (this.calids != null && !this.calids.isEmpty()) {
                    for (n = 0; n < this.calids.size(); ++n) {
                        sOCSCalendar = null;
                        CalendarComponent[] calendarComponentArray = null;
                        UWCCalendar uWCCalendar = (UWCCalendar)this.calendars.get((String)this.calids.get(n));
                        if (uWCCalendar != null) {
                            sOCSCalendar = (SOCSCalendar)uWCCalendar.getCalendar();
                        }
                        properties = new Properties();
                        if (null != this.timezone) {
                            properties.put("cal.socs.preferredTimezone", this.timezone.getID());
                        }
                        if (sOCSCalendar != null) {
                            calendarComponentArray = sOCSCalendar.searchTodos(this.start, this.end, this.componentSearchFilter, this.componentSearchOption, properties);
                            this.numInvitations += sOCSCalendar.getInvitationsCount();
                            calendarStore.closeCalendar((ICalendar)sOCSCalendar);
                        }
                        if (calendarComponentArray == null) continue;
                        for (int i = 0; i < calendarComponentArray.length; ++i) {
                            this.allTodos.add(calendarComponentArray[i]);
                        }
                    }
                } else {
                    _calModelLogger.severe("CalId is not set");
                    throw new UWCModelControlException(5);
                }
                UWCUserHelper.setInviteCount(this.reqCtx, this.numInvitations);
            }
        }
        catch (CalendarStoreException calendarStoreException) {
            _calModelLogger.severe("executeFetchEvents Failed with CalendarStoreException: Unable to get ICalendar object: " + (Object)((Object)calendarStoreException));
            throw new UWCModelControlException(5);
        }
        catch (OperationNotSupportedException operationNotSupportedException) {
            _calModelLogger.severe("OperationNotSupported Exception: " + (Object)((Object)operationNotSupportedException));
            throw new UWCModelControlException(58);
        }
        catch (CalendarException calendarException) {
            _calModelLogger.severe("Calendar Exception: " + (Object)((Object)calendarException));
            throw new UWCModelControlException(58);
        }
        catch (UWCException uWCException) {
            _calModelLogger.severe("Unable to get Store object: " + uWCException);
            throw new UWCModelControlException(uWCException.getReason());
        }
    }

    private void executeOverDueTodos() throws ModelControlException {
        block10: {
            try {
                Properties properties = null;
                this.overDueTodos.clear();
                if (this.anonymous) break block10;
                CalendarStore calendarStore = UWCUserHelper.getCalStore(this.reqCtx, false);
                SOCSCalendar sOCSCalendar = null;
                DateTime dateTime = (DateTime)this.currentDate.clone();
                DateTime dateTime2 = (DateTime)this.currentDate.clone();
                this.calculateTimeZone();
                if (!this.calids.isEmpty()) {
                    for (int i = 0; i < this.calids.size(); ++i) {
                        sOCSCalendar = null;
                        CalendarComponent[] calendarComponentArray = null;
                        UWCCalendar uWCCalendar = (UWCCalendar)this.calendars.get((String)this.calids.get(i));
                        if (uWCCalendar != null) {
                            sOCSCalendar = (SOCSCalendar)uWCCalendar.getCalendar();
                        }
                        properties = new Properties();
                        if (null != this.timezone) {
                            properties.put("cal.socs.preferredTimezone", this.timezone.getID());
                        }
                        if (sOCSCalendar == null) continue;
                        calendarComponentArray = sOCSCalendar.fetchComponents(dateTime, dateTime2, properties, 2);
                        if (calendarComponentArray != null) {
                            for (int j = 0; j < calendarComponentArray.length; ++j) {
                                this.overDueTodos.add((VTodo)calendarComponentArray[j]);
                            }
                        }
                        calendarStore.closeCalendar((ICalendar)sOCSCalendar);
                    }
                    break block10;
                }
                _calModelLogger.severe("Calendar Exception");
                throw new UWCModelControlException(58);
            }
            catch (CalendarStoreException calendarStoreException) {
                _calModelLogger.severe("executeFetchTodos Failed with CalendarStoreException: Unable to get ICalendar object: " + (Object)((Object)calendarStoreException));
                throw new UWCModelControlException(5);
            }
            catch (CalendarException calendarException) {
                _calModelLogger.severe("Calendar Exception: " + (Object)((Object)calendarException));
                _calModelLogger.fine("Fetch Todos failed");
                throw new UWCModelControlException(58);
            }
            catch (UWCException uWCException) {
                _calModelLogger.severe("Unable to get Store object: " + uWCException);
                throw new UWCModelControlException(uWCException.getReason());
            }
        }
    }

    private void fetchOwnedCalendars() throws UWCException {
        ICalendar[] iCalendarArray;
        UWCCalendar uWCCalendar = null;
        CalendarStore calendarStore = UWCUserHelper.getCalStore(this.reqCtx, false);
        try {
            iCalendarArray = calendarStore.getCalendars();
        }
        catch (OperationNotSupportedException operationNotSupportedException) {
            _calModelLogger.severe("OperationNotSupported Exception");
            throw new UWCException(53);
        }
        catch (CalendarStoreException calendarStoreException) {
            _calModelLogger.severe("fetchOwnedCalendars Failed with CalendarStoreException: Unable to get ICalendar object: " + (Object)((Object)calendarStoreException));
            throw new UWCException(52);
        }
        for (int i = 0; i < iCalendarArray.length; ++i) {
            try {
                uWCCalendar = new UWCCalendar(iCalendarArray[i]);
                this.ownedCalendars.put(iCalendarArray[i].getCalID(), uWCCalendar);
                continue;
            }
            catch (Exception exception) {
                _calModelLogger.severe("Exception .." + exception.getMessage());
                this.ownedCalendars.put(iCalendarArray[i].getCalID(), null);
            }
        }
    }

    private void searchCalendars(String string) throws UWCException {
        try {
            CalendarStore calendarStore = UWCUserHelper.getCalStore(this.reqCtx, false);
            Properties properties = new Properties();
            properties.setProperty("calid", "1");
            properties.setProperty("name", "1");
            properties.setProperty("primaryOwner", "1");
            ICalendar[] iCalendarArray = calendarStore.searchCalendars(string, properties);
            for (int i = 0; i < iCalendarArray.length; ++i) {
                this.calendars.put(iCalendarArray[i].getCalID(), iCalendarArray[i]);
            }
        }
        catch (OperationNotSupportedException operationNotSupportedException) {
            _calModelLogger.severe("OperationNotSupported Exception");
            throw new UWCException(56);
        }
        catch (CalendarStoreException calendarStoreException) {
            _calModelLogger.severe("searchCalendars Failed with CalendarStoreException: " + (Object)((Object)calendarStoreException));
            throw new UWCException(57);
        }
    }

    private void sortEventsByType() {
        _calModelLogger.entering(_classname, "sortEventsByType()");
        VEvent vEvent = null;
        int n = 0;
        if (!this.allEvents.isEmpty()) {
            n = this.allEvents.size();
        }
        if (!this.typeSortRequired) {
            _calModelLogger.info("Category Sort is not enabled");
            _calModelLogger.exiting(_classname, "sortEventsByType()");
            return;
        }
        _calModelLogger.info("Category Sort is Enabled and Current Category is" + this.category);
        try {
            if (this.typeSortRequired && n != 0 && this.category != null) {
                for (int i = 0; i < n; ++i) {
                    vEvent = (VEvent)this.allEvents.get(i);
                    String[] stringArray = vEvent.getCategories();
                    if (null == stringArray || stringArray.length == 0) {
                        stringArray = new String[]{CAL_EVENT_CATEGORY_OTHER};
                    }
                    if (null == stringArray || stringArray.length <= 0 || this.category.equalsIgnoreCase(stringArray[0])) continue;
                    this.allEvents.remove(i);
                    --i;
                    --n;
                }
            }
        }
        catch (OperationNotSupportedException operationNotSupportedException) {
            _calModelLogger.severe("OperationNotSupported Exception");
        }
        catch (CalendarComponentException calendarComponentException) {
            _calModelLogger.severe("CalendarComponent Exception");
            _calModelLogger.severe("SortEvents Failed");
        }
    }

    private void sortTodosByType() {
        _calModelLogger.entering(_classname, "sortTodosByType()");
        VTodo vTodo = null;
        int n = 0;
        if (!this.allTodos.isEmpty()) {
            n = this.allTodos.size();
        }
        if (!this.typeSortRequired) {
            _calModelLogger.info("Category Sort is not enabled");
            _calModelLogger.exiting(_classname, "sortTodosByType()");
            return;
        }
        _calModelLogger.info("Category Sort is Enabled and Current Category is" + this.category);
        try {
            if (this.typeSortRequired && n != 0 && this.category != null) {
                for (int i = 0; i < n; ++i) {
                    vTodo = (VTodo)this.allTodos.get(i);
                    String[] stringArray = vTodo.getCategories();
                    if (null == stringArray || stringArray.length == 0) {
                        stringArray = new String[]{CAL_EVENT_CATEGORY_OTHER};
                    }
                    if (null == stringArray || stringArray.length <= 0 || this.category.equalsIgnoreCase(stringArray[0])) continue;
                    this.allTodos.remove(i);
                    --i;
                    --n;
                }
            }
        }
        catch (OperationNotSupportedException operationNotSupportedException) {
            _calModelLogger.severe("OperationNotSupported Exception");
        }
        catch (CalendarComponentException calendarComponentException) {
            _calModelLogger.severe("CalendarComponent Exception");
            _calModelLogger.severe("SortEvents Failed");
        }
    }

    private void sortEvents() {
        _calModelLogger.entering(_classname, "sortEvents()");
        VEvent vEvent = null;
        Attendee attendee = null;
        int n = 0;
        int n2 = 0;
        this.sortEventsByType();
        if (!this.allEvents.isEmpty()) {
            n = this.allEvents.size();
        }
        if (!this.calids.isEmpty()) {
            n2 = this.calids.size();
        }
        _calModelLogger.fine("numEvents is..." + n);
        try {
            for (int i = 0; i < n; ++i) {
                String string;
                vEvent = (VEvent)this.allEvents.get(i);
                String[] stringArray = vEvent.getCategories();
                attendee = null;
                String string2 = string = vEvent.getCalID();
                UWCCalendar uWCCalendar = (UWCCalendar)this.calendars.get(string);
                if (uWCCalendar != null) {
                    string2 = ((SOCSCalendar)uWCCalendar.getCalendar()).getRelativeCalId();
                }
                if (this.allDayEventsSortRequired) {
                    if (vEvent.isAllDay()) {
                        this.allDayEvents.add(vEvent);
                    } else {
                        this.nonAllDayEvents.add(vEvent);
                    }
                }
                if (this.typeSortRequired && this.category != null) {
                    if (null == stringArray || stringArray.length <= 0 || this.category.equalsIgnoreCase(stringArray[0])) {
                        // empty if block
                    }
                    this.typeEvents.add(vEvent);
                }
                if (!this.invitationsSortRequired || vEvent.isCalIdTheOrganizer(string2) || (attendee = vEvent.getAttendee(string2)) == null || !attendee.getParticipantStatus().equals("NEEDS-ACTION")) continue;
                this.invitationEvents.add(vEvent);
            }
        }
        catch (OperationNotSupportedException operationNotSupportedException) {
            _calModelLogger.severe("OperationNotSupported Exception");
        }
        catch (CalendarComponentException calendarComponentException) {
            _calModelLogger.severe("CalendarComponent Exception");
            _calModelLogger.severe("SortEvents Failed");
        }
        catch (Exception exception) {
            _calModelLogger.severe("Exception..." + exception.getMessage());
            _calModelLogger.severe("SortEvents Failed");
        }
    }

    private void sortTodos() {
        VTodo vTodo = null;
        DateTime dateTime = null;
        int n = 0;
        int n2 = 0;
        this.sortTodosByType();
        if (!this.allTodos.isEmpty()) {
            n = this.allTodos.size();
        }
        if (!this.calids.isEmpty()) {
            n2 = this.calids.size();
        }
        _calModelLogger.finest("ContextDate is" + this.contextDate);
        _calModelLogger.finest("CurrentDate is" + this.currentDate);
        _calModelLogger.finest("start is" + this.start);
        _calModelLogger.finest("end is" + this.end);
        _calModelLogger.finest("end is" + this.end);
        boolean bl = false;
        if (this.currentDate.equals((Object)this.start) || this.currentDate.equals((Object)this.end) || this.currentDate.after((Object)this.start) && this.currentDate.before((Object)this.end) || this.currentDate.before((Object)this.start) && this.currentDate.before((Object)this.end)) {
            bl = true;
        }
        try {
            String string;
            int n3;
            block3: for (n3 = 0; n3 < n; ++n3) {
                vTodo = (VTodo)this.allTodos.get(n3);
                string = vTodo.getCalID();
                for (int i = 0; i < n2; ++i) {
                    if (!string.equals((String)this.calids.get(i))) continue;
                    if (this.typeSortRequired && this.category != null) {
                        String[] stringArray = vTodo.getCategories();
                        if (null == stringArray || stringArray.length <= 0 || this.category.equalsIgnoreCase(stringArray[0])) {
                            // empty if block
                        }
                        this.typeTodos.add(vTodo);
                    }
                    if ((dateTime = vTodo.getDueTime()) == null) {
                        _calModelLogger.info("todoDate is null");
                        if (!vTodo.isCompleted()) {
                            this.dueTodos.add(vTodo);
                            continue block3;
                        }
                        dateTime = vTodo.getCompletedTime();
                        if (dateTime == null) {
                            this.completedTodos.add(vTodo);
                            continue block3;
                        }
                    }
                    if (vTodo.isCompleted()) {
                        if ((!dateTime.after((Object)this.start) || !dateTime.before((Object)this.end)) && !dateTime.equals((Object)this.start) && !dateTime.equals((Object)this.end)) continue block3;
                        this.completedTodos.add(vTodo);
                        continue block3;
                    }
                    if (dateTime.before((Object)this.currentDate) || dateTime.equals((Object)this.currentDate)) {
                        if (!bl) continue block3;
                        this.overDueTodos.add(vTodo);
                        continue block3;
                    }
                    if ((!dateTime.after((Object)this.start) || !dateTime.before((Object)this.end)) && !dateTime.equals((Object)this.start) && !dateTime.equals((Object)this.end)) continue;
                    this.dueTodos.add(vTodo);
                    continue block3;
                }
            }
            _calModelLogger.finest("completed todos are..");
            for (n3 = 0; n3 < this.completedTodos.size(); ++n3) {
                string = (SOCSTodo)this.completedTodos.get(n3);
                _calModelLogger.finest(string.toRFC2445());
            }
            _calModelLogger.finest("overdue todos are..");
            for (n3 = 0; n3 < this.overDueTodos.size(); ++n3) {
                string = (SOCSTodo)this.overDueTodos.get(n3);
                _calModelLogger.finest(string.toRFC2445());
            }
            _calModelLogger.finest("due todos are..");
            for (n3 = 0; n3 < this.dueTodos.size(); ++n3) {
                string = (SOCSTodo)this.dueTodos.get(n3);
                _calModelLogger.finest(string.toRFC2445());
            }
        }
        catch (OperationNotSupportedException operationNotSupportedException) {
        }
        catch (CalendarComponentException calendarComponentException) {
            _calModelLogger.severe("CalendarComponent Exception");
            _calModelLogger.severe("SortTodos Failed");
        }
    }

    private void removeCalendarData() {
        if (this.allEvents != null) {
            this.allEvents.clear();
            if (this.allDayEvents != null) {
                this.allDayEvents.clear();
            }
            if (this.nonAllDayEvents != null) {
                this.nonAllDayEvents.clear();
            }
            if (this.invitationEvents != null) {
                this.invitationEvents.clear();
            }
        }
        if (this.allTodos != null) {
            this.allTodos.clear();
            if (this.dueTodos != null) {
                this.dueTodos.clear();
            }
            if (this.overDueTodos != null) {
                this.overDueTodos.clear();
            }
        }
        if (this.freeBusy != null) {
            this.freeBusy.clear();
        }
        if (this.calendars != null) {
            this.calendars.clear();
        }
        if (this.ownedCalendars != null) {
            this.ownedCalendars.clear();
        }
    }

    private void seperateComponentsIntoEventsTasks(CalendarComponent[] calendarComponentArray) {
        if (calendarComponentArray != null) {
            for (int i = 0; i < calendarComponentArray.length; ++i) {
                if (calendarComponentArray[i] instanceof VEvent) {
                    this.allEvents.add(calendarComponentArray[i]);
                    continue;
                }
                if (!(calendarComponentArray[i] instanceof VTodo)) continue;
                this.allTodos.add(calendarComponentArray[i]);
            }
        }
    }

    static {
        _calModelLogger = UWCLogger.getLogger("uwc.common.model");
    }
}

