/*
 * Decompiled with CFR 0.152.
 */
package com.sun.uwc.calclient.model;

import com.sun.comclient.calendar.CalendarException;
import com.sun.comclient.calendar.ICalendar;
import com.sun.comclient.calendar.OperationNotSupportedException;
import com.sun.uwc.common.UWCException;
import com.sun.uwc.common.UWCUserHelper;
import com.sun.uwc.common.util.OrderedMap;
import com.sun.uwc.common.util.UWCLogger;
import com.sun.uwc.common.util.UWCUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CalendarACL {
    private static Logger _calLogger = UWCLogger.getLogger("uwc.calclient");
    private static final String ACCESS_STRING_SEPARATOR = ";";
    private static final String ACCESS_STRING_PARTS_SEPARATOR = "^";
    private static final String DOMAIN_CHAR = "@";
    private static final int NORMAL_USER_LEVEL = 0;
    private static final int OWNER_LEVEL = 1;
    private static final int PRIMARY_OWNER_LEVEL = 2;
    private static final int DOMAIN_LEVEL = 3;
    private static final int ALL_USERS_LEVEL = 4;
    private OrderedMap _acitable;
    private ICalendar _ical;
    private Properties _calProps;
    private String[] _ownersList = null;
    private String _primaryOwner = null;
    private static final int READ = 0;
    private static final int WRITE = 1;
    private static final int DELETE = 2;
    private static final int INVITE = 3;
    private static final int CANCEL = 4;
    private static final int REPLY = 5;
    private static final int FREE_BUSY = 6;
    private static final int SELF_ADMIN = 7;
    private static final int SCHEDULE = 8;
    private static HashMap _rightsMap = new HashMap();

    public CalendarACL() {
    }

    public CalendarACL(String string, String[] stringArray, String string2) {
        _calLogger.entering("CalendarACL", "Constructor with accessString");
        if (string == null) {
            throw new IllegalArgumentException("Access String is mandatory parameter for this constructor");
        }
        this._ownersList = stringArray;
        this._primaryOwner = string2;
        this.parseAccessString(string);
        _calLogger.exiting("CalendarACL", "Constructor with accessString");
    }

    public CalendarACL(ICalendar iCalendar) throws UWCException {
        _calLogger.entering("CalendarACL", "Constructor");
        try {
            this._ical = iCalendar;
            this._calProps = iCalendar.getCalProps();
            if (this._calProps == null) {
                throw new UWCException(60);
            }
            String string = this._calProps.getProperty("ACCESS-CONTROL-ENTRY");
            if (string != null) {
                this.parseAccessString(string);
            }
        }
        catch (CalendarException calendarException) {
            throw new UWCException(60);
        }
        catch (OperationNotSupportedException operationNotSupportedException) {
            throw new UWCException(60);
        }
        _calLogger.exiting("CalendarACL", "Constructor");
    }

    public String getAccessString(boolean bl) {
        if (this._acitable != null) {
            ArrayList arrayList = new ArrayList();
            String[] stringArray = this._acitable.getKeys();
            String string = new String();
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                CalendarACI calendarACI = (CalendarACI)this._acitable.get(string2);
                String[] stringArray2 = calendarACI.getAciStringPerWhat();
                for (int j = 0; j < stringArray2.length; ++j) {
                    string = string + string2 + ACCESS_STRING_PARTS_SEPARATOR + stringArray2[j] + ACCESS_STRING_SEPARATOR;
                }
            }
            string = string.substring(0, string.length() - 1);
            return string;
        }
        return null;
    }

    public boolean checkPermission(String string, String string2, String string3) throws UWCException {
        _calLogger.entering("CalendarACL", "checkPermission");
        if (string == null || string2 == null || string3 == null) {
            throw new IllegalArgumentException("Null value(s) been passed for mandatory arguments");
        }
        if (this._acitable == null) {
            return false;
        }
        CalendarACI calendarACI = (CalendarACI)this._acitable.get(string);
        String string4 = "n";
        if (calendarACI != null) {
            string4 = calendarACI.getPermission(string2, string3);
        }
        if (string.equals(DOMAIN_CHAR) && string4.equals("n")) {
            return false;
        }
        if (string4.equals("n")) {
            int n = 0;
            if (string.equals("@@o")) {
                n = 1;
            }
            if (string.equals("@@p")) {
                n = 2;
            }
            if (!string.equals(DOMAIN_CHAR) && !string.equals("@@o") && !string.equals("@@p") && string.startsWith(DOMAIN_CHAR)) {
                n = 3;
            }
            if (n >= 0 && n < 2 && this._ownersList != null) {
                if (UWCUtils.isStringContainedInStringArray(string, this._ownersList) > -1 && (calendarACI = (CalendarACI)this._acitable.get("@@o")) != null) {
                    string4 = calendarACI.getPermission(string2, string3);
                    if (string4.equals("n") && this._primaryOwner != null && this._primaryOwner.equals(string) && (calendarACI = (CalendarACI)this._acitable.get("@@p")) != null) {
                        string4 = calendarACI.getPermission(string2, string3);
                    }
                    if (!string4.equals("n")) {
                        return this.isGrantedPermission(string4);
                    }
                }
            } else {
                if (n == 0) {
                    if (_calLogger.isLoggable(Level.INFO)) {
                        _calLogger.info("---- Checking for permissions for @@o ----");
                    }
                    try {
                        if (this._ical.isUserTheOwner(string)) {
                            _calLogger.info("User - " + string + " is an owner");
                            calendarACI = (CalendarACI)this._acitable.get("@@o");
                            if (calendarACI != null && !(string4 = calendarACI.getPermission(string2, string3)).equals("n")) {
                                return this.isGrantedPermission(string4);
                            }
                        }
                    }
                    catch (Exception exception) {
                        throw new UWCException("[Error:checkPermission] - " + exception.getMessage());
                    }
                }
                if (n >= 0 && n < 2) {
                    String string5;
                    if (_calLogger.isLoggable(Level.INFO)) {
                        _calLogger.info("---- Checking for permissions for @@p ----");
                    }
                    if ((string5 = this._calProps.getProperty("@@p")) != null && string5.equals(string) && (calendarACI = (CalendarACI)this._acitable.get("@@p")) != null && !(string4 = calendarACI.getPermission(string2, string3)).equals("n")) {
                        return this.isGrantedPermission(string4);
                    }
                }
            }
            if (n >= 0 && n < 3) {
                if (_calLogger.isLoggable(Level.INFO)) {
                    _calLogger.info("---- Checking for permissions for @domain ----");
                }
                if ((calendarACI = (CalendarACI)this._acitable.get(UWCUserHelper.getDomain(null))) != null && !(string4 = calendarACI.getPermission(string2, string3)).equals("n")) {
                    return this.isGrantedPermission(string4);
                }
            }
            if (n >= 0 && n < 4) {
                if (_calLogger.isLoggable(Level.INFO)) {
                    _calLogger.info("---- Checking for permissions for @ ----");
                }
                if ((calendarACI = (CalendarACI)this._acitable.get(DOMAIN_CHAR)) != null && !(string4 = calendarACI.getPermission(string2, string3)).equals("n")) {
                    return this.isGrantedPermission(string4);
                }
            }
        }
        _calLogger.exiting("CalendarACL", "checkPermission");
        return this.isGrantedPermission(string4);
    }

    public boolean checkUserPermission(String string, String string2, String string3) throws UWCException {
        _calLogger.entering("CalendarACL", "checkUserPermission");
        if (string == null || string2 == null || string3 == null) {
            throw new IllegalArgumentException("Null value(s) been passed for mandatory arguments");
        }
        if (null == this._acitable) {
            return false;
        }
        CalendarACI calendarACI = (CalendarACI)this._acitable.get(string);
        String string4 = "n";
        if (null != calendarACI) {
            string4 = calendarACI.getPermission(string2, string3);
        }
        return this.isGrantedPermission(string4);
    }

    public void setPermission(String string, String string2, String string3, String string4) {
        if (string == null || string2 == null || string3 == null || string4 == null) {
            throw new IllegalArgumentException("Null value(s) been passed for mandatory arguments");
        }
        boolean bl = false;
        if (this._acitable == null) {
            bl = true;
            this._acitable = new OrderedMap();
        }
        CalendarACI calendarACI = null;
        if (this._acitable != null && (calendarACI = (CalendarACI)this._acitable.get(string)) == null) {
            bl = true;
        }
        if (bl) {
            calendarACI = new CalendarACI(string2, string3.toLowerCase(), string4);
        } else {
            calendarACI.setPermission(string2, string3.toLowerCase(), string4);
        }
        this._acitable.put(string, calendarACI);
    }

    public void removePermission(String string, String string2, String string3) {
        if (string2 == null && string3 == null) {
            this._acitable.remove(string);
        } else {
            CalendarACI calendarACI = (CalendarACI)this._acitable.get(string);
            if (calendarACI != null) {
                calendarACI.removePermission(string2, string3);
            }
        }
    }

    private boolean isGrantedPermission(String string) {
        return string != null && string.equals("g");
    }

    private void parseAccessString(String string) {
        _calLogger.entering("CalendarACL", "parseAccessString");
        StringTokenizer stringTokenizer = new StringTokenizer(string, ACCESS_STRING_SEPARATOR);
        if (stringTokenizer.hasMoreTokens()) {
            this._acitable = new OrderedMap();
        }
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            StringTokenizer stringTokenizer2 = new StringTokenizer(string2, ACCESS_STRING_PARTS_SEPARATOR);
            int n = stringTokenizer2.countTokens();
            if (!stringTokenizer2.hasMoreTokens()) continue;
            String string3 = stringTokenizer2.nextToken();
            String string4 = stringTokenizer2.nextToken();
            String string5 = null;
            string5 = n < 4 ? "" : stringTokenizer2.nextToken();
            string5 = string5.toLowerCase();
            String string6 = stringTokenizer2.nextToken();
            CalendarACI calendarACI = (CalendarACI)this._acitable.get(string3);
            if (calendarACI == null) {
                calendarACI = new CalendarACI(string4, string5, string6);
            } else {
                calendarACI.setPermission(string4, string5, string6);
            }
            this._acitable.put(string3, calendarACI);
        }
        _calLogger.exiting("CalendarACL", "parseAccessString");
    }

    public String[] getACIUsers() {
        if (null == this._acitable) {
            return null;
        }
        return this._acitable.getKeys();
    }

    static {
        _rightsMap.put("r", new Integer(0));
        _rightsMap.put("w", new Integer(1));
        _rightsMap.put("d", new Integer(2));
        _rightsMap.put("i", new Integer(3));
        _rightsMap.put("c", new Integer(4));
        _rightsMap.put("e", new Integer(5));
        _rightsMap.put("f", new Integer(6));
        _rightsMap.put("z", new Integer(7));
        _rightsMap.put("s", new Integer(8));
    }

    private class CalendarACI {
        private Hashtable _calObjToPermissionMap;

        public CalendarACI(String string, String string2, String string3) {
            _calLogger.entering("CalendarACI", "CalendarACI:Constructor");
            String[] stringArray = new String[_rightsMap.size()];
            UWCUtils.initializeStringArray(stringArray, "n");
            this.parseRights(stringArray, string2, string3);
            this._calObjToPermissionMap = new Hashtable();
            this._calObjToPermissionMap.put(string, stringArray);
            _calLogger.exiting("CalendarACI", "CalendarACI:Constructor");
        }

        private void parseRights(String[] stringArray, String string, String string2) {
            for (int i = 0; i < string.length(); ++i) {
                Integer n = (Integer)_rightsMap.get(String.valueOf(string.charAt(i)));
                if (n == null) continue;
                stringArray[n.intValue()] = string2;
            }
        }

        public String getPermission(String string, String string2) {
            _calLogger.entering("CalendarACI", "getpermission");
            if (string == null) {
                string = "a";
            }
            if (!this._calObjToPermissionMap.containsKey(string)) {
                return "n";
            }
            String[] stringArray = (String[])this._calObjToPermissionMap.get(string);
            int n = (Integer)_rightsMap.get(string2);
            _calLogger.exiting("CalendarACI", "getpermission");
            return stringArray[n];
        }

        public void setPermission(String string, String string2, String string3) {
            _calLogger.entering("CalendarACI", "setpermission");
            String[] stringArray = (String[])this._calObjToPermissionMap.get(string);
            if (stringArray == null) {
                stringArray = new String[_rightsMap.size()];
                UWCUtils.initializeStringArray(stringArray, "n");
            }
            this.parseRights(stringArray, string2, string3);
            this._calObjToPermissionMap.put(string, stringArray);
            _calLogger.exiting("CalendarACI", "setpermission");
        }

        public void removePermission(String string, String string2) {
            this.setPermission(string, string2, "n");
        }

        public String[] getAciStringPerWhat() {
            ArrayList<String> arrayList = new ArrayList<String>();
            Set set = this._calObjToPermissionMap.keySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string;
                String string2 = (String)iterator.next();
                String[] stringArray = (String[])this._calObjToPermissionMap.get(string2);
                String string3 = string = new String();
                Set set2 = _rightsMap.keySet();
                Iterator iterator2 = set2.iterator();
                while (iterator2.hasNext()) {
                    String string4 = (String)iterator2.next();
                    int n = (Integer)_rightsMap.get(string4);
                    if (!stringArray[n].equals("n") && stringArray[n].equals("g")) {
                        string3 = string3 + string4;
                    }
                    if (stringArray[n].equals("n") || !stringArray[n].equals("d")) continue;
                    string = string + string4;
                }
                arrayList.add(string2 + CalendarACL.ACCESS_STRING_PARTS_SEPARATOR + string3 + CalendarACL.ACCESS_STRING_PARTS_SEPARATOR + "g");
                if (string.length() <= 0) continue;
                arrayList.add(string2 + CalendarACL.ACCESS_STRING_PARTS_SEPARATOR + string + CalendarACL.ACCESS_STRING_PARTS_SEPARATOR + "d");
            }
            return arrayList.toArray(new String[0]);
        }
    }
}

