/*
 * Decompiled with CFR 0.152.
 */
package com.sun.uwc.calclient;

import com.iplanet.jato.model.DatasetModel;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.model.ModelExecutionContext;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.RequestHandlingTiledViewBase;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.event.ChildDisplayEvent;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.html.StaticTextField;
import com.sun.comclient.calendar.DateTime;
import com.sun.comclient.calendar.Duration;
import com.sun.uwc.calclient.WeekEventsTiledView;
import com.sun.uwc.calclient.WeekViewTimeSlotTiledView;
import com.sun.uwc.calclient.WeekViewViewBean;
import com.sun.uwc.calclient.model.WeekViewEventsModel;
import com.sun.uwc.common.model.CalendarExecutionModelContext;
import com.sun.uwc.common.util.UWCLogger;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WeekViewTiledView
extends RequestHandlingTiledViewBase {
    private static Logger uwcLogger = null;
    protected static boolean _isFINELoggable;
    CalendarExecutionModelContext ctx = null;
    public static final String CHILD_STATICTEXT_SPAN = "span";
    public static final String CHILD_WEEKEVENTSTILEDVIEW = "nonAllDayEvents";
    private WeekViewEventsModel weekEventsModel = null;
    private WeekViewViewBean _parentViewBean = null;
    private String usersDayInterval = null;
    private DateTime usersDayStart = null;
    private DateTime usersDayEnd = null;
    private DateTime[][] maxEndTimeForSlots = null;
    int timeIndex = -1;
    int dayIndex = -1;
    int index = -1;
    int timeSlotInterval = 30;
    boolean isConflicting = false;
    boolean isOwnedCalendarSlot = false;
    ArrayList userWeekDays = null;
    private int[] displayDayIndex = null;
    static String CLASS_NAME;
    static /* synthetic */ Class class$com$sun$uwc$calclient$WeekEventsTiledView;
    static /* synthetic */ Class class$com$iplanet$jato$view$html$StaticTextField;
    static /* synthetic */ Class class$com$sun$uwc$calclient$model$WeekViewEventsModel;

    protected static void setLoggableFlags() {
        _isFINELoggable = uwcLogger.isLoggable(Level.FINE);
    }

    public WeekViewTiledView(View view, String string) {
        super(view, string);
        uwcLogger.entering(CLASS_NAME, "WeekViewTiledView()");
        this.setMaxDisplayTiles(10);
        this.setPrimaryModel((DatasetModel)this.getDefaultModel());
        this.registerChildren();
        uwcLogger.exiting(CLASS_NAME, "WeekViewTiledView()");
    }

    protected void registerChildren() {
        uwcLogger.entering(CLASS_NAME, "registerChildren()");
        this.registerChild(CHILD_WEEKEVENTSTILEDVIEW, class$com$sun$uwc$calclient$WeekEventsTiledView == null ? (class$com$sun$uwc$calclient$WeekEventsTiledView = WeekViewTiledView.class$("com.sun.uwc.calclient.WeekEventsTiledView")) : class$com$sun$uwc$calclient$WeekEventsTiledView);
        this.registerChild(CHILD_STATICTEXT_SPAN, class$com$iplanet$jato$view$html$StaticTextField == null ? (class$com$iplanet$jato$view$html$StaticTextField = WeekViewTiledView.class$("com.iplanet.jato.view.html.StaticTextField")) : class$com$iplanet$jato$view$html$StaticTextField);
        uwcLogger.exiting(CLASS_NAME, "registerChildren()");
    }

    protected View createChild(String string) {
        uwcLogger.entering(CLASS_NAME, "createChild(" + string + ")");
        if (string.equals(CHILD_WEEKEVENTSTILEDVIEW)) {
            WeekEventsTiledView weekEventsTiledView = new WeekEventsTiledView((View)this, CHILD_WEEKEVENTSTILEDVIEW);
            return weekEventsTiledView;
        }
        if (string.equals(CHILD_STATICTEXT_SPAN)) {
            StaticTextField staticTextField = new StaticTextField((ContainerView)this, CHILD_STATICTEXT_SPAN, (Object)"");
            return staticTextField;
        }
        return null;
    }

    public int getTimeIndex() {
        return this.timeIndex;
    }

    public int getDayIndex() {
        return this.dayIndex;
    }

    public boolean beginEmptyeventDisplay(ChildDisplayEvent childDisplayEvent) {
        uwcLogger.entering(CLASS_NAME, "beginEmptyEventDisplay()");
        uwcLogger.exiting(CLASS_NAME, "beginEmptyEventDisplay()");
        return this.getWeekViewEventsModel().isEmptyNonAllDayEventSlot(this.dayIndex, this.timeIndex);
    }

    public boolean beginEventDisplay(ChildDisplayEvent childDisplayEvent) {
        uwcLogger.entering(CLASS_NAME, "beginEventDisplay()");
        uwcLogger.exiting(CLASS_NAME, "beginEventDisplay()");
        return this.getWeekViewEventsModel().isNonAllDayEventSlot(this.dayIndex, this.timeIndex);
    }

    public WeekViewEventsModel getWeekViewEventsModel() {
        uwcLogger.entering(CLASS_NAME, "getWeekViewEventsModel()");
        if (this.weekEventsModel == null) {
            uwcLogger.info("weekEventsModel is null, so creating it");
            this.weekEventsModel = (WeekViewEventsModel)this.getRequestContext().getModelManager().getModel(class$com$sun$uwc$calclient$model$WeekViewEventsModel == null ? (class$com$sun$uwc$calclient$model$WeekViewEventsModel = WeekViewTiledView.class$("com.sun.uwc.calclient.model.WeekViewEventsModel")) : class$com$sun$uwc$calclient$model$WeekViewEventsModel, "weekNonAllDayEvents");
            this.weekEventsModel.setUseDefaultValues(false);
        }
        uwcLogger.exiting(CLASS_NAME, "getWeekViewEventsModel()");
        return this.weekEventsModel;
    }

    public void beginDisplay(DisplayEvent displayEvent) throws ModelControlException {
        uwcLogger.entering(CLASS_NAME, "beginDisplay()");
        super.beginDisplay(displayEvent);
        if (this._parentViewBean == null) {
            this._parentViewBean = (WeekViewViewBean)this.getParentViewBean();
        }
        if (this.userWeekDays == null) {
            this.userWeekDays = this._parentViewBean.getWeekDays();
        }
        if (this.displayDayIndex == null) {
            this.displayDayIndex = this._parentViewBean.getDisplayDayIndex();
        }
        if (this.usersDayInterval == null) {
            this.usersDayInterval = this._parentViewBean.getDayInterval();
            try {
                Duration duration = new Duration(this.usersDayInterval);
                this.timeSlotInterval = duration.getHours() * 60 + duration.getMinutes();
            }
            catch (Exception exception) {
                uwcLogger.fine("Unable to set TimeSlot Interval");
            }
        }
        if (this.usersDayStart == null) {
            this.usersDayStart = (DateTime)this._parentViewBean.getDayStartTime().clone();
        }
        if (this.usersDayEnd == null) {
            this.usersDayEnd = (DateTime)this._parentViewBean.getDayEndTime().clone();
        }
        this.dayIndex = -1;
        this.index = -1;
        this.timeIndex = ((WeekViewTimeSlotTiledView)this.getParent()).getTimeIndex();
        if (_isFINELoggable) {
            uwcLogger.fine("timeIndex is.." + this.timeIndex);
        }
        this.ctx = new CalendarExecutionModelContext(CalendarExecutionModelContext.WEEKVIEW_NONALLDAY_EVENTS_CONTEXT);
        uwcLogger.fine("execute weekview nonAllDayEventsContext..");
        this.getWeekViewEventsModel().setDayInterval(this.usersDayInterval);
        this.getWeekViewEventsModel().setDayStartTime(this.usersDayStart);
        this.getWeekViewEventsModel().setDayEndTime(this.usersDayEnd);
        this.getWeekViewEventsModel().execute((ModelExecutionContext)this.ctx);
        if (this.maxEndTimeForSlots == null) {
            this.maxEndTimeForSlots = this.getWeekViewEventsModel().getMaxEndTimeArray();
        }
        uwcLogger.exiting(CLASS_NAME, "beginDisplay()");
    }

    public boolean nextTile() throws ModelControlException {
        uwcLogger.entering(CLASS_NAME, "nextTile()");
        ++this.index;
        if (this.index >= this.userWeekDays.size()) {
            uwcLogger.fine("return false");
            uwcLogger.exiting(CLASS_NAME, "nextTile()");
            return false;
        }
        this.dayIndex = this.displayDayIndex[this.index];
        if (_isFINELoggable) {
            uwcLogger.fine("dayIndex is.." + this.dayIndex);
        }
        this.getWeekViewEventsModel().setDayIndex(this.dayIndex);
        this.getWeekViewEventsModel().setTimeIndex(this.timeIndex);
        this.getWeekViewEventsModel().retrieve((ModelExecutionContext)this.ctx);
        this.calculateSpan(this.dayIndex, this.timeIndex);
        this.isConflicting = this.getWeekViewEventsModel().isConflictingNonAllDayEventSlot(this.dayIndex, this.timeIndex);
        this.isOwnedCalendarSlot = this.getWeekViewEventsModel().isOwnedCalendarSpanningSlot();
        uwcLogger.exiting(CLASS_NAME, "nextTile()");
        return true;
    }

    public boolean beginConflictingOwnedCalendarDisplay(ChildDisplayEvent childDisplayEvent) throws ModelControlException {
        uwcLogger.entering(CLASS_NAME, "beginConflictingOwnedCalendarDisplay");
        boolean bl = false;
        if (this.isConflicting && this.isOwnedCalendarSlot) {
            bl = true;
        }
        if (_isFINELoggable) {
            uwcLogger.fine("returning.." + bl);
        }
        uwcLogger.exiting(CLASS_NAME, "beginConflictingOwnedCalendarDisplay");
        return bl;
    }

    public boolean beginConflictingNonOwnedCalendarDisplay(ChildDisplayEvent childDisplayEvent) throws ModelControlException {
        uwcLogger.entering(CLASS_NAME, "beginConflictingNonOwnedCalendarDisplay");
        boolean bl = false;
        if (this.isConflicting && !this.isOwnedCalendarSlot) {
            bl = true;
        }
        if (_isFINELoggable) {
            uwcLogger.fine("returning.." + bl);
        }
        uwcLogger.exiting(CLASS_NAME, "beginConflictingNonOwnedCalendarDisplay");
        return bl;
    }

    public boolean beginNonConflictingOwnedCalendarDisplay(ChildDisplayEvent childDisplayEvent) throws ModelControlException {
        uwcLogger.entering(CLASS_NAME, "beginNonConflictingOwnedDisplay");
        boolean bl = false;
        if (!this.isConflicting && this.isOwnedCalendarSlot) {
            bl = true;
        }
        if (_isFINELoggable) {
            uwcLogger.fine("returning.." + bl);
        }
        uwcLogger.exiting(CLASS_NAME, "beginNonConflictingOwnedCalendarDisplay");
        return bl;
    }

    public boolean beginNonConflictingNonOwnedCalendarDisplay(ChildDisplayEvent childDisplayEvent) throws ModelControlException {
        uwcLogger.entering(CLASS_NAME, "beginNonConflictingNonOwnedCalendarDisplay");
        boolean bl = false;
        if (!this.isConflicting && !this.isOwnedCalendarSlot) {
            bl = true;
        }
        if (_isFINELoggable) {
            uwcLogger.fine("returning.." + bl);
        }
        uwcLogger.exiting(CLASS_NAME, "beginNonConflictingNonOwnedCalendarDisplay");
        return bl;
    }

    public void calculateSpan(int n, int n2) {
        DateTime dateTime;
        uwcLogger.entering(CLASS_NAME, "calculateSpan()");
        if (_isFINELoggable) {
            uwcLogger.fine("dayIndex is..." + n);
            uwcLogger.fine("timeIndex is..." + n2);
        }
        if ((dateTime = this.maxEndTimeForSlots[n][n2]) != null) {
            if (_isFINELoggable) {
                uwcLogger.fine("maxEndTime is..." + dateTime.toISO8601());
                uwcLogger.fine("usersDayStart is..." + this.usersDayStart.toISO8601());
            }
            int n3 = dateTime.getHours() - this.usersDayStart.getHours();
            int n4 = dateTime.getMinutes() - this.usersDayStart.getMinutes();
            if (_isFINELoggable) {
                uwcLogger.fine("hour is..." + n3);
                uwcLogger.fine("min is..." + n4);
            }
            int n5 = (60 * n3 + n4) / this.timeSlotInterval - n2;
            if ((60 * n3 + n4) % this.timeSlotInterval > 0) {
                uwcLogger.fine("increasing timeSpanIndex bcoz of remainder..");
                ++n5;
            }
            if (_isFINELoggable) {
                uwcLogger.fine("timeSpanIndex is..." + n5);
            }
            if (n5 > 0) {
                ((StaticTextField)this.getChild(CHILD_STATICTEXT_SPAN)).setValue((Object)Integer.toString(n5));
            } else {
                ((StaticTextField)this.getChild(CHILD_STATICTEXT_SPAN)).setValue((Object)"1");
            }
        } else {
            ((StaticTextField)this.getChild(CHILD_STATICTEXT_SPAN)).setValue((Object)"1");
        }
        uwcLogger.exiting(CLASS_NAME, "calculateSpan()");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        uwcLogger = UWCLogger.getLogger("uwc.calclient.view");
        WeekViewTiledView.setLoggableFlags();
        CLASS_NAME = "WeekViewTiledView";
    }
}

